/**
 *
 */
function ExeInsereClientes(ip, banco, callback) {

	try {
		var valores = "empresaId,vendedorId,nome,fantasia,cpfCnpj,insEst,responsavel,logadouro,numero,bairro,cidade,telefone,celular,cep,email,obs,complemento".split(',');
		var valoresSql = "@EMPRESAID,@REPRESENTANTEID,@NOME,@FANTASIA,@CPF_CNPJ,@INSC_EST,@RESPONSAVEL,@ENDERECO,@NUMERO,@BAIRRO,@CIDADE,@TELEFONE,@CELULAR,@CEP,@EMAIL,@OBS,@COMPLEMENTO".split(',');
		var tipoValor = "int,int,text,text,text,text,text,text,text,text,text,text,text,text,text,text,text,text,text".split(',');
		var from = "dbo.SP_MOBILE_CLIENTE_2";
		var error = null;
		abrirBanco(function(persistenceBanco) {
			persistenceBanco.clientes.query().filter('sinc', 0).execute().done(function(results) {
				try {
					var sql = montarSqlExecutaCliente(results, valores, valoresSql, tipoValor, from);

					if (results.length > 0) {
						var executa = new ServicoExecuta(ip, banco, sql, false, function(retorno) {
							if (retorno <= 0) {
								throw erroRetorno('Retorno com algum erro inesperado. ');
							} else {
								for (var i = 0; i < results.length; i++) {
									results[i].sinc = 1;
									persistenceBanco.update('clientes', results[i]).done(function() {
										callback();
									});
								};
							}
						});

					} else {
						callback();
					}
				} catch(e) {
					fecharPopUpSemBotao();
					e.message = e.message + '\nBanco: ' + from;
					alert(e.message);
				}
			});
		});

	} catch(e) {
		throw e;
	}

}

function montarSqlExecutaCliente(arrayElementos, valores, valoresSql, tipoValor, from, callback) {
	var rtn = '';
	for (var i = 0; i < arrayElementos.length; i++) {
		rtn += from + ' ';
		rtn += '@RETORNOID = ?, ';

		var umElemento = arrayElementos[i];
		for (var j = 0; j < valores.length; j++) {
			rtn += valoresSql[j];
			rtn += ' = ';

			if (tipoValor[j] == "int") {
				rtn += getValorCliente(umElemento, valores[j]);
			} else {
				rtn += " '";
				rtn += getValorCliente(umElemento, valores[j]);
				rtn += "'";
			}
			if ((j + 1) != valores.length) {
				rtn += ", ";
			}
		}
		if ((i + 1) != arrayElementos.length) {
			rtn += "#l#";
		}

	}

	return rtn;
}

function getValorCliente(elemento, valor) {
	if (valor.indexOf('.') != -1) {
		var valorNovo = [];
		valorNovo = valor.split('.');

		for (var i = 0; i < valorNovo.length; i++) {
			elemento = elemento[valorNovo[i]];
		};

		return elemento;

	} else {
		return elemento[valor];
	}
}

function fecharPopUpSemBotao() {
	var popup = jQuery('.adpopup', window.parent.document);
	var overlay = jQuery('.adpopup-overlay.adpopup-style-overlay-dark', window.parent.document);
	popup.remove();
	overlay.remove();
}

var erroRetorno = function(msg) {
	var errorExecuta = new Error(msg);
	errorExecuta.name = 'ERRO RETORNO BANCO DE DADOS';
	return errorExecuta;
};

