/**
 *
 */
function ExeInserePedidos(ip, banco, empresa, vendedor, callback) {

	try {
		var valores = "empresaId,vendedorId,data,cliente.cpfCnpj,formaPagamento,listaPreco,observacao".split(',');
		var valoresSql = "@EMPRESAID,@REPRESENTANTEID,@DATA,@CPF_CNPJ,@FORMA_PGTOID,@LISTAID,@OBS".split(',');
		var tipoValor = "int,int,text,text,int,int,text".split(',');
		var from = "dbo.SP_MOBILE_VENDA";
		var error = null;
		abrirBanco(function(persistenceBanco) {
			persistenceBanco.pedidos.query().filter('status', 0).execute().done(function(results) {
				if (results.length > 0) {
					for (var i = 0; i < results.length; i++) {
						try {
							if (results[i].produtos.length > 0) {
								results[i].empresaId = empresa;
								results[i].vendedorId = vendedor;
								var sql = montarSqlExecutaPedidos(results[i], valores, valoresSql, tipoValor, from);
								var executa = new ServicoExecuta(ip, banco, sql, false, function(retornoPrimeira) {
									if (retornoPrimeira <= 0) {
										throw erroRetorno('Erro inesperado no Retorno Pedidos.');
									} else {
										results[i].idPedido = retornoPrimeira;
										valores = "empresaId,idPedido,produto.produtoId,produto.unidadeId,produto.linhaId,produto.colunaId,quantidade,valorAlterado,acresc,desc,tipoOperacao".split(',');
										valoresSql = "@EMPRESAID,@VENDAID,@PRODUTOID,@UNIDADEID,@LINHAID,@COLUNAID,@QTDE,@VALOR,@ACRESCIMO,@DESCONTO,@OPERACAO".split(',');
										tipoValor = "int,int,int,int,int,int,int,int,int,int,int".split(',');
										from = "dbo.SP_MOBILE_VENDA_PRODUTO3";

										sql = '';
										for (var j = 0; j < results[i].produtos.length; j++) {
											results[i].produtos[j].empresaId = empresa;
											results[i].produtos[j].vendedorId = vendedor;
											results[i].produtos[j].tipoOperacao = results[i].tipoOperacao;
											results[i].produtos[j].idPedido = retornoPrimeira;


											sql += montarSqlExecutaPedidos(results[i].produtos[j], valores, valoresSql, tipoValor, from);
											if (j + 1 < results[i].produtos.length) {
												sql += '#l#';
											}

										};

										executa = new ServicoExecuta(ip, banco, sql, false, function(retorno) {
											if (retorno >= 0) {
												valores = "empresaId,idPedido".split(',');
												valoresSql = "@EMPRESAID,@VENDAID".split(',');
												tipoValor = "int,int".split(',');
												from = "dbo.SP_MOBILE_VENDA_FINALIZA";

												sql = montarSqlExecutaPedidos(results[i].produtos[0], valores, valoresSql, tipoValor, from);
												executa = new ServicoExecuta(ip, banco, sql, false, function(retorno) {
													results[i].status = 1;
													persistenceBanco.pedidos.update(results[i]).done(function() {
														callback();
													});
												});
											}
										});
									}
								});

							} else {
								results[i].status = 1;
								persistenceBanco.pedidos.update(results[i]).done(function() {
									callback();
								});
							}
						} catch(e) {
							fecharPopUpSemBotao();
							e.message = e.message + '\nBanco: ' + from;
							alert(e.message);
						}
					}
				} else {
					callback();
				}
			});
		});

	} catch(e) {
		throw e;
	}

}

function montarSqlExecutaPedidos(arrayElementos, valores, valoresSql, tipoValor, from, callback) {

	var rtn = '';

	if (!jQuery.isArray(arrayElementos)) {
		arrayElementos = [arrayElementos];
	}

	for (var i = 0; i < arrayElementos.length; i++) {

		rtn += from + ' ';
		rtn += '@RETORNOID = ?, ';

		var umElemento = arrayElementos[i];
		for (var j = 0; j < valores.length; j++) {
			rtn += valoresSql[j];
			rtn += ' = ';

			if (tipoValor[j] == "int") {
				rtn += getValorPedidos(umElemento, valores[j]);
			} else {
				rtn += " '";
				rtn += getValorPedidos(umElemento, valores[j]);
				rtn += "'";
			}
			if ((j + 1) != valores.length) {
				rtn += ", ";
			}
		}
		if ((i + 1) != arrayElementos.length) {
			rtn += "#l#";
		}

	}
	console.log(rtn);

	return rtn;
}

function getValorPedidos(elemento, valor) {
	var retorno = '';
	if (valor.indexOf('.') != -1) {
		var valorNovo = [];

		valorNovo = valor.split('.');

		for (var i = 0; i < valorNovo.length; i++) {
			elemento = elemento[valorNovo[i]];
		};
		retorno = elemento;

	} else {
		retorno = elemento[valor];
	}

	return retorno;
}

function fecharPopUpSemBotao() {
	var popup = jQuery('.adpopup', window.parent.document);
	var overlay = jQuery('.adpopup-overlay.adpopup-style-overlay-dark', window.parent.document);
	popup.remove();
	overlay.remove();
}

var erroRetorno = function(msg) {
	var errorExecuta = new Error(msg);
	errorExecuta.name = 'ERRO RETORNO BANCO DE DADOS';
	return errorExecuta;
};

