/**
 *
 */
function ExeInsereSaldo(ip, banco, callback) {

	try {
		var valores = "empresaId,vendedorId,referencia,acrescimo,desconto".split(',');
		var valoresSql = "@EMPRESAID,@VENDEDORID,@REFERENCIA,@ACRESCIMO,@DESCONTO".split(',');
		var tipoValor = "int,int,text,float,float".split(',');
		var from = "dbo.SP_MOBILE_SALDO";
		var error = null;
		abrirBanco(function(persistenceBanco) {
			persistenceBanco.saldos.query().filter('sinc', 0).execute().done(function(results) {
				try {
					var sql = montarSqlExecutaSaldo(results, valores, valoresSql, tipoValor, from);

					if (results.length > 0) {
						var executa = new ServicoExecuta(ip, banco, sql, false, function(retorno) {
							if (retorno <= 0) {
								throw erroRetorno('Retorno com algum erro inesperado. ');
							} else {
								for (var i = 0; i < results.length; i++) {
									results[i].sinc = 1;
									persistenceBanco.update('saldos', results[i]).done(function() {
										callback();
									});
								};
							}
						});

					} else {
						callback();
					}
				} catch(e) {
					fecharPopUpSemBotao();
					e.message = e.message + '\nBanco: ' + from;
					alert(e.message);
				}
			});
		});

	} catch(e) {
		throw e;
	}

}

function montarSqlExecutaSaldo(arrayElementos, valores, valoresSql, tipoValor, from, callback) {
	var rtn = '';
	for (var i = 0; i < arrayElementos.length; i++) {
		rtn += from + ' ';
		rtn += '@RETORNOID = ?, ';

		var umElemento = arrayElementos[i];
		for (var j = 0; j < valores.length; j++) {
			rtn += valoresSql[j];
			rtn += ' = ';
			
			if (tipoValor[j] == "int") {
				rtn += getValorSaldo(umElemento, valores[j]);
			} else if(tipoValor[j] == "float"){
				rtn += getValorSaldoFloat(umElemento, valores[j]);
			}else {
				rtn += " '";
				rtn += getValorSaldo(umElemento, valores[j]);
				rtn += "'";
			}
			if ((j + 1) != valores.length) {
				rtn += ", ";
			}
		}
		if ((i + 1) != arrayElementos.length) {
			rtn += "#l#";
		}

	}

	return rtn;
}

function getValorSaldo(elemento, valor) {
	if (valor.indexOf('.') != -1) {
		var valorNovo = [];
			
		valorNovo = valor.split('.');

		for (var i = 0; i < valorNovo.length; i++) {
			elemento = elemento[valorNovo[i]];
		};

		return elemento;

	} else {
		return elemento[valor];
	}
}

function getValorSaldoFloat(elemento, valor) {
	if (valor.indexOf('.') != -1) {
		var valorNovo = [];
			
		valorNovo = valor.split('.');

		for (var i = 0; i < valorNovo.length; i++) {
			elemento = elemento[valorNovo[i]];
			
		};
		return parseFloat(elemento).toFixed(2);

	} else {
		return parseFloat(elemento[valor]).toFixed(2);
	}
}

function fecharPopUpSemBotao() {
	var popup = jQuery('.adpopup', window.parent.document);
	var overlay = jQuery('.adpopup-overlay.adpopup-style-overlay-dark', window.parent.document);
	popup.remove();
	overlay.remove();
}

var erroRetorno = function(msg) {
	var errorExecuta = new Error(msg);
	errorExecuta.name = 'ERRO RETORNO BANCO DE DADOS';
	return errorExecuta;
};

