/**
 *
 */

function ServicoExecuta(ip, banco, consulta, aceitaVazio, retorno) {
	var errorExecuta = null;
	var xmlhttp;

	var retornoXml;
	var array;

	try {

		if (ip.indexOf(':') == -1) {
			ip = ip + ":8080";
		}

		if (window.XMLHttpRequest) {
			xmlhttp = new XMLHttpRequest({
				mozSystem : true
			});
		} else {
			xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
		}

		var dois = 0;

		xmlhttp.onreadystatechange = function() {
			console.log("State: " + xmlhttp.readyState);
			console.log("status: " + xmlhttp.status);
			console.log("status: " + xmlhttp.getAllResponseHeaders());
			if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
				console.log("DOWN");

				console.log(xmlhttp.responseText);
				//correcao bug window phone
				var parser = new DOMParser();
				var doc = parser.parseFromString(xmlhttp.responseText, 'text/xml');
				var retornoXML = doc.getElementsByTagName("SqlExecutaReturn");

				var i = 0;

				//verifica se existe linhas e colunas do banco
				//diferencia se é uma excpetion ou se tudo ta normal
				if (retornoXML[0].childNodes.length != 0) {
					var numeroFormatado = parseInt(retornoXML[0].childNodes[0].nodeValue);
					if (!isNaN(numeroFormatado)) {
						array = numeroFormatado;
					} else {
						//verifica se é retorno vazio ou erro
						errorExecuta = errorExecutaGenericoBanco(retornoXML[0].childNodes[0].nodeValue);
					}
				} else {
					if (aceitaVazio === true) {
						array = 1;
					} else {
						errorExecuta = errorExecutaVazio("");
					}
				}
			}

			if (xmlhttp.readyState == 4 && xmlhttp.status == 404) {
				errorExecuta = erro404();
			}

			if (xmlhttp.readyState == 4 && xmlhttp.status == 500) {
				errorExecuta = erro500();
			}

			if (xmlhttp.readyState == 4 && xmlhttp.status == 503) {
				errorExecuta = erro503();
			}

			if (xmlhttp.readyState == 2 && xmlhttp.status == 0) {
			}
		};

		var urlMM = getURLFormatada(ip);
		var consultaa = montarXmlConsulta(banco, consulta);

		console.log("URL de conexão: " + urlMM);

		xmlhttp.open("POST", urlMM, false);

		xmlhttp.setRequestHeader("Content-Type", "text/xml");
		xmlhttp.setRequestHeader("SOAPAction", "\"\"");
		console.log('consulta: ' + consulta);
		xmlhttp.send(consultaa);

	} catch(e) {
		throw e;
	}

	function getURLFormatada(ipMontar) {

		return "http://" + ipMontar + "/axis/SmartMobile.jws";

	}

	function montarXmlConsulta(banco, xml) {
		var retorno = '';

		retorno += '<soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:def="http://DefaultNamespace">';
		retorno += '<soapenv:Header/>';
		retorno += '<soapenv:Body>';
		retorno += '<def:SqlExecuta soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">';
		retorno += '<banco xsi:type="xsd:string" xs:type="type:string" xmlns:xs="http://www.w3.org/2000/XMLSchema-instance">';
		retorno += banco;
		retorno += '</banco>';
		retorno += '<xml xsi:type="xsd:string" xs:type="type:string" xmlns:xs="http://www.w3.org/2000/XMLSchema-instance">';
		retorno += xml;
		retorno += '</xml>';
		retorno += '</def:SqlExecuta>';
		retorno += '</soapenv:Body>';
		retorno += '</soapenv:Envelope>';

		return retorno;
	}

	try {
		if (errorExecuta == null) {
			console.log("Retorno: " + array);
			retorno(array);
		} else {
			throw errorExecuta;
		}
	} catch(e) {
		throw e;
	}
}

function unirArrays(x, y) {
	var obj = {};
	for (var i = x.length - 1; i >= 0; --i)
		obj[x[i]] = x[i];
	for (var i = y.length - 1; i >= 0; --i)
		obj[y[i]] = y[i];
	var res = [];
	for (var k in obj) {
		if (obj.hasOwnProperty(k))
			res.push(obj[k]);
	}
	return res;
}

/**
 *ERRO 500 - 503 (Service Unavailable)
 * Erro que dispara caso não encontra o link correto;
 */
var erro503 = function() {
	var errorExecuta = new Error('Servidor Indisponível');
	errorExecuta.name = 'ERRO 503';
	return errorExecuta;
};
/**
 *ERRO 500 - Erro condição inesperada que o impediu de cumprir o pedido
 * Erro que dispara caso não encontra o link correto;
 */
var erro500 = function() {
	var errorExecuta = new Error('Condição inesperada que o impediu de cumprir o pedido');
	errorExecuta.name = 'ERRO 500';
	return errorExecuta;
};

/**
 *ERRO 404 - Página não encontrada
 * Erro que dispara caso não encontra o link correto;
 */
var erro404 = function() {
	var errorExecuta = new Error('Página não encontrada, verifique se o link ou a porta estão corretas');
	errorExecuta.name = 'ERRO 404';
	return errorExecuta;
};

/**
 *ERRO 404/BANCO - BANCO NÃO ENCONTRADO
 * Erro que dispara caso não encontra o link correto;
 */
var erro404Banco = function(msg) {
	var errorExecuta = new Error(msg);
	errorExecuta.name = 'ERRO 404/BANCO';
	return errorExecuta;
};

var errorExecutaGenericoBanco = function(msg) {
	var errorExecuta = new Error(msg);
	errorExecuta.name = 'Erro interno WEBSERVICE';
	return errorExecuta;
};

var errorExecutaVazio = function(msg) {
	var errorExecuta = new Error('Retorno vazio, não é aceito - ' + msg);
	errorExecuta.name = 'Retorno:';
	return errorExecuta;
};

function retornarBanco(msg) {
	msg = msg.toUpperCase();
	var retorno = msg.split('FROM');
	retorno = retorno[1];

	if (retorno.indexOf('WHERE') != -1) {
		retorno = retorno.split('WHERE');
		retorno = retorno[0];
	}

	if (retorno.indexOf('ORDER BY') != -1) {
		retorno = retorno.split('ORDER BY');
		retorno = retorno[0];
	}

	if (retorno.indexOf('GROUP BY') != -1) {
		retorno = retorno.split('ORDER BY');
		retorno = retorno[0];
	}

	return retorno;

}