/**
 *
 */
var persistenceBanco;

function sincronizarDadosIniciais(ip, banco, empresasRetorno, vendedoresRetorno, spin) {

	var empresaSelect = 'EMPRESAID,RAZAO'.split(',');
	var empresaBanco = 'dbo.VW_MOBILE_EMPRESAS order by EMPRESAID desc';

	var vendedorSelect = 'VENDEDORID,NOME,GERENTE'.split(',');
	var vendedorBanco = 'dbo.VW_MOBILE_VENDEDORES order by VENDEDORID desc';

	var opts = {
		lines : 13, // The number of lines to draw
		length : 20, // The length of each line
		width : 11, // The line thickness
		radius : 30, // The radius of the inner circle
		corners : 1, // Corner roundness (0..1)
		rotate : 0, // The rotation offset
		direction : 1, // 1: clockwise, -1: counterclockwise
		color : '#000', // #rgb or #rrggbb or array of colors
		speed : 1, // Rounds per second
		trail : 60, // Afterglow percentage
		shadow : false, // Whether to render a shadow
		hwaccel : false, // Whether to use hardware acceleration
		className : 'spinner', // The CSS class to assign to the spinner
		zIndex : 2e9, // The z-index (defaults to 2000000000)
		top : 'auto', // Top position relative to parent in px
		left : 'auto' // Left position relative to parent in px
	};
	var target = document.getElementById('conteudo');
	var spinner = new Spinner(opts).spin(target);
	var empresas = [];
	var vendedores = [];

	try {

		var servicoEmpresa = new ServicoConsulta(ip, banco, montarSqlSelect(empresaSelect, empresaBanco, ''), false, function(retorno) {

			for (var i = 0; i < retorno.length; i++) {
				if (retorno[i] != '') {
					var colunas = retorno[i].split("#c#");

					var novasColunas = new HashTable();

					for (var j = 0; j < colunas.length; j++) {
						if (colunas[j] == null) {
							colunas[j] = "";
						}
						novasColunas.setItem(empresaSelect[j], colunas[j]);
					}

					//inserir regra individual cada coluna
					var empresa = '{';
					empresa += '"idEmpresa": ' + novasColunas.getItem('EMPRESAID') + ',';
					empresa += '"razao": "' + novasColunas.getItem('RAZAO') + '"';
					empresa += '}';

					empresa = JSON.parse(empresa);
					empresas[i] = empresa;
				}
			}

			var servicoVendedor = new ServicoConsulta(ip, banco, montarSqlSelect(vendedorSelect, vendedorBanco, ''), false, function(retorno) {

				//isnerir parseXML
				abrirBanco(function(a) {
					persistenceBanco = a;
					var novasColunass = new HashTable();

					for (var i = 0; i < retorno.length; i++) {

						retorno[i] = retorno[i].replace('[', '(');
						retorno[i] = retorno[i].replace(']', ')');

						var colunas = retorno[i].split("#c#");

						for (var j = 0; j < colunas.length; j++) {
							if (colunas[j] == null) {
								colunas[j] = "";
							}
							novasColunass.setItem(vendedorSelect[j], colunas[j]);
						}

						//inserir regra individual cada coluna
						var vendedor = '{';
						vendedor += '"idVendedor": ' + novasColunass.getItem('VENDEDORID') + ',';
						vendedor += '"nome": "' + novasColunass.getItem('NOME') + '",';
						vendedor += '"gerente": "' + novasColunass.getItem('GERENTE') + '"';
						vendedor += '}';
						vendedor = JSON.parse(vendedor);
						vendedores[i] = vendedor;

					}

					persistenceBanco.clear('vendedor').done(function(resultss) {
						persistenceBanco.clear('empresa').done(function(results) {
							empresasRetorno(empresas);
							vendedoresRetorno(vendedores);
							spin(spinner);
						});
					});
				});
			});
		});

	} catch(e) {
		spinner.stop();
		throw e;

	}

}
