var persistenceBanco;

function Pedido() {
	this.cliente = {};
	this.total = 0.0;
	var a = new Date();
	var mes = a.getMonth() + 1;
	this.data = a.getDate() + "/" + mes + "/" + a.getFullYear();
	this.listaPreco = 0;
	this.formaPagamento = 0;
	this.observacao = '';
	this.tipoOperacao = 0;
	this.status = 0;
	this.produtos = [];
	this.sinc = 0;
	this.idPedido = 0;
}

function Saldo(){
	this.empresaId = 0;
	this.vendedorId = 0;
	this.data = new Date().format("dd/MM/yyyy h:mm");
	this.referencia = '';
	this.acrescimo = 0.0;
	this.desconto = 0.0;
	this.saldo = 0.0;
	this.sinc = 0;
}

function Cliente() {
	this.empresaId = 0;
	this.vendedorId = 0;
	this.nome = "";
	this.fantasia = "";
	this.cpfCnpj = "";
	this.insEst = "";
	this.responsavel = "";
	this.logadouro = "";
	this.numero = 0;
	this.bairro = "";
	this.complemento = "";
	this.cidade = "";
	this.telefone = "";
	this.celular = "";
	this.ativo = "";
	this.obs = "";
	this.cep = "";
	this.email = "";
	this.limiteCredito = "";
	this.formaPagamento = "";
	this.listaPrecoId = 0;
	this.ultData = "";
	this.ultTotal = 0.0;
	this.sinc = 0;
}

function ClienteVal(val) {
	this.empresaId = val.empresaId;
	this.vendedorId = val.vendedorId;
	this.nome = val.nome;
	this.fantasia = val.fantasia;
	this.cpfCnpj = val.cpfCnpj;
	this.insEst = val.insEst;
	this.responsavel = val.responsavel;
	this.logadouro = val.logadouro;
	this.numero = val.numero;
	this.bairro = val.bairro;
	this.complemento = val.complemento;
	this.cidade = val.cidade + " - " + val.uf;
	this.telefone = val.telefone;
	this.celular = val.celular;
	this.ativo = val.ativo;
	this.obs = val.obs;
	this.cep = val.cep;
	this.email = val.email;
	this.limiteCredito = val.kimeteCredito;
	this.formaPagamento = val.formaPagamento;
	this.listaPrecoId = val.listaPrecoId;
	this.ultData = val.ultData;
	this.ultTotal = val.ultTotal;
	this.sinc = val.sinc;
	if (val.id != undefined) {
		this.id = val.id;
	}
}

function Produto() {
	this.empresaId = 0;
	this.produtoId = 0;
	this.codigo = "";
	this.descricao = "";
	this.codigoBarra = "";
	this.grupoId = 0;
	this.grupo = "";
	this.un = "";
	this.descontoMax = 0;
	this.valor = 0.0;
	this.estoque = "";
	this.linhaId = 0;
	this.colunaId = 0;
	this.linha = "";
	this.coluna = "";
	this.unidadeId = 0;
}

function ListaPreco() {
	this.listaId = 0;
	this.descricao = '';
	this.tipoLista = '';
	this.percentual = 0.0;
}

function ListaPrecoProduto() {
	this.listaId = 0;
	this.produtoId = 0;
	this.codigo = '';
	this.tipo = '';
	this.percentual = 0.0;
}

function FormaPagamento() {
	this.formaPagamentoId = 0;
	this.descricao = '';
}

function FormaPagamentoCliente() {
	this.formaPagamentoId = 0;
	this.cpfCnpj = '';
	this.padrao = 0;
}

function Titulo() {
	this.empresaId = 0;
	this.vendedorId = 0;
	this.nome = '';
	this.cpfCnpj = '';
	this.codigo = '';
	this.documento = '';
	this.emissao = '';
	this.vencimento = '';
	this.valor = 0.0;
	this.historico = '';
	this.tipo = '';
	this.vencimentoOrder = '';
}

function abrirBanco(retorno) {

	jQuery.when(abrirBancoExe()).done(function() {
		retorno(persistenceBanco);
	});

}

function abrirBancoExe() {
	var deferred = jQuery.Deferred();
	window.db.open({
		server : 'oofdgfahhjjdsdwfgergh',
		version : 1,
		schema : {
			saldos : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			titulos : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			formaPagamentoCliente : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			formaPagamento : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			listaPreco : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			listaPrecoProduto : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			pedidos : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			clientes : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			produtos : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			confSinc : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			vendedor : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			},
			empresa : {
				key : {
					keyPath : 'id',
					autoIncrement : true
				}
			}
		}
	}).done(function(s) {
		persistenceBanco = s;
		deferred.resolve();
	});
	return deferred.promise();
}

//----------------------------------------------------------
//------------------------ CLIENTES ------------------------
//----------------------------------------------------------

function adicionarBanco(persistence, tabela, array, retorno) {

	if (jQuery.isArray(array)) {

		adicionarRecursiva(persistence, tabela, array, function(item) {
			retorno(item);
		});

	} else {
		persistence.add(tabela, array).done(function(item) {
			retorno(item);
		});
	}
}

function updateBanco(persistence, tabela, array, retorno) {

	persistence.update(tabela, array).done(function(item) {
		retorno(item);
	});

}

function executarCliente(persistence, tabela, valor) {

	var deferred = jQuery.Deferred();
	persistence.add(tabela, valor).done(function(item) {
		deferred.resolve();
	});
	return deferred.promise();

}

function adicionarRecursiva(persistence, tabela, array, retorno) {

	var exe = [];

	for (var i = 0; i < array.length; i++) {
		exe.push(executarCliente(persistence, tabela, array[i]));
	};

	jQuery.when.apply($, exe).then(function() {
		retorno();
	});
};

function removerCliente(a) {
	persistenceBanco.clientes.remove(a).done(function(key) {
		// item removed
	});
}

Date.prototype.format = function(format) //author: meizz
{
  var o = {
    "M+" : this.getMonth()+1, //month
    "d+" : this.getDate(),    //day
    "h+" : this.getHours(),   //hour
    "m+" : this.getMinutes(), //minute
    "s+" : this.getSeconds(), //second
    "q+" : Math.floor((this.getMonth()+3)/3),  //quarter
    "S" : this.getMilliseconds() //millisecond
  };

  if(/(y+)/.test(format)) format=format.replace(RegExp.$1,
    (this.getFullYear()+"").substr(4 - RegExp.$1.length));
  for(var k in o)if(new RegExp("("+ k +")").test(format))
    format = format.replace(RegExp.$1,
      RegExp.$1.length==1 ? o[k] :
        ("00"+ o[k]).substr((""+ o[k]).length));
  return format;
};