/**
 *
 */

var persistenceBanco;
var grid;
var bd;

jQuery(document).ready(function() {
	loadListaPedido();
});

function loadListaPedido() {
	document.addEventListener("deviceready", onListaPedido, false);
}

function onListaPedido() {
	document.addEventListener("backbutton", botaoBack, false);
	//localStorage.setItem("clienteEditar", '')
	(function($) {
		localStorage.removeItem("pedidoFinal");
		localStorage.removeItem("pedidoCliente");

		eventoBotaoClick('.botao');
		$(".Menu").hide(0);
		$(".opcaoMenu").on('click', function(e) {
			e.preventDefault();
			jQuery('body,html').scrollTop(0);

			$('.Menu').toggle();
			var menu = $(".Menu");
			var he = $("#header");

			$(".Menu").toggleClass("menuAberto");
			console.log("TROCOU");
		});

		$('#botaoAdicionar').on('click', function(e) {
			e.preventDefault();
			window.location.replace('../../view/pedidos/cliente/listaClientes.html');
		});

		$('#tipoListaBottao').on('click', function(e) {
			e.preventDefault();

			var ads = {
				'teste' : {
					type : 'iframe',
					src : '../../view/popup/tipoLista_produto.html'
				}
			};

			jQuery('body').adPopupPro({
				ads : ads,
				show_type : 'always',
				show_chance : 1,
				show_close_button : false,
				mobile : true,
				tablets : true,
				min_screen_size : '0x0',
				internet_explorer : 'normal',
				os : '',
				cookie_id : '2',
				popup_color : 'light',
				popup_shadow : true,
				overlay_opacity : 0.5,
				overlay_color : 'dark',
				overlay_close : true,
				escape_close : true,
				auto_close_after : false
			});

		});
		
		$("input#pesquisaValor").ezpz_hint();

		$('#botaoSincronizar').on('click', function(e) {
			e.preventDefault();
			grid.pararGerarGrid();
			var ads = {
				'teste' : {
					type : 'iframe',
					src : '../../view/popup/progress/progressoPedidos.html'
				}
			};
			jQuery('.container').adPopupPro({
				ads : ads,
				show_type : 'always',
				show_chance : 1,
				show_close_button : false,
				mobile : true,
				tablets : true,
				min_screen_size : '0x0',
				internet_explorer : 'normal',
				os : '',
				cookie_id : '2',
				popup_color : 'light',
				popup_shadow : true,
				overlay_opacity : 0.5,
				overlay_color : 'dark',
				overlay_close : false,
				escape_close : false,
				auto_close_after : false
			});

			setTimeout(function() {
				jQuery('#iframePopUp').contents().find('#barProgresso').css('width', '20%');
				persistenceBanco.query("confSinc").all().execute().done(function(results) {
					jQuery('#iframePopUp').contents().find('#barProgresso').css('width', '40%');
					var retorno = results[0];
					jQuery('#iframePopUp').contents().find('#barProgresso').css('width', '60%');
					var teste = new ExeInserePedidos(retorno.ip, retorno.banco, retorno.empresa, retorno.vendedor, function() {
						var saldo = new SincSaldo(ip, banco, empresa, vendedor, function() {
							jQuery('#iframePopUp').contents().find('#barProgresso').css('width', '100%');
							setTimeout(function() {
								jQuery('.adpopup').remove();
								jQuery('.adpopup-overlay').remove();

								persistenceBanco.query("pedidos").filter(function(e) {
									return e.produtos.length > 0;
								}).execute().done(function(results) {
									bd = results;
									gridGrande();
								});

							}, 1000);
						});
					});

				});
			}, 1000);
		});

		abrirBanco(function(a) {
			persistenceBanco = a;

			persistenceBanco.query('pedidos').filter(function(e) {
				return e.produtos.length > 0;
			}).desc().execute().done(function(results) {
				bd = results;
				gridGrande();
			});

			var valor = '';
			var clickEventType = ((document.ontouchstart !== null) ? 'click' : 'touchstart');
			$("#pesquisaValor").on('keypress',function(e) {
				//alert(e.keyCode);
				if (e.keyCode == 13) {

					valor = $("#pesquisaValor").val();
					persistenceBanco.query('pedidos').filter(function(e) {
						return e.cliente.nome.toLowerCase().indexOf(valor) != -1 || e.cliente.fantasia.toLowerCase().indexOf(valor) != -1 || e.cliente.cidade.toLowerCase().indexOf(valor) != -1 || e.data.indexOf(valor) != -1;
					}).execute().done(function(results) {
						grid.setValorPesquisar(results, 'linhaPrincipal', function() {
						});
					});
				}
			});
		});

		$('#filtrarMenu').on('click', function(e) {
			e.preventDefault();
			grid.pararGerarGrid();
			var ads = {
				'teste' : {
					type : 'iframe',
					src : '../../view/popup/filtrarListaPrincipal.html'
				}
			};
			jQuery('.container').adPopupPro({
				ads : ads,
				show_type : 'always',
				show_chance : 1,
				show_close_button : false,
				mobile : true,
				tablets : true,
				min_screen_size : '0x0',
				internet_explorer : 'normal',
				os : '',
				cookie_id : '2',
				popup_color : 'light',
				popup_shadow : true,
				overlay_opacity : 0.5,
				overlay_color : 'dark',
				overlay_close : false,
				escape_close : false,
				auto_close_after : false
			});

		});

		$('#ordenarMenu').on('click', function(e) {
			e.preventDefault();
			grid.pararGerarGrid();
			var ads = {
				'teste' : {
					type : 'iframe',
					src : '../../view/popup/ordenacaoPedidoPrincipal.html'
				}
			};
			jQuery('.container').adPopupPro({
				ads : ads,
				show_type : 'always',
				show_chance : 1,
				show_close_button : false,
				mobile : true,
				tablets : true,
				min_screen_size : '0x0',
				internet_explorer : 'normal',
				os : '',
				cookie_id : '2',
				popup_color : 'light',
				popup_shadow : true,
				overlay_opacity : 0.5,
				overlay_color : 'dark',
				overlay_close : false,
				escape_close : false,
				auto_close_after : false
			});

		});

		$('#opcoesMenu').on('click', function(e) {
			e.preventDefault();
			retornoGrid({});
		});

	})(jQuery);

}

function gridGrande() {

	if (grid != undefined) {
		grid.pararGerarGrid();
		jQuery('.adpopup-overlay.adpopup-style-overlay-dark').trigger("click");
		document.getElementById("container").innerHTML = null;
	}

	grid = new ListaGrid("", bd, ".container");

	//SETAR UM MODOLO
	grid.setTitulo([["cliente", "nome"]]);

	grid.adicionarElemento('0', ['cliente', 'fantasia'], '6', 'left');
	grid.adicionarElemento('0', 'Nº:', '2', 'right', 'blue');
	grid.adicionarElemento('0', 'id', '4', 'left');
	grid.adicionarElemento('1', ['cliente', 'cpfCnpj'], '6', 'left');
	grid.adicionarElemento('1', 'Data:', '2', 'right', 'blue');
	grid.adicionarElemento('1', 'data', '4', 'left');
	grid.adicionarElemento('2', ['cliente', 'cidade'], '6', 'left');
	grid.adicionarElemento('2', 'Total:', '2', 'right', 'blue');
	grid.adicionarElemento('2', 'total', '4', 'left');
	grid.adicionarElemento('3', ' ', '6', 'left');
	grid.adicionarElemento('3', 'Status:', '2', 'left', 'blue');
	grid.adicionarElemento('3', 'status', '4', 'left');

	grid.setNumerosMaxLinhas(4);

	grid.setarCorCondicao([['cliente', 'nome'], 'total', 'status'], 'status', 'red', '==', 0);
	grid.setarCorCondicao([['cliente', 'nome'], 'total', 'status'], 'status', 'green', '==', 1);

	//SETAR VALORES A SUBSTITUIR
	var statusLista = [["0", " Pendente"], ['1', 'Sincronizado']];
	grid.adicionarValoresLinhas("status", statusLista);

	//formata numero para valores em reais
	grid.setNumeroFormatado('total');

	grid.montarCampos('linhaPrincipal', function() {

		// new setarFont('.row .linhaContainer #linhaPrincipal', '30px', '11px', 1.5);
		// new setarFont('.row .linhaContainer #linhaSecundariaDescricao', '20px', '12px', 1.5);
		// new setarFont('.row .linhaContainer #linhaSecundariaDinamica', '20px', '12px', 1.5);
		// new setarFont('.row .linhaContainer #linhaSecundariaDescricaoAux', '20px', '12px', 1);
		// new setarFont('.row .linhaContainer #linhaSecundariaDinamicaAux', '20px', '12px', 0.5);
	});
}

function gridSimples() {

	if (grid != undefined) {
		grid.pararGerarGrid();
		jQuery('.adpopup-overlay.adpopup-style-overlay-dark').trigger("click");
		document.getElementById("container").innerHTML = null;
	}

	grid = new ListaGrid("", bd, ".container");

	//SETAR UM MODOLO
	grid.setTitulo([["cliente", "nome"]]);

	grid.adicionarElemento('0', 'data', '3', 'left');
	grid.adicionarElemento('0', 'total', '3', 'right');
	grid.adicionarElemento('0', 'Status:', '3', 'center', 'blue');
	grid.adicionarElemento('0', 'status', '3', 'left');

	grid.setNumerosMaxLinhas(1);

	grid.setarCorCondicao([['cliente', 'nome'], 'total', 'status'], 'status', 'red', '==', 0);
	grid.setarCorCondicao([['cliente', 'nome'], 'total', 'status'], 'status', 'green', '==', 1);

	//SETAR VALORES A SUBSTITUIR
	var statusLista = [["0", " Pendente"], ['1', 'Sincronizado']];
	grid.adicionarValoresLinhas("status", statusLista);

	//formata numero para valores em reais
	grid.setNumeroFormatado('total');

	grid.montarCampos('linhaPrincipalSimples', function() {
		// new setarFont('.row .linhaContainer #linhaPrincipal', '30px', '11px', 1.5);
		// new setarFont('.row .linhaContainer #linhaSecundariaDescricao', '20px', '12px', 1.5);
		// new setarFont('.row .linhaContainer #linhaSecundariaDinamica', '20px', '12px', 1.5);
		// new setarFont('.row .linhaContainer #linhaSecundariaDescricaoAux', '20px', '12px', 1);
		// new setarFont('.row .linhaContainer #linhaSecundariaDinamicaAux', '20px', '12px', 0.5);
	});
}

// metodo da acão do clique do item do grid
function retornoGrid(a) {

	console.log(JSON.stringify(a));

	localStorage.setItem("pedidoFinal", JSON.stringify(a));

	var ads = {
		'teste' : {
			type : 'iframe',
			src : '../../view/popup/listaPricipalPedido.html'
		}
	};

	jQuery('body').adPopupPro({
		ads : ads,
		show_type : 'always',
		show_chance : 1,
		show_close_button : false,
		mobile : true,
		tablets : true,
		min_screen_size : '0x0',
		internet_explorer : 'normal',
		os : '',
		cookie_id : '2',
		popup_color : 'light',
		popup_shadow : true,
		overlay_opacity : 0.5,
		overlay_color : 'dark',
		overlay_close : true,
		escape_close : true,
		auto_close_after : false
	});

}

function filtroProduto(valorReferencia) {
	grid.pararGerarGrid();
	if (valorReferencia == '50') {

		setTimeout(function() {
			persistenceBanco.pedidos.query().all().limit(50).execute().done(function(results) {
				bd = results;
				gridGrande();
			});
		}, 1000);

	} else if (valorReferencia == 'semEstoque') {
		setTimeout(function() {
			persistenceBanco.pedidos.query().all().limit(100).execute().done(function(results) {
				bd = results;
				gridGrande();
			});
		}, 1000);
	} else {
		setTimeout(function() {
			persistenceBanco.pedidos.query().all().desc().execute().done(function(results) {
				bd = results;
				gridGrande();
			});
		}, 1000);
	}

	jQuery(".opcaoMenu").trigger("click");
	jQuery('.adpopup').fadeOut(500, function() {
		jQuery('.adpopup').remove();
		jQuery('.adpopup-overlay').fadeOut(500);
	});

}

function ordenacaoProduto(valorReferencia) {
	grid.pararGerarGrid();
	var valor = valorReferencia;
	bd.sort(function(obj1, obj2) {
		var um = pegarValorComposto(valor, obj1) + '';
		var dois = pegarValorComposto(valor, obj2) + '';

		if (um.indexOf('.') != -1) {
			um = parseFloat(obj1[valor].replace(",", "."));
			dois = parseFloat(obj2[valor].replace(",", "."));
			return dois - um;
		} else {
			return um < dois ? -1 : (um > dois ? 1 : 0);
		}
	});
	jQuery(".opcaoMenu").trigger("click");
	jQuery('.adpopup').fadeOut(500, function() {
		jQuery('.adpopup').remove();
		jQuery('.adpopup-overlay').fadeOut(500);
	});
	gridGrande();
}

function pegarValorComposto(valor, objeto) {
	var retorno = objeto;
	var array;

	if (valor.indexOf('.') != -1) {
		array = valor.split(".");
		for (var i = 0; i < array.length; i++) {
			var temp = array[i];
			retorno = retorno[temp];
		};
	} else {
		retorno = objeto[valor];
	}
	return retorno;

}

function botaoBack() {
	localStorage.removeItem("pedidoFinal");
	if (jQuery('.adpopup').length > 0 || jQuery('.menuAberto').length > 0) {
		if (jQuery('.adpopup').length > 0) {
			jQuery('.adpopup').fadeOut(500, function() {
				jQuery('.adpopup').remove();
				jQuery('.adpopup-overlay').fadeOut(500);
			});
		} else if (jQuery('.menuAberto').length > 0) {
			jQuery(".opcaoMenu").trigger('click');
		}
	} else {
		window.location.replace('../../index.html');
	}
}
