jQuery(document).ready(function() {
	loadPedidoFinal();
});

function loadPedidoFinal() {
	document.addEventListener("deviceready", onPedidoFinal, false);
}

var pedido;
var produtosAll;
var indexLista = 0;
var gridProdutos;
var grid;
var bd;
var persistenceBanco;
var produtoSelecionado;
var existeLista;
var arrayMix;
var saldoFinal;
var saldoAlterado;

function onPedidoFinal() {
	eventoBotaoClick('.botao');

	document.addEventListener("backbutton", botaoBack, false);

	jQuery(".Menu").hide(0);
	jQuery(".opcaoMenu").on('click', function(e) {
		e.preventDefault();
		jQuery('body,html').scrollTop(0);

		jQuery('.Menu').toggle();
		var menu = jQuery(".Menu");
		jQuery(".opcaoMenu").toggleClass("menuAberto");
		var he = jQuery("#header");

		jQuery(".Menu").toggleClass("menuAberto");
		console.log("TROCOU");

	});

	abrirBanco(function(persistence) {
		persistenceBanco = persistence;
		jQuery("#pedido").fadeIn();
		jQuery("#buscaGridPedido").hide(0);
		new setarFont('#centerCadastro #cadastroDescricao', '20px', '11px', 1.5);
		new setarFont('#centerCadastro #cadastroCampo select', '20px', '11px', 1.5);
		new setarFont('#centerCadastro #cadastroCampo input', '20px', '11px', 1.5);

		if (localStorage.getItem("pedidoFinal") == null) {
			pedido = new Pedido();

			var cliente = JSON.parse(localStorage.getItem("pedidoCliente"));
			pedido.cliente = cliente;
			adicionarBanco(persistence, 'pedidos', pedido, function(item) {
				pedido = item[0];
			});
		} else {

			pedido = JSON.parse(localStorage.getItem("pedidoFinal"));
			persistence.get("pedidos", pedido.id).done(function(results) {
				pedido = results;
			});
		}

		persistenceBanco.query('saldos').all().desc().execute().done(function(results) {

			saldoFinal = results[0].saldo;
		});

		//-----------------------------------------------------------------------------
		//---------------- SETANDO LISTA PRECO ------------------
		//-----------------------------------------------------------------------------

		setarListaPreco();

		//-----------------------------------------------------------------------------
		//---------------- SETANDO FORMA DE PAGAMENTO ------------------
		//-----------------------------------------------------------------------------

		setarFormaPagamento();

		setarCliente(pedido);

		//-----------------------------------------------------------------------------
		//---------------- PEDIDO ------------------
		//-----------------------------------------------------------------------------

		jQuery("#clickPedido").on('click', function(e) {
			updatePedido();
			if (gridProdutos != undefined) {
				gridProdutos.pararGerarGrid();
				gridProdutos = undefined;
			}
			trocaMenu(getMenuPedido());
			zerarContainer(false);
			jQuery('#produto').hide(0);
			jQuery('#buscaGridPedido').hide(0);
			jQuery('#pedido').fadeIn('fast');

		});

		//-----------------------------------------------------------------------------
		//---------------- MIX MOBILE ------------------
		//-----------------------------------------------------------------------------

		jQuery("#clickMixMobile").on('click', function(e) {
			updatePedido();
			trocaMenu(getMenuPedido());
			indexLista = 3;
			zerarContainer(false);
			document.getElementById("containerProduto").innerHTML = null;

			jQuery('#pesquisaCliente').empty();
			jQuery('#pesquisaCliente').append(getBuscaMixMobile());

			jQuery('#mixMobile').show('fast');
			jQuery('#buscaGridPedido').show(0);
			jQuery('#containerMix').show('fast');
			jQuery('#containerMix').empty();

			persistenceBanco.query('pedidos').filter(function(e) {
				return e.cliente.cpfCnpj == pedido.cliente.cpfCnpj && e.status == 1 && e.produtos.length > 0;
			}).execute().done(function(results) {
				var arrayRetorno = [];
				for (var i = 0; i < results.length; i++) {
					if (results[i].produtos.length > 0) {
						for (var j = 0; j < results[i].produtos.length; j++) {
							arrayRetorno = arrayRetorno.concat(JSON.stringify(results[i].produtos[j].produto));
						};
					}
				};

				var arrayFinal = [];

				jQuery.each(arrayRetorno, function(index, value) {
					if (jQuery.inArray(value, arrayFinal) == -1) {
						arrayFinal.push(value);
					}
				});

				for (var i = 0; i < arrayFinal.length; i++) {
					arrayFinal[i] = JSON.parse(arrayFinal[i]);
				};

				arrayMix = arrayFinal;
				gerarListaProdutosMix(arrayFinal);

			});

		});

		jQuery('#pesquisaCliente').on('keypress','#pesquisaMixMobile', function(e) {
			if (e.keyCode == 13) {
				var valor = jQuery(this).val();
				var arrayTemp = [];
				for (var i = 0; i < arrayMix.length; i++) {
					if (arrayMix[i].descricao.toLowerCase().indexOf(valor) != -1 || arrayMix[i].codigo.toLowerCase().indexOf(valor) != -1) {
						arrayTemp = arrayMix[i];
					}
				};

				arrayMix = arrayTemp;
				gerarListaProdutosMix(arrayMix);
			}
		});

		//-----------------------------------------------------------------------------
		//---------------- PRODUTO ------------------
		//-----------------------------------------------------------------------------

		jQuery("#clickProduto").on('click', function(e) {

			updatePedido();
			trocaMenu(getMenuPedido());
			indexLista = 1;
			zerarContainer(false);
			document.getElementById("containerProduto").innerHTML = null;

			jQuery('#pesquisaCliente').empty();
			jQuery('#pesquisaCliente').append(getBuscaProdutoAdicionar());

			jQuery('#produto').show('fast');
			jQuery('#buscaGridPedido').show(0);
			jQuery('#containerProduto').show('fast');
			jQuery('#containerProduto').empty();
			//jQuery('#containerProdutoSelecao').hide(0);

			var acrescimoFooter = 0;
			var descontoFooter = 0;
			var totalFooter = 0;

			for (var i = pedido.produtos.length - 1; i >= 0; i--) {
				acrescimoFooter += parseFloat(pedido.produtos[i].acresc);
				descontoFooter += parseFloat(pedido.produtos[i].desc);
				totalFooter += parseFloat(pedido.produtos[i].total);
			};


			if (pedido.produtos.length > 0) {
				gerarListaProdutos(pedido.produtos);
			}
			acrescimoFooter = accounting.formatMoney(acrescimoFooter, "", 2, ".", ",");
			descontoFooter = accounting.formatMoney(descontoFooter, "", 2, ".", ",");
			totalFooter = accounting.formatMoney(totalFooter, "", 2, ".", ",");

			jQuery('#footer #branco').append(' Acresc: ' + acrescimoFooter + ' Desc: ' + descontoFooter + ' Total: ' + totalFooter);
		});

		//-----------------------------------------------------------------------------
		//---------------- EDICAO DE PRODUTO PARA PEDIDO ------------------
		//-----------------------------------------------------------------------------

		jQuery('#qtde').on('keypress',function(e) {
			e.preventDefault();

			verificarESetarValorAlterado();

		});

		jQuery('#rReais').on('keypress',function(e) {
			e.preventDefault();
			verificarESetarValorAlterado();
		});

		//-----------------------------------------------------------------------------
		//---------------- FIM EDICAO DE PRODUTO  ------------------
		//-----------------------------------------------------------------------------

		jQuery("#pesquisaCliente").on('keypress','#pesquisaValorProdutoAdicionado',function(e) {
			if (e.keyCode == 13) {
				if (gridProdutos != undefined) {
					gridProdutos.pararGerarGrid();
					gridProdutos = undefined;
				}
				var valor = jQuery("#pesquisaValorProdutoAdicionado").val();

				var array = [];
				var cont = 0;

				for (var i = 0; i < pedido.produtos.length; i++) {
					if (pedido.produtos[i].produto.descricao.toLowerCase().indexOf(valor) != -1 || pedido.produtos[i].produto.codigo.toLowerCase().indexOf(valor) != -1) {
						array[cont] = pedido.produtos[i];
						cont++;
					}
				};

				grid.setValorPesquisar(array, 'linhaPrincipal', function() {});
			}
		});

		jQuery("#pesquisaCliente").on('keypress','#pesquisaValorProduto',function(e) {
			if (e.keyCode == 13) {

				if (gridProdutos != undefined) {
					gridProdutos.pararGerarGrid();
					gridProdutos = undefined;
				}
				var valor = jQuery("#pesquisaValorProduto").val();
				persistenceBanco.query("produtos").filter(function(e) {

					return e.descricao.toLowerCase().indexOf(valor) != -1 || e.codigo.toLowerCase().indexOf(valor) != -1 || e.grupo.toLowerCase().indexOf(valor) != -1;

				}).execute().done(function(results) {
					grid.setValorPesquisar(results, 'linhaPrincipal', function() {});
				});
			}
		});

		jQuery("#pesquisaCliente").on('click', "#botaoLista", function(e) {
			e.preventDefault();
			updatePedido();

			var ads = {
				'teste': {
					type: 'iframe',
					src: '../../view/popup/tipoLista_produto.html'
				}
			};

			jQuery('body').adPopupPro({
				ads: ads,
				show_type: 'always',
				show_chance: 1,
				show_close_button: false,
				mobile: true,
				tablets: true,
				min_screen_size: '0x0',
				internet_explorer: 'normal',
				os: '',
				cookie_id: '2',
				popup_color: 'light',
				popup_shadow: true,
				overlay_opacity: 0.5,
				overlay_color: 'dark',
				overlay_close: true,
				escape_close: true,
				auto_close_after: false
			});

		});

		//-----------------------------------------------------------------------------
		//---------------- Edição produto ao clickar no produto-lista ------------------
		//-----------------------------------------------------------------------------

		jQuery("#botaoVoltar").on('click', function(e) {
			e.preventDefault();
			jQuery('#clickProduto').trigger("click");

		});

		jQuery('#qtde').on('click', function(e) {
			e.preventDefault();
			this.setSelectionRange(0, this.value.length);
		});

		jQuery('#rReais').on('click', function(e) {
			e.preventDefault();
			this.setSelectionRange(0, this.value.length);
		});


		jQuery("#botaoSalvarProdutoEditavel").on('click', function(e) {
			e.preventDefault();
			var valores = jQuery('#containerProdutoSelecao');

			if (valores.find('#qtde').val() !== '' && parseFloat(valores.find('#qtde').val()) > 0.0 && valores.find('#rReais').val() !== '' && parseFloat(valores.find('#rReais').val())) {

				if (produtoSelecionado.codigo != undefined) {
					var tempProduto = produtoSelecionado;
				} else {
					var tempProduto = produtoSelecionado.produto;
				}

				if (produtoSelecionado.saldo != undefined) {
					var valor = produtoSelecionado.saldo;
					if (valor != 0) {
						if (valor < 0) {

							persistenceBanco.query("confSinc").all().execute().done(function(results) {
								var saldo = new Saldo();
								saldo.empresaId = results[0].empresa;
								saldo.vendedorId = results[0].vendedor;
								saldo.saldo = (valor * -1) + saldoFinal;
								saldoFinal = saldoFinal + valor;
								saldo.acrescimo = valor * -1;
								saldo.referencia = 'Pedido Nº' + pedido.id + ', [ DEL ] Produto ' + tempProduto.codigo + ' - ' + tempProduto.descricao;

								adicionarBanco(persistenceBanco, 'saldos', saldo, function(item) {

								});
							});
						} else if (valor > 0) {
							persistenceBanco.query("confSinc").all().execute().done(function(results) {
								var saldo = new Saldo();
								saldo.empresaId = results[0].empresa;
								saldo.vendedorId = results[0].vendedor;
								saldo.saldo = valor - saldoFinal;
								saldoFinal = saldoFinal - valor;
								saldo.desconto = valor;
								saldo.referencia = 'Pedido Nº' + pedido.id + ', [ DEL ] Produto ' + tempProduto.codigo + ' - ' + tempProduto.descricao;

								adicionarBanco(persistenceBanco, 'saldos', saldo, function(item) {

								});
							});
						}
					}
				}

				if (verificarDescontoMaximo()) {

					jQuery('#containerProdutoSelecao').hide('fast', function() {});

					var quantidade = valores.find('#qtde').val();
					var valorAlterado = valores.find('#rReais').val();
					var acresc = valores.find('#acresc').val();
					var desc = valores.find('#desc').val();
					var total = valores.find('#totalReais').val();
					var tabela = valores.find('#valorReais').val();
					var alteracao = false;

					quantidade = valores.find('#qtde').val();
					valorAlterado = valores.find('#rReais').val();
					acresc = valores.find('#acresc').val();
					desc = valores.find('#desc').val();
					total = valores.find('#totalReais').val();
					tabela = valores.find('#valorReais').val();
					alteracao = false;

					if (produtoSelecionado.produto != undefined) {
						alteracao = true;
						produtoSelecionado = produtoSelecionado.produto;
					}

					var produto = {
						produto: produtoSelecionado,
						valorTabela: tabela,
						quantidade: quantidade,
						valorAlterado: valorAlterado,
						acresc: acresc,
						desc: desc,
						total: total,
						id: produtoSelecionado.id,
						saldo: saldoAlterado
					};

					saldoAlterado = 0;
					var num = pedido.produtos.length;

					for (var i = 0; i < pedido.produtos.length; i++) {
						if (pedido.produtos[i].id == produto.id) {
							num = i;
						}
					};

					pedido.produtos[num] = "";
					pedido.produtos[num] = produto;

					produtoSelecionado = '';
					persistenceBanco.pedidos.update(pedido).done(function(a) {
						console.log('Pedido: ' + pedido.id);

						localStorage.setItem("pedidoFinal", pedido);
						jQuery("#buscaGridPedido").show(0, function() {
							jQuery("#containerProduto").show(0, function() {
								if (alteracao) {
									jQuery('#containerProduto div').empty();
									gerarListaProdutos(pedido.produtos);
									var acrescimoFooter = 0;
									var descontoFooter = 0;
									var totalFooter = 0;

									for (var i = pedido.produtos.length - 1; i >= 0; i--) {
										acrescimoFooter += parseFloat(pedido.produtos[i].acresc);
										descontoFooter += parseFloat(pedido.produtos[i].desc);
										totalFooter += parseFloat(pedido.produtos[i].total);
									};

									acrescimoFooter = accounting.formatMoney(acrescimoFooter, "", 2, ".", ",");
									descontoFooter = accounting.formatMoney(descontoFooter, "", 2, ".", ",");
									totalFooter = accounting.formatMoney(totalFooter, "", 2, ".", ",");

									jQuery('#footer #branco').append(' Acresc: ' + acrescimoFooter + ' Desc: ' + descontoFooter + ' Total: ' + totalFooter);
								}
							});
						});

					});

					updatePedido();
				}
			} else {
				alert('Quantidade ou valor vazio!');
			}
		});

		jQuery("#pesquisaCliente").on('click', "#botaoSincronizar", function(e) {
			e.preventDefault();
			if (gridProdutos != undefined) {
				gridProdutos.pararGerarGrid();
				gridProdutos = undefined;
			}
			var ads = {
				'teste': {
					type: 'iframe',
					src: '../../view/popup/progresso.html'
				}
			};
			jQuery('body').adPopupPro({
				ads: ads,
				show_type: 'always',
				show_chance: 1,
				show_close_button: false,
				mobile: true,
				tablets: true,
				min_screen_size: '0x0',
				internet_explorer: 'normal',
				os: '',
				cookie_id: '2',
				popup_color: 'light',
				popup_shadow: true,
				overlay_opacity: 0.5,
				overlay_color: 'dark',
				overlay_close: false,
				escape_close: false,
				auto_close_after: false
			});

			setTimeout(function() {
				jQuery('#iframePopUp').contents().find('#barProgresso').css('width', '20%');
				persistenceBanco.query("confSinc").all().execute().done(function(results) {
					jQuery('#iframePopUp').contents().find('#barProgresso').css('width', '40%');
					var retorno = results[0];
					jQuery('#iframePopUp').contents().find('#barProgresso').css('width', '60%');
					var teste = new SincProdutos(retorno.ip, retorno.banco, retorno.empresa, function() {
						jQuery('#iframePopUp').contents().find('#barProgresso').css('width', '100%');
						setTimeout(function() {

							persistenceBanco.query("produtos").all().execute().done(function(results) {
								jQuery('.adpopup').remove();
								jQuery('.adpopup-overlay').remove();
								produtosAll = results;
								gridGrande();
							});

						}, 1000);
					});

				});
			}, 1000);
		});

		//-----------------------------------------------------------------------------
		//---------------- BOTÃO PESQUISAR CLIENTE ------------------
		//-----------------------------------------------------------------------------
		jQuery("#imgSearch").on('click', function(e) {
			localStorage.removeItem("pedidoFinal");
			localStorage.removeItem("pedidoCliente");

			window.location.replace('../../view/pedidos/cliente/listaClientes.html');
		});

		//-----------------------------------------------------------------------------
		//---------------- BOTÃO ADICIONAR PRODUTO ------------------
		//-----------------------------------------------------------------------------
		jQuery("#pesquisaCliente").on('click', '#botaoAdicionar', function(e) {
			if (pedido.status == 0) {
				indexLista = 2;
				zerarContainer(true);
				trocaMenu(getMenuProdutos());
				jQuery('#produto').show('fast', function() {
					jQuery('#produto').fadeIn('fast');
					jQuery('#produto').show("#containerProduto");

					jQuery('#pesquisaCliente').empty();
					jQuery('#pesquisaCliente').append(getBuscaProduto());
				});

				if (produtosAll == undefined || produtosAll.length <= 0) {

					persistenceBanco.query("produtos").all().execute().done(function(results) {
						produtosAll = results;
						document.getElementById("containerProduto").innerHTML = null;
						gridProdutos = gerarListaProdutosBusca(results);
					});
				} else {
					document.getElementById("containerProduto").innerHTML = null;
					gridProdutos = gerarListaProdutosBusca(produtosAll);
				}
			}
		});

		jQuery(document).on('click', '#filtrarMenu', function(e) {
			e.preventDefault();
			var ads = {
				'teste': {
					type: 'iframe',
					src: '../../view/popup/filtrarProduto.html'
				}
			};
			jQuery('body').adPopupPro({
				ads: ads,
				show_type: 'always',
				show_chance: 1,
				show_close_button: false,
				mobile: true,
				tablets: true,
				min_screen_size: '0x0',
				internet_explorer: 'normal',
				os: '',
				cookie_id: '2',
				popup_color: 'light',
				popup_shadow: true,
				overlay_opacity: 0.5,
				overlay_color: 'dark',
				overlay_close: false,
				escape_close: false,
				auto_close_after: false
			});

		});

		jQuery(document).on('click', '#ordenarMenu', function(e) {
			e.preventDefault();
			var ads = {
				'teste': {
					type: 'iframe',
					src: '../../view/popup/ordenacaoProduto.html'
				}
			};
			jQuery('body').adPopupPro({
				ads: ads,
				show_type: 'always',
				show_chance: 1,
				show_close_button: false,
				mobile: true,
				tablets: true,
				min_screen_size: '0x0',
				internet_explorer: 'normal',
				os: '',
				cookie_id: '2',
				popup_color: 'light',
				popup_shadow: true,
				overlay_opacity: 0.5,
				overlay_color: 'dark',
				overlay_close: false,
				escape_close: false,
				auto_close_after: false
			});

		});

	});
}

function verificarESetarValorAlterado() {

	var form = jQuery('#containerProdutoSelecao');

	var valorOriginal = form.find('#valorReais').val();
	valorOriginal = valorOriginal.replace(' A', '').replace(' D', '').replace('X', '');
	var quantidade = form.find('#qtde').val();
	var valorDesconto = jQuery('#rReais').val();

	//setar valor acre. desc.
	var totalOriginal = valorOriginal * quantidade;

	var totalDesconto = valorDesconto * quantidade;

	var totalFinal = totalDesconto - totalOriginal;

	form.find('#acresc').val(0);
	form.find('#desc').val(0);
	form.find('#totalReais').val(0);

	if (totalFinal > 0) {
		form.find('#acresc').val(totalFinal.toFixed(2));
	}
	if (totalFinal < 0) {
		form.find('#desc').val(totalFinal.toFixed(2) * -1);
	}

	form.find('#totalReais').val(totalDesconto.toFixed(2));
}

function setarFormaPagamento() {

	persistenceBanco.formaPagamento.query().all().execute().done(function(itemFormaPagamento) {

		persistenceBanco.query('formaPagamentoCliente').filter(function(e) {
			return e.cpfCnpj == pedido.cliente.cpfCnpj;
		}).execute().done(function(results) {

			if (results.length > 0) {
				for (var j = 0; j < itemFormaPagamento.length; j++) {
					for (var i = 0; i < results.length; i++) {
						if (results[i].formaPagamentoId == itemFormaPagamento[j].formaPagamentoId) {
							jQuery('#formaPagamento').append('<option value="' + itemFormaPagamento[j].formaPagamentoId + '">' + itemFormaPagamento[j].formaPagamentoId + ' - ' + itemFormaPagamento[j].descricao + '</option>');
						}
					};
				};
				jQuery('#formaPagamento').val(results[0].padrao);
			} else {

				for (var i = 0; i < itemFormaPagamento.length; i++) {
					jQuery('#formaPagamento').append('<option value="' + itemFormaPagamento[i].formaPagamentoId + '">' + itemFormaPagamento[i].formaPagamentoId + ' - ' + itemFormaPagamento[i].descricao + '</option>');
				};

				jQuery('#formaPagamento').val(pedido.cliente.formaPagamento);
			}
		});
	});
}

function setarListaPreco() {

	if (pedido.cliente.listaPrecoId != 0) {
		persistenceBanco.listaPreco.query().filter('listaId', pedido.cliente.listaPrecoId).execute().done(function(listaEspecifico) {

			if (listaEspecifico.length != 0) {
				jQuery('#listaPreco').append('<option value="' + listaEspecifico[0].listaId + '">' + listaEspecifico[0].listaId + ' - ' + listaEspecifico[0].descricao + '</option>');
				pedido.listaPreco.lista = listaEspecifico[0];
				jQuery('#listaPreco').val(pedido.cliente.listaPrecoId).prop('disabled', true);
			} else {
				persistenceBanco.listaPreco.query().all().execute().done(function(listaEspecifico) {

					for (var i = 0; i < itemListaPreco.length; i++) {
						jQuery('#listaPreco').append('<option value="' + itemListaPreco[i].listaId + '">' + itemListaPreco[i].listaId + ' - ' + itemListaPreco[i].descricao + '</option>');
					};
				});
			}
		});
	} else {
		persistenceBanco.listaPreco.query().all().execute().done(function(itemListaPreco) {

			for (var i = 0; i < itemListaPreco.length; i++) {
				jQuery('#listaPreco').empty();
				jQuery('#listaPreco').append('<option value="' + itemListaPreco[i].listaId + '">' + itemListaPreco[i].listaId + ' - ' + itemListaPreco[i].descricao + '</option>');
			};
		});
	}
}

function gerarListaProdutosBusca(results) {
	if (grid != undefined) {
		grid.pararGerarGrid();
		jQuery('.adpopup-overlay.adpopup-style-overlay-dark').trigger("click");
		document.getElementById("containerProduto").innerHTML = null;
	}

	grid = new ListaGrid("", results, "#containerProduto");
	grid.setTitulo([
		["descricao"],
		["linha"],
		["coluna"]
	]);

	//primeira Linha
	grid.adicionarElemento('0', 'Código:', '2', 'center', 'blue');
	grid.adicionarElemento('0', 'codigo', '2', 'left');
	grid.adicionarElemento('0', 'Un:', '1', 'center', 'blue');
	grid.adicionarElemento('0', 'un', '2', 'left');
	grid.adicionarElemento('0', 'Valor R$:', '3', 'center', 'blue');
	grid.adicionarElemento('0', 'valor', '2', 'left');

	//segunda linha
	grid.adicionarElemento('1', 'Grupo:', '2', 'center', 'blue');
	grid.adicionarElemento('1', 'grupo', '5', 'left');
	grid.adicionarElemento('1', 'Estoque:', '3', 'center', 'blue');
	grid.adicionarElemento('1', 'estoque', '2', 'left');

	grid.setNumerosMaxLinhas(2);

	grid.setNumeroFormatado('valor');

	grid.setarCorCondicao(['estoque', 'descricao'], 'estoque', 'red', '<=', 0);

	grid.montarCampos('linhaPrincipal', function() {

	});
	return grid;

}

function gridGrande() {
	gerarListaProdutosBusca(produtosAll);
}

function gridSimples() {
	if (grid != undefined) {
		grid.pararGerarGrid();
		jQuery('.adpopup-overlay.adpopup-style-overlay-dark').trigger("click");
		document.getElementById("containerProduto").innerHTML = null;
	}

	grid = new ListaGrid("", produtosAll, "#containerProduto");
	grid.setTitulo(["descricao", "linha", "coluna"]);

	//primeira Linha
	grid.adicionarElemento('0', '', '10', 'center', 'blue');
	grid.adicionarElemento('0', 'valor', '2', 'left');

	grid.setNumerosMaxLinhas(1);

	grid.setNumeroFormatado('valor');

	grid.setarCorCondicao(['estoque', 'descricao'], 'estoque', 'red', '<=', 0);

	grid.montarCampos('linhaPrincipalSimples', function() {});
}

function gerarListaProdutos(results) {
	if (grid != undefined) {
		grid.pararGerarGrid();
		jQuery('.adpopup-overlay.adpopup-style-overlay-dark').trigger("click");
		document.getElementById("containerProduto").innerHTML = null;
	}

	grid = new ListaGrid("", results, "#containerProduto");

	//SETAR UM MODOLO
	grid.setTitulo([
		["produto", "descricao"],
		["produto", "un"]
	]);

	grid.adicionarElemento('0', 'Cód:', '1', 'right', 'blue');
	grid.adicionarElemento('0', ['produto', 'codigo'], '2', 'left');
	grid.adicionarElemento('0', 'Qtde:', '1', 'right', 'blue');
	grid.adicionarElemento('0', 'quantidade', '2', 'left');
	grid.adicionarElemento('0', 'R$ Cad.:', '3', 'right', 'blue');
	grid.adicionarElemento('0', ['produto', 'valor'], '3', 'left');
	grid.adicionarElemento('1', 'Acre:', '1', 'right', 'blue');
	grid.adicionarElemento('1', 'acresc', '2', 'left', 'green');
	grid.adicionarElemento('1', 'Desc:', '1', 'right', 'blue');
	grid.adicionarElemento('1', 'desc', '2', 'left', 'red');
	grid.adicionarElemento('1', 'R$ Final:', '3', 'right', 'blue');
	grid.adicionarElemento('1', 'valorAlterado', '3', 'left');
	grid.adicionarElemento('2', 'Total R$:', '3', 'right', 'blue');
	grid.adicionarElemento('2', 'total', '3', 'left');
	grid.setNumerosMaxLinhas(3);

	//formata numero para valores em reais
	// grid.setNumeroFormatado(['produto', 'valor']);
	grid.setNumeroFormatado('desc');
	grid.setNumeroFormatado('valorAlterado');
	grid.setNumeroFormatado('total');
	grid.setNumeroFormatado('acresc');
	grid.setNumeroFormatado(['produto', 'valor']);

	grid.montarCampos('linhaPrincipal', function() {
		// new setarFont('.row .linhaContainer #linhaPrincipal', '30px', '11px', 1.5);
	});
}

function gerarListaProdutosMix(results) {
	if (grid != undefined) {
		grid.pararGerarGrid();
		jQuery('.adpopup-overlay.adpopup-style-overlay-dark').trigger("click");
		document.getElementById("containerProduto").innerHTML = null;
	}

	grid = new ListaGrid("", results, "#containerMix");
	grid.setTitulo([
		["descricao"],
		["linha"],
		["coluna"]
	]);

	//primeira Linha
	grid.adicionarElemento('0', 'Código:', '2', 'center', 'blue');
	grid.adicionarElemento('0', 'codigo', '2', 'left');
	grid.adicionarElemento('0', 'Un:', '1', 'center', 'blue');
	grid.adicionarElemento('0', 'un', '2', 'left');
	grid.adicionarElemento('0', 'Valor R$:', '3', 'center', 'blue');
	grid.adicionarElemento('0', 'valor', '2', 'left');

	//segunda linha
	grid.adicionarElemento('1', 'Grupo:', '2', 'center', 'blue');
	grid.adicionarElemento('1', 'grupo', '5', 'left');
	grid.adicionarElemento('1', 'Estoque:', '3', 'center', 'blue');
	grid.adicionarElemento('1', 'estoque', '2', 'left');

	grid.setNumerosMaxLinhas(2);

	grid.setNumeroFormatado('valor');

	grid.setarCorCondicao(['estoque', 'descricao'], 'estoque', 'red', '<=', 0);

	grid.montarCampos('linhaPrincipal', function() {

	});
	return grid;

}

function setarCliente(produto) {

	jQuery("#razaoSocial").val(produto.cliente.nome);
	jQuery("#fantasia").val(produto.cliente.fantasia);
	jQuery("#cnpjCpf").val(produto.cliente.cpfCnpj);
	jQuery("#listaPreco").val(produto.cliente.listaPrecoId);
	jQuery("#formaPagamento").val(produto.cliente.formaPagamento);
	jQuery("#observacao").val(produto.observacao);

}

function retornoGrid(a, i) {
	switch (indexLista) {
		case 1:
			//lista produtos selecionados
			produtoSelecionado = a;
			var ads = {
				'teste': {
					type: 'iframe',
					src: '../../view/popup/lista_produtoListaPequena.html'
				}
			};
			jQuery('body').adPopupPro({
				ads: ads,
				show_type: 'always',
				show_chance: 1,
				show_close_button: false,
				mobile: true,
				tablets: true,
				min_screen_size: '0x0',
				internet_explorer: 'normal',
				os: '',
				cookie_id: '2',
				popup_color: 'light',
				popup_shadow: true,
				overlay_opacity: 0.5,
				overlay_color: 'dark',
				overlay_close: false,
				escape_close: false,
				auto_close_after: false
			});

			break;
		case 2:
			//lista todos os produtos
			var existe = false;
			if (pedido.status == 0) {
				for (var i = 0; i < pedido.produtos.length; i++) {
					if (pedido.produtos[i].id == a.id) {
						existe = true;
					}
				};

				if (!existe) {
					if (gridProdutos != undefined) {
						gridProdutos.pararGerarGrid();
						gridProdutos = undefined;
					}
					produtoSelecionado = a;
					gerarTelaEdicaoProduto(a, true);
				}
			}
			break;
	}
}

function zerarContainer(fast) {
	if (fast) {
		if (gridProdutos != undefined) {
			gridProdutos.pararGerarGrid();
			gridProdutos = undefined;
		}

		jQuery('#pedido').fadeOut('fast', function() {
			jQuery(this).hide();
		});
		jQuery('#produto').fadeOut('fast', function() {
			jQuery(this).hide();
		});
		jQuery('#mixMobile').fadeOut('fast', function() {
			jQuery(this).hide();
		});
		jQuery('#mixFatura').fadeOut('fast', function() {
			jQuery(this).hide();
		});
		jQuery('#listaProdutoSelecao').fadeOut('fast', function() {
			jQuery(this).hide();
		});
		jQuery('#edicaoProdutoSelecionado').fadeOut('fast', function() {
			jQuery(this).hide();
		});
		jQuery("#containerProdutoSelecao").fadeOut('fast', function() {
			jQuery(this).hide();
		});
	} else {
		if (gridProdutos != undefined) {
			gridProdutos.pararGerarGrid();
			gridProdutos = undefined;
		}
		jQuery('#pedido').fadeOut(0, function() {
			jQuery(this).hide();
		});
		jQuery('#produto').fadeOut(0, function() {
			jQuery(this).hide();
		});
		jQuery('#mixMobile').fadeOut(0, function() {
			jQuery(this).hide();
		});
		jQuery('#mixFatura').fadeOut(0, function() {
			jQuery(this).hide();
		});
		jQuery('#listaProdutoSelecao').fadeOut(0, function() {
			jQuery(this).hide();
		});
		jQuery('#edicaoProdutoSelecionado').fadeOut(0, function() {
			jQuery(this).hide();
		});
		jQuery("#containerProdutoSelecao").fadeOut(0, function() {
			jQuery(this).hide();
		});
	}
}

function gerarTelaEdicaoProduto(a, novo) {
	jQuery('body,html').scrollTop(0);
	jQuery("#containerProduto").hide(0, function() {
		jQuery("#footer").empty();
		jQuery("#buscaGridPedido").hide(0, function() {
			jQuery('#containerProdutoSelecao').show('fast', function() {
				jQuery(this).fadeIn('fast');

				if (novo) {
					jQuery("#footer").empty();

					jQuery(this).find('#descricaoProduto').val(a.descricao).prop('disabled', true);
					jQuery(this).find('#unidadeProduto').val(a.un).prop('disabled', true);
					jQuery(this).find('#valorReais').val(a.valor).prop('disabled', true);
					jQuery(this).find('#descMax').val(a.descontoMax + "%").prop('disabled', true);
					jQuery(this).find('#qtde').val(1);
					jQuery(this).find('#rReais').val(a.valor);
					if (pedido.tipoOperacao != 0) {
						jQuery(this).find('#rReais').prop('disabled', true);
					}
					setarValorFinalTabelaPreco();
					jQuery(this).find('#saldoReais').val(parseFloat(saldoFinal).toFixed(2)).prop('disabled', true);
					jQuery(this).find('#acresc').val(0.0).css('color', 'blue').prop('disabled', true);
					jQuery(this).find('#desc').val(0.0).css('color', 'red').prop('disabled', true);

					jQuery(this).find('#totalReais').prop('disabled', true);

				} else {
					jQuery("#footer").empty();

					jQuery(this).find('#descricaoProduto').val(a.produto.descricao).prop('disabled', true);
					jQuery(this).find('#unidadeProduto').val(a.produto.un).prop('disabled', true);
					jQuery(this).find('#valorReais').val(a.valorTabela).prop('disabled', true);
					jQuery(this).find('#descMax').val(a.produto.descontoMax + '%').prop('disabled', true);
					jQuery(this).find('#qtde').val(a.quantidade);
					jQuery(this).find('#rReais').val(a.valorAlterado);
					if (pedido.tipoOperacao != 0) {
						jQuery(this).find('#rReais').prop('disabled', true);
					}
					jQuery(this).find('#saldoReais').val(parseFloat(saldoFinal).toFixed(2)).prop('disabled', true);
					jQuery(this).find('#acresc').val(a.acresc).css('color', 'blue').prop('disabled', true);
					jQuery(this).find('#desc').val(a.desc).css('color', 'red').prop('disabled', true);
					jQuery(this).find('#totalReais').val(a.total).prop('disabled', true);
				}

			});
		});
	});

}

function verificarDescontoMaximo() {
	var valorVerificar = jQuery('#containerProdutoSelecao').find('#valorReais').val();
	var descontoMax = jQuery('#containerProdutoSelecao').find('#descMax').val();
	var valorAlterado = jQuery('#containerProdutoSelecao').find('#rReais').val();
	if (saldoFinal < 0) {

		if (existeLista == 0) {
			valorVerificar = valorVerificar.replace(' A', '').replace(' D', '').replace(' X', '');
			valorVerificar = valorVerificar - ((valorVerificar * parseFloat(descontoMax.replace('%', ''))) / 100);
			if (valorAlterado < valorVerificar) {
				alert('Valor Mínimo é de ' + valorVerificar.toFixed(2));

				return false;
			} else {
				return true;
			}
		} else {
			valorVerificar = valorVerificar.replace(' A', '').replace(' D', '').replace(' X', '');

			if (valorAlterado < parseFloat(valorVerificar)) {
				alert('Valor Mínimo é de ' + parseFloat(valorVerificar).toFixed(2));

				return false;
			} else {
				return true;
			}
		}
	} else {
		//-------
		//caso tenha flex implementar aqui ...
		//-------

		valorVerificar = valorVerificar.replace(' A', '').replace(' D', '').replace(' X', '');
		valorVerificar = valorVerificar - ((valorVerificar * parseFloat(descontoMax.replace('%', ''))) / 100);

		var valorPrecoSemDesconto = valorAlterado - valorVerificar;

		if (valorPrecoSemDesconto > 0) {
			acrescentarFlex(valorPrecoSemDesconto);
			return true;
		} else {
			if ((saldoFinal - (valorPrecoSemDesconto * -1)) > 0) {
				decrementarFlex(valorPrecoSemDesconto);
				return true;
			} else {
				alert('Saldo insuficiente para esse valor');
				return false;
			}
		}

	}
}

function acrescentarFlex(valor) {

	if (produtoSelecionado.codigo != undefined) {
		var produto = produtoSelecionado;
	} else {
		var produto = produtoSelecionado.produto;
	}

	var saldo = new Saldo();

	persistenceBanco.query("confSinc").all().execute().done(function(results) {
		conf = results[0];
		saldo.referencia = 'Pedido Nº' + pedido.id + ', [ ADD ] Produto ' + produto.codigo + ' - ' + produto.descricao;
		saldo.desconto = 0.0;
		saldo.acrescimo = valor;
		saldo.empresaId = conf.empresa;
		saldo.vendedorId = conf.vendedor;
		saldo.saldo = saldoFinal - valor;

		saldoAlterado = valor;

		saldoFinal = saldoFinal + valor;
		adicionarBanco(persistenceBanco, 'saldos', saldo, function(item) {

		});
	});
}

function decrementarFlex(valor) {

	if (valor < 0) {
		saldoAlterado = valor;
		valor = valor * -1;
	}

	if (produtoSelecionado.codigo != undefined) {
		var produto = produtoSelecionado;
	} else {
		var produto = produtoSelecionado.produto;
	}

	var saldo = new Saldo();
	var conf;
	persistenceBanco.query("confSinc").all().execute().done(function(results) {
		conf = results[0];
		saldo.referencia = 'Pedido Nº' + pedido.id + ', [ ADD ] Produto ' + produto.codigo + ' - ' + produto.descricao;
		saldo.desconto = valor;
		saldo.acrescimo = 0.0;
		saldo.empresaId = conf.empresa;
		saldo.vendedorId = conf.vendedor;
		saldo.saldo = saldoFinal - valor;

		saldoFinal = saldoFinal - valor;
		adicionarBanco(persistenceBanco, 'saldos', saldo, function(item) {

		});

	});
}

function filtroProduto(valorReferencia) {
	if (gridProdutos != undefined) {
		gridProdutos.pararGerarGrid();
		gridProdutos = undefined;
	}
	if (valorReferencia == 'estoque') {

		setTimeout(function() {
			persistenceBanco.produtos.query().filter(function(produto) {
				return produto.estoque > 0;
			}).execute().done(function(results) {
				produtosAll = results;
				gridGrande();
			});
		}, 1000);

	} else if (valorReferencia == 'semEstoque') {
		setTimeout(function() {
			persistenceBanco.produtos.query().filter(function(produto) {
				return produto.estoque < 0;
			}).execute().done(function(results) {
				produtosAll = results;
				gridGrande();
			});
		}, 1000);
	} else {
		setTimeout(function() {
			persistenceBanco.produtos.query().all().execute().done(function(results) {
				produtosAll = results;
				gridGrande();
			});
		}, 1000);
	}

	jQuery(".opcaoMenu").trigger("click");
	jQuery('.adpopup').fadeOut(500, function() {
		jQuery('.adpopup').remove();
		jQuery('.adpopup-overlay').fadeOut(500);
	});

}

function ordenacaoProduto(valorReferencia) {
	if (gridProdutos != undefined) {
		gridProdutos.pararGerarGrid();
		gridProdutos = undefined;
	}
	var valor = valorReferencia;
	produtosAll.sort(function(obj1, obj2) {
		var um = obj1[valor];
		var dois = obj2[valor];

		if (um.indexOf('.') != -1) {
			um = parseFloat(obj1[valor].replace(",", "."));
			dois = parseFloat(obj2[valor].replace(",", "."));
			return dois - um;
		} else {
			return um < dois ? -1 : (um > dois ? 1 : 0);
		}
	});
	jQuery(".opcaoMenu").trigger("click");
	jQuery('.adpopup').fadeOut(500, function() {
		jQuery('.adpopup').remove();
		jQuery('.adpopup-overlay').fadeOut(500);
	});
	gridGrande();
}

function botaoBack() {
	updatePedido();
	if (jQuery('.adpopup').length > 0 || jQuery('.menuAberto').length > 0) {
		if (jQuery('.adpopup').length > 0) {
			jQuery('.adpopup').fadeOut(500, function() {
				jQuery('.adpopup').remove();
				jQuery('.adpopup-overlay').fadeOut(500);
			});
		} else if (jQuery('.menuAberto').length > 0) {
			jQuery(".opcaoMenu").trigger('click');
		}
	} else {
		window.location.replace('../../view/pedidos/pedidoPrincipal.html');
	}
}

function getBuscaProduto() {

	var ret = '';
	ret += '<div id="inputPesquisa" style="padding: 0px"';
	ret += ' class="col-xs-8 col-sm-8" style="padding: 2px">';
	ret += '<input type="text" id="pesquisaValorProduto" name="pesquisaValor"';
	ret += 'title="Desc., Cód, Grupo">';
	ret += '</div>';
	ret += '<div id="botaoLista" style="padding: 1px" class="col-xs-2 col-sm-2">';
	ret += '<div class="botaoNovoLista">';
	ret += '<img alt="tipoLista" class="img-responsive center-block"';
	ret += 'src="../../img/android/ico_tipolista.png">';
	ret += '</div>';
	ret += '</div>';
	ret += '<div id="botaoSincronizar" style="padding: 1px"';
	ret += 'class="col-xs-2 col-sm-2">';
	ret += '<div class="botaoNovoLista">';
	ret += '<img alt="tipoLista" class="img-responsive center-block"';
	ret += 'src="../../img/android/ico_sincronizar.png">';
	ret += '</div>';
	ret += '</div>';

	return ret;
}

function getBuscaProdutoAdicionar() {

	var ret = '';
	ret += '<div id="inputPesquisa" style="padding: 0px"';
	ret += ' class="col-xs-10 col-sm-10" style="padding: 2px">';
	ret += '<input type="text" id="pesquisaValorProdutoAdicionado" name="pesquisaValor"';
	ret += ' title="Desc., Cód, Grupo">';
	ret += '</div>';
	ret += '<div id="botaoAdicionar" style="padding: 1px"';
	ret += ' class="col-xs-2 col-sm-2">';
	ret += '<div class="botaoNovoLista">';
	ret += '<img alt="tipoLista" id="imagemBotaoBuscar" class="img-responsive center-block"';
	ret += ' src="../../img/android/ico_adicionar.png">';
	ret += '</div>';
	ret += '</div>';
	ret += '</div>';

	return ret;

}

function getBuscaMixMobile() {

	var ret = '';
	ret += '<div id="inputPesquisa" style="padding: 0px"';
	ret += ' class="col-xs-12 col-sm-12" style="padding: 2px">';
	ret += '<input type="text" id="pesquisaMixMobile" name="pesquisaValor"';
	ret += ' title="">';
	ret += '</div>';
	ret += '</div>';

	return ret;

}

function getMenuProdutos() {

	var ret = '';
	ret += '<div id="menuTitulo" class="row">';
	ret += '<div class="col-xs-12 col-sm-12 center-block">';
	ret += '<div style="height: 41px"></div>';
	ret += '</div>';
	ret += '</div>';

	ret += '<div id="ordenarMenu" class="row ordenar">';
	ret += '<div id="menuItemImage" class="col-xs-5 col-sm-5">';
	ret += '<img alt="ord" class="img-responsive"';
	ret += ' src="../../img/android/ico_order.png">';
	ret += '</div>';
	ret += '<div id="menuItemTexto" class="col-xs-7 col-sm-7"><p>Ordenar</p></div>';
	ret += '</div>';

	ret += '<div id="filtrarMenu" class="row ordenar">';
	ret += '<div id="menuItemImage" class="col-xs-5 col-sm-5">';
	ret += '<img alt="ord" class="img-responsive"';
	ret += ' src="../../img/android/ico_filtrar.png">';
	ret += '</div>';
	ret += '<div id="menuItemTexto" class="col-xs-7 col-sm-7"><p>Filtrar</p></div>';
	ret += '</div>';

	ret += '<div id="opcoesMenu" class="row ordenar">';
	ret += '<div id="menuItemImage" class="col-xs-5 col-sm-5">';
	ret += '<img alt="ord" class="img-responsive"';
	ret += ' src="../../img/android/ico_opcoes.png">';
	ret += '</div>';
	ret += '<div id="menuItemTexto" class="col-xs-7 col-sm-7"><p>Opções</p></div>';
	ret += '</div>';

	ret += '<div id="ordenar" class="row ordenar">';
	ret += '<div id="menuItemImage" class="col-xs-5 col-sm-5">';
	ret += '<img alt="ord" class="img-responsive"';
	ret += ' src="../../img/android/ico_voltar.png">';
	ret += '</div>';
	ret += '<div id="menuItemTexto" class="col-xs-7 col-sm-7"><p>Voltar</p></div>';
	ret += '</div>';

	return ret;
}

function getMenuPedido() {

	var ret = '';
	ret += '<div id="menuTitulo" class="row">';
	ret += '<div class="col-xs-12 col-sm-12 center-block">';
	ret += '<div style="height: 41px"></div>';
	ret += '</div>';
	ret += '</div>';

	ret += '<div id="ordenar" class="row ordenar">';
	ret += '<div id="menuItemImage" class="col-xs-5 col-sm-5">';
	ret += '<img alt="ord" class="img-responsive"';
	ret += ' src="../../img/android/ico_voltar.png">';
	ret += '</div>';
	ret += '<div id="menuItemTexto" class="col-xs-7 col-sm-7"><p>Voltar</p></div>';
	ret += '</div>';

	ret += '<div id="opcoesMenu" class="row ordenar">';
	ret += '<div id="menuItemImage" class="col-xs-5 col-sm-5">';
	ret += '<img alt="ord" class="img-responsive"';
	ret += ' src="../../img/android/ico_opcoes.png">';
	ret += '</div>';
	ret += '<div id="menuItemTexto" class="col-xs-7 col-sm-7"><p>Salvar</p></div>';
	ret += '</div>';

	return ret;

}

function setarValorFinalTabelaPreco() {
	var campo = jQuery('#containerProdutoSelecao').find('#rReais');
	var valor = parseFloat(campo.val());
	var tipoRetorno = '';
	persistenceBanco.query('listaPreco').filter('listaId', pedido.listaPreco).execute().done(function(results) {
		if (results[0] != undefined) {
			var lista = results[0];
			if (lista.tipoLista == 'A') {
				valor = valor + ((valor * parseFloat(lista.percentual)) / 100);
				existeLista = 0;
				tipoRetorno = ' A';
			} else if (lista.tipoLista == 'D') {
				existeLista = 1;
				valor = valor - ((valor * parseFloat(lista.percentual)) / 100);
				jQuery('#containerProdutoSelecao').find('#descMax').val(lista.percentual);
				tipoRetorno = ' D';
			} else if (lista.tipoLista == 'X') {
				persistenceBanco.query('listaPrecoProduto').filter(function(e) {
					return e.listaId == pedido.listaPreco && e.produtoId == produtoSelecionado.produtoId;
				}).execute().done(function(resultsNovo) {

					if (resultsNovo[0] != undefined) {
						var listaNova = resultsNovo[0];

						if (listaNova.tipo == 'A') {
							existeLista = 0;
							valor = valor + ((valor * parseFloat(listaNova.percentual)) / 100);
							tipoRetorno = ' A';
						} else if (listaNova.tipo == 'D') {
							existeLista = 1;
							valor = valor - ((valor * parseFloat(listaNova.percentual)) / 100);
							jQuery('#containerProdutoSelecao').find('#descMax').val(parseFloat(listaNova.percentual).toFixed(2) + '%');
							tipoRetorno = ' D';
						}
						campo.val(valor.toFixed(2));
						jQuery('#containerProdutoSelecao').find('#totalReais').val(valor.toFixed(2));
						jQuery('#containerProdutoSelecao').find('#valorReais').val(valor.toFixed(2) + tipoRetorno);
					} else {
						existeLista = 0;
					}
				});
			}
			campo.val(valor.toFixed(2));
			jQuery('#containerProdutoSelecao').find('#totalReais').val(valor.toFixed(2));
			jQuery('#containerProdutoSelecao').find('#valorReais').val(valor.toFixed(2) + tipoRetorno);
		} else {
			existeLista = 3;
			campo.val(valor.toFixed(2));
			jQuery('#containerProdutoSelecao').find('#totalReais').val(valor.toFixed(2));
			jQuery('#containerProdutoSelecao').find('#valorReais').val(valor.toFixed(2) + tipoRetorno);
		}
	});
}

function updatePedido() {

	pedido.formaPagamento = jQuery('#formaPagamento').val();
	pedido.listaPreco = jQuery('#listaPreco').val();
	pedido.tipoOperacao = jQuery('#tipoOperacao').val();
	pedido.observacao = jQuery('#campoObservacao').val();

	pedido.total = 0;

	if (pedido.produtos.length > 0) {
		for (var i = 0; i < pedido.produtos.length; i++) {

			pedido.total += parseFloat(pedido.produtos[i].total);
		};
	}

	persistenceBanco.pedidos.update(pedido).done(function(a) {});
}

function trocaMenu(menu) {
	jQuery('.Menu').empty();
	jQuery('.Menu').append(menu);
}

function union_arrays(x, y) {
	var obj = {};
	for (var i = x.length - 1; i >= 0; --i)
		obj[x[i]] = x[i];
	for (var i = y.length - 1; i >= 0; --i)
		obj[y[i]] = y[i];
	var res = [];
	for (var k in obj) {
		if (obj.hasOwnProperty(k)) // <-- optional
			res.push(obj[k]);
	}
	return res;
}