define(function(require) {
    "use strict";
    // private
    var selectedCity;
    var selectedVehicle;
    var vehicleSelector;
    var citySelector;
    var city; 
    var vehicle;
    var parkingZones;
    var cityButton;
    var vehicleButton;
    var zoneButtons;
    var buttonNodeName;
    var request;
    var licensePlateStore = [];
    var forEach = Array.prototype.forEach;
    
    function getClassName(zone) {
        switch (zone) {
        case 'red':
            return 'pure-button-zone-red';
            break;
        case 'yellow':
            return 'pure-button-zone-yellow';
            break;
        case 'green':
            return 'pure-button-zone-green';
            break;
        case 'blue':
            return 'pure-button-zone-blue'
            break;
        case 'orange':
            return 'pure-button-zone-orange'
            break;
        case 'aqua':
            return 'pure-button-zone-aqua'
            break;
        case 'purple':
            return 'pure-button-zone-purple'
            break;
        default:
            return 'pure-button-zone-grey'
            break;
        }
    }
    
    // public
    function parking() {
        // constructor
        parkingZones = window.parkingZones;
        // last select city
        selectedCity = window.localStorage.getItem('selectedCity');
        // last select vehicle
        selectedVehicle = window.localStorage.getItem('selectedVehicle');
        // select elemtens
        vehicleSelector = document.getElementsByClassName('js-vehicle-select')[0];
        citySelector = document.getElementsByClassName('js-city-select')[0];
    
        // buttons that triger select element
        cityButton = document.getElementsByClassName('js-city-button')[0]
        vehicleButton = document.getElementsByClassName('js-vehicle-button')[0];
        
        zoneButtons = document.getElementsByClassName('js-zone-buttons')[0];
        
        buttonNodeName = document.createElement('button').nodeName;
        this.database = null;
        this.zoneButtonsAdded = false;

        request = new parkingStore(this.fetchAllLicensePlate);
        
        this.populateCityData();
        this.addEvents();
    };
    
    parking.prototype.populateCityData = function () {
        var placeHolder = document.createDocumentFragment();
        // add locations
        for (var city in parkingZones) {
            var option = document.createElement('option');

            option.setAttribute('value', city);
            option.innerHTML = city;

            if (selectedCity !== null && city === selectedCity) {
                option.setAttribute('selected', 'selected');
                document.getElementsByClassName('js-city-button')[0].innerHTML = option.innerHTML;
                this.createZoneButtons(parkingZones[city]);
            }

            placeHolder.appendChild(option);
        }
        
        citySelector.appendChild(placeHolder);
    };
    
    parking.prototype.populateLicensePlatedata = function () {
        var placeHolder = document.createDocumentFragment();
        var store = licensePlateStore;
        var selected = false;
        
        for (var id in store) {
            var vehicle = store[id].license;
            var option = document.createElement('option');

            option.setAttribute('value', vehicle);
            option.innerHTML = vehicle;
            
            if (selectedVehicle !== null && vehicle === selectedVehicle) {
                option.setAttribute('selected', 'selected');
                vehicleButton.innerHTML = option.innerHTML;
                selected = true;
            }

            placeHolder.appendChild(option);
        }
        if (!selected && store.length > 0) {
            // this.selectFirstVehicle();
            // select first vehicle
            console.log(placeHolder);
            var first = placeHolder.querySelector('option');
            first.setAttribute('selected', 'selected');
            vehicleButton.innerHTML = first.innerHTML;
            window.localStorage.setItem('selectedVehicle', first.innerHTML);
        }
        vehicleSelector.appendChild(placeHolder);
    };
    
    parking.prototype.addEvents = function () {
        var $this = this;

        citySelector.addEventListener('change', function () {
            var value = this.options[this.selectedIndex].value;
            
            cityButton.setAttribute('selected', this.options[this.selectedIndex].value);
            cityButton.innerHTML = this.options[this.selectedIndex].innerHTML;
            window.localStorage.setItem('selectedCity', value);

            $this.createZoneButtons(parkingZones[value]);
        }, false);

        vehicleSelector.addEventListener('change', function () {
            var value = this.options[this.selectedIndex].value;
            vehicleButton.setAttribute('selected', value);
            vehicleButton.innerHTML = this.options[this.selectedIndex].innerHTML;
            window.localStorage.setItem('selectedVehicle', value);
        }, false);
        if (this.zoneButtonsAdded) {
            this.addZoneButtonEvent();
        }
        
        // index page "+" button
        document.getElementsByClassName('js-add-vehicle-click')[0].addEventListener('click', function () {
            $this.showAddPage();
        });
        
        // add page "dodaj" button
        document.querySelector('.js-add .js-add-button-click').addEventListener('click', function () {
            var request = new parkingStore($this.addNewLicense, function () {console.log('error');});
        });
        
        // add page back button
        document.querySelector('.js-add .js-back-to-index').addEventListener('click', function () {
            $this.showIndexPage();
        });
    };
    
    parking.prototype.createZoneButtons = function (zoneList) {
        var buttonPlaceHolder = document.createDocumentFragment();
        
        zoneList.forEach(function (el, index, array) {
            var button = document.createElement('button');
            button.className = getClassName(el.color);
            button.innerHTML = el.number + ' '  + el.name  + ' (' + el.duration + ')';
            button.setAttribute('number', el.number);
            buttonPlaceHolder.appendChild(button);
        });
        zoneButtons.innerHTML = '';
        zoneButtons.appendChild(buttonPlaceHolder);
        this.zoneButtonsAdded = true;
    };
    
    parking.prototype.addZoneButtonEvent = function () {
        var $this = this;
        zoneButtons.addEventListener('click', function (event) {
            var el = event.target;
            var number;
            var license;
            // check if user click on button
            if (el.nodeName === buttonNodeName) {
                number = el.getAttribute('number');
                license = vehicleButton.innerHTML;
        
                $this.sendSMS(number, license);
            }
        });
    };
    
    parking.prototype.sendSMS = function (number, licensePlate) {
        // Send a message
        var sms = new MozActivity({
            name: "new", // Possible compose-sms in future versions
            data: {
                type: "websms/sms",
                number: number,
                body: licensePlate
            }
        });
    };
    
    parking.prototype.fetchAllLicensePlate = function () {
        // talk witn indexedDB
        var objectStore;
        var database = request.result;
        var transaction = database.transaction(["licensePlate"], "readwrite");
        // reset array
        licensePlateStore = [];
        // remove all option
        vehicleSelector.innerHTML = '';
        objectStore = database.transaction("licensePlate").objectStore("licensePlate");
        objectStore.openCursor().onsuccess = function(event) {
            var cursor = event.target.result;
            if (cursor) {
                // console.log("Note id: "+cursor.key+", Title: "+cursor.value.city);
                licensePlateStore.push(cursor.value);
                cursor.continue();
            } else {
                // assume that all data are fetch
                // $this.populateLicensePlatedata();
                parking.prototype.populateLicensePlatedata.call();
            }
        };
    };
    
    parking.prototype.addNewLicense = function () {
        var plate = document.getElementsByClassName('js-license-plate-number')[0].value;
        var license = {
            license: plate
        };
        
        console.log(license);
        var database = request.result;
        var transaction = database.transaction(["licensePlate"], "readwrite");
        var objectStore = transaction.objectStore("licensePlate");
        var addRequest = objectStore.put(license);
        
        addRequest.onsuccess = function(event) {
            parking.prototype.fetchAllLicensePlate();
            parking.prototype.showIndexPage();
        };
        
    };
    
    parking.prototype.showIndexPage = function () {
        forEach.call(document.getElementsByClassName('js-index'), function (element, index, array) {
            element.style.display = 'inline';
        });
        forEach.call(document.getElementsByClassName('js-add'), function (element, index, array) {
            element.style.display = 'none';
        });
    };
    
    parking.prototype.showAddPage = function () {
        forEach.call(document.getElementsByClassName('js-index'), function (element, index, array) {
            element.style.display = 'none';
        });
        forEach.call(document.getElementsByClassName('js-add'), function (element, index, array) {
            element.style.display = 'inline';
        });
    };
    
    return parking;
});
