/* HTML CANVAS RELATED FUNCTIONS */

function canvas_initialize() {
    // Register an event listener to
    // call the resizeCanvas() function each time 
    // the window is resized.
    window.addEventListener('resize', resizeCanvas, false);
    
    // Draw canvas border for the first time.
    resizeCanvas();
}
    
// Display custom canvas.
// In this case it's a blue, 5 pixel border that 
// resizes along with the browser window.                    
function redraw() {
	if (redraw_enable) {
		
		/* weather */
		if (current_weather == 'sunny') {
			context.drawImage(imageObj, 640, 0, maxCanvasWidth, maxCanvasHeight, 0, 0, htmlCanvas.width, htmlCanvas.height);
		} else if (current_weather == 'cloudy') {
			context.drawImage(imageObj, 0, 0, maxCanvasWidth, maxCanvasHeight, 0, 0, htmlCanvas.width, htmlCanvas.height);
		} else if (current_weather == 'rainy') {
			context.drawImage(imageObj, 1280, 0, maxCanvasWidth, maxCanvasHeight, 0, 0, htmlCanvas.width, htmlCanvas.height);
		}
		
		/* bar */
		context.drawImage(imageObj, 0, 400, maxCanvasWidth, maxCanvasHeight, 0, 0, htmlCanvas.width, htmlCanvas.height);
        
        /* header */
        /* box */
        var header_w = htmlCanvas.width / 2;
        var header_h = htmlCanvas.height / 16;
        var header_x = htmlCanvas.width / 2 - header_w / 2;
        var header_y = htmlCanvas.height / 6;
        context.rect(header_x, header_y, header_w, header_h);
        context.fillStyle = header_color;
        context.fill();
        
        /* border */
        context.rect(header_x, header_y, header_w, header_h);
        context.stroke();
        
        var title = snackbar_name;
        context.fillStyle = 'black';
        context.font=header_h+"px Helvetica";
        var title_w = context.measureText(title);
        /*console.log(title_w);
        console.log("header_h: " + header_h);*/
        title_w = title_w.width;
        var title_x = header_x + (header_w / 2) - (title_w / 2);
        context.fillText(title, title_x, header_y+header_h-header_h/10);
        /*console.log(title_x);
        console.log(title_w);*/
    }
}

// Runs each time the DOM window resize event fires.
// Resets the canvas dimensions to match window,
// then draws the new borders accordingly.
function resizeCanvas() {

	console.log("BEFORE: size of canvas: "+htmlCanvas.width+"x"+htmlCanvas.height);

	console.log("window size: "+window.innerWidth+"x"+window.innerHeight);

    /* landscape */
    if (window.innerWidth > window.innerHeight) {
    	console.log("landscape!");
		htmlCanvas.height = maxCanvasHeight;
		if (window.innerHeight < (maxCanvasHeight+canvasPaddingHeight)) {
			if (document.getElementById('game_menue').style.display == 'block') {
				htmlCanvas.height = window.innerHeight-canvasPaddingHeight-document.getElementById('button_row_two').offsetHeight-document.getElementById('button_row_one').offsetHeight;
			} else {
				htmlCanvas.height = window.innerHeight-canvasPaddingHeight;
			}
			console.log("true "+window.innerHeight+" - "+canvasPaddingHeight);
		}
		htmlCanvas.width = htmlCanvas.height*(aspect_ratio_h);
		
		/* to wide? */
		if (window.innerWidth < (htmlCanvas.width+canvasPaddingWidth)) {
			htmlCanvas.width = window.innerWidth-canvasPaddingWidth;
			console.log("too wide = true "+window.innerWidth+" - "+canvasPaddingWidth);
			htmlCanvas.height = htmlCanvas.width*aspect_ratio_w;
		}
    /* potrait */
    } else {
    	console.log("portrait!");
		htmlCanvas.width = maxCanvasWidth;
		if (window.innerWidth < (maxCanvasWidth+canvasPaddingWidth)) {
			htmlCanvas.width = window.innerWidth-canvasPaddingWidth;
			console.log("true "+window.innerWidth+" - "+canvasPaddingWidth);
		}
		htmlCanvas.height = htmlCanvas.width*aspect_ratio_w;
		
		/* too tall? */
		if (window.innerHeight < (htmlCanvas.height+canvasPaddingHeight)) {
	    	console.log("too tall = true");
	        htmlCanvas.height = window.innerHeight-canvasPaddingHeight;
        	htmlCanvas.width = htmlCanvas.height*(aspect_ratio_h);
    	}
    }
 
    console.log("AFTER: size of canvas: "+htmlCanvas.width+"x"+htmlCanvas.height);
    
    overlayDiv.style.width = htmlCanvas.width+'px';
    
    redraw();
}