var linkHTMLDisplay = function(){
	"use strict";
	var cashDisplay = $("#cash")[0];
	var scoreDisplay = $("#score")[0];
	var writer = cashDisplay.textContent !== undefined ? "textContent" : "innerHTML";
	if(mainWindow.mode() === 'turns') {
		mainWindow.watchRemainingTilesWith(function(value) {
			cashDisplay[writer] = " Movimientos: " + value + (value !== 1 ? " Turnos" : " turn");
		});
	} else if(mainWindow.mode() === 'time') {
		mainWindow.watchRemainingTimeWith(function(value) {
			cashDisplay[writer] = " Tiempo: " + Math.floor(value/60) + ":" + (value%60 < 10 ? '0' + value%60 : value%60);
		});
	} else {
		cashDisplay.textContent = "error";
		console.warn('mainWindow.mode is \'' + mainWindow.mode() + '\', should be either \'turns\' or \'time\'.');
		console.error('bad mode value');
	}
	mainWindow.watchScoreWith(function(value) {
		scoreDisplay[writer] = " Puntos: " + value;
	});
};
