window.indexedDB = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
var DB_NAME = 'BucketDB13';
var DB_VERSION = 1; 
var TABLE_BUCKETS = 'bucketss13';
var db;

function getRequests() {
    var s1 = location.search.substring(1, location.search.length).split('&'),
            r = {}, s2, i;
    for (i = 0; i < s1.length; i += 1) {
        s2 = s1[i].split('=');
        r[decodeURIComponent(s2[0]).toLowerCase()] = decodeURIComponent(s2[1]);
    }
    return r;
}

function openDB() {
	
    var req = window.indexedDB.open(DB_NAME, DB_VERSION);
    req.onsuccess = function(evt) {
        db = this.result;
        console.log("succes open db");
        getAllBucketByName();
    };
    req.onerror = function(evt) {
        console.error("req.onerror:", evt.target.error.message);
    };

    req.onupgradeneeded = function(evt) {
        console.log("openDb.onupgradeneeded");
        try {
            var store0 = evt.currentTarget.result.createObjectStore(TABLE_BUCKETS, {keyPath: 'id', autoIncrement: true});
            store0.createIndex('name', 'name', {unique: false});
        }
        catch (e) {console.log(e);}
        console.log("openDb.onupgradeneeded");
    };
}


function getObjectStore(store_name, mode) {
    var tx = db.transaction(store_name, mode);
    return tx.objectStore(store_name);
}

function getAllBucketByName() {
    store = getObjectStore(TABLE_BUCKETS, 'readonly');

    req = store.index("name").openCursor();
    req.onsuccess = function(evt) {
        var cursor = req.result;
        if (cursor) {
            var value = cursor.value;
            newP0 = document.createElement("td");
            newP0.innerHTML = value.name;
            newP1 = document.createElement("td");
            newP1.innerHTML = value.state;
            
            newLI = document.createElement("tr");
            newLI.appendChild(newP0);
			newLI.appendChild(newP1);
            document.querySelector("#bucket").appendChild(newLI);
            cursor.continue();
        }
    };
}

function deleteAll(){
    store = getObjectStore(TABLE_BUCKETS, 'readwrite00');
    store.clear();
    clearRequest.onsuccess = function(event){
        document.querySelector("#bucket").innerHTML="";
        getAllBucketByName();        
    };
}

function exportData(){
    var content = [];
    var objectStore = getObjectStore(TABLE_BUCKETS, "readonly");
    req=objectStore.index("name").openCursor();
    req.onsuccess = function(event) {
        var cursor = req.result;
        if (cursor) {
            content.push({name:cursor.value.name,state:cursor.value.state});
            cursor.continue();
        }
        else send(content);
    };  
}

function putObject(pName, data) {
    storeI = getObjectStore(pName, "readwrite");
    request = storeI.add(data); 
    request.onsuccess = function(event) {
        document.querySelector("#bucket").innerHTML="";
        getAllBucketByName();
    };
    request.onerror = function(event) {
        console.log("tranzakcioserr:" + event.result.error.message);
    };
}

function modifySate(pName, id){
    store = getObjectStore(TABLE_BUCKETS, 'readwrite');
    request = store.get(id);
    request.onsuccess = function(event) {
        var data = request.result;
        data.state=true;
        var requestUpdate =store.put(data);
        requestUpdate.onsuccess = function(event) {
            document.querySelector("#bucket").innerHTML="";
            getAllBucketByName();
        }
        requestUpdate.oneror = function(event) {}
    };
    request.onerror = function(event) {
        console.log("tranzakcioserr:" + event.result.error.message);
    };
}
