/**
*  William Malone Sprite
*
*  @author William Malone (www.williammalone.com)
*/

/*global window, WM */

WM.hud = function (GLOBAL, WM, ctx, options) {

	var that = WM.view(GLOBAL, WM, ctx, options),
		targetItems = options.targetItemViews || [];
	
	that.render = function () {
		
		var i,
			padding = 10;
			yPos = padding,
			width = padding * 2,
			height = padding * 2;
		
		if (that.dirty) {
			
			ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);
			
			for (i = 0; i < targetItems.length; i += 1) {
				
				if (targetItems[i].found) {
					ctx.fillStyle = "rgba(255,255,255,0.3)";
					ctx.fillRect(ctx.canvas.width - targetItems[i].width - padding * 3, yPos, targetItems[i].width + padding * 2, targetItems[i].height + padding * 2);
				}
				if (i === 0) {
					yPos += padding;
				}
				
				targetItems[i].x = ctx.canvas.width - targetItems[i].width - padding * 3;
				targetItems[i].y = yPos;
				targetItems[i].dirty = true;
				targetItems[i].render();
				
				yPos += targetItems[i].height + padding;
				height += targetItems[i].height + padding;
				if (targetItems[i].width > width) {
					width = targetItems[i].width + padding * 2;
				}
			}
			
			ctx.beginPath();
			ctx.rect(ctx.canvas.width - width - padding, padding, width, height);
			ctx.closePath();
			ctx.lineWidth = 4;
			ctx.lineJoin = "round";	
			ctx.strokeStyle = "#ffffff";
			ctx.stroke();
			ctx.lineWidth = 0;
		
			that.dirty = false;	
		}
	}
	
	that.targetFound = function (url) {
		
		var i;
			
		for (i = 0; i < targetItems.length; i += 1) {
			if (url === targetItems[i].imageResource.url) {
				targetItems[i].found = true;
				that.dirty = true;
			}
		}
	};
	
	return that;
};