/**
*  William Malone HTML5 Player
*
*  @author William Malone (www.williammalone.com)
*/

WM.player = function (GLOBAL, options) {
					
	"use strict";
	
	var that = {},
		device,
		deviceWidth,
		deviceHeight,
		game,
		gameAvailable = false,
	
		updateOrientation = function () {
			that.viewportWidth = deviceWidth;
			that.viewportHeight = deviceHeight;
		},
	
		setViewportMetaTag = function () {
			
			var viewport;
			
			// Try to get the viewport meta tag from the markup
			viewport = GLOBAL.document.querySelector("meta[name=viewport]");
			
			// If the viewport meta tag doesn't exist then create it
			if (!viewport) {
				viewport = GLOBAL.document.createElement('meta');
				viewport.name = "viewport";
				viewport.content = "";
				GLOBAL.document.getElementsByTagName("head")[0].appendChild(viewport);
			}

			// Update viewport meta tag
			viewport.setAttribute("content", "width=" + deviceWidth + ", height=" + deviceHeight + ", user-scalable=no");
			
		},
		
		updateGame = function () {
			if(game) {
				game.setGameSize(deviceWidth, deviceHeight);
			}
		},
		
		detectDevice = function () {
			device = "UNKNOWN";
			if(window.innerWidth > window.innerHeight) {
				deviceWidth = window.innerWidth;
				deviceHeight = window.innerHeight;
			}
        };
	
	that.orientation = "LANDSCAPE";
	that.viewportWidth;
	that.viewportHeight;
	that.preventScrolling = (options && options.preventScrolling !== undefined) ? options.preventScrolling : false;
	
	that.touchStart = function (e) {
		that.hideURLBar();
	};
	
	that.touchMove = function (e) {
		if (that.preventScrolling) {
			// Prevent native scrolling
			e.preventDefault();
		}
	};
	
	that.touchEnd = function (e) {
		// Do nothing
	};
	
	that.touchCancel = function (e) {
		// Do nothing
	};

	// Used to scroll the url bar off the screen on iPhone when not added to the home screen
	that.hideURLBar = function () {
		GLOBAL.scrollTo(0, 1);
	};
	
	that.getDevice = function () {
		return device;
	};
	
	that.setGame = function (gameObj) {
		game = gameObj;
		updateGame();
	};
	
	// Set location of icon when added to Home Screen in iOS device.
	that.setGameIcon = function (filename) {
			
		var iconTag;
		
		// Try to get the link tag from the markup
		iconTag = GLOBAL.document.querySelector("link[rel=apple-touch-icon-precomposed]");
		
		// If the tag doesn't exist then create it
		if (!iconTag) {
			iconTag = GLOBAL.document.createElement('link');
			iconTag.rel = "apple-touch-icon-precomposed";
			GLOBAL.document.getElementsByTagName("head")[0].appendChild(iconTag);
		}

		// Update tag
		iconTag.setAttribute("href", filename);
	};
	
	that.onOrientationChange = function() {
		detectDevice();
		updateOrientation();
		setViewportMetaTag();
		updateGame();
	};
	
	// Initialize a few things
	detectDevice();
	updateOrientation();
	setViewportMetaTag();
	updateGame();
	
	// Listen to touch events
	GLOBAL.document.addEventListener("touchstart", that.touchStart);
	GLOBAL.document.addEventListener("touchmove", that.touchMove);
	GLOBAL.document.addEventListener("touchend", that.touchMove);
	GLOBAL.document.addEventListener("touchcancel", that.touchCancel);
	
	window.screen.onmozorientationchange = that.onOrientationChange;
    window.onresize = that.onOrientationChange;

	return that;
};
