// Roller Coaster Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//         Example:
//              alpha: 0.5 // View will be rendered at half transparency
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Roller Coaster Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     audio
//         Available States:
//             PAYOFF: Played after the path is traced.
//             MUSIC: Loops in the background.
//      hint
//         Properties:
//             color: The color (in hex e.g. #ff0000 for red) of the hint line.
//		       speed: The speed (in pixels per second) at which the line is drawn.
//		       width: The diameter of the line.
//		       dashWidth: The length of the dash.
//		       dashGap: The length of the gap between dashes.
//         
// Round Properties
//
//     background
//         Properties:
//            filename: Filename of the background image.
//     rider: Character that will traverse the path upon round completion.
//         Available States:
//             INTRO: Initial state of the bubble.
//             RIDE: Displayed when the rider is moving along the path.
//     dataPoints (Array): Array of objects that describe the points which define the shape.
//         Example:
//             dataPoints: [ 
//			    	{ 
//                      i: 0,
//                      x: 329,
//                      y: 594
//                  }, {
//                      i: 1,
//                      x: 329,
//                      y: 192
//                  }
//             ]
//     hintPaths (Array): Array of objects that describe the hint paths by the using the index 'i' values of the dataPoints.
//          Example:
//              hintPaths: [
//				    [ 0, 1, 2 ],
//                  [ 3, 4 ]
//			    ]
//     successPath (Array): Array of index 'i' values of the dataPoints that describe the path the rider will traverse on sucess.
//          Example:
//              successPath: [ 0, 1, 2, 1, 3, 1, 4 ]
//     targetItems: Items that are activated by touch.  Target items are not visible until activated. Once all target items are activated the round is complete.
//     payoff: View that is displayed while the rider is moving along the path after the round is complete.

WM.config = {
	//showOnlyThisRound: 22,
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -96
		}
	},
	gameIcon: "mozilla_thumb_256x256_SnuffysLetterCar.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "start-rollerCoaster-uppercase.jpg",
	audioEnabled: true,
	audioFilename: "audio-rollerCoaster-uppercaseLetters.mp3", //all audio including intro, payoff, and music is in this one file
	audio: {
		states: [
			{
				name: "music", 
				startTime: 186,
				duration: 17.18,
				loop: true
			}
		]
	},
	hint: {
		color: "#ffea00",
		speed: 10,
		width: 5, //width of the line itself. Makes the dots get bigger
		dashWidth: 10, //width of the dash in pixels. Cannot go higher than 10px
		dashGap: 10 //number of pixels between each dash. Cannot go lower than 10px
	},
	rounds: [
		{ //Round 1
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 0,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 4,
						duration: 1.5
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO", //poof animation
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE", //ride animation
						filename: "snuffy-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10, //can find this on the stage of the .fla file
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ //points in the object where the coaster and dots changes direction. Make these up based on x y coordinates in Fireworks
				{ i: 0, x: 528, y: 189 },
				{ i: 1, x: 311, y: 592 },
				{ i: 2, x: 721, y: 592 },
				{ i: 3, x: 394, y: 440 },
				{ i: 4, x: 647, y: 440 }
				
			],
			hintPaths: [ //these are the dotted line points
				[ 0, 1 ],
				[ 0, 2 ],
				[ 3, 4 ]
			],
			successPath: [ 1, 0, 2, 4, 3 ], //this is the payoff rollercoaster ride path
			targetItems: [
				{ filename: "capital-a-01.png", x: 277, y: 543 },
				{ filename: "capital-a-02.png", x: 301, y: 484 },
				{ filename: "capital-a-03.png", x: 342, y: 402 },
				{ filename: "capital-a-04.png", x: 376, y: 342 },
				{ filename: "capital-a-05.png", x: 407, y: 288 },
				{ filename: "capital-a-06.png", x: 438, y: 236 },
				{ filename: "capital-a-07.png", x: 474, y: 164 },
				{ filename: "capital-a-08.png", x: 525, y: 236 },
				{ filename: "capital-a-09.png", x: 546, y: 288 },
				{ filename: "capital-a-10.png", x: 565, y: 342 },
				{ filename: "capital-a-11.png", x: 597, y: 402 },
				{ filename: "capital-a-12.png", x: 623, y: 484 },
				{ filename: "capital-a-13.png", x: 642, y: 543 },
				{ filename: "capital-a-14.png", x: 546, y: 402 },
				{ filename: "capital-a-15.png", x: 489, y: 402 },
				{ filename: "capital-a-16.png", x: 438, y: 402 }
			],
			payoff: { filename: "capital-a-payoff.png", x: 0, y: 0 }
		}, { //Round 2
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 6,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 10,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 405, y: 591 },
				{ i: 1, x: 405, y: 179 },
				{ i: 2, x: 554, y: 179 },
				{ i: 3, x: 574, y: 184 },
				{ i: 4, x: 595, y: 193 },
				{ i: 5, x: 610, y: 207 },
				{ i: 6, x: 624, y: 222 },
				{ i: 7, x: 632, y: 241 },
				{ i: 8, x: 638, y: 260 },
				{ i: 9, x: 639, y: 280 },
				{ i: 10, x: 638, y: 303 },
				{ i: 11, x: 633, y: 322 },
				{ i: 12, x: 624, y: 341 },
				{ i: 13, x: 612, y: 357 },
				{ i: 14, x: 596, y: 369 },
				{ i: 15, x: 582, y: 376 },
				{ i: 16, x: 562, y: 384 },
				{ i: 17, x: 405, y: 384 },
				{ i: 18, x: 582, y: 390 },
				{ i: 19, x: 595, y: 395 },
				{ i: 20, x: 610, y: 401 },
				{ i: 21, x: 629, y: 413 },
				{ i: 22, x: 637, y: 429 },
				{ i: 23, x: 649, y: 444 },
				{ i: 24, x: 653, y: 462 },
				{ i: 25, x: 657, y: 484 },
				{ i: 26, x: 655, y: 506 },
				{ i: 27, x: 649, y: 526 },
				{ i: 28, x: 643, y: 544 },
				{ i: 29, x: 629, y: 563 },
				{ i: 30, x: 610, y: 577 },
				{ i: 31, x: 593, y: 586 },
				{ i: 32, x: 576, y: 591 },
				{ i: 33, x: 554, y: 593 }
			],
			hintPaths: [
				[ 1, 0 ],
				[ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 ],
				[ 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 0 ]
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 0 ],
			targetItems: [
				{ filename: "capital-b-01.png", x: 376, y: 154 },
				{ filename: "capital-b-02.png", x: 376, y: 223 },
				{ filename: "capital-b-03.png", x: 376, y: 269 },
				{ filename: "capital-b-04.png", x: 376, y: 323 },
				{ filename: "capital-b-05.png", x: 376, y: 368 },
				{ filename: "capital-b-06.png", x: 376, y: 420 },
				{ filename: "capital-b-07.png", x: 376, y: 459 },
				{ filename: "capital-b-08.png", x: 376, y: 510 },
				{ filename: "capital-b-09.png", x: 376, y: 559 },
				{ filename: "capital-b-10.png", x: 496, y: 510 },
				{ filename: "capital-b-11.png", x: 546, y: 510 },
				{ filename: "capital-b-12.png", x: 583, y: 510 },
				{ filename: "capital-b-13.png", x: 546, y: 469 },
				{ filename: "capital-b-14.png", x: 546, y: 429 },
				{ filename: "capital-b-15.png", x: 546, y: 384 },
				{ filename: "capital-b-16.png", x: 496, y: 296 },
				{ filename: "capital-b-17.png", x: 546, y: 296 },
				{ filename: "capital-b-18.png", x: 608, y: 296 },
				{ filename: "capital-b-19.png", x: 546, y: 255 },
				{ filename: "capital-b-20.png", x: 591, y: 154 },
				{ filename: "capital-b-21.png", x: 546, y: 154 },
				{ filename: "capital-b-22.png", x: 496, y: 154 }
			],
			payoff: { filename: "capital-b-payoff.png", x: 0, y: 0 }
		},{ //Round 3
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 12,
						duration: 4
					},
					{
						name: "payoff",
						startTime: 17,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-3.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 675, y: 236 }, 
				{ i: 1, x: 644, y: 209 }, 
				{ i: 2, x: 622, y: 195 }, 
				{ i: 3, x: 604, y: 187 }, 
				{ i: 4, x: 586, y: 181 }, 
				{ i: 5, x: 562, y: 179 }, 
				{ i: 6, x: 536, y: 178 }, 
				{ i: 7, x: 516, y: 177 }, 
				{ i: 8, x: 486, y: 183 }, 
				{ i: 9, x: 460, y: 195 }, 
				{ i: 10, x: 426, y: 213 }, 
				{ i: 11, x: 410, y: 229 }, 
				{ i: 12, x: 392, y: 247 }, 
				{ i: 13, x: 380, y: 261 }, 
				{ i: 14, x: 366, y: 287 }, 
				{ i: 15, x: 358, y: 307 }, 
				{ i: 16, x: 350, y: 335 }, 
				{ i: 17, x: 344, y: 369 }, 
				{ i: 18, x: 346, y: 409 }, 
				{ i: 19, x: 350, y: 435 }, 
				{ i: 20, x: 358, y: 459 }, 
				{ i: 21, x: 372, y: 489 }, 
				{ i: 22, x: 382, y: 505 }, 
				{ i: 23, x: 392, y: 519 }, 
				{ i: 24, x: 414, y: 541 }, 
				{ i: 25, x: 430, y: 557 }, 
				{ i: 26, x: 458, y: 571 }, 
				{ i: 27, x: 484, y: 583 }, 
				{ i: 28, x: 508, y: 587 }, 
				{ i: 29, x: 538, y: 591 }, 
				{ i: 30, x: 554, y: 589 }, 
				{ i: 31, x: 586, y: 583 }, 
				{ i: 32, x: 610, y: 575 }, 
				{ i: 33, x: 634, y: 563 }, 
				{ i: 34, x: 676, y: 529 } 
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 ]
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34  ],
			targetItems: [
				{ filename: "capital-c-01.png", x: 630, y: 177 },
				{ filename: "capital-c-02.png", x: 556, y: 154 },
				{ filename: "capital-c-03.png", x: 477, y: 154 },
				{ filename: "capital-c-04.png", x: 364, y: 154 },
				{ filename: "capital-c-05.png", x: 320, y: 243 },
				{ filename: "capital-c-06.png", x: 292, y: 302 },
				{ filename: "capital-c-07.png", x: 292, y: 357 },
				{ filename: "capital-c-08.png", x: 320, y: 421 },
				{ filename: "capital-c-09.png", x: 338, y: 470 },
				{ filename: "capital-c-10.png", x: 364, y: 520 },
				{ filename: "capital-c-11.png", x: 477, y: 520 },
				{ filename: "capital-c-12.png", x: 556, y: 520 },
				{ filename: "capital-c-13.png", x: 630, y: 478 }
			],
			payoff: { filename: "capital-c-payoff.png", x: 0, y: 0 }
		}, { //Round 4
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 19,
						duration: 4
					},
					{
						name: "payoff",
						startTime: 24,
						duration: 1.5
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				  { i: 0, x: 339, y: 180 }, 
				  { i: 1, x: 339, y: 590 }, 
				  { i: 2, x: 348, y: 592 }, 
				  { i: 3, x: 358, y: 592 }, 
				  { i: 4, x: 366, y: 592 }, 
				  { i: 5, x: 370, y: 592 }, 
				  { i: 6, x: 376, y: 592 }, 
				  { i: 7, x: 382, y: 592 }, 
				  { i: 8, x: 388, y: 592 }, 
				  { i: 9, x: 396, y: 592 }, 
				  { i: 10, x: 406, y: 592 }, 
				  { i: 11, x: 418, y: 592 }, 
				  { i: 12, x: 430, y: 592 }, 
				  { i: 13, x: 442, y: 592 }, 
				  { i: 14, x: 454, y: 592 }, 
				  { i: 15, x: 470, y: 592 }, 
				  { i: 16, x: 482, y: 590 }, 
				  { i: 17, x: 498, y: 589 }, 
				  { i: 18, x: 514, y: 583 }, 
				  { i: 19, x: 530, y: 581 }, 
				  { i: 20, x: 544, y: 575 }, 
				  { i: 21, x: 558, y: 571 }, 
				  { i: 22, x: 580, y: 561 }, 
				  { i: 23, x: 596, y: 549 }, 
				  { i: 24, x: 618, y: 533 }, 
				  { i: 25, x: 634, y: 519 },
				  { i: 26, x: 646, y: 503 },
				  { i: 27, x: 658, y: 481 }, 
				  { i: 28, x: 670, y: 457 }, 
				  { i: 29, x: 676, y: 433 }, 
				  { i: 30, x: 680, y: 407 }, 
				  { i: 31, x: 682, y: 379 }, 
				  { i: 32, x: 680, y: 345 }, 
				  { i: 33, x: 672, y: 321 }, 
				  { i: 34, x: 664, y: 295 }, 
				  { i: 35, x: 654, y: 277 }, 
				  { i: 36, x: 640, y: 257 },
				  { i: 37, x: 624, y: 237 }, 
				  { i: 38, x: 600, y: 219 }, 
				  { i: 39, x: 578, y: 205 },
				  { i: 40, x: 546, y: 191 }, 
				  { i: 41, x: 508, y: 181 },
				  { i: 42, x: 480, y: 177 },
				  { i: 43, x: 448, y: 177 },
				  { i: 44, x: 420, y: 177 },
				  { i: 45, x: 402, y: 177 },
				  { i: 46, x: 376, y: 177 },
				  { i: 47, x: 352, y: 177 }, 
				  { i: 48, x: 351, y: 177 }
			],
			hintPaths: [
				[ 0, 1 ],
				[48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2 ]
				
				
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48 ],
			targetItems: [
				{ filename: "capital-d-01.png", x: 331, y: 169 },
				{ filename: "capital-d-02.png", x: 389, y: 169 },
				{ filename: "capital-d-03.png", x: 440, y: 169 },
				{ filename: "capital-d-04.png", x: 489, y: 169 },
				{ filename: "capital-d-05.png", x: 538, y: 169 },
				{ filename: "capital-d-06.png", x: 585, y: 197 },
				{ filename: "capital-d-07.png", x: 630, y: 226 },
				{ filename: "capital-d-08.png", x: 538, y: 313 },
				{ filename: "capital-d-09.png", x: 538, y: 359 },
				{ filename: "capital-d-10.png", x: 538, y: 411 },
				{ filename: "capital-d-11.png", x: 630, y: 461 },
				{ filename: "capital-d-12.png", x: 585, y: 461 },
				{ filename: "capital-d-13.png", x: 538, y: 461 },
				{ filename: "capital-d-14.png", x: 489, y: 436 },
				{ filename: "capital-d-15.png", x: 440, y: 461 },
				{ filename: "capital-d-16.png", x: 389, y: 461 },
				{ filename: "capital-d-17.png", x: 331, y: 461 },
				{ filename: "capital-d-18.png", x: 331, y: 411 },
				{ filename: "capital-d-19.png", x: 331, y: 359 },
				{ filename: "capital-d-20.png", x: 331, y: 313 }
		
			],
			payoff: { filename: "capital-d-payoff.png", x: 0 , y: 0 }
		},{ //Round 5
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 27,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 31,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 370, y: 176 },
				{ i: 1, x: 370, y: 592 },
				{ i: 2, x: 663, y: 176 },
				{ i: 3, x: 663, y: 375 },
				{ i: 4, x: 663, y: 592 },
				{ i: 5, x: 370, y: 375 }
			],
			hintPaths: [
				[ 0, 1 ],
				[ 0, 2 ],
				[ 5, 3 ],
				[ 1, 4 ]
				
			],
			successPath: [ 2, 0, 5, 3, 5, 1, 4],
			targetItems: [
				{ filename: "capital-e-01.png", x: 605, y: 542 },
				{ filename: "capital-e-02.png", x: 517, y: 542 },
				{ filename: "capital-e-03.png", x: 426, y: 542 },
				{ filename: "capital-e-04.png", x: 347, y: 542 },
				{ filename: "capital-e-05.png", x: 347, y: 480 },
				{ filename: "capital-e-06.png", x: 347, y: 419 },
				{ filename: "capital-e-07.png", x: 605, y: 350 },
				{ filename: "capital-e-08.png", x: 517, y: 350 },
				{ filename: "capital-e-09.png", x: 426, y: 350 },
				{ filename: "capital-e-10.png", x: 347, y: 350 },
				{ filename: "capital-e-11.png", x: 347, y: 291 },
				{ filename: "capital-e-12.png", x: 347, y: 228 },
				{ filename: "capital-e-13.png", x: 605, y: 152 },
				{ filename: "capital-e-14.png", x: 517, y: 152 },
				{ filename: "capital-e-15.png", x: 426, y: 152 },
				{ filename: "capital-e-16.png", x: 347, y: 152 }
		
		
			],
			payoff: { filename: "capital-e-payoff.png", x: 0 , y: 0  }
		},{ //Round 6
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 34,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 38,
						duration: 2.9
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-3.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 370, y: 176 }, 
				{ i: 1, x: 370, y: 595 }, 
				{ i: 2, x: 664, y: 176 },
				{ i: 3, x: 376, y: 376 },
				{ i: 4, x: 650, y: 376 },
			
								
			],
			hintPaths: [
				[ 0, 1 ],
				[ 0, 2 ],
				[ 3, 4 ]
				
			],
			successPath: [ 2, 0, 3, 4, 3, 1  ],
			targetItems: [
				{ filename: "capital-f-01.png", x: 349, y: 544 },
				{ filename: "capital-f-02.png", x: 349, y: 488 },
				{ filename: "capital-f-03.png", x: 349, y: 424 },
				{ filename: "capital-f-04.png", x: 629, y: 369 },
				{ filename: "capital-f-05.png", x: 569, y: 369 },
				{ filename: "capital-f-06.png", x: 487, y: 369 },
				{ filename: "capital-f-07.png", x: 421, y: 369 },
				{ filename: "capital-f-08.png", x: 349, y: 369 },
				{ filename: "capital-f-09.png", x: 349, y: 300 },
				{ filename: "capital-f-10.png", x: 349, y: 231 },
				{ filename: "capital-f-11.png", x: 608, y: 152 },
				{ filename: "capital-f-12.png", x: 530, y: 152 },
				{ filename: "capital-f-13.png", x: 444, y: 152 },
				{ filename: "capital-f-14.png", x: 349, y: 152 }
						
			],
			payoff: { filename: "capital-f-payoff.png", x: 0, y: 0  }
		},{ //Round 7
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 41,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 44,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 680, y: 245 }, 
				 { i: 1, x: 678, y: 243 }, 
				 { i: 2, x: 643, y: 213 }, 
				 { i: 3, x: 613, y: 197 }, 
				 { i: 4, x: 579, y: 185 }, 
				 { i: 5, x: 539, y: 177 }, 
				 { i: 6, x: 513, y: 177 }, 
				 { i: 7, x: 483, y: 181 }, 
				 { i: 8, x: 453, y: 189 }, 
				 { i: 9, x: 423, y: 203 }, 
				 { i: 10, x: 395, y: 221 }, 
				 { i: 11, x: 369, y: 243 }, 
				 { i: 12, x: 351, y: 263 }, 
				 { i: 13, x: 337, y: 287 }, 
				 { i: 14, x: 323, y: 319 }, 
				 { i: 15, x: 315, y: 347 }, 
				 { i: 16, x: 313, y: 381 }, 
				 { i: 17, x: 313, y: 409 }, 
				 { i: 18, x: 319, y: 431 }, 
				 { i: 19, x: 325, y: 455 }, 
				 { i: 20, x: 337, y: 481 }, 
				 { i: 21, x: 351, y: 503 }, 
				 { i: 22, x: 369, y: 525 }, 
				 { i: 23, x: 385, y: 541 }, 
				 { i: 24, x: 399, y: 551 }, 
				 { i: 25, x: 419, y: 565 }, 
				 { i: 26, x: 439, y: 575 }, 
				 { i: 27, x: 459, y: 581 }, 
				 { i: 28, x: 491, y: 591 }, 
				 { i: 29, x: 521, y: 593 },
				 { i: 30, x: 547, y: 591 }, 
				 { i: 31, x: 573, y: 589 }, 
				 { i: 32, x: 601, y: 577 }, 
				 { i: 33, x: 625, y: 566 }, 
				 { i: 34, x: 657, y: 539 }, 
				 { i: 35, x: 685, y: 505 }, 
				 { i: 36, x: 701, y: 467 },
				 { i: 37, x: 707, y: 427 }, 
				 { i: 38, x: 711, y: 385 }, 
				 { i: 39, x: 713, y: 371 }, 
				 { i: 40, x: 537, y: 371 }
			
				
			],
			hintPaths: [
				 [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40 ]

				
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40 ],
			targetItems: [
				{ filename: "capital-g-01.png", x: 612, y: 175 },
				{ filename: "capital-g-02.png", x: 547, y: 165 },
				{ filename: "capital-g-03.png", x: 479, y: 165 },
				{ filename: "capital-g-04.png", x: 422, y: 168 },
				{ filename: "capital-g-05.png", x: 329, y: 195 },
				{ filename: "capital-g-06.png", x: 303, y: 280 },
				{ filename: "capital-g-07.png", x: 303, y: 345 },
				{ filename: "capital-g-08.png", x: 303, y: 409 },
				{ filename: "capital-g-09.png", x: 324, y: 475 },
				{ filename: "capital-g-10.png", x: 422, y: 475 },
				{ filename: "capital-g-11.png", x: 479, y: 511 },
				{ filename: "capital-g-12.png", x: 547, y: 475 },
				{ filename: "capital-g-13.png", x: 612, y: 475 },
				{ filename: "capital-g-14.png", x: 612, y: 437 },
				{ filename: "capital-g-15.png", x: 648, y: 380 },
				{ filename: "capital-g-16.png", x: 648, y: 360 },
				{ filename: "capital-g-17.png", x: 612, y: 360 },
				{ filename: "capital-g-18.png", x: 575, y: 360 },
				{ filename: "capital-g-19.png", x: 523, y: 360 }
		
			],
			payoff: { filename: "capital-g-payoff.png", x: 0, y: 0  }
		},{ //Round 8
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 48,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 52,
						duration: 2.8
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 370, y: 180 },
				{ i: 1, x: 370, y: 594 },
				{ i: 2, x: 662, y: 180 },
				{ i: 3, x: 662, y: 594 },
				{ i: 4, x: 370, y: 385 },
				{ i: 5, x: 655, y: 385 }
			],
			hintPaths: [
				[0, 1],
				[2, 3],
				[4, 5]
				
			],
			successPath: [0, 1, 4, 5, 2, 3 ],
			targetItems: [
				{ filename: "capital-h-01.png", x: 338, y: 170 },
				{ filename: "capital-h-02.png", x: 338, y: 230 },
				{ filename: "capital-h-03.png", x: 338, y: 279 },
				{ filename: "capital-h-04.png", x: 338, y: 328 },
				{ filename: "capital-h-05.png", x: 338, y: 377 },
				{ filename: "capital-h-06.png", x: 338, y: 416 },
				{ filename: "capital-h-07.png", x: 338, y: 471 },
				{ filename: "capital-h-08.png", x: 338, y: 525 },
				{ filename: "capital-h-09.png", x: 377, y: 377 },
				{ filename: "capital-h-10.png", x: 431, y: 377 },
				{ filename: "capital-h-11.png", x: 485, y: 377 },
				{ filename: "capital-h-12.png", x: 539, y: 377 },
				{ filename: "capital-h-13.png", x: 597, y: 377 },
				{ filename: "capital-h-14.png", x: 654, y: 170 },
				{ filename: "capital-h-15.png", x: 654, y: 230 },
				{ filename: "capital-h-16.png", x: 654, y: 279 },
				{ filename: "capital-h-17.png", x: 654, y: 328 },
				{ filename: "capital-h-18.png", x: 654, y: 377 },
				{ filename: "capital-h-19.png", x: 655, y: 416 },
				{ filename: "capital-h-20.png", x: 655, y: 471 },
				{ filename: "capital-h-21.png", x: 655, y: 525 }
		
			],
			payoff: { filename: "capital-h-payoff.png", x: 0, y: 0 }
		},{ //Round 9
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 55,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 59,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-3.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 522, y: 215},
				{ i: 1, x: 522, y: 560},
				{ i: 2, x: 398, y: 202},
				{ i: 3, x: 646, y: 202},
				{ i: 4, x: 398, y: 568},
				{ i: 5, x: 646, y: 568}
			],
			hintPaths: [
				[0, 1],
				[2, 3],
				[4, 5]
			],
			successPath: [2, 3, 0, 1, 4, 5 ],
			targetItems: [
				{ filename: "capital-i-01.png", x: 376, y: 156 },
				{ filename: "capital-i-02.png", x: 441, y: 156 },
				{ filename: "capital-i-03.png", x: 488, y: 156 },
				{ filename: "capital-i-04.png", x: 556, y: 156 },
				{ filename: "capital-i-05.png", x: 610, y: 156 },
				{ filename: "capital-i-06.png", x: 474, y: 223 },
				{ filename: "capital-i-07.png", x: 474, y: 272 },
				{ filename: "capital-i-08.png", x: 474, y: 322 },
				{ filename: "capital-i-09.png", x: 474, y: 366 },
				{ filename: "capital-i-10.png", x: 474, y: 420 },
				{ filename: "capital-i-11.png", x: 474, y: 467 },
				{ filename: "capital-i-12.png", x: 474, y: 512 },
				{ filename: "capital-i-13.png", x: 376, y: 552 },
				{ filename: "capital-i-14.png", x: 441, y: 552 },
				{ filename: "capital-i-15.png", x: 488, y: 552 },
				{ filename: "capital-i-16.png", x: 556, y: 552 },
				{ filename: "capital-i-17.png", x: 610, y: 552 }
		
			],
			payoff: { filename: "capital-i-payoff.png", x: 0, y: 0 }
		},{ //Round 10
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 62,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 66,
						duration: 2.9
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 602, y: 176 },
                { i: 1, x: 474, y: 176 },
                { i: 2, x: 730, y: 176 },
                { i: 3, x: 602, y: 420 },
                { i: 4, x: 600, y: 445 }, 
                { i: 5, x: 598, y: 459 }, 
                { i: 6, x: 592, y: 469 }, 
                { i: 7, x: 586, y: 487 }, 
                { i: 8, x: 578, y: 499 },
                { i: 9, x: 568, y: 511 }, 
                { i: 10, x: 558, y: 521 }, 
                { i: 11, x: 544, y: 531 },
                { i: 12, x: 530, y: 539 },
                { i: 13, x: 514, y: 545 },
                { i: 14, x: 500, y: 551 },
                { i: 15, x: 488, y: 553 },
                { i: 16, x: 470, y: 555 },
                { i: 17, x: 452, y: 555 },
                { i: 18, x: 434, y: 551 },
                { i: 19, x: 418, y: 549 },
                { i: 20, x: 402, y: 543 },
                { i: 21, x: 378, y: 533 },
                { i: 22, x: 364, y: 519 },
                { i: 23, x: 354, y: 507 },
                { i: 24, x: 348, y: 493 },
                { i: 25, x: 344, y: 479 }, 
                { i: 26, x: 348, y: 493 }
				
			],
			hintPaths: [
				[ 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 ,17, 18, 19, 20, 21, 22, 23, 24, 25, 26,],
				[ 1, 2]
			],
			successPath: [1, 2, 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 ,17, 18, 19, 20, 21, 22, 23, 24, 25, 26, ],
			targetItems: [
				{ filename: "capital-j-01.png", x: 466, y: 169 },
				{ filename: "capital-j-02.png", x: 508, y: 169 },
				{ filename: "capital-j-03.png", x: 547, y: 169 },
				{ filename: "capital-j-04.png", x: 591, y: 169 },
				{ filename: "capital-j-05.png", x: 612, y: 169 },
				{ filename: "capital-j-06.png", x: 650, y: 169 },
				{ filename: "capital-j-07.png", x: 692, y: 169 },
				{ filename: "capital-j-08.png", x: 547, y: 241 },
				{ filename: "capital-j-09.png", x: 547, y: 277 },
				{ filename: "capital-j-10.png", x: 547, y: 321 },
				{ filename: "capital-j-11.png", x: 547, y: 367 },
				{ filename: "capital-j-12.png", x: 527, y: 410 },
				{ filename: "capital-j-13.png", x: 527, y: 465 },
				{ filename: "capital-j-14.png", x: 527, y: 501 },
				{ filename: "capital-j-15.png", x: 482, y: 459 },
				{ filename: "capital-j-16.png", x: 436, y: 459 },
				{ filename: "capital-j-17.png", x: 390, y: 437 },
				{ filename: "capital-j-18.png", x: 284, y: 437 }
		
			],
			payoff: { filename: "capital-j-payoff.png", x: 0 , y: 0  }
		},{ //Round 11
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 69,
						duration: 3.1
					},
					{
						name: "payoff",
						startTime: 72,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 379, y: 182 },
				{ i: 1, x: 379, y: 594 },
				{ i: 2, x: 666, y: 182 },
				{ i: 3, x: 379, y: 385 },
				{ i: 4, x: 379, y: 393 },
				{ i: 5, x: 666, y: 594 }
			],
			hintPaths: [
				[0,1],
				[2,3,4,5]
			],
			successPath: [0,1,3,2,3,4,5],
			targetItems: [
				{ filename: "capital-k-01.png", x: 346, y: 170 },
				{ filename: "capital-k-02.png", x: 346, y: 225 },
				{ filename: "capital-k-03.png", x: 346, y: 276 },
				{ filename: "capital-k-04.png", x: 346, y: 322 },
				{ filename: "capital-k-05.png", x: 346, y: 387 },
				{ filename: "capital-k-06.png", x: 346, y: 437 },
				{ filename: "capital-k-07.png", x: 346, y: 487 },
				{ filename: "capital-k-08.png", x: 346, y: 541 },
				{ filename: "capital-k-09.png", x: 385, y: 305 },
				{ filename: "capital-k-10.png", x: 432, y: 272 },
				{ filename: "capital-k-11.png", x: 481, y: 236 },
				{ filename: "capital-k-12.png", x: 532, y: 202 },
				{ filename: "capital-k-13.png", x: 581, y: 170 },
				{ filename: "capital-k-14.png", x: 630, y: 170 },
				{ filename: "capital-k-15.png", x: 385, y: 387 },
				{ filename: "capital-k-16.png", x: 432, y: 420 },
				{ filename: "capital-k-17.png", x: 481, y: 455 },
				{ filename: "capital-k-18.png", x: 532, y: 488 },
				{ filename: "capital-k-19.png", x: 581, y: 523 },
				{ filename: "capital-k-20.png", x: 630, y: 557 }
		
			],
			payoff: { filename: "capital-k-payoff.png", x: 0 , y: 0 }
		}, { //Round 12
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 75,
						duration: 4
					},
					{
						name: "payoff",
						startTime: 80,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-3.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 369, y: 176 },
				{ i: 1, x: 369, y: 594 },
				{ i: 2, x: 658, y: 594 }
			],
			hintPaths: [
				[ 0, 1, 2 ]
			],
			successPath: [ 0, 1, 2 ],
			targetItems: [
				{ filename: "capital-l-01.png", x: 332, y: 157 },
				{ filename: "capital-l-02.png", x: 332, y: 223 },
				{ filename: "capital-l-03.png", x: 332, y: 276 },
				{ filename: "capital-l-04.png", x: 332, y: 326 },
				{ filename: "capital-l-05.png", x: 332, y: 376 },
				{ filename: "capital-l-06.png", x: 332, y: 425 },
				{ filename: "capital-l-07.png", x: 332, y: 484 },
				{ filename: "capital-l-08.png", x: 332, y: 535 },
				{ filename: "capital-l-09.png", x: 424, y: 535 },
				{ filename: "capital-l-10.png", x: 485, y: 535 },
				{ filename: "capital-l-11.png", x: 554, y: 535 },
				{ filename: "capital-l-12.png", x: 615, y: 535 }
			],
			payoff: { filename: "capital-l-payoff.png", x: 0, y: 0 } 
			},{ //Round 13
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 83,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 86,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 307, y: 178},
				{ i: 1, x: 307, y: 592},
				{ i: 2, x: 516, y: 574},
				{ i: 3, x: 703, y: 178},
				{ i: 4, x: 725, y: 592},
				{ i: 5, x: 327, y: 178},
				{ i: 6, x: 725, y: 178}
				
			],
			hintPaths: [
				[0,1],
				[0,5,2,3,6,4]
			],
			successPath: [ 1, 0, 5, 2, 3, 6, 4 ],
			targetItems: [
				{ filename: "capital-m-01.png", x: 284, y: 530 },
				{ filename: "capital-m-02.png", x: 284, y: 468 },
				{ filename: "capital-m-03.png", x: 284, y: 413 },
				{ filename: "capital-m-04.png", x: 284, y: 368 },
				{ filename: "capital-m-05.png", x: 284, y: 286 },
				{ filename: "capital-m-06.png", x: 284, y: 148 },
				{ filename: "capital-m-07.png", x: 284, y: 220 },
				{ filename: "capital-m-08.png", x: 346, y: 184 },
				{ filename: "capital-m-09.png", x: 371, y: 253 },
				{ filename: "capital-m-10.png", x: 405, y: 300 },
				{ filename: "capital-m-11.png", x: 444, y: 368 },
				{ filename: "capital-m-12.png", x: 477, y: 456 },
				{ filename: "capital-m-13.png", x: 516, y: 456 },
				{ filename: "capital-m-14.png", x: 556, y: 368 },
				{ filename: "capital-m-15.png", x: 589, y: 300 },
				{ filename: "capital-m-16.png", x: 623, y: 253 },
				{ filename: "capital-m-17.png", x: 657, y: 184 },
				{ filename: "capital-m-18.png", x: 687, y: 148 },
				{ filename: "capital-m-19.png", x: 687, y: 220 },
				{ filename: "capital-m-20.png", x: 687, y: 286 },
				{ filename: "capital-m-21.png", x: 687, y: 368 },
				{ filename: "capital-m-22.png", x: 687, y: 413 },
				{ filename: "capital-m-23.png", x: 687, y: 468 },
				{ filename: "capital-m-24.png", x: 687, y: 530 },
		
			],
			payoff: { filename: "capital-m-payoff.png", x: 0, y: 0 }
		},{ //Round 14
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 90,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 94,
						duration: 2.9 
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 355, y: 178},
				{ i: 1, x: 355, y: 570},
				{ i: 2, x: 651, y: 545},
				{ i: 3, x: 651, y: 178}
				
			],
			hintPaths: [
				[0,1],
				[0,2,3 ]
			],
			successPath: [ 1, 0, 2, 3 ],
			targetItems: [
				{ filename: "capital-n-01.png", x: 328, y: 533 },
				{ filename: "capital-n-02.png", x: 328, y: 473 },
				{ filename: "capital-n-03.png", x: 328, y: 406 },
				{ filename: "capital-n-04.png", x: 328, y: 348 },
				{ filename: "capital-n-05.png", x: 328, y: 282 },
				{ filename: "capital-n-06.png", x: 328, y: 230 },
				{ filename: "capital-n-07.png", x: 328, y: 156 },
				{ filename: "capital-n-08.png", x: 393, y: 193 },
				{ filename: "capital-n-09.png", x: 435, y: 230 },
				{ filename: "capital-n-10.png", x: 474, y: 282 },
				{ filename: "capital-n-11.png", x: 512, y: 311 },
				{ filename: "capital-n-12.png", x: 558, y: 373 },
				{ filename: "capital-n-13.png", x: 597, y: 406 },
				{ filename: "capital-n-14.png", x: 635, y: 506 },
				{ filename: "capital-n-15.png", x: 635, y: 459 },
				{ filename: "capital-n-16.png", x: 635, y: 406 },
				{ filename: "capital-n-17.png", x: 635, y: 348 },
				{ filename: "capital-n-18.png", x: 635, y: 282 },
				{ filename: "capital-n-19.png", x: 635, y: 230 },
				{ filename: "capital-n-20.png", x: 635, y: 156 }
		
			],
			payoff: { filename: "capital-n-payoff.png", x: 0, y: 0 }
		},{ //Round 15
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 97,
						duration: 2.9
					},
					{
						name: "payoff",
						startTime: 100,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-3.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 504, y: 178 }, { i: 1, x: 476, y: 180 }, { i: 2, x: 452, y: 187 }, { i: 3, x: 422, y: 201 }, { i: 4, x: 378, y: 227 }, { i: 5, x: 352, y: 257 }, { i: 6, x: 330, y: 289 }, { i: 7, x: 314, y: 335 }, { i: 8, x: 308, y: 387 }, { i: 9, x: 312, y: 431 }, { i: 10, x: 324, y: 463 }, { i: 11, x: 342, y: 499 }, { i: 12, x: 362, y: 523 }, { i: 13, x: 380, y: 541 }, { i: 14, x: 398, y: 555 }, { i: 15, x: 412, y: 563 }, { i: 16, x: 424, y: 569 }, { i: 17, x: 442, y: 579 }, { i: 18, x: 460, y: 583 }, { i: 19, x: 480, y: 589 }, { i: 20, x: 496, y: 591 }, { i: 21, x: 514, y: 593 }, { i: 22, x: 536, y: 591 }, { i: 23, x: 560, y: 587 }, { i: 24, x: 588, y: 579 }, { i: 25, x: 610, y: 569 }, { i: 26, x: 628, y: 559 }, { i: 27, x: 662, y: 533 }, { i: 28, x: 684, y: 507 }, { i: 29, x: 702, y: 479 }, { i: 30, x: 716, y: 443 }, { i: 31, x: 724, y: 395 }, { i: 32, x: 720, y: 355 }, { i: 33, x: 712, y: 313 }, { i: 34, x: 696, y: 279 }, { i: 35, x: 674, y: 247 }, { i: 36, x: 638, y: 215 }, { i: 37, x: 598, y: 193 }, { i: 38, x: 566, y: 181 }, { i: 39, x: 519, y: 178 }
				
			
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39 ],
				
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39 ],
			targetItems: [
				{ filename: "capital-o-01.png", x: 290, y: 153 },
				{ filename: "capital-o-02.png", x: 290, y: 248 },
				{ filename: "capital-o-03.png", x: 290, y: 298 },
				{ filename: "capital-o-04.png", x: 290, y: 343 },
				{ filename: "capital-o-05.png", x: 290, y: 407 },
				{ filename: "capital-o-06.png", x: 290, y: 450 },
				{ filename: "capital-o-07.png", x: 290, y: 497 },
				{ filename: "capital-o-08.png", x: 443, y: 153 },
				{ filename: "capital-o-09.png", x: 443, y: 450 },
				{ filename: "capital-o-10.png", x: 492, y: 450 },
				{ filename: "capital-o-11.png", x: 543, y: 450 },
				{ filename: "capital-o-12.png", x: 577, y: 497 },
				{ filename: "capital-o-13.png", x: 577, y: 450 },
				{ filename: "capital-o-14.png", x: 577, y: 401 },
				{ filename: "capital-o-15.png", x: 577, y: 343 },
				{ filename: "capital-o-16.png", x: 577, y: 298 },
				{ filename: "capital-o-17.png", x: 648, y: 153 },
				{ filename: "capital-o-18.png", x: 584, y: 153 },
				{ filename: "capital-o-19.png", x: 543, y: 153 },
				{ filename: "capital-o-20.png", x: 492, y: 153 }
		
			],
			payoff: { filename: "capital-o-payoff.png", x: 0 , y: 0  }
		},{ //Round 16
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 104,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 108,
						duration: 2
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 400, y: 180 },
				{ i: 1, x: 400, y: 596 },
				{ i: 2, x: 400, y: 179 },
				{ i: 3, x: 550, y: 177 },
				{ i: 4, x: 576, y: 179 },
				{ i: 5, x: 600, y: 183 },
				{ i: 6, x: 618, y: 191 },
				{ i: 7, x: 632, y: 199 },
				{ i: 8, x: 648, y: 217 },
				{ i: 9, x: 658, y: 235 },
				{ i: 10, x: 664, y: 251 },
				{ i: 11, x: 668, y: 271 },
				{ i: 12, x: 672, y: 285 },
				{ i: 13, x: 668, y: 307 },
				{ i: 14, x: 668, y: 321 },
				{ i: 15, x: 660, y: 340 },
				{ i: 16, x: 654, y: 349 },
				{ i: 17, x: 644, y: 365 },
				{ i: 18, x: 626, y: 379 },
				{ i: 19, x: 608, y: 389 },
				{ i: 20, x: 590, y: 395 },
				{ i: 21, x: 574, y: 399 },
				{ i: 22, x: 400, y: 400 }
				
				
				
			],
			hintPaths: [
				[0, 1 ],
				[ 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 ]
			],
			successPath: [ 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 ],
			targetItems: [
				{ filename: "capital-p-01.png", x: 372, y: 552 },
				{ filename: "capital-p-02.png", x: 372, y: 506 },
				{ filename: "capital-p-03.png", x: 372, y: 460 },
				{ filename: "capital-p-04.png", x: 372, y: 416 },
				{ filename: "capital-p-05.png", x: 372, y: 357 },
				{ filename: "capital-p-06.png", x: 372, y: 316 },
				{ filename: "capital-p-07.png", x: 451, y: 357 },
				{ filename: "capital-p-08.png", x: 501, y: 316 },
				{ filename: "capital-p-09.png", x: 561, y: 316 },
				{ filename: "capital-p-10.png", x: 613, y: 316 },
				{ filename: "capital-p-11.png", x: 561, y: 267 },
				{ filename: "capital-p-12.png", x: 561, y: 218 },
				{ filename: "capital-p-13.png", x: 561, y: 159 },
				{ filename: "capital-p-14.png", x: 501, y: 159 },
				{ filename: "capital-p-15.png", x: 372, y: 159 },
				{ filename: "capital-p-16.png", x: 372, y: 218 },
				{ filename: "capital-p-17.png", x: 372, y: 267 }
		
			],
			payoff: { filename: "capital-p-payoff.png", x: 0, y: 0 }
		},{ //Round 17
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 111,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 115,
						duration: 2.9
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
			{ i: 0, x: 516, y: 178 }, 
			{ i: 1, x: 476, y: 180 }, 
			{ i: 2, x: 452, y: 187 }, 
			{ i: 3, x: 422, y: 201 }, 
			{ i: 4, x: 378, y: 227 }, 
			{ i: 5, x: 352, y: 257 }, 
			{ i: 6, x: 330, y: 289 }, 
			{ i: 7, x: 314, y: 335 }, 
			{ i: 8, x: 308, y: 387 }, 
			{ i: 9, x: 312, y: 431 }, 
			{ i: 10, x: 324, y: 463 }, 
			{ i: 11, x: 342, y: 499 }, 
			{ i: 12, x: 362, y: 523 }, 
			{ i: 13, x: 380, y: 541 }, 
			{ i: 14, x: 398, y: 555 }, 
			{ i: 15, x: 412, y: 563 }, 
			{ i: 16, x: 424, y: 569 }, 
			{ i: 17, x: 442, y: 579 }, 
			{ i: 18, x: 460, y: 583 }, 
			{ i: 19, x: 480, y: 589 }, 
			{ i: 20, x: 496, y: 591 }, 
			{ i: 21, x: 514, y: 593 }, 
			{ i: 22, x: 536, y: 591 }, 
			{ i: 23, x: 560, y: 587 }, 
			{ i: 24, x: 588, y: 579 }, 
			{ i: 25, x: 610, y: 569 }, 
			{ i: 26, x: 628, y: 559 }, 
			{ i: 27, x: 662, y: 533 }, 
			{ i: 28, x: 684, y: 507 }, 
			{ i: 29, x: 702, y: 479 }, 
			{ i: 30, x: 716, y: 443 }, 
			{ i: 31, x: 724, y: 395 }, 
			{ i: 32, x: 720, y: 355 }, 
			{ i: 33, x: 712, y: 313 }, 
			{ i: 34, x: 696, y: 279 }, 
			{ i: 35, x: 674, y: 247 }, 
			{ i: 36, x: 638, y: 215 }, 
			{ i: 37, x: 598, y: 193 }, 
			{ i: 38, x: 566, y: 181 }, 
			{ i: 39, x: 516, y: 178 },
			{ i: 40, x: 573, y: 478},
			{ i: 41, x: 639, y: 546},
			{ i: 42, x: 683, y: 590},
			
			
				
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39  ],
				[40, 42]
				
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 41, 40, 42, 41, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39  ],
			targetItems: [
				{ filename: "capital-q-01.png", x: 323, y: 191 },
				{ filename: "capital-q-02.png", x: 413, y: 168 },
				{ filename: "capital-q-03.png", x: 479, y: 165 },
				{ filename: "capital-q-04.png", x: 547, y: 165 },
				{ filename: "capital-q-05.png", x: 617, y: 194 },
				{ filename: "capital-q-06.png", x: 617, y: 273 },
				{ filename: "capital-q-07.png", x: 617, y: 342 },
				{ filename: "capital-q-08.png", x: 617, y: 410 },
				{ filename: "capital-q-09.png", x: 617, y: 474 },
				{ filename: "capital-q-10.png", x: 641, y: 514 },
				{ filename: "capital-q-11.png", x: 561, y: 470 },
				{ filename: "capital-q-12.png", x: 595, y: 514 },
				{ filename: "capital-q-13.png", x: 641, y: 558 },
				{ filename: "capital-q-14.png", x: 595, y: 552 },
				{ filename: "capital-q-15.png", x: 547, y: 514 },
				{ filename: "capital-q-16.png", x: 479, y: 521 },
				{ filename: "capital-q-17.png", x: 413, y: 487 },
				{ filename: "capital-q-18.png", x: 315, y: 487 },
				{ filename: "capital-q-19.png", x: 297, y: 409 },
				{ filename: "capital-q-20.png", x: 297, y: 345 },
				{ filename: "capital-q-21.png", x: 297, y: 277 }
		
			],
			payoff: { filename: "capital-q-payoff.png", x: 0, y: 0 }
		},{ //Round 18
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 118,
						duration: 3.2
					},
					{
						name: "payoff",
						startTime: 122,
						duration: 2.8
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-3.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 400, y: 180 },
				{ i: 1, x: 400, y: 596 },
				{ i: 2, x: 400, y: 179 },
				{ i: 3, x: 550, y: 177 },
				{ i: 4, x: 576, y: 179 },
				{ i: 5, x: 600, y: 183 },
				{ i: 6, x: 618, y: 191 },
				{ i: 7, x: 632, y: 199 },
				{ i: 8, x: 648, y: 217 },
				{ i: 9, x: 658, y: 235 },
				{ i: 10, x: 664, y: 251 },
				{ i: 11, x: 668, y: 271 },
				{ i: 12, x: 672, y: 285 },
				{ i: 13, x: 668, y: 307 },
				{ i: 14, x: 668, y: 321 },
				{ i: 15, x: 660, y: 337 },
				{ i: 16, x: 655, y: 349 },
				{ i: 17, x: 644, y: 365 },
				{ i: 18, x: 626, y: 379 },
				{ i: 19, x: 608, y: 389 },
				{ i: 20, x: 590, y: 395 },
				{ i: 21, x: 574, y: 399 },
				{ i: 22, x: 400, y: 400 },
				{ i: 23, x: 401, y: 399 },
				{ i: 24, x: 435, y: 401 },
				{ i: 25, x: 645, y: 591 }	
			],
			hintPaths: [
				[0, 1],
				[0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
				[24, 25]
			],
			successPath: [ 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25],
			targetItems: [
				{ filename: "capital-r-01.png", x: 390, y: 170 },
				{ filename: "capital-r-02.png", x: 496, y: 170 },
				{ filename: "capital-r-03.png", x: 553, y: 170 },
				{ filename: "capital-r-04.png", x: 553, y: 216 },
				{ filename: "capital-r-05.png", x: 553, y: 257 },
				{ filename: "capital-r-06.png", x: 553, y: 318 },
				{ filename: "capital-r-07.png", x: 553, y: 360 },
				{ filename: "capital-r-08.png", x: 496, y: 318 },
				{ filename: "capital-r-09.png", x: 390, y: 216 },
				{ filename: "capital-r-10.png", x: 390, y: 257 },
				{ filename: "capital-r-11.png", x: 390, y: 318 },
				{ filename: "capital-r-12.png", x: 390, y: 360 },
				{ filename: "capital-r-13.png", x: 390, y: 407 },
				{ filename: "capital-r-14.png", x: 390, y: 483 },
				{ filename: "capital-r-15.png", x: 390, y: 543 },
				{ filename: "capital-r-16.png", x: 427, y: 407 },
				{ filename: "capital-r-17.png", x: 457, y: 483 },
				{ filename: "capital-r-18.png", x: 508, y: 536 }
		
			],
			payoff: { filename: "capital-r-payoff.png", x: 0, y: 0 }
		},{ //Round 19
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 125,
						duration: 3.5
					},
					{
						name: "payoff",
						startTime: 129,
						duration: 2.9
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 644, y: 235 }, 
				{ i: 1, x: 634, y: 223 }, 
				{ i: 2, x: 620, y: 208 }, 
				{ i: 3, x: 600, y: 195 }, 
				{ i: 4, x: 582, y: 187 }, 
				{ i: 5, x: 562, y: 181 }, 
				{ i: 6, x: 542, y: 179 }, 
				{ i: 7, x: 520, y: 177 }, 
				{ i: 8, x: 492, y: 181 }, 
				{ i: 9, x: 468, y: 187 }, 
				{ i: 10, x: 452, y: 195 }, 
				{ i: 11, x: 440, y: 201 }, 
				{ i: 12, x: 429, y: 209 }, 
				{ i: 13, x: 418, y: 222 }, 
				{ i: 14, x: 411, y: 229 }, 
				{ i: 15, x: 404, y: 245 }, 
				{ i: 16, x: 402, y: 257 }, 
				{ i: 17, x: 400, y: 260 }, 
				{ i: 18, x: 404, y: 277 }, 
				{ i: 19, x: 404, y: 291 }, 
				{ i: 20, x: 408, y: 301 }, 
				{ i: 21, x: 414, y: 311 }, 
				{ i: 22, x: 422, y: 323 },
				{ i: 23, x: 432, y: 333 },
				{ i: 24, x: 446, y: 345 }, 
				{ i: 25, x: 466, y: 355 }, 
				{ i: 26, x: 518, y: 375 }, 
				{ i: 27, x: 544, y: 385 }, 
				{ i: 28, x: 586, y: 399 }, 
				{ i: 29, x: 616, y: 411 }, 
				{ i: 30, x: 630, y: 425 }, 
				{ i: 31, x: 644, y: 437 }, 
				{ i: 32, x: 656, y: 453 }, 
				{ i: 33, x: 660, y: 467 }, 
				{ i: 34, x: 660, y: 479 }, 
				{ i: 35, x: 662, y: 491 }, 
				{ i: 36, x: 662, y: 503 }, 
				{ i: 37, x: 658, y: 513 }, 
				{ i: 38, x: 654, y: 525 }, 
				{ i: 39, x: 650, y: 537 }, 
				{ i: 40, x: 642, y: 547 }, 
				{ i: 41, x: 632, y: 557 }, 
				{ i: 42, x: 622, y: 567 }, 
				{ i: 43, x: 608, y: 575 }, 
				{ i: 44, x: 594, y: 581 }, 
				{ i: 45, x: 578, y: 587 }, 
				{ i: 46, x: 562, y: 590 }, 
				{ i: 47, x: 516, y: 593 }, 
				{ i: 48, x: 500, y: 589 }, 
				{ i: 49, x: 486, y: 587 }, 
				{ i: 50, x: 466, y: 579 }, 
				{ i: 51, x: 406, y: 551 }, 
				{ i: 52, x: 400, y: 549 }
				
			],
			hintPaths: [
				[ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 ],
				
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 ],
			targetItems: [
				{ filename: "capital-s-01.png", x: 604, y: 168 },
				{ filename: "capital-s-02.png", x: 551, y: 156 },
				{ filename: "capital-s-03.png", x: 491, y: 145 },
				{ filename: "capital-s-04.png", x: 433, y: 156 },
				{ filename: "capital-s-05.png", x: 366, y: 175 },
				{ filename: "capital-s-06.png", x: 370, y: 268 },
				{ filename: "capital-s-07.png", x: 429, y: 285 },
				{ filename: "capital-s-08.png", x: 483, y: 315 },
				{ filename: "capital-s-09.png", x: 549, y: 349 },
				{ filename: "capital-s-10.png", x: 619, y: 367 },
				{ filename: "capital-s-11.png", x: 623, y: 494 },
				{ filename: "capital-s-12.png", x: 553, y: 527 },
				{ filename: "capital-s-13.png", x: 483, y: 545 },
				{ filename: "capital-s-14.png", x: 413, y: 526 },
				{ filename: "capital-s-15.png", x: 343, y: 497 }
		
			],
			payoff: { filename: "capital-s-payoff.png", x: 0, y: 0 }
		},{ //Round 20
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 133,
						duration: 3.9
					},
					{
						name: "payoff",
						startTime: 137,
						duration: 2.9
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 335, y: 176 },
				{ i: 1, x: 711, y: 176 },
				{ i: 2, x: 522, y: 176 },
				{ i: 3, x: 522, y: 595 }
			],
			hintPaths: [
				[2, 3],
				[0, 1]	
			],
			successPath: [0, 1, 2, 3 ],
			targetItems: [
				{ filename: "capital-t-01.png", x: 327 ,y: 168 },
				{ filename: "capital-t-02.png", x: 372, y: 168 },
				{ filename: "capital-t-03.png", x: 420, y: 168 },
				{ filename: "capital-t-04.png", x: 467, y: 168 },
				{ filename: "capital-t-05.png", x: 508, y: 168 },
				{ filename: "capital-t-06.png", x: 534, y: 168 },
				{ filename: "capital-t-07.png", x: 579, y: 168 },
				{ filename: "capital-t-08.png", x: 627, y: 168 },
				{ filename: "capital-t-09.png", x: 674, y: 168 },
				{ filename: "capital-t-10.png", x: 487, y: 210 },
				{ filename: "capital-t-11.png", x: 487, y: 252 },
				{ filename: "capital-t-12.png", x: 487, y: 294 },
				{ filename: "capital-t-13.png", x: 487, y: 336 },
				{ filename: "capital-t-14.png", x: 487, y: 378 },
				{ filename: "capital-t-15.png", x: 487, y: 420 },
				{ filename: "capital-t-16.png", x: 487, y: 462 },
				{ filename: "capital-t-17.png", x: 487, y: 504 },
				{ filename: "capital-t-18.png", x: 487, y: 550 }
		
			],
			payoff: { filename: "capital-t-payoff.png", x: 0, y: 0 }
		},{ //Round 21
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 140,
						duration: 3.3
					},
					{
						name: "payoff",
						startTime: 144,
						duration: 2.9 
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-3.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				 { i: 0, x: 350, y: 176 }, 
				 { i: 1, x: 350, y: 440 }, 
				 { i: 2, x: 356, y: 463 }, 
				 { i: 3, x: 366, y: 493 }, 
				 { i: 4, x: 374, y: 511 }, 
				 { i: 5, x: 386, y: 529 }, 
				 { i: 6, x: 400, y: 545 }, 
				 { i: 7, x: 414, y: 559 }, 
				 { i: 8, x: 425, y: 569 }, 
				 { i: 9, x: 446, y: 579 }, 
				 { i: 10, x: 466, y: 587 }, 
				 { i: 11, x: 484, y: 591 }, 
				 { i: 12, x: 526, y: 592 }, 
				 { i: 13, x: 538, y: 590 }, 
				 { i: 14, x: 560, y: 590 }, 
				 { i: 15, x: 596, y: 569 }, 
				 { i: 16, x: 622, y: 555 }, 
				 { i: 17, x: 640, y: 535 }, 
				 { i: 18, x: 654, y: 513 }, 
				 { i: 19, x: 668, y: 481 }, 
				 { i: 20, x: 674, y: 451 }, 
				 { i: 21, x: 678, y: 425 }, 
				 { i: 22, x: 680, y: 317 }, 
				 { i: 23, x: 678, y: 176 }
				
			],
			hintPaths: [
				[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 ],
				
			],
			successPath: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
			targetItems: [
				{ filename: "capital-u-01.png", x: 554, y: 158 },
				{ filename: "capital-u-02.png", x: 554, y: 239 },
				{ filename: "capital-u-03.png", x: 554, y: 310 },
				{ filename: "capital-u-04.png", x: 515, y: 378 },
				{ filename: "capital-u-05.png", x: 515, y: 442 },
				{ filename: "capital-u-06.png", x: 515, y: 500 },
				{ filename: "capital-u-07.png", x: 389, y: 555 },
				{ filename: "capital-u-09.png", x: 323, y: 500 },
				{ filename: "capital-u-10.png", x: 323, y: 442 },
				{ filename: "capital-u-11.png", x: 323, y: 378 },
				{ filename: "capital-u-12.png", x: 323, y: 310 },
				{ filename: "capital-u-13.png", x: 323, y: 239 },
                { filename: "capital-u-14.png", x: 323, y: 158 }
							
			],
			payoff: { filename: "capital-u-payoff.png", x: 0 , y: 0 }
		},{ //Round 22
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 148,
						duration: 3.9
					},
					{
						name: "payoff",
						startTime: 152,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 350, y: 178 },
				{ i: 1, x: 517, y: 594 },
                { i: 2, x: 685, y: 178 }
			],
			hintPaths: [
				[0, 1, 2 ],
				
			],
			successPath: [ 0, 1, 2 ],
			targetItems: [
				{ filename: "capital-v-01.png", x: 324, y: 154 },
				{ filename: "capital-v-02.png", x: 341, y: 222 },
				{ filename: "capital-v-03.png", x: 369, y: 279 },
				{ filename: "capital-v-04.png", x: 391, y: 340 },
				{ filename: "capital-v-05.png", x: 414, y: 398 },
				{ filename: "capital-v-06.png", x: 435, y: 450 },
				{ filename: "capital-v-07.png", x: 461, y: 493 },
				{ filename: "capital-v-08.png", x: 476, y: 548 },
				{ filename: "capital-v-09.png", x: 517, y: 493 },
				{ filename: "capital-v-10.png", x: 517, y: 450 },
				{ filename: "capital-v-11.png", x: 517, y: 398 },
				{ filename: "capital-v-12.png", x: 546, y: 340 },
				{ filename: "capital-v-13.png", x: 563, y: 279 },
				{ filename: "capital-v-14.png", x: 596, y: 222 },
				{ filename: "capital-v-15.png", x: 617, y: 154 }

			],
			payoff: { filename: "capital-v-payoff.png", x: 0, y: 0 }
		},{ //Round 23
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 156,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 160,
						duration: 3
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 265, y: 219 },
				{ i: 1, x: 396, y: 575 },
				{ i: 2, x: 522, y: 256 },
				{ i: 3, x: 650, y: 575 },
				{ i: 4, x: 783, y: 219 }
			],
			hintPaths: [
				[0, 1, 2, 3, 4 ],
				
			],
			successPath: [0, 1, 2, 3, 4 ],
			targetItems: [
				{ filename: "capital-w-01.png", x: 216, y: 155 },
				{ filename: "capital-w-02.png", x: 241, y: 223 },
				{ filename: "capital-w-03.png", x: 264, y: 278 },
				{ filename: "capital-w-04.png", x: 285, y: 330 },
				{ filename: "capital-w-05.png", x: 312, y: 384 },
				{ filename: "capital-w-06.png", x: 329, y: 435 },
				{ filename: "capital-w-07.png", x: 343, y: 483 },
				{ filename: "capital-w-08.png", x: 363, y: 539 },
				{ filename: "capital-w-09.png", x: 398, y: 483 },
				{ filename: "capital-w-10.png", x: 398, y: 435 },
				{ filename: "capital-w-11.png", x: 411, y: 384 },
				{ filename: "capital-w-12.png", x: 424, y: 330 },
				{ filename: "capital-w-13.png", x: 451, y: 278 },
				{ filename: "capital-w-14.png", x: 462, y: 170 },
				/*{ filename: "capital-w-15.png", x: 477, y: 155 },*/
				{ filename: "capital-w-16.png", x: 524, y: 170 },
				{ filename: "capital-w-17.png", x: 524, y: 278 },
				{ filename: "capital-w-18.png", x: 534, y: 330 },
				{ filename: "capital-w-19.png", x: 558, y: 384 },
				{ filename: "capital-w-20.png", x: 577, y: 435 },
				{ filename: "capital-w-21.png", x: 592, y: 483 },
				{ filename: "capital-w-22.png", x: 611, y: 539 },
				{ filename: "capital-w-23.png", x: 646, y: 483 },
				{ filename: "capital-w-24.png", x: 646, y: 435 },
				{ filename: "capital-w-25.png", x: 656, y: 384 },
				{ filename: "capital-w-26.png", x: 676, y: 330 },
				{ filename: "capital-w-27.png", x: 696, y: 278 },
				{ filename: "capital-w-28.png", x: 716, y: 223 },
				{ filename: "capital-w-29.png", x: 737, y: 155 }
			],
			payoff: { filename: "capital-w-payoff.png", x: 0 , y: 0  }
		},{ //Round 24
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 164,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 168,
						duration: 2.8
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-3.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 353, y: 176 },
				{ i: 1, x: 691, y: 590 },
				{ i: 2, x: 683, y: 176 },
				{ i: 3, x: 355, y: 590 },
				{ i: 4, x: 521, y: 386 }
			],
			hintPaths: [
				[ 0, 4, 1 ],
				[ 2, 4, 3 ]
			],
			successPath: [ 0, 1, 4, 2, 3 ],
			targetItems: [
				{ filename: "capital-x-01.png", x: 284, y: 156 },
				{ filename: "capital-x-02.png", x: 330, y: 219 },
				{ filename: "capital-x-03.png", x: 369, y: 271 },
				{ filename: "capital-x-04.png", x: 407, y: 316 },
				{ filename: "capital-x-05.png", x: 440, y: 357 },
				{ filename: "capital-x-06.png", x: 407, y: 415 },
				{ filename: "capital-x-07.png", x: 369, y: 464 },
				{ filename: "capital-x-08.png", x: 330, y: 513 },
				{ filename: "capital-x-09.png", x: 284, y: 556 },
				{ filename: "capital-x-10.png", x: 613, y: 156 },
				{ filename: "capital-x-11.png", x: 573, y: 219 },
				{ filename: "capital-x-12.png", x: 549, y: 271 },
				{ filename: "capital-x-13.png", x: 519, y: 316 },
				{ filename: "capital-x-14.png", x: 519, y: 357 },
				{ filename: "capital-x-15.png", x: 519, y: 415 },
				{ filename: "capital-x-16.png", x: 549, y: 464 },
				{ filename: "capital-x-17.png", x: 549, y: 513 },
				{ filename: "capital-x-18.png", x: 632, y: 556 }
			],
			payoff: { filename: "capital-x-payoff.png", x: 0, y: 0 }
		},{ //Round 25
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 171,
						duration: 3
					},
					{
						name: "payoff",
						startTime: 175,
						duration: 1.8
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-1.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 361, y: 176},
				{ i: 1, x: 522, y: 379},
				{ i: 2, x: 679, y: 179},
				{ i: 3, x: 520, y: 592},
				
			],
			hintPaths: [
				[ 0, 1 ],
				[ 2, 1, 3 ]
			],
			successPath: [ 0, 1, 2, 1, 3 ],
			targetItems: [
				{ filename: "capital-y-01.png", x: 283, y: 155 },
				{ filename: "capital-y-02.png", x: 330, y: 228 },
				{ filename: "capital-y-03.png", x: 361, y: 284 },
				{ filename: "capital-y-04.png", x: 439, y: 335 },
				{ filename: "capital-y-05.png", x: 466, y: 384 },
				{ filename: "capital-y-06.png", x: 466, y: 434 },
				{ filename: "capital-y-07.png", x: 466, y: 490 },
				{ filename: "capital-y-08.png", x: 466, y: 543 },
				{ filename: "capital-y-09.png", x: 522, y: 284 },
				{ filename: "capital-y-10.png", x: 565, y: 228 },
				{ filename: "capital-y-11.png", x: 609, y: 155 }

			],
			payoff: { filename: "capital-y-payoff.png", x: 0 , y: 0  }
		},{ //Round 26
			background: {
				filename: "background-circus-green.jpg"
			},
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 178,
						duration: 4.0
					},
					{
						name: "payoff",
						startTime: 182,
						duration: 2.9
					}
				]
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "snuffy-appear.png",
						offsetX: -109,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "snuffy-payoff-2.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -69,
						offsetY: -165
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 415, y: 177},
				{ i: 1, x: 664, y: 177},
				{ i: 2, x: 411, y: 564},
				{ i: 3, x: 643, y: 564}
			],
			hintPaths: [
				[ 0, 1, 2, 3]
			],
			successPath: [ 0, 1, 2, 3],
			targetItems: [
				{ filename: "capital-z-01.png", x: 365, y: 151 },
				{ filename: "capital-z-02.png", x: 437, y: 151 },
				{ filename: "capital-z-03.png", x: 520, y: 151 },
				{ filename: "capital-z-04.png", x: 592, y: 151 },
				{ filename: "capital-z-05.png", x: 542, y: 218 },
				{ filename: "capital-z-06.png", x: 514, y: 264 },
				{ filename: "capital-z-07.png", x: 479, y: 309 },
				{ filename: "capital-z-08.png", x: 437, y: 357 },
				{ filename: "capital-z-09.png", x: 416, y: 401 },
				{ filename: "capital-z-10.png", x: 388, y: 447 },
				{ filename: "capital-z-11.png", x: 359, y: 496 },
				{ filename: "capital-z-12.png", x: 332, y: 545 },
				{ filename: "capital-z-13.png", x: 437, y: 545 },
				{ filename: "capital-z-14.png", x: 520, y: 545 },
				{ filename: "capital-z-15.png", x: 592, y: 545 }
			],
			payoff: { filename: "capital-z-payoff.png", x:0 , y: 0 }
		}
	]
}