
function createPauseScreen(list) {
    setScreenScale();

    // console.log("pause screen created ", list.length);
    if(list != undefined ){
        hideImages(list, false);    
    }
    pauseTimerClock();

    Crafty.audio.stop();


    var bg = Crafty.e("2D, Canvas, GameLogo, Mouse");
    bg.x = Crafty.viewport.width/2-320/2; bg.y = Crafty.viewport.height/2-480/2;

    var hoverEffect = Crafty.e("2D, Canvas, Image, Mouse").image("images/onclick_mainmenu.png");
    hoverEffect.x = bg._x+20; hoverEffect.y = bg._y+200;    hoverEffect.alpha=0.01

    var resumeBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/resume_btn.png");
    resumeBtn.x = bg._x+100; resumeBtn.y = bg._y+200;

    // var restartBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/restart_btn.png");
    // restartBtn.x = bg._x+20; restartBtn.y = resumeBtn._y+50;

    
    var onBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/sound_on.png");
    onBtn.x = bg._x+100; onBtn.y = bg._y+250;
    onBtn.originX = onBtn._x;

    var offBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/sound_off.png");
    offBtn.x = bg._x+100; offBtn.y = bg._y+250;
    offBtn.originX = offBtn._x;

    var helpBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/menu_help.png");
    helpBtn.x = bg._x+100; helpBtn.y = bg._y+300;

    var leaveGameBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/mainmenu.png");//mainmenu.png
    leaveGameBtn.x = bg._x+100; leaveGameBtn.y = bg._y+350;

    if(getAudioIsMuted()) {
        offBtn.visible = true;
        onBtn.visible = false;
        onBtn.x = -1000;
    } else {
        offBtn.visible = false;
        onBtn.visible = true;
        offBtn.x = -1000;
    }

    bg.bind("MouseDown", function(e) {
        console.log("pause bg mouse down ")
        return true;
    })

    bg.bind("MouseMove", function(e)  {
        hoverEffect.alpha=0.01;
    })

    resumeBtn.bind("MouseDown", function(e) {
        console.log("resume button clicked, so resume the game ")
        //delete pause menu
        beginTimerClock();
        setTimerText(true);
        deleteImages([bg,resumeBtn, hoverEffect, onBtn, offBtn, helpBtn, leaveGameBtn]);
        playBgMusic("GameMusic")
    })
    
    // restartBtn.bind("Click", function(e) {
    //     console.log("restart the game ")
    //     Crafty.scene('GamePlay')
    //     resetPuzzleId();
    // })

    offBtn.bind("MouseDown", function(e) {
        console.log("off btn clicked");
        hoverEffect.alpha=0.01;
       setAudioIsMuted(false)
        onBtn.visible = true;
        offBtn.visible = false;
        offBtn.x = -1000;
        onBtn.x = onBtn.originX
    });

    onBtn.bind("MouseDown", function(e) {
        console.log("on btn clicked");
        hoverEffect.alpha=0.01;
       setAudioIsMuted(true)
        offBtn.visible = true;
        onBtn.visible = false;
        offBtn.x = offBtn.originX
        onBtn.x = -1000;
    });

    helpBtn.bind("MouseDown", function(e) {
        hoverEffect.alpha=0.01;
        createHelpScreen()    
    })
    

    leaveGameBtn.bind("MouseDown", function(e) {
        hoverEffect.alpha=0.01;
        Crafty.scene('GameMenu');
    })

    // leaveGameBtn.bind("MouseDown", function(e) {
    //     hoverEffect.x= this._x; hoverEffect.y=this._y;
    //     hoverEffect.alpha=1.0
    // })

    // helpBtn.bind("MouseDown", function(e) {
    //     hoverEffect.x= this._x; hoverEffect.y=this._y;
    //     hoverEffect.alpha=1.0
    // })

    // offBtn.bind("MouseDown", function(e) {
    //     hoverEffect.x= this._x; hoverEffect.y=this._y;
    //     hoverEffect.alpha=1.0
    // })

    // onBtn.bind("MouseDown", function(e) {
    //     hoverEffect.x= this._x; hoverEffect.y=this._y;
    //     hoverEffect.alpha=1.0
    // })

    // resumeBtn.bind("MouseDown", function(e) {
    //     hoverEffect.x= this._x; hoverEffect.y=this._y;
    //     hoverEffect.alpha=1.0
    // })

}






