
function updateSource(source, src) {
    source = $(source);
    source.attr("src", src).appendTo(source.parent());
}

$(document).ready(function() {

	advertisement.init();


	
	$('#soundList a').click(function(e) {
		e.preventDefault();

		sound = $('#audioObject')[0];
			
		if ($(this).hasClass('active')) {
			//pause actual sound
			sound.pause();
			sound.currentTime = 0;		

			$(this).removeClass('active');
			$(this).children('div').removeClass('iconMusicOn');
			$(this).children('div').addClass('iconMusicOff');
			
		} else {
			//pause actual sound
			 if (sound.paused == false) {
				sound.pause();
				sound.currentTime = 0;
			}
			
			$('#soundList a').each(function(index) {
				$(this).children('div').attr('class', '');
				$(this).removeClass('active');
				$(this).children('div').addClass('iconMusicOff');
			});
			
			//play other sound
			src = $(this).attr('source');
			if (src != '')	updateSource('#audioObject',src);
			sound.play();
	
			$(this).addClass('active');
			$(this).children('div').removeClass('iconMusicOff');
			$(this).children('div').addClass('iconMusicOn');
		
		}
		
	});
	
	$('#audioObject').bind("ended", function() { 
		$('#soundList a').each(function(index) {
			$(this).children('div').attr('class', '');
			$(this).removeClass('active');
			$(this).children('div').addClass('iconMusicOff');
		});
	
	
	});

	$('#btnSettings').click(function(e) { 
		e.preventDefault();
		$('.card').toggleClass('flipped');
	
		
	});

	$('#btnDone').click(function(e) {
		e.preventDefault();
		$('.card').toggleClass('flipped');
	
	});

});

jQuery(function($) {
$(document).on("click", "a", function(event){ 
	if ((!this.target) || (this.target =='_self')) {
		//alert('internal link');
		event.preventDefault();
		window.location = this.href;
	} else {
		//alert('external link');
	}
  });
});