var Ball = function (width, height) {
	// this.x = Math.randomNumber(0, 1) == 0 ? -1 : width + 1;
	// this.y = Math.randomNumber(0, 1) == 0 ? -1 : height + 1;

	this.setupXYTest = Math.randomNumber(0, 1)
	this.x = [ [-1, width + 1][Math.randomNumber(0, 1)], Math.randomNumber(0, width) ][this.setupXYTest];
	this.y = [ Math.randomNumber(0, height), [-1, height + 1][Math.randomNumber(0, 1)] ][this.setupXYTest];

	// this.x = Math.randomNumber(0, width);
	// this.y = Math.randomNumber(0, height);
	this.radius = Math.randomNumber(10, 20);

  this.speed = Math.randomNumber(200, 500);
  this.colors = [0xf1c40f, 0xe67e22, 0xe74c3c, 0xbdc3c7, 0x9b59b6, 0x34495e, 0x3498db, 0x2ecc71];

	this.enemy = null;
	this.enemyGraphics = null;

	// enemy graphic object
	this.build();

}


Ball.prototype.build = function() {
	this.createEnemy();
};

Ball.prototype.createEnemy = function () {
	this.enemy = this.physicsEnemy();
	this.enemyGraphics = this.graphicsEnemy();
};

/**
 * enamy objects go here
 * physicsEnemy, setup an enemy object
 * graphicsEnemy, setup an enemy graphic object
 */

Ball.prototype.physicsEnemy = function () {
	var enemyShape, enemy = new p2.Body({
	  position: [this.x, this.y],
	  mass: 1,
	  damping: 0,
	  angularDamping: 0,
	  velocity: [this.speed.randomVelocity(), this.speed.randomVelocity()],
	  angulerVelocity: this.speed.randomVelocity()
	});

	enemyShape = new p2.Circle({ radius: this.radius });
	enemy.addShape(enemyShape);

	return enemy;
}

Ball.prototype.graphicsEnemy = function () {
	// some graphic for enemy
	var enemyGraphics = new PIXI.Graphics();
	enemyGraphics.beginFill(this.colors.random());
	enemyGraphics.drawCircle(0, 0, this.radius);
	enemyGraphics.x = this.x;
	enemyGraphics.y = this.y;
	enemyGraphics.endFill();

	return enemyGraphics;
}