SP.Game = function(game) {
//Constants
	this._playerSpeed = 450;
	this._computerSpeed = 250;
	this.speed = 400;

	//Texts
	this._pause = "▮▮";
	this._play = "▶";
	this._heart = "♥";
	this._sound = "♫";

//Stats    
	this._fontStyle = null;
	SP._scoreText = null;

//Participants
	this._playerBet = null;
	this._computerBet = null;
	this._ball = null;

//Per Game Constants
	this._playerBound = 0;
	this._computerBound = 0;

// Future constructors
	this._createBet = function(x, y, image) {
		var bet = game.add.sprite(x, y, image);
		this.physics.enable(bet, Phaser.Physics.ARCADE, true);
		bet.anchor.setTo(0.5, 0.5);
		bet.body.collideWorldBounds = true;
		bet.body.bounce.setTo(1, 1);
		bet.body.immovable = true;

		return bet;
	};
};

SP.Game.prototype = {
	create: function() {
		this.physics.startSystem(Phaser.Physics.ARCADE);
		//Fix for Sprite collision
		this.physics.arcade.OVERLAP_BIAS = 10;
		this.add.tileSprite(0, 0, SP.gW, SP.gH, 'background');

		SP._score = 0;
		SP._health = 3;
		SP._gameOver = false;

		this._playerBet = this._createBet(this.world.centerX, SP.gH * 80 / 100, 'player');
		this._playerBet.halfWidth = this._playerBet.width / 2;
		this._computerBet = this._createBet(this.world.centerX, SP.gH * 10 / 100, 'enemy');

		this._ball = new Ball(this, 0, 0);

		//Set Bounds
		this._playerBound = SP.gH - this._ball.body.halfHeight - 5;
		this._computerBound = this._ball.body.halfHeight + 5;



		var playmusic = function(target, event) {
			this.input.disabled = true;
			if (SP.musicon) {
				SP.music.pause();
				SP._musicPlayBtn.setStyle(this._redfontStyle);
			} else {
				SP.music.resume();
				SP._musicPlayBtn.setStyle(this._fontStyle);
			}
			SP.musicon = !SP.musicon;
			this.input.disabled = false;
		}

		this._fontStyle = { font: "25px Arial", fill: "#FFCC00", stroke: "#333", strokeThickness: 0, align: "center" };
		this._redfontStyle = { font: "25px Arial", fill: "#FF0000", stroke: "#333", strokeThickness: 0, align: "center" };
		SP._scoreText = this.add.text(5, 5, "Score: 0", this._fontStyle);
		SP._lifeText = this.add.text(this.world.centerX - 25, 5, this._getHearts(), this._fontStyle);
		SP._pausePlayBtn = this.add.text(SP.gW - 55, 5, this._pause, this._fontStyle);
		SP._musicPlayBtn = this.add.text(SP.gW - 100, 5, this._sound, SP.musicon ? this._fontStyle : this._redfontStyle);
		SP._pausePlayBtn.inputEnabled = true;
		SP._pausePlayBtn.events.onInputDown.add(this.managePause, this, 2);
		SP._musicPlayBtn.inputEnabled = true;
		SP._musicPlayBtn.events.onInputDown.add(playmusic, this, 2);

		this._ball.set(this._playerBet.position.x, this._playerBet.position.y - this._playerBet.body.halfHeight);

		this.input.onUp.add(this._ball.release, this._ball, 1);

	},
	managePause: function() {
		this.game.paused = true;
		var pausedText = this.add.text(this.world.centerX, this.world.centerY, "Game paused.\nTap anywhere to continue.",
						{ font: "50px Arial", fill: "#FFCC00", stroke: "#333", strokeThickness: 3,
							wordWrap: true, wordWrapWidth: this.world.width, align: "center" });
		pausedText.anchor.setTo(0.5, 0.5);
		this.input.onDown.add(function(game, evt) {
			pausedText.destroy();
			this.game.paused = false;
			evt.stopPropagation();
		}, this);
	},
	update: function() {
		if (SP._gameOver)
			return;

		this._playerMoves();
		this._computerMoves();

		//Collisions
		this.physics.arcade.collide(this._ball, this._playerBet, this._ballHitsBet, null, this);
		this.physics.arcade.collide(this._ball, this._computerBet, this._ballHitsBet, null, this);

		//check Goal
		this._checkGoal();

	},
	//Game Over
	gameOver: function() {
		SP._gameOver = true;
		var tStyle = { font: "50px Arial", fill: "#FFCC00", stroke: "#333", strokeThickness: 3,
			wordWrap: true, wordWrapWidth: this.world.width, align: "center" };
		var btnTextStyle = { font: "30px Arial", fill: "#FFCC00", stroke: "#333", strokeThickness: 3,
			wordWrap: true, wordWrapWidth: this.world.width, align: "center" };
		var gamOverText = this.add.text(this.world.centerX, this.world.centerY - 150, "Game Over.", btnTextStyle);
		var scoreText = this.add.text(this.world.centerX, this.world.centerY - 50, "You scored: " + SP._score, btnTextStyle);
		var shareScoreText = this.add.text(this.world.centerX, this.world.centerY + 25, "Share Score", tStyle);
		var startAgainText = this.add.text(this.world.centerX, this.world.centerY + 100, "Start Again", tStyle);
		var mainMenuText = this.add.text(this.world.centerX, this.world.centerY + 175, "Main Menu", tStyle);
		var creditsText = this.add.text(this.world.centerX, this.world.centerY + 250, "Credits", tStyle);
		shareScoreText.anchor.setTo(0.5, 0.5);
		scoreText.anchor.setTo(0.5, 0.5);
		gamOverText.anchor.setTo(0.5, 0.5);
		startAgainText.anchor.setTo(0.5, 0.5);
		mainMenuText.anchor.setTo(0.5, 0.5);
		creditsText.anchor.setTo(0.5, 0.5);

		var shareScore = function() {
			if (leaderboard)
				leaderboard.post({ score: SP._score });

			Clay.Facebook.post({ message: "I just scored " + SP._score + ' in http://spacepong.clay.io/ Game!' });
		};

		shareScoreText.inputEnabled = true;
		shareScoreText.events.onInputDown.add(function() {
			shareScore();
		}, this);

		startAgainText.inputEnabled = true;
		startAgainText.events.onInputDown.add(function() {
			this.state.start('Game');
		}, this);

		mainMenuText.inputEnabled = true;
		mainMenuText.events.onInputDown.add(function() {
			this.state.start('MainMenu');
		}, this);

		creditsText.inputEnabled = true;
		creditsText.events.onInputDown.add(function() {
			this.state.start('Credits');
		}, this);
	},
	//Game actions
	_playerMoves: function() {
		var diff = this._playerBet.x - this.input.x;
		var velo = Math.abs(diff);
		var moveTo;
		if (velo > 200)
			moveTo = this._playerBet.x - diff * (this._playerSpeed / this.world.width);
		else
			moveTo = this._playerBet.x - diff;
		if (moveTo < this._playerBet.halfWidth) {
			moveTo = this._playerBet.halfWidth;
		} else if (moveTo > this.world.width - this._playerBet.halfWidth)
			moveTo = this.world.width - this._playerBet.halfWidth;
		this._playerBet.x = moveTo;
	},
	_computerMoves: function() {
		if (!this._ball.released) {
			this._computerBet.x = this.world.centerX;
			return;
		}
		this.physics.arcade.moveToXY(this._computerBet, this._ball.x, this._computerBet.y, this._computerSpeed);
		//  if it's overlapping the mouse, don't move any more
		var diff = this._computerBet.x - this._ball.x;
		if (Math.abs(diff) < 15) {
			this._computerBet.body.velocity.setTo(0, 0);
		}
	},
	_ballHitsBet: function(_ball, _bet) {
		var diff = _bet.x - _ball.x;
		_ball.body.velocity.x = -10 * diff;
		this._incScore(1);
	},
	_checkGoal: function() {
		if (this._ball.y < this._computerBound) {
			this._goal(true);
		} else if (this._ball.y > this._playerBound) {
			this._goal(false);
		}
	},
	_goal: function(win) {
		if (!this._ball.released)
			return;
		this._ball.set(this._playerBet.position.x, this._playerBet.position.y - this._playerBet.body.halfHeight);
		if (win) {
			this._incScore(100);
			this._sayNew("Oh yeah!");
		} else
			this._die();
	},
	_sayNew: function(text) {
		this._sayTextElem = this.add.text(this.world.centerX, this.world.centerY, text,
						{ font: "50px Arial", fill: "#FFCC00", stroke: "#333", strokeThickness: 3,
							wordWrap: true, wordWrapWidth: this.world.width, align: "center" });
		this._sayTextElem.anchor.setTo(0.5, 0.5);
		this._sayTextElem.alpha = 0.5;
		var tween1 = this.add.tween(this._sayTextElem.scale).to({ x: 3, y: 3 }, 1000).start();
		this.add.tween(this._sayTextElem).to({ alpha: 1 }, 500).to({ alpha: 0 }, 500).start();
		tween1.onComplete.add(function() {
			this._sayTextElem.destroy();
		}, this);
	},
	_incScore: function(inc) {
		SP._score += inc;
		SP._scoreText.setText("Score: " + SP._score);
	},
	_die: function() {
		SP._lifeText.setText(SP._lifeText.text.substring(0, SP._lifeText.text.length - 1));
		SP._health--;
		if (!SP._health) {
			this.gameOver();
			return true;
		} else
			this._sayNew("Oh No!");
		return false;
	},
	//Services
	_getHearts: function() {
		var hearts = "";
		for (var i = 0; i < SP._health; i++) {
			hearts += this._heart;
		}
		return hearts;
	}
};
