Ball = function(game, x, y) {
	Phaser.Sprite.call(this, game, x, y, 'ball');
	game.physics.enable(this, Phaser.Physics.ARCADE, true);
	
	this.released = false;
	this.anchor.setTo(0.5, 0.5);
	this.body.collideWorldBounds = true;
	this.body.bounce.setTo(1, 1);

	game.add.existing(this);
};

Ball.prototype = Object.create(Phaser.Sprite.prototype);
Ball.prototype.constructor = Ball;

Ball.prototype.release = function(target, evt) {
	if (evt.clientY < this.game.world.centerY >> 1 || SP._gameOver)
		return;
	if (!this.released) {
		this.body.velocity.x = this.game.speed >> 4;
		this.body.velocity.y = -this.game.speed;
		this.released = true;
	}
};

Ball.prototype.set = function(x, y) {
	this.released = false;
	this.body.velocity.x = 0;
	this.body.velocity.y = 0;
	this.x = x;
	this.y = y - this.game._ball.body.halfHeight;
};

Ball.prototype.update = function() {
	if (!this.released)
		this.x = this.game._playerBet.x;
};
