/**
 * Created with JetBrains WebStorm.
 * User: gravis_ihara
 * Date: 14/09/08
 * Time: 17:18
 * To change this template use File | Settings | File Templates.
 */
gravis.Bahuda = enchant.Class.create(enchant.Group, {
    initialize: function(num, x, y) {
        enchant.Group.call(this);

        this.num = num;
        this.state = gravis.Bahuda.STATE_WAIT;
        this.target = 0;

        this.base_pos_x = this.pos_x = x;//(x<<8);
        this.base_pos_y = this.pos_y = y;//(y<<8);

        this.target_pos_x = this.add_pos_x = 0;
        this.target_pos_y = this.target_pos_y = 0;
        this.move_count = 0;

        this.drawObj = new enchant.Sprite(gravis.CARD_W, gravis.CARD_H);
        this.drawObj.image = gravis.Utility.getImage('card.png');
        this.addChild(this.drawObj);
        this.drawObj.visible = false;

        this.push = false;
        this.enablePush = true;
        var myObj = this;
        this.addEventListener('touchstart', function(){
            if( myObj.enablePush ) myObj.push = true;
        });
        this.addEventListener('touchend', function(){
            myObj.push = false;
        });
    },

    proc: function() {
        if( this.move_count > 0 ) {
            this.pos_x += this.add_pos_x;
            this.pos_y += this.add_pos_y;
            if( --this.move_count == 0 ) {
                if( this.state == gravis.Bahuda.STATE_GO ) {
                    this.pos_x = this.target_pos_x;
                    this.pos_y = this.target_pos_y;
                    this.state = gravis.Bahuda.STATE_CHECK;
                } else if( this.state == gravis.Bahuda.STATE_BACK ) {
                    this.pos_x = this.base_pos_x;
                    this.pos_y = this.base_pos_y;
                    this.state = gravis.Bahuda.STATE_WAIT;
                } else if( this.state == gravis.Bahuda.STATE_SET ) {
                    this.pos_x = this.base_pos_x;
                    this.pos_y = this.base_pos_y;
                    this.state = gravis.Bahuda.STATE_WAIT;
                }
            }
        }
    },

    draw: function() {
        if( this.num == gravis.CARD_EMPTY ) {
            this.drawObj.visible = false;
        } else {
            this.drawObj.visible = true;
            this.drawObj.moveTo(this.pos_x,this.pos_y);
            this.drawObj.frame = this.num;
        }
    },

    go: function(target, px, py) {
        this.target = target;
        this.target_pos_x = px;//(px<<8);
        this.target_pos_y = py;//(py<<8);
        this.state = gravis.Bahuda.STATE_GO;
        this.move_count = gravis.CARDMOVE_GO;

        this.add_pos_x = (this.target_pos_x-this.pos_x) / this.move_count;
        this.add_pos_y = (this.target_pos_y-this.pos_y) / this.move_count;
    },

    back: function() {
        this.target_pos_x = this.base_pos_x;
        this.target_pos_y = this.base_pos_y;
        this.state = gravis.Bahuda.STATE_BACK;
        this.move_count = gravis.CARDMOVE_BACK;

        this.add_pos_x = (this.target_pos_x-this.pos_x) / this.move_count;
        this.add_pos_y = (this.target_pos_y-this.pos_y) / this.move_count;
    },

    reset: function() {
        this.move_count = 0;
        this.pos_x = this.base_pos_x;
        this.pos_y = this.base_pos_y;
        this.state = gravis.Bahuda.STATE_WAIT;
    },

    set: function(px, py) {
        this.pos_x = px;//(px<<8);
        this.pos_y = py;//(py<<8);
        this.target_pos_x = this.base_pos_x;
        this.target_pos_y = this.base_pos_y;
        this.state = gravis.Bahuda.STATE_SET;
        this.move_count = gravis.CARDMOVE_SET;

        this.add_pos_x = (this.target_pos_x-this.pos_x) / this.move_count;
        this.add_pos_y = (this.target_pos_y-this.pos_y) / this.move_count;
    },

    isDown: function() {
        var ret = this.push;
        this.push = false;
        return ret;
    }
});

gravis.Bahuda.STATE_WAIT = 0;
gravis.Bahuda.STATE_GO = 1;
gravis.Bahuda.STATE_CHECK = 2;
gravis.Bahuda.STATE_BACK = 3;
gravis.Bahuda.STATE_SET = 4;

gravis.Daihuda = enchant.Class.create(enchant.Group, {
    initialize: function(num, x, y) {
        enchant.Group.call(this);

        this.num = num;
        this.target = 0;
        this.state = gravis.Daihuda.STATE_WAIT;

        this.base_pos_x = this.pos_x = x;
        this.base_pos_y = this.pos_y = y;

        this.add_pos_x = 0;
        this.add_pos_y = 0;
        this.move_count = 0;

        this.drawObj = new enchant.Sprite(gravis.CARD_W, gravis.CARD_H);
        this.drawObj.image = gravis.Utility.getImage('card.png');
        this.addChild(this.drawObj);
        this.drawObj.visible = false;
    },

    proc: function() {
        if( this.move_count > 0 ) {
            this.pos_x += this.add_pos_x;
            this.pos_y += this.add_pos_y;
            if( --this.move_count == 0 ) {
                this.pos_x = this.base_pos_x;
                this.pos_y = this.base_pos_y;
                this.state = gravis.Daihuda.STATE_WAIT;
            }
        }
    },

    draw: function() {
        if( this.num == gravis.CARD_EMPTY ) {
            this.drawObj.visible = false;
        } else {
            this.drawObj.visible = true;
            this.drawObj.moveTo(this.pos_x,this.pos_y);
            this.drawObj.frame = this.num;
        }
    },

    reload: function(num, x, y) {
        this.num = num;
        this.move_count = gravis.CARDMOVE_SET;
        this.pos_x = x;
        this.pos_y = y;
        this.add_pos_x = (this.base_pos_x - this.pos_x) / this.move_count;
        this.add_pos_y = (this.base_pos_y - this.pos_y) / this.move_count;
        this.state = gravis.Daihuda.STATE_RELOAD;
    }
});

gravis.Daihuda.STATE_WAIT = 0;
gravis.Daihuda.STATE_RELOAD = 1;

