/**
 * Created with JetBrains WebStorm.
 * User: gravis_ihara
 * Date: 14/09/09
 * Time: 18:29
 * To change this template use File | Settings | File Templates.
 */

gravis.GameEffect = enchant.Class.create(enchant.Group, {
    initialize: function(w, h) {
        enchant.Group.call(this);
        this.type = gravis.GameEffect.TYPE_NONE;
        this.versus = 0;
        this.winner = 0;
        this.workFrame = 0;
        this.window_width = w;
        this.window_height = h;
        this.effectWord = null;
    },

    setEffect: function(type, num1, num2) {
        if( type != gravis.GameEffect.TYPE_RESULT ) {
            if( this.effectWord != null ) {
                for( var i=0; i<this.effectWord.length; i++ ) {
                    this.removeChild(this.effectWord[i]);
                }
            }
        }

        this.type = type;
        this.versus = num1;
        this.winner = num2;
        switch( type ) {
            case gravis.GameEffect.TYPE_NONE:
                this.effectWord = null;
                break;
            case  gravis.GameEffect.TYPE_READY:
                if( this.versus == gravis.SceneGame.VERSUS_PLAYER ) {
                    this.effectWord = new Array(2);
                    //this.effectWord[0] = new gravis.EffectWord( "ready.png", 240, this.window_height/2+75, 360, 149 );
                    this.effectWord[0] = new gravis.EffectWord( "ready.png", 160, this.window_height/2+50, 240, 99 );
                    this.effectWord[0].setTypeAnimation(gravis.GameEffect.ANIMATION_PATTERN[0], -1);
                    //this.effectWord[1] = new gravis.EffectWord( "ready.png", 240, this.window_height/2+75, 360, 149, 0, true );
                    this.effectWord[1] = new gravis.EffectWord( "ready.png", 160, this.window_height/2+50, 240, 99, 0, true );
                    this.effectWord[1].setTypeAnimation(gravis.GameEffect.ANIMATION_PATTERN[0], -1);
                    this.addChild(this.effectWord[0]);
                    this.addChild(this.effectWord[1]);
                } else if( this.versus == gravis.SceneGame.VERSUS_COMPUTER ) {
                    this.effectWord = new Array(1);
                    //this.effectWord[0] = new gravis.EffectWord( "ready.png", 240, this.window_height/2, 360, 149 );
                    this.effectWord[0] = new gravis.EffectWord( "ready.png", 160, this.window_height/2, 240, 99 );
                    this.effectWord[0].setTypeAnimation(gravis.GameEffect.ANIMATION_PATTERN[0], -1);
                    this.addChild(this.effectWord[0]);
                }
                this.workFrame = 60;
                break;
            case  gravis.GameEffect.TYPE_GO:
                if( this.versus == gravis.SceneGame.VERSUS_PLAYER ) {
                    this.effectWord = new Array(2);
                    //this.effectWord[0] = new gravis.EffectWord( "go.png", 240, this.window_height/2+65, 208, 134 );
                    this.effectWord[0] = new gravis.EffectWord( "go.png", 160, this.window_height/2+43, 139, 90 );
                    this.effectWord[0].setTypeFadeout( 10, 20, 1, 3, 0, 4 );
                    //this.effectWord[1] = new gravis.EffectWord( "go.png", 240, this.window_height/2+65, 208, 134, 0, true );
                    this.effectWord[1] = new gravis.EffectWord( "go.png", 160, this.window_height/2+43, 139, 90, 0, true );
                    this.effectWord[1].setTypeFadeout( 10, 20, 1, 3, 0, 4 );
                    this.addChild(this.effectWord[0]);
                    this.addChild(this.effectWord[1]);
                } else if( this.versus == gravis.SceneGame.VERSUS_COMPUTER ) {
                    this.effectWord = new Array(1);
                    //this.effectWord[0] = new gravis.EffectWord( "go.png", 240, this.window_height/2, 208, 134 );
                    this.effectWord[0] = new gravis.EffectWord( "go.png", 160, this.window_height/2, 139, 90 );
                    this.effectWord[0].setTypeFadeout( 10, 20, 1, 3, 0, 0 );
                    this.addChild(this.effectWord[0]);
                }
                this.workFrame = 25;
                break;
            case  gravis.GameEffect.TYPE_BREAK:
                this.effectWord = new Array(2);
                this.effectWord[0] = new gravis.EffectWord(
                    "card.png",
                    //this.window_width/2-38-(gravis.CARD_W/2),
                    this.window_width/2-25-(gravis.CARD_W/2),
                    this.window_height/2,
                    gravis.CARD_W,
                    gravis.CARD_H,
                    num1
                );
                this.effectWord[0].setTypeFadeout( 10, 25, 1, 1, 13, 0 );
                this.effectWord[1] = new gravis.EffectWord(
                    "card.png",
                    //this.window_width/2+44+(gravis.CARD_W/2),
                    this.window_width/2+29+(gravis.CARD_W/2),
                    this.window_height/2,
                    gravis.CARD_W,
                    gravis.CARD_H,
                    num2
                );
                this.effectWord[1].setTypeFadeout( 10, 25, 1, 1, -13, 0 );
                this.addChild(this.effectWord[0]);
                this.addChild(this.effectWord[1]);
                this.workFrame = 40;
                break;
            case  gravis.GameEffect.TYPE_WINLOSE:
                if( this.versus == gravis.SceneGame.VERSUS_PLAYER ) {
                    this.effectWord = new Array(2);
                    //this.effectWord[0] = new gravis.EffectWord("win.png", 240, this.window_height/2+150, 269, 133, 0, this.winner == gravis.SceneGame.WINNER_P2 );
                    this.effectWord[0] = new gravis.EffectWord("win.png", 160, this.window_height/2+100, 179, 88, 0, this.winner == gravis.SceneGame.WINNER_P2 );
                    this.effectWord[0].setTypeFadein( 10, 25, 3, 1, 0, 0 );
                    //this.effectWord[1] = new gravis.EffectWord("lose.png", 240, this.window_height/2+150, 269, 133, 0, this.winner == gravis.SceneGame.WINNER_P1 );
                    this.effectWord[1] = new gravis.EffectWord("lose.png", 160, this.window_height/2+100, 179, 88, 0, this.winner == gravis.SceneGame.WINNER_P1 );
                    this.effectWord[1].setTypeFadein( 45, 60, 3, 1, 0, 0 );
                    this.addChild(this.effectWord[0]);
                    this.addChild(this.effectWord[1]);
                    this.workFrame = 90;
                } else if( this.versus == gravis.SceneGame.VERSUS_COMPUTER ) {
                    this.effectWord = new Array(1);
                    if( this.winner == gravis.SceneGame.WINNER_P1 ) {
                        //this.effectWord[0] = new gravis.EffectWord("win.png", 240, this.window_height/2, 269, 133 );
                        this.effectWord[0] = new gravis.EffectWord("win.png", 160, this.window_height/2, 179, 88 );
                        this.effectWord[0].setTypeFadein( 10, 25, 3, 1, 0, 0 );
                        this.addChild(this.effectWord[0]);
                    } else if( this.winner == gravis.SceneGame.WINNER_P2 ) {
                        //this.effectWord[0] = new gravis.EffectWord("lose.png", 240, this.window_height/2, 269, 133 );
                        this.effectWord[0] = new gravis.EffectWord("lose.png", 160, this.window_height/2, 179, 88 );
                        this.effectWord[0].setTypeFadein( 10, 25, 3, 1, 0, 0 );
                        this.addChild(this.effectWord[0]);
                    }
                    this.workFrame = 55;
                }
                break;
            case  gravis.GameEffect.TYPE_DRAW:
                if( this.versus == gravis.SceneGame.VERSUS_PLAYER ) {
                    this.effectWord = new Array(2);
                    //this.effectWord[0] = new gravis.EffectWord("draw.png", 240, this.window_height/2+150, 269, 133 );
                    this.effectWord[0] = new gravis.EffectWord("draw.png", 160, this.window_height/2+100, 219, 92 );
                    this.effectWord[0].setTypeFadein( 10, 25, 3, 1, 0, 0 );
                    //this.effectWord[1] = new gravis.EffectWord("draw.png", 240, this.window_height/2+150, 269, 133, 0, true );
                    this.effectWord[1] = new gravis.EffectWord("draw.png", 160, this.window_height/2+100, 219, 92, 0, true );
                    this.effectWord[1].setTypeFadein( 10, 25, 3, 1, 0, 0 );
                    this.addChild(this.effectWord[0]);
                    this.addChild(this.effectWord[1]);
                } else if( this.versus == gravis.SceneGame.VERSUS_COMPUTER ) {
                    this.effectWord = new Array(1);
                    //this.effectWord[0] = new gravis.EffectWord("draw.png", 240, this.window_height/2, 269, 133 );
                    this.effectWord[0] = new gravis.EffectWord("draw.png", 160, this.window_height/2, 219, 92 );
                    this.effectWord[0].setTypeFadein( 10, 25, 3, 1, 0, 0 );
                    this.addChild(this.effectWord[0]);
                }
                this.workFrame = 85;
                break;
            case gravis.GameEffect.TYPE_RESULT:
                this.workFrame = 0;
                break;
        }
    },

    proc: function() {
        if( this.effectWord != null ) {
            for( var i=0; i<this.effectWord.length; i++ ) {
                if( this.effectWord[i] != null ) {
                    this.effectWord[i].proc();

                    //win,lose,draw演出の場合はフェードイン後アニメに遷移
                    if( (this.type == gravis.GameEffect.TYPE_WINLOSE || this.type == gravis.GameEffect.TYPE_DRAW) && this.effectWord[i].type == gravis.EffectWord.TYPE_FADEIN ) {
                        if( this.effectWord[i].workFrame >= this.effectWord[i].endFrame ) {
                            gravis.Utility.playSE('se_03.ogg');
                            this.effectWord[i].setTypeAnimation(gravis.GameEffect.ANIMATION_PATTERN[1], -1);
                        }
                    }
                }
            }
        }
        if( --this.workFrame < 0 ) {
            return true;
        }
        return false;
    },
    draw: function() {
        if( this.effectWord != null ) {
            for( var i=0; i<this.effectWord.length; i++ ) {
                if( this.effectWord[i] != null ) this.effectWord[i].draw();
            }
        }
    }
});

gravis.GameEffect.TYPE_READY = 0;
gravis.GameEffect.TYPE_GO = 1;
gravis.GameEffect.TYPE_BREAK = 2;
gravis.GameEffect.TYPE_WINLOSE = 3;
gravis.GameEffect.TYPE_DRAW = 4;
gravis.GameEffect.TYPE_RESULT = 5;
gravis.GameEffect.TYPE_NONE = -1;

gravis.GameEffect.ANIMATION_PATTERN = [
    [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
    [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 3, 3 ]
];

gravis.EffectWord = enchant.Class.create(enchant.Group, {
    initialize: function(img, x, y, w, h, frame, reverse) {
        enchant.Group.call(this);
        this.img = img;
        this.base_x = x;
        this.base_y = y;
        this.w = w;
        this.h = h;
        this.alpha = 0xff;
        this.workFrame = 0;
        this.reverse = reverse || false;
        this.type = gravis.EffectWord.TYPE_NONE;
        this.now_scale = 1.0;
        this.pattern = null;
        this.loop = 0;
        this.startFrame = 0;
        this.endFrame = 0;
        this.add_alpha = 0;
        this.add_scale = 0;
        this.add_x = 0;
        this.add_y = 0;
        this.loop_num = 0;

        this.drawObj = new enchant.Sprite(w, h);
        this.drawObj.moveTo(x-w/2, y-h/2);
        this.drawObj.image = gravis.Utility.getImage(img);
        this.drawObj.frame = frame || 0;

        if( reverse ) {
            var group = new enchant.Group();
            group.originX = gravis.WINDOW_WIDTH / 2;
            group.originY = gravis.WINDOW_HEIGHT / 2;
            group.rotation = 180;
            this.addChild(group);
            group.addChild(this.drawObj);
        } else {
            this.addChild(this.drawObj);
        }
    },

    setTypeNone: function() {
        this.type = gravis.EffectWord.TYPE_NONE;
    },

    setTypeFadein: function(startFrame, endFrame, startScale, endScale, add_x, add_y) {
        this.type = gravis.EffectWord.TYPE_FADEIN;
        this.alpha = 0;
        this.now_scale = startScale;
        this.workFrame = 0;

        this.startFrame = startFrame;//フェードイン開始フレーム
        this.endFrame = endFrame;//フェードイン終了フレーム

        this.add_alpha = 0xff / (endFrame - startFrame); //１フレームあたりのアルファ変化量
        this.add_scale = (endScale - startScale) / (endFrame - startFrame);//１フレームあたりの表示サイズ変化量
        this.add_x = add_x;
        this.add_y = add_y;
    },

    setTypeFadeout: function(startFrame, endFrame, startScale, endScale, add_x, add_y) {
        this.type = gravis.EffectWord.TYPE_FADEOUT;
        this.alpha = 0xff;
        this.now_scale = startScale;
        this.workFrame = 0;

        this.startFrame = startFrame;//フェードイン開始フレーム
        this.endFrame = endFrame;//フェードイン終了フレーム

        this.add_alpha = -(0xff / (endFrame - startFrame)); //１フレームあたりのアルファ変化量
        this.add_scale = (endScale - startScale) / (endFrame - startFrame);//１フレームあたりの表示サイズ変化量
        this.add_x = add_x;
        this.add_y = add_y;
    },

    setTypeAnimation: function(pattern, loop_num) {
        this.type = gravis.EffectWord.TYPE_ANIMATION;
        this.alpha = 0xff;
        this.now_scale = 1;
        this.workFrame = 0;

        this.loop = 0;
        this.loop_num = loop_num;
        this.pattern = pattern;

        this.startFrame = pattern.length;
        this.endFrame = pattern.length + 1;
    },

    proc: function() {
        ++this.workFrame;
        if( this.startFrame <= this.workFrame && this.workFrame < this.endFrame ) {
            if( this.type == gravis.EffectWord.TYPE_ANIMATION ) {
                if( this.loop_num == -1 || this.loop < this.loop_num ) {
                    this.workFrame = 0;
                    this.loop++;
                }
            } else {
                this.alpha += this.add_alpha;
                if( this.alpha > 0xff ) this.alpha = 0xff;
                else if( this.alpha < 0 ) this.alpha = 0;

                this.now_scale += this.add_scale;
                if( this.now_scale < 0 ) this.now_scale = 0;
                this.base_x += this.add_x;
                this.base_y += this.add_y;
            }
        }

        if( this.workFrame == this.endFrame ) {
            if( this.type == gravis.EffectWord.TYPE_FADEIN ) {
                this.alpha = 0xff;
            } else if( this.type == gravis.EffectWord.TYPE_FADEOUT ) {
                this.alpha = 0;
            }
        }
    },

    draw: function() {
        var dx,dy;
        //if( reverse ) { cv.m_bbcv.scale( -1, -1, cv.m_backbufInfo_cx/2, cv.m_backbufInfo_cy/2 ); }
        switch( this.type )
        {
            case gravis.EffectWord.TYPE_NONE:
                dx = this.base_x-this.w/2;
                dy = this.base_y-this.h/2;
                //cv.drawImage( img, dx, dy, w, h, sx, sy );
                this.drawObj.moveTo(dx, dy);
                break;
            case gravis.EffectWord.TYPE_FADEIN:
                dx = this.base_x-this.w/2;
                dy = this.base_y-this.h/2;
                //cv.drawImage(img, dx, dy, (int)(w*scale), (int)(h*scale), sx, sy, w, h, alpha);
                this.drawObj.moveTo(dx, dy);
                this.drawObj.scaleX = this.now_scale;
                this.drawObj.scaleY = this.now_scale;
                this.drawObj.opacity = this.alpha / 0xff;
                break;
            case gravis.EffectWord.TYPE_FADEOUT:
                dx = this.base_x-this.w/2;
                dy = this.base_y-this.h/2;
                //cv.drawImage(img, dx, dy, (int)(w*scale), (int)(h*scale), sx, sy, w, h, alpha);
                this.drawObj.moveTo(dx, dy);
                this.drawObj.scaleX = this.now_scale;
                this.drawObj.scaleY = this.now_scale;
                this.drawObj.opacity = this.alpha / 0xff;
                break;
            case gravis.EffectWord.TYPE_ANIMATION:
                dx = this.base_x-this.w/2;
                dy = this.base_y-this.h/2;
                var p = this.workFrame;
                if( p >= this.pattern.length ) p = this.pattern.length-1;
                //cv.drawImage( img, dx, dy, w, h, sx, sy+h*pattern[p] );
                this.drawObj.moveTo(dx, dy);
                this.drawObj.scaleX = this.now_scale;
                this.drawObj.scaleY = this.now_scale;
                this.drawObj.frame = this.pattern[p];
                break;
        }
        //if( reverse ) { cv.m_bbcv.scale( -1, -1, cv.m_backbufInfo_cx/2, cv.m_backbufInfo_cy/2 ); }
    }
});

gravis.EffectWord.TYPE_NONE = 0;
gravis.EffectWord.TYPE_FADEIN = 1;
gravis.EffectWord.TYPE_FADEOUT = 2;
gravis.EffectWord.TYPE_ANIMATION = 3;

