/**
 * Created with JetBrains WebStorm.
 * User: gravis_ihara
 * Date: 14/09/08
 * Time: 20:53
 * To change this template use File | Settings | File Templates.
 */
gravis.SceneGame = enchant.Class.create(enchant.Group, {
    initialize: function() {
        enchant.Group.call(this);

        this.window_width = gravis.WINDOW_WIDTH;
        this.window_height = gravis.WINDOW_HEIGHT;

        this.gameState = gravis.SceneGame.GS_INIT;
        this.inputWait = false;
        this.rankingState = gravis.SceneGame.RS_PLAYER_INIT;
        this.versus = gravis.SceneGame.VERSUS_COMPUTER;

        //ゲームで使うパラメータ
        this.card_dai = new Array(2);
        this.card_ba_1 = new Array(4);
        this.card_ba_2 = new Array(4);

        //山札
        this.card_yama_1 = new Array(26);
        this.card_yama_2 = new Array(26);
        this.num_yama_1 = 0;
        this.num_yama_2 = 0;

        this.card_position = new Array(10);
        this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0] = { x: this.window_width/2-25-gravis.CARD_W, y: (this.window_height-gravis.CARD_H)/2 };
        this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1] = { x: this.window_width/2+29, y: (this.window_height-gravis.CARD_H)/2 };
        this.card_position[gravis.SceneGame.CARD_POSITION_P1_0] = { x: 16, y: this.window_height-13-gravis.CARD_H };
        this.card_position[gravis.SceneGame.CARD_POSITION_P1_1] = { x: 89, y: this.window_height-13-gravis.CARD_H };
        this.card_position[gravis.SceneGame.CARD_POSITION_P1_2] = { x: 163, y: this.window_height-13-gravis.CARD_H };
        this.card_position[gravis.SceneGame.CARD_POSITION_P1_3] = { x: 237, y: this.window_height-13-gravis.CARD_H };
        this.card_position[gravis.SceneGame.CARD_POSITION_P2_0] = { x: 16, y: 13 };
        this.card_position[gravis.SceneGame.CARD_POSITION_P2_1] = { x: 89, y: 13 };
        this.card_position[gravis.SceneGame.CARD_POSITION_P2_2] = { x: 163, y: 13 };
        this.card_position[gravis.SceneGame.CARD_POSITION_P2_3] = { x: 237, y: 13 };

        //勝利数
        this.winner = gravis.SceneGame.WINNER_P1;
        this.win_num_1 = 0;
        this.win_num_2 = 0;
        this.draw_num = 0;

        //最後に置いた方の台札
        this.lastTarget_1 = 0;
        this.lastTarget_2 = 0;

        //CPU
        this.gameCpu = null;//new gravis.GameCpu();
        this.cpuLevel = 0;

        //リザルトウィンドウ
        this.resultWindow = null;

        //画面演出
        this.gameEffect = new gravis.GameEffect(this.window_width, this.window_height);

        //汎用フレーム
        this.workFrame = 0;

        //オブジェクト生成
        this.card_dai[0] = new gravis.Daihuda( gravis.CARD_EMPTY, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0].x, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0].y );
        this.card_dai[1] = new gravis.Daihuda( gravis.CARD_EMPTY, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1].x, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1].y );
        this.card_ba_1[0] = new gravis.Bahuda( gravis.CARD_EMPTY, this.card_position[gravis.SceneGame.CARD_POSITION_P1_0].x, this.card_position[gravis.SceneGame.CARD_POSITION_P1_0].y );
        this.card_ba_1[1] = new gravis.Bahuda( gravis.CARD_EMPTY, this.card_position[gravis.SceneGame.CARD_POSITION_P1_1].x, this.card_position[gravis.SceneGame.CARD_POSITION_P1_1].y );
        this.card_ba_1[2] = new gravis.Bahuda( gravis.CARD_EMPTY, this.card_position[gravis.SceneGame.CARD_POSITION_P1_2].x, this.card_position[gravis.SceneGame.CARD_POSITION_P1_2].y );
        this.card_ba_1[3] = new gravis.Bahuda( gravis.CARD_EMPTY, this.card_position[gravis.SceneGame.CARD_POSITION_P1_3].x, this.card_position[gravis.SceneGame.CARD_POSITION_P1_3].y );
        this.card_ba_2[0] = new gravis.Bahuda( gravis.CARD_EMPTY, this.card_position[gravis.SceneGame.CARD_POSITION_P2_0].x, this.card_position[gravis.SceneGame.CARD_POSITION_P2_0].y );
        this.card_ba_2[1] = new gravis.Bahuda( gravis.CARD_EMPTY, this.card_position[gravis.SceneGame.CARD_POSITION_P2_1].x, this.card_position[gravis.SceneGame.CARD_POSITION_P2_1].y );
        this.card_ba_2[2] = new gravis.Bahuda( gravis.CARD_EMPTY, this.card_position[gravis.SceneGame.CARD_POSITION_P2_2].x, this.card_position[gravis.SceneGame.CARD_POSITION_P2_2].y );
        this.card_ba_2[3] = new gravis.Bahuda( gravis.CARD_EMPTY, this.card_position[gravis.SceneGame.CARD_POSITION_P2_3].x, this.card_position[gravis.SceneGame.CARD_POSITION_P2_3].y );

        //背景
        this.back = new enchant.Sprite(gravis.WINDOW_WIDTH,gravis.WINDOW_HEIGHT);
        this.back.image = gravis.Utility.getImage('back_green.png');
        this.addChild(this.back);
        //プレイヤー名
        this.nameLayer = [new enchant.Group(), new enchant.Group()];
        //if( this.versus == gravis.SceneGame.VERSUS_COMPUTER ) {
        {
            //var sprite1 = new enchant.Sprite(130, 59);
            var sprite1 = new enchant.Sprite(87, 39);
            //sprite1.moveTo(24, this.window_height-20-gravis.CARD_H-59-8);
            sprite1.moveTo(16, this.window_height-13-gravis.CARD_H-39-5);
            sprite1.image = gravis.Utility.getImage('word_01.png');
            sprite1.frame = 0;
            this.nameLayer[gravis.SceneGame.VERSUS_COMPUTER].addChild(sprite1);
            //var sprite2 = new enchant.Sprite(163, 59);
            var sprite2 = new enchant.Sprite(109, 39);
            //sprite2.moveTo(this.window_width-(24+163), 20+gravis.CARD_H+8);
            sprite2.moveTo(this.window_width-(16+109), 13+gravis.CARD_H+5);
            sprite2.image = gravis.Utility.getImage('word_01.png');
            sprite2.frame = 2;
            this.nameLayer[gravis.SceneGame.VERSUS_COMPUTER].addChild(sprite2);
        }// else if( this.versus == gravis.SceneGame.VERSUS_PLAYER ) {
        {
            //var sprite1 = new enchant.Sprite(163, 59);
            var sprite1 = new enchant.Sprite(109, 39);
            //sprite1.moveTo(24, this.window_height-20-gravis.CARD_H-59-8);
            sprite1.moveTo(16, this.window_height-13-gravis.CARD_H-39-5);
            sprite1.image = gravis.Utility.getImage('word_01.png');
            sprite1.frame = 0;
            this.nameLayer[gravis.SceneGame.VERSUS_PLAYER].addChild(sprite1);
            var group = new enchant.Group();
            group.originX = this.window_width / 2;
            group.originY = this.window_height / 2;
            group.rotation = 180;
            this.nameLayer[gravis.SceneGame.VERSUS_PLAYER].addChild(group);
            //var sprite2 = new enchant.Sprite(163, 59);
            var sprite2 = new enchant.Sprite(109, 39);
            //sprite2.moveTo(24, this.window_height-20-gravis.CARD_H-59-8);
            sprite2.moveTo(16, this.window_height-13-gravis.CARD_H-39-5);
            sprite2.image = gravis.Utility.getImage('word_01.png');
            sprite2.frame = 1;
            group.addChild(sprite2);
        }
        //対戦結果
        this.resultLayer = [new enchant.Group(), new enchant.Group()];
        //if( this.versus == gravis.SceneGame.VERSUS_COMPUTER ) {
        {
            //var sprite1 = new enchant.Sprite(138, 79);
            var sprite1 = new enchant.Sprite(92, 53);
            //sprite1.moveTo(310, this.window_height-20-gravis.CARD_H-10-79);
            sprite1.moveTo(207, this.window_height-13-gravis.CARD_H-6-53);
            sprite1.image = gravis.Utility.getImage('result_02.png');
            this.resultLayer[gravis.SceneGame.VERSUS_COMPUTER].addChild(sprite1);
            var group = new enchant.Group();
            group.originX = this.window_width / 2;
            group.originY = this.window_height / 2;
            group.rotation = 180;
            this.resultLayer[gravis.SceneGame.VERSUS_COMPUTER].addChild(group);
            //var sprite2 = new enchant.Sprite(275, 52);
            var sprite2 = new enchant.Sprite(183, 34);
            //sprite2.moveTo(205, this.window_height-20-gravis.CARD_H-10-52);
            sprite2.moveTo(137, this.window_height-13-gravis.CARD_H-6-34);
            sprite2.image = gravis.Utility.getImage('result.png');
            group.addChild(sprite2);
        }// else if( this.versus == gravis.SceneGame.VERSUS_PLAYER ) {
        {
            //var sprite1 = new enchant.Sprite(275, 79);
            var sprite1 = new enchant.Sprite(183, 53);
            //sprite1.moveTo(205, this.window_height-20-gravis.CARD_H-10-79, 275, 79, 0, 0);
            sprite1.moveTo(137, this.window_height-13-gravis.CARD_H-6-53);
            sprite1.image = gravis.Utility.getImage('result.png');
            this.resultLayer[gravis.SceneGame.VERSUS_PLAYER].addChild(sprite1);
            var group = new enchant.Group();
            group.originX = this.window_width / 2;
            group.originY = this.window_height / 2;
            group.rotation = 180;
            this.resultLayer[gravis.SceneGame.VERSUS_PLAYER].addChild(group);
            //var sprite2 = new enchant.Sprite(275, 79);
            var sprite2 = new enchant.Sprite(183, 53);
            //sprite2.moveTo(205, this.window_height-20-gravis.CARD_H-10-79, 275, 79, 0, 0);
            sprite2.moveTo(137, this.window_height-13-gravis.CARD_H-6-53);
            sprite2.image = gravis.Utility.getImage('result.png');
            group.addChild(sprite2);
        }

        //
        this.makeResultObject();

        //
        this.pushBackButton = false;
        var myObj = this;
        this.backObj = new enchant.Sprite(27,25);
        this.backObj.moveTo(274,this.window_height/2-12);
        this.backObj.addEventListener('touchstart', function(){
            this.frame = 1;
        });
        this.backObj.addEventListener('touchend', function(e){
            this.frame = 0;
            if( gravis.Utility.isTap(this, e) ) {
                myObj.pushBackButton = true;
            }
        });
        this.backObj.image = gravis.Utility.getImage('x.png');
        this.addChild(this.backObj);

        //
        this.addChild(this.card_dai[0]);
        this.addChild(this.card_dai[1]);
        for( var i=0; i<4; i++ ) {
            this.addChild(this.card_ba_1[i]);
            this.addChild(this.card_ba_2[i]);
        }

        //
        this.addChild(this.gameEffect);
    },

    start: function() {
        this.num_yama_1 = 26;
        this.num_yama_2 = 26;
        for( var i=0; i<26; i++ ) {
            this.card_yama_1[i] = i;
            this.card_yama_2[i] = i+26;
        }
        this.shuffle(this.card_yama_1);
        this.shuffle(this.card_yama_2);

        // カード配置
        for( var i=0; i<4; i++ )
        {
            this.card_ba_1[i].num = this.card_yama_1[this.num_yama_1-1];
            this.card_ba_1[i].set(this.card_position[gravis.SceneGame.CARD_POSITION_P1_0+i].x+this.window_width, this.card_position[gravis.SceneGame.CARD_POSITION_P1_0+i].y);
            this.num_yama_1--;

            this.card_ba_2[i].enablePush = (this.versus == gravis.SceneGame.VERSUS_PLAYER);
            this.card_ba_2[i].num = this.card_yama_2[this.num_yama_2-1];
            this.card_ba_2[i].set(this.card_position[gravis.SceneGame.CARD_POSITION_P2_0+i].x+this.window_width, this.card_position[gravis.SceneGame.CARD_POSITION_P2_0+i].y);
            this.num_yama_2--;
        }
        this.card_dai[0].num = gravis.CARD_EMPTY;
        this.card_dai[1].num = gravis.CARD_EMPTY;
        this.lastTarget_1 = gravis.SceneGame.CARD_POSITION_DAI_1;
        this.lastTarget_2 = gravis.SceneGame.CARD_POSITION_DAI_0;

        //Cpu初期化
        if( this.versus == gravis.SceneGame.VERSUS_COMPUTER ) {
            this.gameCpu = new gravis.GameCpu(this.cpuLevel, this.card_dai, this.card_ba_2, null);
        } else {
            this.gameCpu = null;
        }

        //
        this.gameEffect.setEffect( gravis.GameEffect.TYPE_NONE, this.versus, this.winner );
        this.resultWindow = null;

        this.gameState = gravis.SceneGame.GS_READY;
        this.inputWait = false;

        //
        this.insertBefore(this.nameLayer[this.versus], this.resultGroup[0]);
        this.insertBefore(this.resultLayer[this.versus], this.resultGroup[0]);
        for( var i=0; i<2; i++ ) {
            for( var j=0; j<8; j++ ) {
                this.resultSprite[i][j].visible = false;
            }
        }
    },

    end: function() {
        this.removeChild(this.nameLayer[this.versus]);
        this.removeChild(this.resultLayer[this.versus]);
        if(this.resultWindow != null) {
            this.removeChild(this.resultWindow);
            this.resultWindow = null;
        }
    },

    proc: function() {
        if( this.inputWait ) return;

        if( this.gameState == gravis.SceneGame.GS_READY )
        {
            for( var i=0; i<4; i++ ) {
                this.card_ba_1[i].proc();
                this.card_ba_2[i].proc();
            }
            //ゲーム準備
            if( this.card_ba_1[0].state == gravis.Bahuda.STATE_WAIT )
            {
                this.gameEffect.setEffect(gravis.GameEffect.TYPE_READY, this.versus, this.winner);
                this.workFrame = 0;
                this.gameState = gravis.SceneGame.GS_EFFECT_READY;
            }
        }
        else if( this.gameState == gravis.SceneGame.GS_EFFECT_READY )
        {
            this.workFrame++;
            if( this.workFrame == 1 || this.workFrame == 30 ) {
                gravis.Utility.playSE('se_01.ogg');
            }
            //READY演出
            if( this.gameEffect.proc() ) {
                if( this.num_yama_2 > 0 )
                {
                    this.card_dai[0].reload(
                        this.card_yama_2[this.num_yama_2-1],
                        this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0].x-268,
                        this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0].y
                    );
                    this.num_yama_2--;
                }
                else
                {
                    this.card_dai[0].reload(
                        gravis.CARD_WILD,
                        this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0].x-268,
                        this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0].y
                    );
                }

                if( this.num_yama_1 > 0 )
                {
                    this.card_dai[1].reload(
                        this.card_yama_1[this.num_yama_1-1],
                        this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1].x+268,
                        this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1].y
                    );
                    this.num_yama_1--;
                }
                else
                {
                    this.card_dai[1].reload(
                        gravis.CARD_WILD,
                        this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1].x+268,
                        this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1].y
                    );
                }

                this.gameEffect.setEffect(gravis.GameEffect.TYPE_GO, this.versus, this.winner);
                gravis.Utility.playSE('se_02.ogg');
                this.gameState = gravis.SceneGame.GS_EFFECT_GO;
            }
        }
        else if( this.gameState == gravis.SceneGame.GS_EFFECT_GO )
        {
            this.card_dai[0].proc();
            this.card_dai[1].proc();
            //GO演出
            if( this.gameEffect.proc() ) {
                this.gameEffect.setEffect(gravis.GameEffect.TYPE_NONE, this.versus, this.winner);
                this.gameState = gravis.SceneGame.GS_MAIN;
            }
        }
        else if( this.gameState == gravis.SceneGame.GS_MAIN )
        {
            //ゲームメインプレイ部分

            //CPU思考
            if( this.gameCpu != null ) this.gameCpu.proc();

            //場札タッチによる挙動
            var p1_through = false;
            var p2_through = false;

            for( var i=0; i<4; i++ ) {
                if( this.card_ba_1[i].state == gravis.Bahuda.STATE_BACK ) p1_through = true;
                if( this.card_ba_2[i].state == gravis.Bahuda.STATE_BACK ) p2_through = true;
            }

            for( var i=0; i<4; i++ ) {
                // 手前プレイヤー
                if( p1_through == false )
                {
                    if( this.card_ba_1[i].isDown() )
                    {
                        if( this.card_ba_1[i].state == gravis.Bahuda.STATE_WAIT ) // 台札へ
                        {
                            gravis.Utility.playSE('se_00.ogg');
                            if( gravis.SceneGame.isEnableSettingCard(this.card_dai[1].num, this.card_ba_1[i].num) )
                            {
                                this.card_ba_1[i].go(1, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1].x, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1].y);
                                this.lastTarget_1 = gravis.SceneGame.CARD_POSITION_DAI_1;
                            }
                            else if( gravis.SceneGame.isEnableSettingCard(this.card_dai[0].num, this.card_ba_1[i].num) )
                            {
                                this.card_ba_1[i].go(0, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0].x, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0].y);
                                this.lastTarget_1 = gravis.SceneGame.CARD_POSITION_DAI_0;
                            }
                            else
                            {
                                //どこにも置けないが飛ばしはする
                                this.card_ba_1[i].go(this.lastTarget_1, this.card_position[this.lastTarget_1].x, this.card_position[this.lastTarget_1].y);
                            }
                            p1_through = true;
                        }
                    }
                }

                // 奥プレイヤー
                if( p2_through == false )
                {
                    if( this.card_ba_2[i].isDown() )
                    {
                        if( this.card_ba_2[i].state == gravis.Bahuda.STATE_WAIT ) // 台札へ
                        {
                            gravis.Utility.playSE('se_00.ogg');
                            if( gravis.SceneGame.isEnableSettingCard(this.card_dai[0].num, this.card_ba_2[i].num) )
                            {
                                this.card_ba_2[i].go(0, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0].x, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_0].y);
                                this.lastTarget_2 = gravis.SceneGame.CARD_POSITION_DAI_0;
                            }
                            else if( gravis.SceneGame.isEnableSettingCard(this.card_dai[1].num, this.card_ba_2[i].num) )
                            {
                                this.card_ba_2[i].go(1, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1].x, this.card_position[gravis.SceneGame.CARD_POSITION_DAI_1].y);
                                this.lastTarget_2 = gravis.SceneGame.CARD_POSITION_DAI_1;
                            }
                            else
                            {
                                //どこにも置けないが飛ばしはする
                                this.card_ba_2[i].go(this.lastTarget_2, this.card_position[this.lastTarget_2].x, this.card_position[this.lastTarget_2].y);
                            }
                            p2_through = true;
                        }
                    }
                }
            }

            //場札の挙動
            for( var i=0; i<4; i++ )
            {
                this.card_ba_1[i].proc();
                if( this.card_ba_1[i].state == gravis.Bahuda.STATE_CHECK )
                {
                    if(gravis.SceneGame.isEnableSettingCard(this.card_dai[this.card_ba_1[i].target].num, this.card_ba_1[i].num))
                    {
                        gravis.Utility.playSE('se_08.ogg');
                        this.card_dai[this.card_ba_1[i].target].num = this.card_ba_1[i].num;
                        if( this.num_yama_1 > 0 )
                        {
                            this.card_ba_1[i].num = this.card_yama_1[this.num_yama_1-1];
                            this.num_yama_1--;
                            this.card_ba_1[i].set(this.card_position[gravis.SceneGame.CARD_POSITION_P1_0+i].x+this.window_width, this.card_position[gravis.SceneGame.CARD_POSITION_P1_0+i].y);
                        }
                        else
                        {
                            this.card_ba_1[i].reset();
                            this.card_ba_1[i].num = gravis.CARD_EMPTY;
                        }
                    }
                    else
                    {
                        this.card_ba_1[i].back();
                    }
                }

                this.card_ba_2[i].proc();
                if( this.card_ba_2[i].state == gravis.Bahuda.STATE_CHECK )
                {
                    if(gravis.SceneGame.isEnableSettingCard(this.card_dai[this.card_ba_2[i].target].num, this.card_ba_2[i].num))
                    {
                        gravis.Utility.playSE('se_08.ogg');
                        this.card_dai[this.card_ba_2[i].target].num = this.card_ba_2[i].num;
                        if( this.num_yama_2 > 0 )
                        {
                            this.card_ba_2[i].num = this.card_yama_2[this.num_yama_2-1];
                            this.num_yama_2--;
                            this.card_ba_2[i].set(this.card_position[gravis.SceneGame.CARD_POSITION_P2_0+i].x+this.window_width, this.card_position[gravis.SceneGame.CARD_POSITION_P2_0+i].y);
                        }
                        else
                        {
                            this.card_ba_2[i].reset();
                            this.card_ba_2[i].num = gravis.CARD_EMPTY;
                        }
                    }
                    else
                    {
                        this.card_ba_2[i].back();
                    }
                }
            }

            // 終了チェック
            var p1_end = false;
            var p2_end = false;
            if( this.num_yama_1 == 0 &&
                this.card_ba_1[0].num == gravis.CARD_EMPTY &&
                this.card_ba_1[1].num == gravis.CARD_EMPTY &&
                this.card_ba_1[2].num == gravis.CARD_EMPTY &&
                this.card_ba_1[3].num == gravis.CARD_EMPTY )
            {
                p1_end = true;
            }
            else if( this.num_yama_2 == 0 &&
                this.card_ba_2[0].num == gravis.CARD_EMPTY &&
                this.card_ba_2[1].num == gravis.CARD_EMPTY &&
                this.card_ba_2[2].num == gravis.CARD_EMPTY &&
                this.card_ba_2[3].num == gravis.CARD_EMPTY )
            {
                p2_end = true;
            }

            if( p1_end == true && p2_end == false ) {
                this.winner = gravis.SceneGame.WINNER_P1;
                this.win_num_1++;
                if( this.versus == gravis.SceneGame.VERSUS_COMPUTER ) {
                    //通算勝利数をカウント
                    //GameSystem.m_saveData.total_win++;
                    //lastlevel更新
                    //GameSystem.m_saveData.last_level++;
                    //GameSystem.gameSave();
                    gravis.Utility.savedata.cpu = this.cpuLevel + 1;
                    gravis.Utility.save();
                    //omit 100勝ごとにアチーブメントのwall投稿をする
                }
                this.gameEffect.setEffect(gravis.GameEffect.TYPE_WINLOSE, this.versus, this.winner);
                this.gameState = gravis.SceneGame.GS_EFFECT_WINLOSE;
                //広告表示
                //Main.instance.setAdPosition(Gravity.TOP);
                //Main.instance.startAd();
            } else if( p1_end == false && p2_end == true ) {
                this.winner = gravis.SceneGame.WINNER_P2;
                this.win_num_2++;
                this.gameEffect.setEffect(gravis.GameEffect.TYPE_WINLOSE, this.versus, this.winner);
                this.gameState = gravis.SceneGame.GS_EFFECT_WINLOSE;
                //広告表示
                //Main.instance.setAdPosition(Gravity.TOP);
                //Main.instance.startAd();
            } else if( p1_end == true && p2_end == true ) {
                this.winner = gravis.SceneGame.WINNER_DRAW;
                this.draw_num++;
                this.gameEffect.setEffect(gravis.GameEffect.TYPE_DRAW, this.versus, this.winner);
                this.gameState = gravis.SceneGame.GS_EFFECT_WINLOSE;
                //広告表示
                //Main.instance.setAdPosition(Gravity.TOP);
                //Main.instance.startAd();
            }
            else
            {
                // 場札全部見えつつ置けるものが無い
                var dai_reload = false;
                for( var i=0; i<4; i++ )
                {
                    if( this.card_ba_1[i].state != gravis.Bahuda.STATE_WAIT ) break;
                    if( this.card_ba_2[i].state != gravis.Bahuda.STATE_WAIT ) break;
                    if( gravis.SceneGame.isEnableSettingCard(this.card_dai[0].num, this.card_ba_1[i].num) ) break;
                    if( gravis.SceneGame.isEnableSettingCard(this.card_dai[1].num, this.card_ba_1[i].num) ) break;
                    if( gravis.SceneGame.isEnableSettingCard(this.card_dai[0].num, this.card_ba_2[i].num) ) break;
                    if( gravis.SceneGame.isEnableSettingCard(this.card_dai[1].num, this.card_ba_2[i].num) ) break;

                    if( i == 3 ) dai_reload = true;
                }
                if( dai_reload )
                {
                    // 台札更新へ
                    this.gameEffect.setEffect(gravis.GameEffect.TYPE_BREAK, this.card_dai[0].num, this.card_dai[1].num );
                    this.card_dai[0].num = gravis.CARD_EMPTY;
                    this.card_dai[1].num = gravis.CARD_EMPTY;
                    gravis.Utility.playSE('se_07.ogg');
                    this.gameState = gravis.SceneGame.GS_EFFECT_BREAK;
                }
            }
        }
        else if( this.gameState == gravis.SceneGame.GS_EFFECT_BREAK )
        {
            if( this.gameEffect.proc() ) {
                // 台札更新へ
                this.gameEffect.setEffect(gravis.GameEffect.TYPE_READY, this.versus, this.winner);
                this.workFrame = 0;
                this.gameState = gravis.SceneGame.GS_EFFECT_READY;
            }
        }
        else if( this.gameState == gravis.SceneGame.GS_EFFECT_WINLOSE )
        {
            //WINLOSE演出
            if( this.gameEffect.proc() ) {
                this.gameEffect.setEffect(gravis.GameEffect.TYPE_RESULT, this.versus, this.winner);

                //対戦orCPU戦勝利の場合はNEXT/QUIT表示
                if( this.versus == gravis.SceneGame.VERSUS_PLAYER || this.winner == gravis.SceneGame.WINNER_P1 ) {
                    this.resultWindow = new gravis.ResultWindow(this.window_width, this.window_height, true);
                    this.addChild(this.resultWindow);
                } else {
                    this.resultWindow = new gravis.ResultWindow(this.window_width, this.window_height, false);
                    this.addChild(this.resultWindow);
                }

                this.gameState = gravis.SceneGame.GS_RESULT;
                if( this.winner == gravis.SceneGame.WINNER_P1 ) {
                    gravis.Utility.playSE('se_04.ogg');
                } else if( this.winner == gravis.SceneGame.WINNER_P2 ) {
                    if( this.versus == gravis.SceneGame.VERSUS_PLAYER ) {
                        gravis.Utility.playSE('se_04.ogg');
                    } else if( this.versus == gravis.SceneGame.VERSUS_COMPUTER ) {
                        gravis.Utility.playSE('se_05.ogg');
                    }
                } else if( this.winner == gravis.SceneGame.WINNER_DRAW ) {
                    gravis.Utility.playSE('se_06.ogg');
                }
            }
        }
        else if( this.gameState == gravis.SceneGame.GS_RESULT )
        {
            //リザルト画面
            this.gameEffect.proc();
            if( this.resultWindow == null ) {
                return;
            }
            var ret = this.resultWindow.proc();

            //広告終了
            if( ret != 0 ) {
                //Main.instance.endAd();
            }

            if( ret == 1 ) {
                //CPU強くなる
                if( this.versus == gravis.SceneGame.VERSUS_COMPUTER && this.winner == gravis.SceneGame.WINNER_P1 ) {
                    this.cpuLevel++;
                }

                //対戦orCPU戦勝利引分時は次のゲームへ
                if( this.versus == gravis.SceneGame.VERSUS_PLAYER || this.winner == gravis.SceneGame.WINNER_P1 || this.winner == gravis.SceneGame.WINNER_DRAW ) {
                    //this.resultWindow.delete();
                    this.removeChild(this.resultWindow);
                    this.resultWindow = null;

                    gameManager.changeScene( gravis.GameManager.APPSTATE_GAME );
                } else {
                    //タイトルに戻る確認
                    this.dialogBackToTitle();
                    /*
                    //ハイスコアチェック
                    if(this.hiscoreCheck(this.win_num_1)) {
                        //登録へ
                        //gameConnection.start(win_num_1, GameConnection.CONNECT_TYPE_PW);
                        this.gameState = gravis.SceneGame.GS_REGIST;
                    } else {
                        //タイトルに戻る確認
                        this.dialogBackToTitle();
                    }
                    */
                }
            } else if( ret == 2 ) {
                //タイトルに戻る確認
                this.dialogBackToTitle();
                /*
                //ハイスコアチェック
                if(this.versus == gravis.SceneGame.VERSUS_COMPUTER && this.hiscoreCheck(this.win_num_1)) {
                    //登録へ
                    //gameConnection.start(win_num_1, GameConnection.CONNECT_TYPE_PW);
                    this.gameState = gravis.SceneGame.GS_REGIST;
                } else {
                    //タイトルに戻る確認
                    this.dialogBackToTitle();
                }
                */
            }
        }
        else if( this.gameState == gravis.SceneGame.GS_REGIST )
        {
            //if( gameConnection.proc() == GameConnection.RET_END ) {
            //    if( gameConnection.next == GameConnection.NEXT_RANKING ) {
            //        rankingState = RS_PLAYER_INIT;
            //        changeState( APPSTATE_RANKING );
            //    } else if( gameConnection.next == GameConnection.NEXT_TITLE ) {
            //        changeState( APPSTATE_TITLE );
            //    }
            //}
            //dialogRegist(win_num_1);
            gameManager.changeScene( gravis.GameManager.APPSTATE_TITLE );
        }

        //BACKボタンでのシステムダイアログ表示
        if( this.pushBackButton ) {
            this.pushBackButton = false;
            this.dialogBackToTitle();
        }
    },

    draw: function() {
        //対戦結果
        if( this.versus == gravis.SceneGame.VERSUS_COMPUTER ) {
            this.drawResult2( 0, this.win_num_1, this.num_yama_1 );
            this.drawResult1( 1, this.num_yama_2 );
        } else if( this.versus == gravis.SceneGame.VERSUS_PLAYER ) {
            this.drawResult4( 0, this.win_num_1, this.win_num_2, this.draw_num, this.num_yama_1 );
            this.drawResult4( 1, this.win_num_2, this.win_num_1, this.draw_num, this.num_yama_2 );
        }

        //カード
        if( this.card_dai[0] != null ) this.card_dai[0].draw();
        if( this.card_dai[1] != null ) this.card_dai[1].draw();
        for( var i=0; i<4; i++ )
        {
            if( this.card_ba_1[i] != null ) this.card_ba_1[i].draw();
            if( this.card_ba_2[i] != null ) this.card_ba_2[i].draw();
        }

        //画面効果
        if( this.gameEffect != null ) this.gameEffect.draw();

        //リザルトウィンドウ
        if( this.gameState == gravis.SceneGame.GS_RESULT )
        {
            if( this.resultWindow != null ) this.resultWindow.draw();
        }
    },

    makeResultObject: function() {
        var make = function(parent,img,w,h) {
            var s = new enchant.Sprite(w, h);
            s.image = img;
            s.visible = false;
            parent.addChild(s);
            return s;
        };
        var img1 = gravis.Utility.getImage('number01.png');
        var img2 = gravis.Utility.getImage('number02.png');
        this.resultSprite = new Array(2);
        this.resultSprite[0] = new Array(8);
        this.resultSprite[0][0] = make(this, img1, 11, 14);
        this.resultSprite[0][1] = make(this, img1, 11, 14);
        this.resultSprite[0][2] = make(this, img1, 11, 14);
        this.resultSprite[0][3] = make(this, img1, 11, 14);
        this.resultSprite[0][4] = make(this, img1, 11, 14);
        this.resultSprite[0][5] = make(this, img1, 11, 14);
        this.resultSprite[0][6] = make(this, img2, 10, 16);
        this.resultSprite[0][7] = make(this, img2, 10, 16);
        this.resultSprite[1] = new Array(8);
        this.resultSprite[1][0] = make(this, img1, 11, 14);
        this.resultSprite[1][1] = make(this, img1, 11, 14);
        this.resultSprite[1][2] = make(this, img1, 11, 14);
        this.resultSprite[1][3] = make(this, img1, 11, 14);
        this.resultSprite[1][4] = make(this, img1, 11, 14);
        this.resultSprite[1][5] = make(this, img1, 11, 14);
        this.resultSprite[1][6] = make(this, img2, 10, 16);
        this.resultSprite[1][7] = make(this, img2, 10, 16);

        this.resultGroup = new Array(2);
        this.resultGroup[0] = new enchant.Group();
        this.resultGroup[1] = new enchant.Group();
        this.resultGroup[1].originX = this.window_width / 2;
        this.resultGroup[1].originY = this.window_height / 2;
        this.resultGroup[1].rotation = 180;
        this.addChild(this.resultGroup[0]);
        this.addChild(this.resultGroup[1]);
        for( var i=0; i<2; i++ ) {
            for( var j=0; j<8; j++ ) {
                this.resultGroup[i].addChild(this.resultSprite[i][j]);
            }
        }
    },

    drawResult4: function(id, win, lose, draw, card) {
        this.resultSprite[id][0].visible = true;
        this.resultSprite[id][1].visible = true;
        this.resultSprite[id][2].visible = true;
        this.resultSprite[id][3].visible = true;
        this.resultSprite[id][4].visible = true;
        this.resultSprite[id][5].visible = true;
        this.resultSprite[id][6].visible = true;
        this.resultSprite[id][7].visible = true;
        //this.resultSprite[id][0].moveTo(205+40, this.window_height-20-gravis.CARD_H-10-79+56);
        //this.resultSprite[id][1].moveTo(205+56, this.window_height-20-gravis.CARD_H-10-79+56);
        //this.resultSprite[id][2].moveTo(205+122, this.window_height-20-gravis.CARD_H-10-79+56);
        //this.resultSprite[id][3].moveTo(205+138, this.window_height-20-gravis.CARD_H-10-79+56);
        //this.resultSprite[id][4].moveTo(205+214, this.window_height-20-gravis.CARD_H-10-79+56);
        //this.resultSprite[id][5].moveTo(205+230, this.window_height-20-gravis.CARD_H-10-79+56);
        //this.resultSprite[id][6].moveTo(205+205, this.window_height-20-gravis.CARD_H-10-79+12);
        //this.resultSprite[id][7].moveTo(205+219, this.window_height-20-gravis.CARD_H-10-79+12);
        this.resultSprite[id][0].moveTo(137+26, this.window_height-14-gravis.CARD_H-6-52+37);
        this.resultSprite[id][1].moveTo(137+37, this.window_height-14-gravis.CARD_H-6-52+37);
        this.resultSprite[id][2].moveTo(137+81, this.window_height-14-gravis.CARD_H-6-52+37);
        this.resultSprite[id][3].moveTo(137+92, this.window_height-14-gravis.CARD_H-6-52+37);
        this.resultSprite[id][4].moveTo(137+143, this.window_height-14-gravis.CARD_H-6-52+37);
        this.resultSprite[id][5].moveTo(137+154, this.window_height-14-gravis.CARD_H-6-52+37);
        this.resultSprite[id][6].moveTo(137+136, this.window_height-14-gravis.CARD_H-6-52+8);
        this.resultSprite[id][7].moveTo(137+145, this.window_height-14-gravis.CARD_H-6-52+8);
        this.resultSprite[id][0].frame = Math.floor(win/10)%10;
        this.resultSprite[id][1].frame = win%10;
        this.resultSprite[id][2].frame = Math.floor(lose/10)%10;
        this.resultSprite[id][3].frame = lose%10;
        this.resultSprite[id][4].frame = Math.floor(draw/10)%10;
        this.resultSprite[id][5].frame = draw%10;
        this.resultSprite[id][6].frame = Math.floor(card/10)%10;
        this.resultSprite[id][7].frame = card%10;
    },

    drawResult2: function(id, win, card) {
        //win,lose,draw数
        if( win < 100 ) {
            this.resultSprite[id][0].visible = true;
            this.resultSprite[id][1].visible = true;
            //this.resultSprite[id][0].moveTo(205+172, this.window_height-20-gravis.CARD_H-10-79+56);
            //this.resultSprite[id][1].moveTo(205+188, this.window_height-20-gravis.CARD_H-10-79+56);
            this.resultSprite[id][0].moveTo(137+115, this.window_height-14-gravis.CARD_H-6-52+37);
            this.resultSprite[id][1].moveTo(137+125, this.window_height-14-gravis.CARD_H-6-52+37);
            this.resultSprite[id][0].frame = Math.floor(win/10)%10;
            this.resultSprite[id][1].frame = win%10;
        } else {
            this.resultSprite[id][0].visible = true;
            this.resultSprite[id][1].visible = true;
            this.resultSprite[id][2].visible = true;
            //this.resultSprite[id][0].moveTo(205+172, this.window_height-20-gravis.CARD_H-10-79+56);
            //this.resultSprite[id][1].moveTo(205+188, this.window_height-20-gravis.CARD_H-10-79+56);
            //this.resultSprite[id][2].moveTo(205+204, this.window_height-20-gravis.CARD_H-10-79+56);
            this.resultSprite[id][0].moveTo(137+115, this.window_height-14-gravis.CARD_H-6-52+37);
            this.resultSprite[id][1].moveTo(137+125, this.window_height-14-gravis.CARD_H-6-52+37);
            this.resultSprite[id][2].moveTo(137+135, this.window_height-14-gravis.CARD_H-6-52+37);
            this.resultSprite[id][0].frame = Math.floor(win/100)%10;
            this.resultSprite[id][1].frame = Math.floor(win/10)%10;
            this.resultSprite[id][2].frame = win%10;
        }
        //card数
        this.resultSprite[id][6].visible = true;
        this.resultSprite[id][7].visible = true;
        //this.resultSprite[id][6].moveTo(205+204, this.window_height-20-gravis.CARD_H-10-79+12);
        //this.resultSprite[id][7].moveTo(205+218, this.window_height-20-gravis.CARD_H-10-79+12);
        this.resultSprite[id][6].moveTo(137+136, this.window_height-14-gravis.CARD_H-6-52+8);
        this.resultSprite[id][7].moveTo(137+145, this.window_height-14-gravis.CARD_H-6-52+8);
        this.resultSprite[id][6].frame = Math.floor(card/10)%10;
        this.resultSprite[id][7].frame = card%10;
    },

    drawResult1: function(id, card) {
        //card数
        this.resultSprite[id][6].visible = true;
        this.resultSprite[id][7].visible = true;
        //this.resultSprite[id][6].moveTo(205+205, this.window_height-20-gravis.CARD_H-10-52+12);
        //this.resultSprite[id][7].moveTo(205+219, this.window_height-20-gravis.CARD_H-10-52+12);
        this.resultSprite[id][6].moveTo(137+136, this.window_height-14-gravis.CARD_H-6-34+8);
        this.resultSprite[id][7].moveTo(137+145, this.window_height-14-gravis.CARD_H-6-34+8);
        this.resultSprite[id][6].frame = Math.floor(card/10)%10;
        this.resultSprite[id][7].frame = card%10;
    },

    /**
     * トランプのシャッフル
     * @param card
     */
    shuffle: function(card) {
        for( var i=0, a, b, tmp; i<200; i++ ) {
            a = gravis.Utility.nextInt(card.length);
            b = gravis.Utility.nextInt(card.length);

            tmp = card[a];
            card[a] = card[b];
            card[b] = tmp;
        }
    },

    hiscoreCheck: function(win) {
        return true;
    },

    dialogBackToTitle: function() {
        var obj = this;
        this.inputWait = true;
        var confirm = new enchant.widget.ConfirmScene('Back To Title?', 'YES', 'NO');
        confirm.callback = function(accept) {
            if( accept ) {
                gameManager.changeScene(gravis.GameManager.APPSTATE_TITLE);
            } else {
                obj.inputWait = false;
            }
        };
        game.pushScene(confirm);
    }
});

//プレイ中の遷移
gravis.SceneGame.GS_INIT = 0;
gravis.SceneGame.GS_READY = 1;
gravis.SceneGame.GS_EFFECT_READY = 2;
gravis.SceneGame.GS_EFFECT_GO = 3;
gravis.SceneGame.GS_MAIN = 4;
gravis.SceneGame.GS_EFFECT_BREAK = 5;
gravis.SceneGame.GS_EFFECT_WINLOSE = 6;
gravis.SceneGame.GS_RESULT = 7;
gravis.SceneGame.GS_REGIST = 8;

//ランキングの繊維
gravis.SceneGame.RS_PLAYER_INIT = 0;
gravis.SceneGame.RS_TOP100_INIT = 1;
gravis.SceneGame.RS_TOP100_CONNECT = 2;
gravis.SceneGame.RS_MAIN = 3;

//対戦状態
gravis.SceneGame.VERSUS_COMPUTER = 0;
gravis.SceneGame.VERSUS_PLAYER = 1;

//トランプ設置位置
gravis.SceneGame.CARD_POSITION_DAI_0 = 0;
gravis.SceneGame.CARD_POSITION_DAI_1 = 1;
gravis.SceneGame.CARD_POSITION_P1_0 = 2;
gravis.SceneGame.CARD_POSITION_P1_1 = 3;
gravis.SceneGame.CARD_POSITION_P1_2 = 4;
gravis.SceneGame.CARD_POSITION_P1_3 = 5;
gravis.SceneGame.CARD_POSITION_P2_0 = 6;
gravis.SceneGame.CARD_POSITION_P2_1 = 7;
gravis.SceneGame.CARD_POSITION_P2_2 = 8;
gravis.SceneGame.CARD_POSITION_P2_3 = 9;

//勝者
gravis.SceneGame.WINNER_P1 = 0;
gravis.SceneGame.WINNER_P2 = 1;
gravis.SceneGame.WINNER_DRAW = 2;

gravis.SceneGame.isEnableSettingCard = function(dai, ba) {
    if( ba == gravis.CARD_EMPTY ) return false;
    if( dai == gravis.CARD_WILD ) return true;

    var ret = false;
    var dai_num = dai % 13;
    var ba_num = ba % 13;

    if( Math.abs(dai_num-ba_num) == 1 ) ret = true;
    if( dai_num == 12 && ba_num == 0 ) ret = true;
    if( dai_num == 0 && ba_num == 12 ) ret = true;

    return ret;
};

