/**
 * Created with JetBrains WebStorm.
 * User: gravis_ihara
 * Date: 14/09/09
 * Time: 18:29
 * To change this template use File | Settings | File Templates.
 */
gravis.GameCpu = enchant.Class.create({
    initialize: function(level, daihuda, bahuda, button) {
        this.daihuda = daihuda;
        this.bahuda = bahuda;
        this.button = button;
        this.state = gravis.GameCpu.STATE_WAIT;
        if( level > 99 ) level = 99;
        this.level = level;
        this.waitTime = gravis.GameCpu.WAIT_TIME[level][0]+gravis.Utility.nextInt(gravis.GameCpu.WAIT_TIME[level][1]+1);
    },

    proc: function() {
        switch(this.state){
            case gravis.GameCpu.STATE_READY:
                //準備状態
                for( var i=0; i<4; i++ )
                {
                    //カードを置ける状態になるとWAITに移行
                    if( gravis.SceneGame.isEnableSettingCard(this.daihuda[0].num, this.bahuda[i].num) ||
                        gravis.SceneGame.isEnableSettingCard(this.daihuda[1].num, this.bahuda[i].num) )
                    {
                        this.waitTime = gravis.GameCpu.WAIT_TIME[this.level][0]+gravis.Utility.nextInt(gravis.GameCpu.WAIT_TIME[this.level][1]+1);
                        this.state = gravis.GameCpu.STATE_WAIT;
                    }
                }
                break;
            case gravis.GameCpu.STATE_WAIT:
                //待ち状態
                for( var i=0; i<4; i++ )
                {
                    //カードを置ける状態で一定時間経つとTOUCHに移行
                    if( gravis.SceneGame.isEnableSettingCard(this.daihuda[0].num, this.bahuda[i].num) ||
                        gravis.SceneGame.isEnableSettingCard(this.daihuda[1].num, this.bahuda[i].num) )
                    {
                        if( --this.waitTime < 0 ) {
                            this.state = gravis.GameCpu.STATE_TOUCH;
                        }
                        break;
                    }
                    else if( i == 3 )
                    {
                        //カードが置けなくなったのでREADYに戻る
                        this.state = gravis.GameCpu.STATE_READY;
                    }
                }
                break;
            case gravis.GameCpu.STATE_TOUCH:
                //ボタン押し状態
                for( var i=0; i<4; i++ )
                {
                    //置けるカードのボタンを押してTOUCHWAITに移行
                    if( gravis.SceneGame.isEnableSettingCard(this.daihuda[0].num, this.bahuda[i].num) ||
                        gravis.SceneGame.isEnableSettingCard(this.daihuda[1].num, this.bahuda[i].num) )
                    {
                        //button[i].down = true;
                        this.bahuda[i].push = true;
                        this.waitTime = gravis.CARDMOVE_GO;
                        this.state = gravis.GameCpu.STATE_TOUCHWAIT;
                        break;
                    }
                    else if( i == 3 )
                    {
                        //カードが置けなくなったのでREADYに戻る
                        this.state = gravis.GameCpu.STATE_READY;
                    }
                }
                break;
            case gravis.GameCpu.STATE_TOUCHWAIT:
                //タッチ後のウェイトを待ってからREADYに移行
                if( --this.waitTime < 0 ) {
                    this.state = gravis.GameCpu.STATE_READY;
                }
                break;
        }
    }
});

gravis.GameCpu.WAIT_TIME = [
    [50,50],[50,40],[40,50],[40,40],[30,50],[30,40],[30,30],[30,20],[30,10],[30, 5],
    [25,50],[25,45],[25,40],[25,35],[25,30],[25,25],[25,20],[25,15],[25,10],[25, 5],
    [20,50],[20,45],[20,40],[20,35],[20,30],[20,25],[20,20],[20,15],[20,10],[20, 5],
    [15,50],[15,45],[15,40],[15,35],[15,30],[15,25],[15,20],[15,15],[15,10],[15, 5],
    [10,50],[10,45],[10,40],[10,35],[10,30],[10,25],[10,20],[10,15],[10,10],[10, 5],
    [ 5, 5],[ 5, 5],[ 5, 4],[ 5, 4],[ 5, 3],[ 5, 3],[ 5, 2],[ 5, 2],[ 5, 1],[ 5, 1],
    [ 4, 5],[ 4, 5],[ 4, 4],[ 4, 4],[ 4, 3],[ 4, 3],[ 4, 2],[ 4, 2],[ 4, 1],[ 4, 1],
    [ 3, 5],[ 3, 5],[ 3, 4],[ 3, 4],[ 3, 3],[ 3, 3],[ 3, 2],[ 3, 2],[ 3, 1],[ 3, 1],
    [ 2, 5],[ 2, 5],[ 2, 4],[ 2, 4],[ 2, 3],[ 2, 3],[ 2, 2],[ 2, 2],[ 2, 1],[ 2, 1],
    [ 1, 5],[ 1, 5],[ 1, 4],[ 1, 4],[ 1, 3],[ 1, 3],[ 1, 2],[ 1, 2],[ 1, 1],[ 1, 1]
];

gravis.GameCpu.STATE_READY = 0;
gravis.GameCpu.STATE_WAIT = 1;
gravis.GameCpu.STATE_TOUCH = 2;
gravis.GameCpu.STATE_TOUCHWAIT =3;

