function Achievement() {

    this.achievements = [];
    this.recentAchievements = [];

    this.checkForAchievement = function () {
        //should pull from game state, unless we have to reload it each time. it might reload before a save
        var statistics = new Statistics();
        var stats = statistics.stats;
        var sessionStats = statistics.sessionStats;

        this.recentAchievements = [];

        for (i in this.allAchievements) {
            if (this.allAchievements[i].Check != undefined && this.allAchievements[i].Check(stats, sessionStats)) {
                this.addAchievement(this.allAchievements[i].Name);
            }
        }
        return this.recentAchievements;
    }
    this.addAchievement = function (achievement) {
        for (i in this.achievements) {
            if (this.achievements[i] === achievement) return;
        }
        this.achievements.push(achievement);//could make this keyvaluse pair and just incremt the number.  
        this.recentAchievements.push(achievement);
        this.save();
    }
    this.getAchievement = function (name) {
        for (key in this.allAchievements) {
            var achievement = this.allAchievements[key];
            if (achievement.Name === name) return achievement;
        }
    }
    this.load = function () {
        //get data
        var data_a = localStorage.getItem('achievements');
        if (data_a !== null) this.achievements = JSON.parse(data_a);
    }
    this.save = function () {
        localStorage.achievements = JSON.stringify(this.achievements);
    }
    this.clear = function () {
        this.achievements = [];
        this.save();
    }
    this.load();

    this.allAchievements = [
      {
          "Name": "Played First Game",
          "Category": "Overall",
          "Title": "Let the Games Begin",
          "Description": "Played First Game",
          "Image": "ace.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "1",
          "Check": function (p, s) { return p["win"] > 0 || p["lose"] > 0 }
      },
      {
          "Name": "5 Easy Wins",
          "Category": "Easy",
          "Title": "Piece of Cake",
          "Description": "Win 5 matches on Easy",
          "Image": "cake-slice.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "2",
          "Check": function (p, s) { return p["win_Easy"] >= 5 }
      },
      {
          "Name": "5 Medium Wins",
          "Category": "Medium",
          "Title": "Made Flight",
          "Description": "Win 5 matches on Medium",
          "Image": "butterfly.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "3",
          "Check": function (p, s) { return p["win_Medium"] >= 5 }
      },
      {
          "Name": "10 Medium Wins",
          "Category": "Medium",
          "Title": "Quick Flyer",
          "Description": "Win 10 matches on Medium",
          "Image": "dragonfly.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "4",
          "Check": function (p, s) { return p["win_Medium"] >= 10 }
      },
      {
          "Name": "20 Medium Wins",
          "Category": "Medium",
          "Title": "Growing Force",
          "Description": "Win 20 matches on Medium",
          "Image": "bee.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "5",
          "Check": function (p, s) { return p["win_Medium"] >= 20 }
      },
      {
          "Name": "50 Medium Wins",
          "Category": "Medium",
          "Title": "Little Fighter",
          "Description": "Win 50 matches on Medium",
          "Image": "wasp-sting.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "6",
          "Check": function (p, s) { return p["win_Medium"] >= 50 }
      },
      {
          "Name": "100 Medium Wins",
          "Category": "Medium",
          "Title": "Little Champion ",
          "Description": "Win 100 matches on Medium",
          "Image": "scarab-beetle.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "7",
          "Check": function (p, s) { return p["win_Medium"] >= 100 }
      },
      //{
      //    "Name": "Played a WIFI Game",
      //    "Category": "Online",
      //    "Title": "Get Connected",
      //    "Description": "Played a WIFI Game",
      //    "Image": "aerial-signal.png",
      //    "Points": "3",
      //    "PushToFacebook": "true",
      //    "Order": "8"
      //},
      {
          "Name": "5 Hard Wins",
          "Category": "Hard",
          "Title": "Got Your Feet Wet",
          "Description": "Win 5 matches on Hard",
          "Image": "ammonite.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "9",
          "Check": function (p, s) { return p["win_Hard"] >= 5 }
      },
      {
          "Name": "10 Hard Wins",
          "Category": "Hard",
          "Title": "Neigh to Losing",
          "Description": "Win 10 matches on Hard",
          "Image": "horse-head.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "10",
          "Check": function (p, s) { return p["win_Hard"] >= 10 }
      },
      {
          "Name": "20 Hard Wins",
          "Category": "Hard",
          "Title": "Hard to Beat",
          "Description": "Win 20 matches on Hard",
          "Image": "turtle.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "11",
          "Check": function (p, s) { return p["win_Hard"] >= 20 }
      },
      {
          "Name": "50 Hard Wins",
          "Category": "Hard",
          "Title": "Fast And Silent",
          "Description": "Win 50 matches on Hard",
          "Image": "frog.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "12",
          "Check": function (p, s) { return p["win_Hard"] >= 50 }
      },
      {
          "Name": "100 Hard Wins",
          "Category": "Hard",
          "Title": "Choice Fish",
          "Description": "Win 100 matches on Hard",
          "Image": "angler-fish.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "13",
          "Check": function (p, s) { return p["win_Hard"] >= 100 }
      },
      {
          "Name": "5 Crazy Ninja Wins",
          "Category": "CrazyNinja",
          "Title": "Ninja Has Awaken",
          "Description": "Win 5 matches on CrazyNinja",
          "Image": "sleepy.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "14",
          "Check": function (p, s) { return p["win_CrazyNinja"] >= 5 }
      },
      {
          "Name": "10 Crazy Ninja Wins",
          "Category": "CrazyNinja",
          "Title": "Sparing Partner",
          "Description": "Win 10 matches on CrazyNinja",
          "Image": "ninja-mask.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "15",
          "Check": function (p, s) { return p["win_CrazyNinja"] >= 10 }
      },
      {
          "Name": "20 Crazy Ninja Wins",
          "Category": "CrazyNinja",
          "Title": "Black Belt",
          "Description": "Win 20 matches on CrazyNinja",
          "Image": "iron-mask.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "16",
          "Check": function (p, s) { return p["win_CrazyNinja"] >= 20 }
      },
      {
          "Name": "50 Crazy Ninja Wins",
          "Category": "CrazyNinja",
          "Title": "Merciless",
          "Description": "Win 50 matches on CrazyNinja",
          "Image": "tear-tracks.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "17",
          "Check": function (p, s) { return p["win_CrazyNinja"] >= 50 }
      },
      {
          "Name": "100 Crazy Ninja Wins",
          "Category": "CrazyNinja",
          "Title": "Ninja Destroyer",
          "Description": "Win 100 matches on CrazyNinja",
          "Image": "pummeled.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "18",
          "Check": function (p, s) { return p["win_CrazyNinja"] >= 100 }
      },
      {
          "Name": "5 Wins",
          "Category": "Overall",
          "Title": "Reached Noob Status",
          "Description": "Win 5 matches",
          "Image": "mouse.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "19",
          "Check": function (p, s) { return p["win"] >= 5 }
      },
      {
          "Name": "100 Wins",
          "Category": "Overall",
          "Title": "Small Beginnings ",
          "Description": "Win 100 matches",
          "Image": "mouse.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "20",
          "Check": function (p, s) { return p["win"] >= 100 }
      },
      {
          "Name": "200 Wins",
          "Category": "Overall",
          "Title": "Consistent Flyer",
          "Description": "Win 200 matches",
          "Image": "bird-twitter.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "21",
          "Check": function (p, s) { return p["win"] >= 200 }
      },
      {
          "Name": "300 Wins",
          "Category": "Overall",
          "Title": "Quiet Potential",
          "Description": "Win 300 matches",
          "Image": "white-cat.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "22",
          "Check": function (p, s) { return p["win"] >= 300 }
      },
      {
          "Name": "400 Wins",
          "Category": "Overall",
          "Title": "Dangerous Foe",
          "Description": "Win 400 matches",
          "Image": "scorpion.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "23",
          "Check": function (p, s) { return p["win"] >= 400 }
      },
      {
          "Name": "500 Wins",
          "Category": "Overall",
          "Title": "Slippery Predator ",
          "Description": "Win 500 matches",
          "Image": "squid.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "24",
          "Check": function (p, s) { return p["win"] >= 500 }
      },
      {
          "Name": "600 Wins",
          "Category": "Overall",
          "Title": "Power Player",
          "Description": "Win 600 matches",
          "Image": "hound.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "25",
          "Check": function (p, s) { return p["win"] >= 600 }
      },
      {
          "Name": "700 Wins",
          "Category": "Overall",
          "Title": "Quick and Formidable",
          "Description": "Win 700 matches",
          "Image": "lion.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "26",
          "Check": function (p, s) { return p["win"] >= 700 }
      },
      {
          "Name": "800 Wins",
          "Category": "Overall",
          "Title": "Unstoppable Force",
          "Description": "Win 800 matches",
          "Image": "croc-jaws.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "27",
          "Check": function (p, s) { return p["win"] >= 800 }
      },
      {
          "Name": "900 Wins",
          "Category": "Overall",
          "Title": "It's Dinomight!",
          "Description": "Win 900 matches",
          "Image": "dinosaur-rex.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "28",
          "Check": function (p, s) { return p["win"] >= 900 }
      },
      {
          "Name": "1000 Wins",
          "Category": "Overall",
          "Title": "Soaring Above The Competition",
          "Description": "Win 1000 matches",
          "Image": "eagle-emblem.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "29",
          "Check": function (p, s) { return p["win"] >= 1000 }
      },
      {
          "Name": "1500 Wins",
          "Category": "Overall",
          "Title": "King of Cards",
          "Description": "Win 1500 matches",
          "Image": "king.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "30",
          "Check": function (p, s) { return p["win"] >= 1500 }
      },
      {
          "Name": "Win Easy 5 times in a row",
          "Category": "Easy",
          "Title": "Dominator",
          "Description": "Win Easy 5 times in a row",
          "Image": "palm.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "31",
          "Order": "30",
          "Check": function (p, s) { return p["win_streak_Easy"] >= 5 }
      },
      {
          "Name": "Win Medium 5 times in a row",
          "Category": "Medium",
          "Title": "Dominator",
          "Description": "Win Medium 5 times in a row",
          "Image": "palm.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "32",
          "Check": function (p, s) { return p["win_streak_Medium"] >= 5 }
      },
      {
          "Name": "Win Hard 5 times in a row",
          "Category": "Hard",
          "Title": "Dominator",
          "Description": "Win Hard 5 times in a row",
          "Image": "palm.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "33",
          "Check": function (p, s) { return p["win_streak_Hard"] >= 5 }
      },
      {
          "Name": "Win Crazy Ninja 5 times in a row",
          "Category": "CrazyNinja",
          "Title": "Dominator",
          "Description": "Win Crazy Ninja 5 times in a row",
          "Image": "palm.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "34",
          "Check": function (p, s) { return p["win_streak_CrazyNinja"] >= 5 }
      },
      {
          "Name": "Win Easy 7 times in a row",
          "Category": "Easy",
          "Title": "On Fire",
          "Description": "Win Easy 7 times in a row",
          "Image": "paw.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "35",
          "Check": function (p, s) { return p["win_streak_Easy"] >= 7 }
      },
      {
          "Name": "Win Medium 7 times in a row",
          "Category": "Medium",
          "Title": "On Fire",
          "Description": "Win Medium 7 times in a row",
          "Image": "paw.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "36",
          "Check": function (p, s) { return p["win_streak_Medium"] >= 7 }
      },
      {
          "Name": "Win Hard 7 times in a row",
          "Category": "Hard",
          "Title": "On Fire",
          "Description": "Win Hard 7 times in a row",
          "Image": "paw.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "37",
          "Check": function (p, s) { return p["win_streak_Hard"] >= 7 }
      },
      {
          "Name": "Win Crazy Ninja 7 times in a row",
          "Category": "CrazyNinja",
          "Title": "On Fire",
          "Description": "Win Crazy Ninja 7 times in a row",
          "Image": "paw.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "38",
          "Check": function (p, s) { return p["win_streak_CrazyNinja"] >= 7 }
      },
      {
          "Name": "Win Hard 10 times in a row",
          "Category": "Hard",
          "Title": "Overkill",
          "Description": "Win Hard 10 times in a row",
          "Image": "flaming-claw.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "39",
          "Check": function (p, s) { return p["win_streak_Hard"] >= 10 }
      },
      {
          "Name": "Win Crazy Ninja 10 times in a row",
          "Category": "CrazyNinja",
          "Title": "Overkill",
          "Description": "Win Crazy Ninja 10 times in a row",
          "Image": "flaming-claw.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "40",
          "Check": function (p, s) { return p["win_streak_CrazyNinja"] >= 10 }
      },
      {
          "Name": "Win Easy on the first draw",
          "Category": "Easy",
          "Title": "No Need For a Deck",
          "Description": "Win Easy on the first draw",
          "Image": "skeleton-inside.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "41",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGameLevel"] === "Easy" && s["lastGame_PullCount"] >= 1 }
      },
      {
          "Name": "Win Medium on the first draw",
          "Category": "Medium",
          "Title": "No Need For a Deck",
          "Description": "Win Medium on the first draw",
          "Image": "skeleton-inside.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "42",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGameLevel"] === "Medium" && s["lastGame_PullCount"] >= 1 }
      },
      {
          "Name": "Win Hard on the first draw",
          "Category": "Hard",
          "Title": "No Need For a Deck",
          "Description": "Win Hard on the first draw",
          "Image": "skeleton-inside.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "43",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGameLevel"] === "Hard" && s["lastGame_PullCount"] >= 1 }
      },
      {
          "Name": "Win Crazy Ninja on the first draw",
          "Category": "CrazyNinja",
          "Title": "No Need For a Deck",
          "Description": "Win Crazy Ninja on the first draw",
          "Image": "skeleton-inside.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "44",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGameLevel"] === "CrazyNinja" && s["lastGame_PullCount"] >= 1 }
      },
      {
          "Name": "Win Medium 5 times in one session",
          "Category": "Medium",
          "Title": "Going the Distance",
          "Description": "Win Medium 5 times in one session",
          "Image": "bird-mask.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "45",
          "Check": function (p, s) { return s["win_Medium"] >= 5 }
      },
      {
          "Name": "Win Hard 5 times in one session",
          "Category": "Hard",
          "Title": "Going the Distance",
          "Description": "Win Hard 5 times in one session",
          "Image": "bird-mask.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "46",
          "Check": function (p, s) { return s["win_Hard"] >= 5 }
      },
      {
          "Name": "Win Crazy Ninja 5 times in one session",
          "Category": "CrazyNinja",
          "Title": "Going the Distance",
          "Description": "Win Crazy Ninja 5 times in one session",
          "Image": "bird-mask.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "47",
          "Check": function (p, s) { return s["winCrazyNinja"] >= 5 }
      },
      {
          "Name": "Win Medium 10 times in one session",
          "Category": "Medium",
          "Title": "Don’t Stop Till You Get Enough",
          "Description": "Win Medium 10 times in one session",
          "Image": "gluttony.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "48",
          "Check": function (p, s) { return s["win_Medium"] >= 10 }
      },
      {
          "Name": "Win Hard 10 times in one session",
          "Category": "Hard",
          "Title": "Don’t Stop Till You Get Enough",
          "Description": "Win Hard 10 times in one session",
          "Image": "gluttony.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "49",
          "Check": function (p, s) { return s["win_Hard"] >= 10 }
      },
      {
          "Name": "Win Crazy Ninja 10 times in one session",
          "Category": "CrazyNinja",
          "Title": "Don’t Stop Till You Get Enough",
          "Description": "Win Crazy Ninja 10 times in one session",
          "Image": "gluttony.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "50",
          "Check": function (p, s) { return s["winCrazyNinja"] >= 10 }
      },
      {
          "Name": "Lose Medium 5 times in one session",
          "Category": "Medium",
          "Title": "Raining On Your Parade",
          "Description": "Lose Medium 5 times in one session",
          "Image": "back-pain.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "51",
          "Check": function (p, s) { return s["lose_Medium"] >= 5 }
      },
      {
          "Name": "Lose Hard 5 times in one session",
          "Category": "Hard",
          "Title": "Raining On Your Parade",
          "Description": "Lose Hard 5 times in one session",
          "Image": "back-pain.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "52",
          "Check": function (p, s) { return s["lose_Hard"] >= 5 }
      },
      {
          "Name": "Lose Crazy Ninja 5 times in one session",
          "Category": "CrazyNinja",
          "Title": "Raining On Your Parade",
          "Description": "Lose Crazy Ninja 5 times in one session",
          "Image": "back-pain.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "53",
          "Check": function (p, s) { return s["lose_CrazyNinja"] >= 5 }
      },
      {
          "Name": "Tie Medium 3 times in one session",
          "Category": "Medium",
          "Title": "Peacemaker",
          "Description": "Tie Medium 3 times in one session",
          "Image": "meditation.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "54",
          "Check": function (p, s) { return s["tie_Medium"] >= 3 }
      },
      {
          "Name": "Tie Hard 3 times in one session",
          "Category": "Hard",
          "Title": "Peacemaker",
          "Description": "Tie Hard 3 times in one session",
          "Image": "meditation.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "55",
          "Check": function (p, s) { return s["tie_Hard"] >= 3 }
      },
      {
          "Name": "Tie Crazy Ninja 3 times in one session",
          "Category": "CrazyNinja",
          "Title": "Peacemaker",
          "Description": "Tie Crazy Ninja 3 times in one session",
          "Image": "meditation.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "56",
          "Check": function (p, s) { return s["tie_CrazyNinja"] >= 3 }
      },
      {
          "Name": "Win Medium Under 60 Seconds",
          "Category": "Medium",
          "Title": "Slow and Steady",
          "Description": "Win Medium under 60 Seconds",
          "Image": "snail.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "57",
          "Check": function (p, s) {
              return p["fastestWinTime_Medium"] <= 60
          }
      },
      {
          "Name": "Win Medium Under 50 Seconds",
          "Category": "Medium",
          "Title": "Quick Hands",
          "Description": "Win Medium under 50 Seconds",
          "Image": "crow-dive.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "58",
          "Check": function (p, s) { return p["fastestWinTime_Medium"] <= 50 }
      },
      {
          "Name": "Win Medium Under 45 Seconds",
          "Category": "Medium",
          "Title": "Crazy Fast",
          "Description": "Win Medium under 45 Seconds",
          "Image": "stopwatch.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "59",
          "Check": function (p, s) { return p["fastestWinTime_Medium"] <= 45 }
      },
      {
          "Name": "Win Hard Under 60 Seconds",
          "Category": "Hard",
          "Title": "Slow and Steady",
          "Description": "Win Hard under 60 Seconds",
          "Image": "snail.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "60",
          "Check": function (p, s) { return p["fastestWinTime_Hard"] <= 60 }
      },
      {
          "Name": "Win Hard Under 50 Seconds",
          "Category": "Hard",
          "Title": "Quick Hands",
          "Description": "Win Hard under 50 Seconds",
          "Image": "crow-dive.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "61",
          "Check": function (p, s) { return p["fastestWinTime_Hard"] <= 50 }
      },
      {
          "Name": "Win Hard Under 45 Seconds",
          "Category": "Hard",
          "Title": "Crazy Fast",
          "Description": "Win Hard under 45 Seconds",
          "Image": "stopwatch.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "62",
          "Check": function (p, s) { return p["fastestWinTime_Hard"] <= 45 }
      },
            {
                "Name": "Win Hard Under 35 Seconds",
                "Category": "Hard",
                "Title": "Crazy Fastest",
                "Description": "Win Hard under 35 Seconds",
                "Image": "stopwatch.png",
                "Points": "5",
                "PushToFacebook": "true",
                "Order": "62",
                "Check": function (p, s) { return p["fastestWinTime_Hard"] <= 35 }
            },
      {
          "Name": "Win Crazy Ninja Under 60 Seconds",
          "Category": "CrazyNinja",
          "Title": "Slow and Steady",
          "Description": "Win Crazy Ninja under 60 Seconds",
          "Image": "snail.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "63",
          "Check": function (p, s) { return p["fastestWinTime_CrazyNinja"] <= 60 }
      },
      {
          "Name": "Win Crazy Ninja Under 50 Seconds",
          "Category": "CrazyNinja",
          "Title": "Quick Hands",
          "Description": "Win Crazy Ninja under 50 Seconds",
          "Image": "crow-dive.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "64",
          "Check": function (p, s) { return p["fastestWinTime_CrazyNinja"] <= 50 }
      },
      {
          "Name": "Win Crazy Ninja Under 45 Seconds",
          "Category": "CrazyNinja",
          "Title": "Crazy Fast",
          "Description": "Win Crazy Ninja under 45 Seconds",
          "Image": "stopwatch.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "65",
          "Check": function (p, s) { return p["fastestWinTime_CrazyNinja"] <= 45 }
      },
    {
        "Name": "Win Crazy Ninja Under 35 Seconds",
        "Category": "CrazyNinja",
        "Title": "Crazy Fastest",
        "Description": "Win Crazy Ninja under 35 Seconds",
        "Image": "stopwatch.png",
        "Points": "5",
        "PushToFacebook": "true",
        "Order": "65",
        "Check": function (p, s) { return p["fastestWinTime_CrazyNinja"] <= 35 }
    },
      {
          "Name": "Win with the '2' card",
          "Category": "Other",
          "Title": "Loneliest Number Next to the Number 1",
          "Description": "Win with the '2' card",
          "Image": "2card.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "66",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^2[a-zA-Z]/) !== -1 }

      },
      {
          "Name": "Win with the '3' card",
          "Category": "Other",
          "Title": "3 Times The Charm",
          "Description": "Win with the '3' card",
          "Image": "3card.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "67",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^3[a-zA-Z]/) !== -1 }

      },
      {
          "Name": "Win with the '4' card",
          "Category": "Other",
          "Title": "This is 4 You",
          "Description": "Win with the '4' card",
          "Image": "4card.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "68",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^4[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win with the '5' card",
          "Category": "Other",
          "Title": "High 5",
          "Description": "Win with the '5' card",
          "Image": "5card.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "69",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^5[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win with the '6' card",
          "Category": "Other",
          "Title": "6th Sense",
          "Description": "Win with the '6' card",
          "Image": "6card.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "70",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^6[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win with the '7' card",
          "Category": "Other",
          "Title": "Lucky 7",
          "Description": "Win with the '7' card",
          "Image": "7card.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "71",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^7[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win with the '8' card",
          "Category": "Other",
          "Title": "Behind the 8 Ball",
          "Description": "Win with the '8' card",
          "Image": "8card.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "72",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^8[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win with the '9' card",
          "Category": "Other",
          "Title": "9 Lives",
          "Description": "Win with the '9' card",
          "Image": "9card.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "73",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^9[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win with the '10' card",
          "Category": "Other",
          "Title": "Perfect 10",
          "Description": "Win with the '10' card",
          "Image": "10card.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "74",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^10[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win with the 'Jack' card",
          "Category": "Other",
          "Title": "Jack in the Box",
          "Description": "Win with the 'Jack' card",
          "Image": "jcard.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "75",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^11[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win with the 'Queen' card",
          "Category": "Other",
          "Title": "Dancing Queen",
          "Description": "Win with the 'Queen' card",
          "Image": "qcard.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "76",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^12[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win with the 'King' card",
          "Category": "Other",
          "Title": "King Pin",
          "Description": "Win with the 'King' card",
          "Image": "kcard.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "77",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^13[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win with the 'Ace' card",
          "Category": "Other",
          "Title": "Ace High",
          "Description": "Win with the 'Ace' card",
          "Image": "ace.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "78",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^1[a-zA-Z]/) !== -1 }
      },
      {
          "Name": "Win Medium with the 'Ace' card",
          "Category": "Medium",
          "Title": "Ace High",
          "Description": "Win Medium with the 'Ace' card",
          "Image": "ace.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "79",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^1[a-zA-Z]/) !== -1 && s["lastGameLevel"] === "Medium" }
      },
      {
          "Name": "Win Hard with the 'Ace' card",
          "Category": "Hard",
          "Title": "Ace High",
          "Description": "Win Hard with the 'Ace' card",
          "Image": "ace.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "80",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^1[a-zA-Z]/) !== -1 && s["lastGameLevel"] === "Hard" }
      },
      {
          "Name": "Win Crazy Ninja with the 'Ace' card",
          "Category": "CrazyNinja",
          "Title": "Ace High",
          "Description": "Win Crazy Ninja with the 'Ace' card",
          "Image": "ace.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "81",
          "Check": function (p, s) { return s["lastGame_Winner"] === "Player1" && s["lastGame_LastCardPlayed"] != 'undefined' && s["lastGame_LastCardPlayed"].search(/^1[a-zA-Z]/) !== -1 && s["lastGameLevel"] === "CrazyNinja" }
      },
      {
          "Name": "Block",
          "Category": "Other",
          "Title": "Block",
          "Description": "Play a card as another player is about to play card",
          "Image": "boxing-glove.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "82",
          "Check": function (p, s) { return s["lastGame_blockedCount"] >= 1 }
      },
      {
          "Name": "Double Block (2x)",
          "Category": "Other",
          "Title": "Double Block (2x)",
          "Description": "Play 2 cards as another player is about to play card",
          "Image": "boxing-glove2.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "83",
          "Check": function (p, s) { return s["lastGame_blockedCount"] >= 2 }
      },
      {
          "Name": "Ninja Block (3x)",
          "Category": "Other",
          "Title": "Ninja Block (3x)",
          "Description": "Play 3 cards as another player is about to play card",
          "Image": "boxing-glove3.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "84",
          "Check": function (p, s) { return s["lastGame_blockedCount"] >= 3 }
      },
      {
          "Name": "Crazy Ninja Block (4x)",
          "Category": "Other",
          "Title": "Crazy Ninja Block (4x)",
          "Description": "Play 4 cards as another player is about to play card",
          "Image": "boxing-glove4.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "85",
          "Check": function (p, s) { return s["lastGame_blockedCount"] >= 4 }
      },
      {
          "Name": "Ultra Crazy Ninja Block (5x)",
          "Category": "Other",
          "Title": "Ultra Crazy Ninja Block (5x)",
          "Description": "Play 5 cards as another player is about to play card",
          "Image": "boxing-glove5.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "86",
          "Check": function (p, s) { return s["lastGame_blockedCount"] >= 5 }
      },
      {
          "Name": "Streak (4x)",
          "Category": "Other",
          "Title": "Streak (4x)",
          "Description": "Play 4 cards before your opponent plays a card ",
          "Image": "strong4.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "87",
          "Check": function (p, s) { return s["lastGame_maxStreakCount"] >= 4 }
      },
      {
          "Name": "Great Streak (5x)",
          "Category": "Other",
          "Title": "Great Streak (5x)",
          "Description": "Play 5 cards before your opponent plays a card ",
          "Image": "strong5.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "88",
          "Check": function (p, s) { return s["lastGame_maxStreakCount"] >= 5 }
      },
      {
          "Name": "Super Streak (6x)",
          "Category": "Other",
          "Title": "Super Streak (6x)",
          "Description": "Play 6 cards before your opponent plays a card ",
          "Image": "strong6.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "89",
          "Check": function (p, s) { return s["lastGame_maxStreakCount"] >= 6 }
      },
      {
          "Name": "Crazy Streak (7x)",
          "Category": "Other",
          "Title": "Crazy Streak (7x)",
          "Description": "Play 7 cards before your opponent plays a card ",
          "Image": "strong7.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "90",
          "Check": function (p, s) { return s["lastGame_maxStreakCount"] >= 7 }
      },
      {
          "Name": "On Fire Streak (8x)",
          "Category": "Other",
          "Title": "On Fire Streak (8x)",
          "Description": "Play 8 cards before your opponent plays a card ",
          "Image": "strong8.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "91",
          "Check": function (p, s) { return s["lastGame_maxStreakCount"] >= 8 }
      },
      {
          "Name": "Ninja Streak (9x)",
          "Category": "Other",
          "Title": "Ninja Streak (9x)",
          "Description": "Play 9 cards before your opponent plays a card ",
          "Image": "strong9.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "92",
          "Check": function (p, s) { return s["lastGame_maxStreakCount"] >= 9 }
      },
      {
          "Name": "Crazy Ninja Streak (10x)",
          "Category": "Other",
          "Title": "Crazy Ninja Streak (10x)",
          "Description": "Play 10 cards before your opponent plays a card ",
          "Image": "strong10.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "93",
          "Check": function (p, s) { return s["lastGame_maxStreakCount"] >= 10 }
      },
      //{
      //    "Name": "Flush (4x)",
      //    "Category": "Other",
      //    "Title": "Flush (4x)",
      //    "Description": "Play 4 cards of the same suit in a row",
      //    "Image": "flush4.png",
      //    "Points": "3",
      //    "PushToFacebook": "true",
      //    "Order": "94"
      //},
      //{
      //    "Name": "Great Flush (5x)",
      //    "Category": "Other",
      //    "Title": "Great Flush (5x)",
      //    "Description": "Play 5 cards of the same suit in a row",
      //    "Image": "flush5.png",
      //    "Points": "3",
      //    "PushToFacebook": "true",
      //    "Order": "95"
      //},
      //{
      //    "Name": "Ninja Flush (6x)",
      //    "Category": "Other",
      //    "Title": "Ninja Flush (6x)",
      //    "Description": "Play 6 cards of the same suit in a row",
      //    "Image": "flush6.png",
      //    "Points": "3",
      //    "PushToFacebook": "true",
      //    "Order": "96"
      //},
      //{
      //    "Name": "Crazy Ninja Flush (7x)",
      //    "Category": "Other",
      //    "Title": "Crazy Ninja Flush (7x)",
      //    "Description": "Play 7 cards of the same suit in a row",
      //    "Image": "flush7.png",
      //    "Points": "5",
      //    "PushToFacebook": "true",
      //    "Order": "97"
      //},
      //{
      //    "Name": "Straight (4x)",
      //    "Category": "Other",
      //    "Title": "Straight (4x)",
      //    "Description": "Play 4 cards of sequential rank",
      //    "Image": "flush4.png",
      //    "Points": "3",
      //    "PushToFacebook": "true",
      //    "Order": "98"
      //},
      //{
      //    "Name": "Great Straight (5x)",
      //    "Category": "Other",
      //    "Title": "Great Straight (5x)",
      //    "Description": "Play 5 cards of sequential rank",
      //    "Image": "flush5.png",
      //    "Points": "3",
      //    "PushToFacebook": "true",
      //    "Order": "99"
      //},
      //{
      //    "Name": "Ninja Straight (6x)",
      //    "Category": "Other",
      //    "Title": "Ninja Straight (6x)",
      //    "Description": "Play 6 cards of sequential rank",
      //    "Image": "flush6.png",
      //    "Points": "3",
      //    "PushToFacebook": "true",
      //    "Order": "100"
      //},
      //{
      //    "Name": "Crazy Ninja Straight (7x)",
      //    "Category": "Other",
      //    "Title": "Crazy Ninja Straight (7x)",
      //    "Description": "Play 7 cards of sequential rank",
      //    "Image": "flush7.png",
      //    "Points": "5",
      //    "PushToFacebook": "true",
      //    "Order": "101"
      //},
      {
          "Name": "Easy - New Fastest Time",
          "Category": "Easy",
          "Title": "Improving Beginner",
          "Description": "New fastest time on Easy",
          "Image": "hourglass.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "102",
          "Check": function (p, s) { return p["win_Easy"] > 5 && s["lastGame_Level"] === "Easy" && s["lastGame_newFastestTime"] > 0 }
      },
      {
          "Name": "Medium - New Fastest Time",
          "Category": "Medium",
          "Title": "Improving User",
          "Description": "New fastest time on Medium",
          "Image": "hourglass.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "103",
          "Check": function (p, s) { return p["win_Medium"] > 5 && s["lastGame_Level"] === "Medium" && s["lastGame_newFastestTime"] > 0 }
      },
      {
          "Name": "Hard - New Fastest Time",
          "Category": "Hard",
          "Title": "Improving Expert",
          "Description": "New fastest time on Hard",
          "Image": "hourglass.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "104",
          "Check": function (p, s) { return p["win_Hard"] > 5 && s["lastGame_Level"] === "Hard" && s["lastGame_newFastestTime"] > 0 }
      },
      {
          "Name": "Crazy Ninja - New Fastest Time",
          "Category": "CrazyNinja",
          "Title": "Improving Master",
          "Description": "New fastest time on CrazyNinja",
          "Image": "hourglass.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "105",
          "Check": function (p, s) { return p["win_CrazyNinja"] > 5 && s["lastGame_Level"] === "CrazyNinja" && s["lastGame_newFastestTime"] > 0 }
      },
      {
          "Name": "5 Online Wins",
          "Category": "Online",
          "Title": "Online Noobie",
          "Description": "Win 5 matches Online",
          "Image": "duality.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "106",
          "Check": function (p, s) { return p["win_Online"] >= 5 }
      },
      {
          "Name": "10 Online Wins",
          "Category": "Online",
          "Title": "Meeting the Competition",
          "Description": "Win 10 matches Online",
          "Image": "duality.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "107",
          "Check": function (p, s) { return p["win_Online"] >= 10 }
      },
      {
          "Name": "20 Online Wins",
          "Category": "Online",
          "Title": "Beating the Competition",
          "Description": "Win 20 matches Online",
          "Image": "backup.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "108",
          "Check": function (p, s) { return p["win_Online"] >= 20 }
      },
      {
          "Name": "50 Online Wins",
          "Category": "Online",
          "Title": "Plays To Win",
          "Description": "Win 50 matches Online",
          "Image": "backup.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "109",
          "Check": function (p, s) { return p["win_Online"] >= 50 }
      },
      {
          "Name": "100 Online Wins",
          "Category": "Online",
          "Title": "Wifi Junkie",
          "Description": "Win 100 matches Online",
          "Image": "dark-squad.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "110",
          "Check": function (p, s) { return p["win_Online"] >= 100 }
      },
      {
          "Name": "500 Online Wins",
          "Category": "Online",
          "Title": "Online Legend",
          "Description": "Win 500 matches Online",
          "Image": "dozen.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "111",
          "Check": function (p, s) { return p["win_Online"] >= 500 }
      },
      {
          "Name": "100 Losses",
          "Category": "Overall",
          "Title": "Thunder Struck",
          "Description": "Lose 100 matches",
          "Image": "thunder-struck.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "112",
          "Check": function (p, s) { p["lose"] > 100 }
      },
      {
          "Name": "200 Losses",
          "Category": "Overall",
          "Title": "Eaten Right Up",
          "Description": "Lose 200 matches",
          "Image": "fishbone.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "113",
          "Check": function (p, s) { p["lose"] > 200 }
      },
      {
          "Name": "300 Losses",
          "Category": "Overall",
          "Title": "Swimming in Dangerous Waters",
          "Description": "Lose 300 matches",
          "Image": "shark-jaws.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "114",
          "Check": function (p, s) { p["lose"] > 300 }
      },
      {
          "Name": "400 Losses",
          "Category": "Overall",
          "Title": "Burned",
          "Description": "Lose 400 matches",
          "Image": "salamander.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "115",
          "Check": function (p, s) { p["lose"] > 400 }
      },
      {
          "Name": "500 Losses",
          "Category": "Overall",
          "Title": "Determined to The End",
          "Description": "Lose 500 matches",
          "Image": "animal-skull.png",
          "Points": "3",
          "PushToFacebook": "true",
          "Order": "116",
          "Check": function (p, s) { p["lose"] > 500 }
      },
      {
          "Name": "Rate Game",
          "Category": "Other",
          "Title": "Courteous Citizen",
          "Description": "Rate the game",
          "Image": "paw-heart.png",
          "Points": "3",
          "Order": "117"
      },
      //{
      //    "Name": "See More Games",
      //    "Category": "Other",
      //    "Title": "Dora The Explorer",
      //    "Description": "See More Games",
      //    "Image": "heart-inside.png",
      //    "Points": "3",
      //    "Order": "118"
      //},
      //{
      //    "Name": "Play Bluetooth Game",
      //    "Category": "Online",
      //    "Title": "Close Combat",
      //    "Description": "Play a bluetooth game",
      //    "Image": "telepathy.png",
      //    "Points": "3",
      //    "PushToFacebook": "true",
      //    "Order": "119"
      //},
      //{
      //    "Name": "Invite Facebook Friend",
      //    "Category": "Online",
      //    "Title": "Get The Party Started",
      //    "Description": "Invite a facebook friend",
      //    "Image": "minions.png",
      //    "Points": "3",
      //    "Order": "120"
      //}
      //,
      {
          "Name": "1 Insane Monkey Wins",
          "Category": "Insane Monkey",
          "Title": "Distinguished Warrior",
          "Description": "Win 1 match on Insane Monkey",
          "Image": "monkey.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "121",
          "Check": function (p, s) { return p["win_InsaneMonkey"] >= 1 }
      },
      {
          "Name": "5 Insane Monkey Wins",
          "Category": "Insane Monkey",
          "Title": "Monkey Dominator",
          "Description": "Win 5 matches on Insane Monkey",
          "Image": "totem-head.png",
          "Points": "10",
          "PushToFacebook": "true",
          "Order": "122",
          "Check": function (p, s) { return p["win_InsaneMonkey"] >= 5 }
      },
      {
          "Name": "10 Insane Monkey Losses",
          "Category": "Insane Monkey",
          "Title": "Monkey Fighter",
          "Description": "Lose 10 matches on Insane Monkey",
          "Image": "monkey.png",
          "Points": "5",
          "PushToFacebook": "true",
          "Order": "123",
          "Check": function (p, s) { return p["win_InsaneMonkey"] >= 10 }
      }
    ];
}
