

//show ad timer
var lastShown = sessionStorage.getItem("lastShown");
if (lastShown == null) {
    lastShown = Date.now();//now
    sessionStorage.lastShown = Date.now();//now
}

var readyToShowAd = false;
//check for  180 seconds passed
if (Date.now() - lastShown > 180 * 1000) {
    readyToShowAd = true;
}
//check if over 20 min, may have not been in the app and reopened it with out restarting 
if (Date.now() - lastShown > 1200 * 1000) {
    readyToShowAd = false;
    sessionStorage.lastShown = Date.now();//now, reset
}
//todo: log anlytics data about ads


var admobid = {};
if (/(android)/i.test(navigator.userAgent)) {
    admobid = { // for Android
        banner: 'ca-app-pub-2191584882036728/1108878888',
        interstitial: 'ca-app-pub-2191584882036728/2018864088'
    };
} else if (/(ipod|iphone|ipad)/i.test(navigator.userAgent)) {
    admobid = { // for iOS
        banner: 'ca-app-pub-2191584882036728/1108878888',
        interstitial: 'ca-app-pub-2191584882036728/8065397685'
    };
} else {
    admobid = { // for Windows Phone
        banner: 'ca-app-pub-2191584882036728/1108878888',
        interstitial: 'ca-app-pub-2191584882036728/4565044480'
    };
}

//if ((/(ipad|iphone|ipod|android|windows phone)/i.test(navigator.userAgent))) {
//    document.addEventListener('deviceready', initApp, false);
//} else {
//    initApp();
//}
document.addEventListener("deviceready", function () {
    TryShowAd();
}, false);

function TryShowAd() {
    //https://github.com/floatinghotpot/cordova-admob-pro
    if (!AdMob) { console.log('admob plugin not ready'); return; }
    registerAdEvents();

    if (readyToShowAd === true && sessionStorage.isAdLoaded == "true") {
        AdMob.showInterstitial();
    }
    else if (readyToShowAd === true && sessionStorage.isAdLoaded != "true") {
        AdMob.prepareInterstitial({ adId: admobid.interstitial, autoShow: true });
    }
    else if (readyToShowAd === false && sessionStorage.isAdLoaded != "true") {
        AdMob.prepareInterstitial({ adId: admobid.interstitial, autoShow: false });
    }
    

}
// optional, in case respond to events or handle error
function registerAdEvents() {
    // new events, with variable to differentiate: adNetwork, adType, adEvent
    document.addEventListener('onAdFailLoad', function (data) {
        //alert('error: ' + data.error +
        //        ', reason: ' + data.reason +
        //        ', adNetwork:' + data.adNetwork +
        //        ', adType:' + data.adType +
        //        ', adEvent:' + data.adEvent); // adType: 'banner', 'interstitial', etc.
        console.log('error: ' + data.error +
                ', reason: ' + data.reason +
                ', adNetwork:' + data.adNetwork +
                ', adType:' + data.adType +
                ', adEvent:' + data.adEvent); // adType: 'banner', 'interstitial', etc.
    });
    document.addEventListener('onAdLoaded',
        function (data) {
            console.log("onAdLoaded: " + data);
            sessionStorage.isAdLoaded = true;
        }
        );
    document.addEventListener('onAdPresent',
        function (data) {
            console.log("onAdPresent: " + data);
            //reset timer
            sessionStorage.lastShown = Date.now();
            sessionStorage.isAdLoaded = false;
        }
        );
    document.addEventListener('onAdLeaveApp',
        function (data) {
            console.log("onAdLeaveApp: " + data);
        }
        );
    document.addEventListener('onAdDismiss',
        function (data) {
            console.log("onAdDismiss: " + data);
        }
        );
}



