/// <reference path="js/phaser.js" />
/// <reference path="js/SpeedCore.js" />


//could create the game in this format http://searchcode.com/codesearch/view/88875375/

BasicGame = {

    /* Here we've just got some global level vars that persist regardless of State swaps */
    score: 0,

    /* If the music in your game needs to play through-out a few State swaps, then you could reference it here */
    music: null,

    /* Your game can check BasicGame.orientated in internal loops to know if it should pause or not */
    orientated: false

};
BasicGame.Game = function (game) {
    var _this = this;
    //	When a State is added to Phaser it automatically has the following properties set on it, even if they already exist:

    this.game;		//	a reference to the currently running game
    this.add;		//	used to add sprites, text, groups, etc
    this.camera;	//	a reference to the game camera
    this.cache;		//	the game cache
    this.input;		//	the global input manager (you can access this.input.keyboard, this.input.mouse, as well from it)
    this.load;		//	for preloading assets
    this.math;		//	lots of useful common math operations
    this.sound;		//	the sound manager - add a sound, play one, set-up markers, etc
    this.stage;		//	the game stage
    this.time;		//	the clock
    this.tweens;	//	the tween manager
    this.world;		//	the game world
    this.particles;	//	the particle manager
    this.physics;	//	the physics manager
    this.rnd;		//	the repeatable random number generator

    //	You can use any of these from any function within this State.
    //	But do consider them as being 'reserved words', i.e. don't create a property for your own game called "world" or you'll over-write the world reference.

    this.speed;
    this.cardUIs = [];
    this.textblock;
    this.cardLayer;
    this.drawPile1;
    this.drawPile1a;
    this.drawPile2;
    this.drawPile2a;
    this.pullPile1;
    this.pullPile1a;
    this.pullPile2;
    this.pullPile2a;
    this.txtGameOverMessage;

    this.player2;

    this.hand1 = { x: 0, y: 490, zOrder: 1 };
    this.hand2 = { x: 0, y: 140, zOrder: -1 };

    this.layoutNormal = {
        textblock: { x: 30, y: 640 },
        drawPile1: { x: 340, y: 740 },
        drawPile1a: { x: 340 + 5, y: 740 + 5 },
        drawPile2: { x: 10, y: 110 },
        drawPile2a: { x: 10 + 5, y: 110 + 5 },
        hand1: { x: 0, y: 490, zOrder: 1 },
        hand2: { x: 0, y: 140, zOrder: -1 },
        hs1: { x: 140, y: 315 },
        hs2: { x: 260, y: 315 },
        pullPile1a: { x: 15 + 5, y: 310 + 5 },
        pullPile1: { x: 15, y: 310 },
        pullPile2a: { x: 380 + 5, y: 310 + 5 },
        pullPile2: { x: 380, y: 310 },
        buttonExit: { x: 435, y: 10, w: 50, h: 50 },
        styleProfile: { font: "24px Arial", fill: "#ffffff", align: "center" },
        styleProfileSmall: { font: "14px Arial", fill: "#ffffff", align: "center" },
        profile1Background: { x: 170, y: 10, width: 250, height: 60 },
        imgProfile1: { x: 170 + 5, y: 10 + 5, width: 50, height: 50 },
        txtProfile1: { x: 170 + 5 + +50 + 10, y: 10 + 5 },
        txtProfile1Rank: { x: 170 + 5 + 50 + 10, y: 10 + 36 },
        profile2Background: { x: 80, y: 680, width: 250, height: 60 },
        imgProfile2: { x: 80 + 5, y: 680 + 5, width: 50, height: 50 },
        txtProfile2: { x: 80 + 5 + 50 + 10, y: 680 + 5, },
        txtProfile2Rank: { x: 80 + 5 + 50 + 10, y: 680 + 36 },
    };
    this.layoutFliped = {
        textblock: { x: 30, y: 640 },
        drawPile2: { x: 340, y: 740 },
        drawPile2a: { x: 340 + 5, y: 740 + 5 },
        drawPile1: { x: 10, y: 110 },
        drawPile1a: { x: 10 + 5, y: 110 + 5 },
        hand2: { x: 0, y: 490, zOrder: 1 },
        hand1: { x: 0, y: 140, zOrder: -1 },
        hs2: { x: 140, y: 315 },
        hs1: { x: 260, y: 315 },
        pullPile2a: { x: 15 + 5, y: 310 + 5 },
        pullPile2: { x: 15, y: 310 },
        pullPile1a: { x: 380 + 5, y: 310 + 5 },
        pullPile1: { x: 380, y: 310 },
        buttonExit: { x: 435, y: 10, w: 50, h: 50 },
        styleProfile: { font: "24px Arial", fill: "#ffffff", align: "center" },
        styleProfileSmall: { font: "14px Arial", fill: "#ffffff", align: "center" },
        profile2Background: { x: 170, y: 10, width: 250, height: 60 },
        imgProfile2: { x: 170 + 5, y: 10 + 5, width: 50, height: 50 },
        txtProfile2: { x: 170 + 5 + +50 + 10, y: 10 + 5 },
        txtProfile2Rank: { x: 170 + 5 + 50 + 10, y: 10 + 36 },
        profile1Background: { x: 80, y: 680, width: 250, height: 60 },
        imgProfile1: { x: 80 + 5, y: 680 + 5, width: 50, height: 50 },
        txtProfile1: { x: 80 + 5 + 50 + 10, y: 680 + 5, },
        txtProfile1Rank: { x: 80 + 5 + 50 + 10, y: 680 + 36 },

    };
    this.layout = this.layoutNormal;

    this.applyLayout = function (layout, source) {
        //apply layout / trasformation
        for (var layout_prop in layout) {
            if (layout.hasOwnProperty(layout_prop)) {
                for (var source_prop in source) {
                    if (layout_prop == source_prop) {
                        for (var layout_prop_prop in layout[layout_prop]) {
                            source[source_prop][layout_prop_prop] = layout[layout_prop][layout_prop_prop];
                        }
                    }
                }
            }
        }
    };
};

BasicGame.Game.prototype = {

    init: function (params) {
        //moved out of the UI
        //this.player2 = params;
        ////try {
        ////    // URL will change to /plate/sandwich
        ////    history.pushState(null, params, "#" + params);
        ////} catch (ex) { }
    },
    loadRender: function () {
        this.game.debug.text('Loading ...' + this.game.load.progress, 180, 200);

    },
    loadUpdate: function (s) {

    },
    preload: function () {

        if (this.game.device.desktop) {
            this.scale.scaleMode = Phaser.ScaleManager.NO_SCALE;
            this.scale.windowConstraints.bottom = "visual";
            this.scale.pageAlignHorizontally = true;
            this.scale.pageAlignVertically = true;
            this.scale.setScreenSize(true);
            this.scale.refresh();
        }
        else {
            this.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
            this.scale.windowConstraints.bottom = "visual";
            this.scale.pageAlignHorizontally = true;
            this.scale.pageAlignVertically = true;
            this.scale.setScreenSize(true);
            this.scale.refresh();
        }

        //This sets the preloadBar sprite as a loader sprite.
        //What that does is automatically crop the sprite from 0 to full-width as the files below are loaded in.
        //Needs to be preloaded the sprite, unles i can find a way to load an empty sprite with a back ground.
        //this.load.image('preloaderBar', 'images/SpeedTitle.png');
        //this.preloadBar = this.add.sprite(50, 300, 'preloaderBar');
        //this.renderTextureBar = this.add.renderTexture(300, 50, 'renderTextureBar');
        //this.preloadBar = this.add.sprite(50, 100, this.renderTextureBar);
        //this.preloadBar.tint = 0xff00ff;
        //this.load.setPreloadSprite(this.preloadBar);


        //this.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
        //this.scale.setScreenSize(true);
        this.load.crossOrigin = 'anonymous';
        this.load.atlasJSONHash('cards', 'images/cards_SimpleDualSide.png', 'images/cards_SimpleDualSide.json');
        this.load.image('SpeedTitle', 'images/SpeedTitle.png');
        this.load.image('Background', 'images/wood.jpg');
        //this.load.image('Button1Player', 'images/Button1Player.png');
        //this.load.image('Button2Player', 'images/Button2Player.png');
        //this.load.image('Button4Player', 'images/Button4Player.png');
        //this.load.image('ButtonAchievements', 'images/ButtonAchievements.png');
        //this.load.image('ButtonItems', 'images/ButtonItems.png');
        //this.load.image('ButtonSettings', 'images/ButtonSettings.png');
        this.load.image('GameOverBackground', 'images/GameOverBackground.png');
        this.load.image('ButtonBlankShadow', 'images/ButtonBlankShadow.png');

        //this.load.image('HowToPlayFull', 'images/HowToPlayFull.png');

        this.load.image('BackButton', 'images/BackButton.png');

        this.load.image('ProfileDefault', 'images/Avatars/default-avatar.png');
        // this.load.image('Profile1', 'https://graph.facebook.com/560706963/picture?type=normal');



    },
    create: function () {

        
        //clear the loader does in the preload
        this.game.debug.reset();

       



        this.cardUIs = [];

        //create new if needed, so it can be preset if need
        if (!this.speed) this.speed = new Speed();
        //moved out of the UI
        //this.speed.player2 = this.player2;

        //todo: maybe remove and have have a different trigger to start, such as in the controller
        // this.speed.setUpGame();
        var t = this;
        this.speed.onMessage = function (message, value) {
            t.moveCardsToPiles(message, value);
        };

        //todo:remove - debug mode
        this.game.stage.disableVisibilityChange = true;

        //should switch timer to use game time not js timers, but the game logic knows nothing of the UI.
        this.game.onPause.add(this.onGamePause, this);
        this.game.onResume.add(this.onGameResume, this);


        //add background
        var background = this.add.sprite(0, 0, 'Background');


        //this.background = this.add.sprite(0, 0, 'cards', 'wood.jpg');
        // this.add.tileSprite(0, 0, 1000, 1000, 'cards', 'wood.jpg');

        this.textblock = this.add.text(30, 675, "", { font: "30px Arial", fill: "#ffffff", align: "center" });

        //addhotspots
        this.hs1 = this.add.sprite(140, 315, 'cards', 'CardBack.png');
        this.hs2 = this.add.sprite(260, 315, 'cards', 'CardBack.png');

        //add layer
        this.cardLayer = this.add.group();


        for (var i = 0; i < this.speed.cards.length; i++) {
            var cardId = this.speed.cards[i].id;
            this.createCard(cardId, this.cardLayer, 200, 300);
            // this.createCard(cardId, this.cardLayer, Math.random() * 500, Math.random() * 500);
        }
        // this.cardLayer.children.sort(this.depthCompare);
        this.cardLayer.sort();





        ////addbuttons
        this.drawPile1a = this.add.sprite(345, 745, 'cards', 'CardBack.png');
        this.drawPile1a.angle = -90;
        this.drawPile1 = this.add.sprite(340, 740, 'cards', 'CardBack.png');
        this.drawPile1.angle = -90;
        // drawPile1.position.x = 310;
        //drawPile1.position.y = 640;
        // drawPile1.width = 100;
        // drawPile1.height = 137;
        this.drawPile1.interactive = true;
        this.drawPile1.buttonMode = true;
        // drawPile1.anchor.x = 0.5;
        // drawPile1.anchor.y = 0.5;
        // drawPile1.alpha = 0.1;
        this.drawPile1.inputEnabled = true;
        this.drawPile1.events.onInputDown.add(function (data) {
            t.speed.FillHand1();
        });



        this.drawPile2a = this.add.sprite(15, 115, 'cards', 'CardBack.png');
        this.drawPile2a.angle = -90;
        this.drawPile2 = this.add.sprite(10, 110, 'cards', 'CardBack.png');
        this.drawPile2.angle = -90;
        // drawPile2.position.x = 360;
        // drawPile2.position.y = 0;
        //drawPile2.width = 100;
        //drawPile2.height = 137;
        this.drawPile2.interactive = true;
        this.drawPile2.buttonMode = true;
        //drawPile2.anchor.x = 0.5;
        // drawPile2.anchor.y = 0.5;
        // drawPile2.alpha = 0.1;
        this.drawPile2.inputEnabled = true;
        this.drawPile2.events.onInputDown.add(function (data) {
            t.speed.FillHand2();
        });



        this.pullPile1a = this.add.sprite(20, 315, 'cards', 'CardBack.png');
        this.pullPile1 = this.add.sprite(15, 310, 'cards', 'CardBack.png');
        //pullPile2.position.x = 370;
        //pullPile2.position.y = 320;
        // pullPile1.width = 100;
        //  pullPile1.height = 137;
        this.pullPile1.interactive = true;
        this.pullPile1.buttonMode = true;
        // pullPile1.anchor.x = 0.5;
        //  pullPile1.anchor.y = 0.5;
        //pullPile1.alpha = 0.1;
        this.pullPile1.inputEnabled = true;
        this.pullPile1.events.onInputDown.add(function (data) { t.speed.pull(); });

        this.pullPile2a = this.add.sprite(385, 315, 'cards', 'CardBack.png');
        this.pullPile2 = this.add.sprite(380, 310, 'cards', 'CardBack.png');
        //pullPile2.position.x = 370;
        //pullPile2.position.y = 320;
        //pullPile2.width = 100;
        // pullPile2.height = 137;
        this.pullPile2.interactive = true;
        this.pullPile2.buttonMode = true;
        // pullPile2.anchor.x = 0.5;
        // pullPile2.anchor.y = 0.5;
        // pullPile2.alpha = 0.1;
        this.pullPile2.inputEnabled = true;
        this.pullPile2.events.onInputDown.add(function (data) { t.speed.pull(); });

        //add layer
        this.gameOverLayer = this.add.group();
        this.gameOverLayer.x = 0;
        this.gameOverLayer.y = 0;

        this.gameOverBackground = this.add.sprite(0, 0, 'GameOverBackground');
        this.gameOverBackground.width = this.game.width;
        this.gameOverBackground.height = this.game.height;
        this.gameOverBackground.alpha = 1;
        // this.gameOverBackground.interactive = true;
        // this.gameOverBackground.buttonMode = true;
        // this.gameOverBackground.inputEnabled = true;
        // this.gameOverBackground.events.onInputDown.add(function (data) { t.quitGame(); });
        this.gameOverLayer.add(this.gameOverBackground);

        var style = { font: "50px Arial", fill: "#ffffff", align: "center" };
        this.txtGameOverMessage = this.add.text(this.game.world.centerX, 200, "Player1 Wins!", style);
        this.txtGameOverMessage.anchor.set(0.5);
        this.gameOverLayer.add(this.txtGameOverMessage);


        var style = { font: "20px Arial", fill: "#ffffff", align: "center" };
        this.txtGameOverTime = this.add.text(this.game.world.centerX, 250, "Time: 3:02", style);
        this.txtGameOverTime.anchor.set(0.5);
        this.gameOverLayer.add(this.txtGameOverTime);

        this.gameOverButton = this.add.button(this.game.world.centerX, 500, 'ButtonBlankShadow', function (data) { t.quitGame(); });
        this.gameOverButton.anchor.set(0.5);
        this.gameOverButton.width = 400;
        this.gameOverLayer.add(this.gameOverButton);

        var style = { font: "35px Arial", fill: "#ffffff", align: "center" };
        this.txtGameOverMessage2 = this.add.text(this.game.world.centerX, 500, "Play again", style);
        this.txtGameOverMessage2.anchor.set(0.5);
        this.gameOverLayer.add(this.txtGameOverMessage2);

        this.gameOverLayer.visible = false;;
        // this.add.tween(this.gameOverLayer).from({ alpha: 0 }, 2000, Phaser.Easing.Cubic.Out, true, false, false);



        //exit button
        this.buttonExit = this.add.button(435, 10, 'BackButton', this.quitGame, this);
        this.buttonExit.width = 50;
        this.buttonExit.height = 50;



        this.styleProfile = { font: "22px Arial", fill: "#ffffff", align: "center" };
        this.styleProfileSmall = { font: "14px Arial", fill: "#ffffff", align: "center" };

        //setup profile image 1
        this.profile1Background = this.add.sprite(170, 10, 'ButtonBlankShadow');
        this.profile1Background.width = 250;
        this.profile1Background.height = 60;
        this.profile1Background.alpha = 0.5;
        this.txtProfile1 = this.game.add.text(170 + 5 + +50 + 10, 15 + 2, "Top", this.styleProfile);
        this.txtProfile1Rank = this.game.add.text(170 + 5 + +50 + 10, 15 + 33, "", this.styleProfileSmall);
        this.imgProfile1 = this.add.sprite(170 + 5, 15, 'ProfileDefault');
        this.imgProfile1.width = 50;
        this.imgProfile1.height = 50;

        //setup profile image 2
        this.profile2Background = this.add.sprite(80, 680, 'ButtonBlankShadow');
        this.profile2Background.width = 250;
        this.profile2Background.height = 60;
        this.profile2Background.alpha = 0.5;
        this.txtProfile2 = this.game.add.text(80 + 5 + 50 + 10, 685 + 2, "Buttom", this.styleProfile);
        this.txtProfile2Rank = this.game.add.text(80 + 5 + +50 + 10, 685 + 33, "", this.styleProfileSmall);
        this.imgProfile2 = this.add.sprite(80 + 5, 685, 'ProfileDefault');
        this.imgProfile2.width = 50;
        this.imgProfile2.height = 50;

        ////performance test
        //this.profile2Background.visible = false;
        //this.txtProfile2.visible = false;
        //this.txtProfile2Rank.visible = false;
        //this.imgProfile2.visible = false;

        //this.profile1Background.visible = false;
        //this.txtProfile1.visible = false;
        //this.txtProfile1Rank.visible = false;
        //this.imgProfile1.visible = false;



        //todo: update image with users profile image
        //http://www.html5gamedevs.com/topic/7491-async-image-loader/
        //http://codepen.io/anon/pen/doZWxb

        // this.dynamicUpdateTexture(this.game, this.imgProfile2, 'https://graph.facebook.com/560706963/picture?type=normal', 'Profile2', "Profile2Custom");

        // this.dynamicUpdateTexture(this.game, this.imgProfile1, this.speed.PlayerTop.avatar, 'Profile2', "Profile2Custom");


        this.updateLayout();
        


        //doto:trigger ready as if a player loading and let controller start the game
        //this.speed.start();
        this.speed.message("ready", "UI", null, "Local");




    },
    updateLayout: function (){
        if (this.speed.PlayerBottom.isLocal)
            this.applyLayout(this.layout, this);
        else
            this.applyLayout(this.layoutFliped, this);
    },
    dynamicUpdateTexture: function (game, image, url, fallback, key) {
        if (typeof key === 'undefined') key = 'dynamicLoad_' + url;
        if (game.cache.checkImageKey(key)) {
            image.loadTexture(key);
            image.width = image._width;//reset auto scaling.
            image.height = image._height;
        } else {

            var loader = new Phaser.Loader(game);
            loader.crossOrigin = 'anonymous';
            loader.image(key, url);
            loader.onFileComplete.addOnce(this._fileComplete, image);
            loader.start();

            return image;
        }
    },
    _fileComplete: function (progress, cacheKey, success, totalLoaded, totalFiles) {
        if (success) {
            this.loadTexture(cacheKey);

            this.width = this._width;//reset auto scaling.
            this.height = this._height;
        }
    },
    dynamicLoadImage: function (game, x, y, url, fallback, key) {
        if (typeof key === 'undefined') key = 'dynamicLoad_' + url;
        if (game.cache.checkImageKey(key)) {
            return game.add.image(x, y, key);
        } else {
            var image = game.add.image(x, y, fallback);
            var loader = new Phaser.Loader(game);
            loader.crossOrigin = 'anonymous';
            loader.image(key, url);
            loader.onFileComplete.addOnce(this._fileComplete, image);
            loader.start();

            return image;
        }
    },
    onGamePause: function () {
        //dont pause on network play
        this.speed.pause();
        console.log("onGamePause");
    },
    onGameResume: function () {
        this.speed.resume();
        console.log("onGameResume");
    },
    update: function () {
        // stats.begin();

        ////tween v1
        //for (key in this.cardUIs) {
        //    var sprite = this.cardUIs[key];
        //    if (sprite.dragging === true) continue;
        //    var speed = sprite.speed;
        //    if (speed === undefined) speed = 12;
        //    if (sprite.position.x > sprite.targetx) sprite.position.x -= speed;
        //    if (sprite.position.x < sprite.targetx) sprite.position.x += speed;
        //    if (sprite.position.y > sprite.targety) sprite.position.y -= speed;
        //    if (sprite.position.y < sprite.targety) sprite.position.y += speed;
        //    if (Math.abs(sprite.position.x - sprite.targetx) < speed)
        //        sprite.position.x = sprite.targetx;
        //    if (Math.abs(sprite.position.y - sprite.targety) < speed)
        //        sprite.position.y = sprite.targety;

        //}


        //  case "Easy": Id = -11; ComputerTimer = 50; ComputerCardSpeed = TimeSpan.FromMilliseconds(1200); break;
        //   case "Medium": Id = -12; ComputerTimer = 35; ComputerCardSpeed = TimeSpan.FromMilliseconds(800); break;
        //   case "Hard": Id = -13; ComputerTimer = 20; ComputerCardSpeed = TimeSpan.FromMilliseconds(500); break;
        //   case "Crazy Ninja": Id = -14; ComputerTimer = 14; ComputerCardSpeed = TimeSpan.FromMilliseconds(300); break;
        //   case "Insane Monkey": Id = -15; ComputerTimer = 10; ComputerCardSpeed = TimeSpan.FromMilliseconds(200); break;

        //need to round / floor all x/y
        //also anchor will off set it by fraction


        //auto drop
        for (key in this.cardUIs) {
            var sprite = this.cardUIs[key];
            if (sprite.dragging !== true) continue;
            if (sprite.disableAutoDrop === undefined || sprite.disableAutoDrop === false) {
                if (this.hitTest(this.hs1, sprite)) {
                    var card = this.speed.getCard("card" + sprite.cardId);
                    var canDrop = this.speed.canDrop(card, "hs1");
                    if (canDrop) {
                        var played = this.speed.tryPlayCard(card, "hs1");
                        if (played) {
                            sprite.input.disableDrag();
                            sprite.dragging = false;
                            //todo: remove
                            this.moveCardsToPiles("cardMoved", "AutoDrop");
                        }
                    }
                }
                //check if hit hs2
                if (this.hitTest(this.hs2, sprite)) {
                    var card = this.speed.getCard("card" + sprite.cardId);
                    var canDrop = this.speed.canDrop(card, "hs2");
                    if (canDrop) {
                        var played = this.speed.tryPlayCard(card, "hs2");
                        if (played) {
                            sprite.input.disableDrag();
                            sprite.dragging = false;
                            //todo: remove
                            this.moveCardsToPiles("cardMoved", "AutoDrop");
                        }
                    }
                }
            }
        }


    },
    render: function () {
       // //todo:need to round / floor all x/y
       // //also anchor will off set it by fraction
       
       // //this.debug.inputInfo(32, 32);
       // this.game.time.advancedTiming = true;
       //this.game.debug.text("FPS:" + this.game.time.fps, 200, 100);
       // // stats.end();
    },
    quitGame: function (pointer) {

        //	Here you should destroy anything you no longer need.
        //	Stop music, delete sprites, purge caches, free resources, all that good stuff.
        this.speed.destroy();

        //	Then let's go back to the main menu.
        try { window.history.back(); }
        catch (ex) { window.location.href = 'index.html'; }

        //   this.state.start('MainMenu');

    },
    createCard: function (id, cardLayer, x, y) {


        var imgId = id;
        if (imgId.indexOf("11") === 0) imgId = imgId.replace("11", "J");
        if (imgId.indexOf("12") === 0) imgId = imgId.replace("12", "Q");
        if (imgId.indexOf("13") === 0) imgId = imgId.replace("13", "K");
        if (imgId.indexOf("10") != 0 && imgId.indexOf("1") === 0) imgId = imgId.replace("1", "A");

        var cardUI = this.add.sprite(0, 0, 'cards', imgId.toUpperCase() + ".png");
        cardUI.cardId = id;
        this.cardUIs[id] = cardUI;



        // enable the bunny to be interactive.. this will allow it to respond to mouse and touch events
        cardUI.interactive = true;
        // this button mode will mean the hand cursor appears when you rollover the bunny with your mouse
        cardUI.buttonMode = true;

        // center the bunnys anchor point
        // cardUI.anchor.x = 0.5;
        // cardUI.anchor.y = 0.5;
        // make it a bit bigger, so its easier to touch
        cardUI.scale.x = cardUI.scale.y = 1;

        // move the sprite to its designated position
        cardUI.position.x = x;
        cardUI.position.y = y;
        cardUI.z = x;

        // cardUI.width = 105;
        // cardUI.height = 141;

        cardUI.inputEnabled = true;
        cardUI.input.enableDrag(true, true);
        // use the mousedown and touchstart
        cardUI.events.onDragStart.add(this.startDrag, this);
        cardUI.events.onDragStop.add(this.stopDrag, this);

        // add it to the stage
        cardLayer.add(cardUI);
    },
    startDrag: function (sender, event) {
        sender.dragging = true;

        sender.zold = sender.z;
        sender.z = 1000;
        this.speed.message("startDrag", sender.cardId, null, "touch")
    },
    stopDrag: function (sender, event) {
        sender.dragging = false;
        sender.z = sender.zold;
        sender.tweenx = 0;//reset tween
        this.speed.message("stopDrag", sender.id)
        if (this.hitTest(this.hs1, sender)) {
            var card = this.speed.getCard("card" + sender.cardId);
            this.speed.tryPlayCard(card, "hs1");
        }
        //check if hit hs2
        if (this.hitTest(this.hs2, sender)) {
            var card = this.speed.getCard("card" + sender.cardId);
            this.speed.tryPlayCard(card, "hs2");
        }
    },


    hitTest: function (sprite1, sprite2) {
        /// <param name="sprite1" type="Phaser.Sprite">sprite</param>
        /// <param name="sprite2" type="Phaser.Sprite">sprite</param>

        if (sprite1.position.x + sprite1.width > sprite2.position.x)
            if (sprite1.position.x < sprite2.position.x + sprite2.width)
                if (sprite1.position.y + sprite1.height > sprite2.position.y)
                    if (sprite1.position.y < sprite2.position.y + sprite2.height)
                        return true;
        return false;
    },

    depthCompare: function (a, b) {
        if (a.z < b.z)
            return -1;
        if (a.z > b.z)
            return 1;
        return 0;
    },
    //MoveElement: function (id, x, y, z, fliped, isVisible, speed) {
    //    var sprite = this.cardUIs[id];
    //    sprite.targetx = x;
    //    sprite.targety = y;
    //    sprite.z = z;
    //    sprite.speed = speed;
    //    sprite.visible = isVisible;
    //    this.cardLayer.children.sort(this.depthCompare);
    //},
    moveCardsToPiles: function (msg, value, model) {
        //spanMessage.innerHTML = msg + " " + value;
        // if (this.textblock != undefined && msg =='message' ) this.textblock.text = msg;

        var gameWidth = 470;
        var pileCards = this.speed.getPile("hand1");
        for (var i = 0; i < pileCards.length; i++) {
            card = pileCards[i];
            // card.targetx = 10 + (i * 90);

            //todo: order right to left if fliped
            //todo: or dont move pile and just change name of pile
           // card.targetx = (10 * (1 + 5 - pileCards.length)) + (i * gameWidth / pileCards.length);
            if (this.hand2.zOrder == -1) card.targetx = (10 * (1 + 5 - pileCards.length)) + ((pileCards.length - i - 1) * gameWidth / pileCards.length);
            if (this.hand2.zOrder == 1) card.targetx = (10 * (1 + 5 - pileCards.length)) + (i * gameWidth / pileCards.length);

            card.targety = this.hand1.y;
            if (card.selected === true) card.targety = this.hand1.y - 15;
            card.targetz = -i ;
            card.isDragable = true;
            card.isFlipped = false;
            card.isVisible = true;
        }
        var pileCards = this.speed.getPile("hand2");
        for (var i = 0; i < pileCards.length; i++) {
            card = pileCards[i];
            // card.targetx = 10 + (i * 90);

            //todo: order right to left if fliped
            if(this.hand2.zOrder == 1)  card.targetx = (10 * (1 + 5 - pileCards.length)) + ((pileCards.length-i-1) * gameWidth / pileCards.length);
            if (this.hand2.zOrder == -1) card.targetx = (10 * (1 + 5 - pileCards.length)) + (i * gameWidth / pileCards.length);
            card.targety = this.hand2.y;
            if (card.selected === true) card.targety = this.hand2.y - 15;
            // card.speed = 4;
            card.targetz = -i ;
            card.isDragable = true;
            card.isFlipped = false;
            card.isVisible = true;
        }
        var pileCards = this.speed.getPile("pull1");
        for (var i = 0; i < pileCards.length; i++) {
            card = pileCards[i];
            card.targetx = this.pullPile1.x + (i * 1);
            card.targety = this.pullPile1.y + (i * 1);
            card.targetz = i;
            card.isDragable = false;
            card.isFlipped = true;
            card.isVisible = false;
            this.pullPile1.visible = true;
            this.pullPile1a.visible = true;
        }
        if (pileCards.length == 0) {
            this.pullPile1.visible = false;
            this.pullPile1a.visible = false;
        }

        var pileCards = this.speed.getPile("pull2");
        for (var i = 0; i < pileCards.length; i++) {
            card = pileCards[i];
            card.targetx = this.pullPile2.x + (i * 1);
            card.targety = this.pullPile2.y + (i * 1);
            card.targetz = i;
            card.isDragable = false;
            card.isFlipped = true;
            card.isVisible = false;
            this.pullPile2.visible = true;
            this.pullPile2a.visible = true;
        }
        if (pileCards.length == 0) {
            this.pullPile2.visible = false;
            this.pullPile2a.visible = false;
        }
        var pileCards = this.speed.getPile("draw1");
        for (var i = 0; i < pileCards.length; i++) {
            card = pileCards[i];
            card.targetx = this.drawPile1.x + (i * 1);
            card.targety = this.drawPile1.y + (i * 1);
            card.targetz = i;
            card.isDragable = false;
            card.isFlipped = true;
            card.isVisible = false;
            this.drawPile1.visible = true;
            this.drawPile1a.visible = true;
        }
        if (pileCards.length == 0) {
            this.drawPile1.visible = false;
            this.drawPile1a.visible = false;
        }
        var pileCards = this.speed.getPile("draw2");
        for (var i = 0; i < pileCards.length; i++) {
            card = pileCards[i];
            card.targetx = this.drawPile2.x + (i * 1);
            card.targety = this.drawPile2.y + (i * 1);
            card.targetz = i;
            card.isDragable = false;
            card.isFlipped = true;
            card.isVisible = false;
            this.drawPile2.visible = true;
            this.drawPile2a.visible = true;
        }
        if (pileCards.length == 0) {
            this.drawPile2.visible = false;
            this.drawPile2a.visible = false;
        }

        var pileCards = this.speed.getPile("hs1");
        for (var i = 0; i < pileCards.length; i++) {
            card = pileCards[i];
            card.targetx = this.hs1.x;
            card.targety = this.hs1.y;
            card.targetz = i;
            //card.speed = 12;
            card.isDragable = false;
            card.isFlipped = false;
            card.isVisible = true;
            if (i < pileCards.length - 3) card.isVisible = false;
        }
        var pileCards = this.speed.getPile("hs2");
        for (var i = 0; i < pileCards.length; i++) {
            card = pileCards[i];
            card.targetx = this.hs2.x;
            card.targety = this.hs2.y;
            card.targetz = i;
            card.isDragable = false;
            card.isFlipped = false;
            card.isVisible = true;
            if (i < pileCards.length - 3) card.isVisible = false;
        }

        //should do all this above and not set it on the model
        ////update UI
        for (var i = 0; i < this.speed.cards.length; i++) {
            card = this.speed.cards[i];
            // this.MoveElement(card.id, card.targetx, card.targety, card.targetz, card.fliped, card.isVisible, card.speed);
            var sprite = this.cardUIs[card.id];
            sprite.targetx = card.targetx;
            sprite.targety = card.targety;
            // sprite.z = card.targetz;
            sprite.targetz = card.targetz;
            sprite.speed = card.speed;
            sprite.visible = card.isVisible;
            sprite.inputEnabled = card.isDragable;
            if (!card.isDragable) sprite.dragging = false;
            sprite.disableAutoDrop = !card.isDragable;
        }


        if (msg === "MoveCardToPile") {

            var values = value.split(":");
            var moveCard = values[0];
            var moveToPlie = values[1];
            var moveToSpeed = values[2];
            //tween card
            var sprite = this.cardUIs[moveCard];
            if (moveToPlie === "hs1") {
                sprite.tweenx = this.hs1.x;
                sprite.tweeny = this.hs1.y;
            }
            if (moveToPlie === "hs2") {
                sprite.tweenx = this.hs2.x;
                sprite.tweeny = this.hs2.y;
            }
            sprite.dragging = true;
            sprite.disableAutoDrop = true;
            sprite.zold = sprite.z;
            sprite.z = 1000;
            // this.cardLayer.children.sort(this.depthCompare);
            // this.cardLayer.sort();
            // + 25 to avoid a glitch when matching tween with models timer
            var tween = this.add.tween(sprite).to({ x: sprite.tweenx, y: sprite.tweeny }, Number(moveToSpeed) , Phaser.Easing.Cubic.Out, true, 0, 0);
            //tween.onComplete.add(function () {
            //    this.moveCardsToPiles("PostMoveCardToPile");
            //}, this);
            // tween.onComplete.add(this.moveCardsToPiles, this);
            tween.onComplete.add(function () {
                this.sprite.dragging = false;
                this.sprite.disableAutoDrop = false;
                this.this.moveCardsToPiles("PostMoveCardToPile");
            }, { this: this, sprite: sprite });
        }

        //tween v2 - can be done on update msg
        for (key in this.cardUIs) {
            var sprite = this.cardUIs[key];
            if (sprite.dragging === true) continue;
            if (sprite.z !== sprite.targetz) sprite.z = sprite.targetz;

            if (sprite.tweenx != sprite.targetx || sprite.tweeny != sprite.targety) {
                sprite.tweenx = sprite.targetx;
                sprite.tweeny = sprite.targety;
                sprite.z = sprite.targetz;

                //  this.add.tween(sprite).to({ x: sprite.tweenx, y: sprite.tweeny },400, Phaser.Easing.Cubic.Out, true, false, false);
                //  this.add.tween(sprite).to({ x: sprite.tweenx, y: sprite.tweeny }, 400, Phaser.Easing.Cubic.Out, true, 0, 0, false);
                var moveSpeed = this.speed.computerDelay;
                this.add.tween(sprite).to({ x: sprite.tweenx, y: sprite.tweeny }, 300, Phaser.Easing.Cubic.Out, true);
            }

        }
        this.cardLayer.sort();
        //  this.cardLayer.children.sort(this.depthCompare);



        if (msg === "hint") {
            if (value === "pull") {
                //highlight pull piles
                var tween = this.add.tween(this.pullPile1).to({ alpha: 0 }, 250, Phaser.Easing.Linear.None, true, false, 5, true);
                var tween = this.add.tween(this.pullPile2).to({ alpha: 0 }, 250, Phaser.Easing.Linear.None, true, false, 5, true);
            }
            else if (value === "hand1") {
                //highlight draw pile
                var tween = this.add.tween(this.drawPile1).to({ alpha: 0 }, 250, Phaser.Easing.Linear.None, true, false, 5, true);
            }
            else {
                //highlight card
                var cardUI = this.cardUIs[value];
                if (cardUI != undefined)
                    var tween = this.add.tween(cardUI).to({ alpha: 1 / 3 }, 250, Phaser.Easing.Linear.None, true, false, 5, true);
                //var tween = this.add.tween(cardUI).to({ tint: 0xff00ff }, 250, Phaser.Easing.Linear.None, true, false, 5, true);
            }
        }
        if (msg === "blocked") {
        }
        if (msg === "combo") {
            this.textblock.text = value;
            this.textblock.alpha = 1;
            var tween = this.add.tween(this.textblock).to({ alpha: 0 }, 3000, Phaser.Easing.Exponential.In, true, false, 0, false);

        }
        // if (msg === "playerChanged") {
        if (this.speed.PlayerTop && this.speed.PlayerTop.name && this.txtProfile1.text !== this.speed.PlayerTop.name) {
            if (this.speed.PlayerTop.name !== undefined) this.txtProfile1.text = this.speed.PlayerTop.name || 'Player';
            if (this.speed.PlayerTop.rank !== undefined) this.txtProfile1Rank.text = this.speed.PlayerTop.rank || '';
            if (this.speed.PlayerTop.avatar)
                this.dynamicUpdateTexture(this.game, this.imgProfile1, this.speed.PlayerTop.avatar, 'Profile1');

        }
        if (this.speed.PlayerBottom && this.speed.PlayerBottom.name && this.txtProfile2.text !== this.speed.PlayerBottom.name) {
            if (this.speed.PlayerBottom.name !== undefined) this.txtProfile2.text = this.speed.PlayerBottom.name || 'Player';
            if (this.speed.PlayerBottom.rank !== undefined) this.txtProfile2Rank.text = this.speed.PlayerBottom.rank || '';
            if (this.speed.PlayerBottom.avatar)
                this.dynamicUpdateTexture(this.game, this.imgProfile2, this.speed.PlayerBottom.avatar, 'Profile2');

        }

        // }
        //if (msg === "message") {
        //    this.textblock.text = value;
        //    this.textblock.alpha = 1;
        //    var tween = this.add.tween(this.textblock).to({ alpha: 0 }, 3000, Phaser.Easing.Exponential.In, true, false, 0, false);

        //}

        if (msg === "updateLayout") {
             this.updateLayout();
        }
        if (this.speed.state === "GameOver") {
            var totalTime = this.speed.elaspedTime;
            var minutes = Math.floor(totalTime / 60);
            var seconds = Math.round((totalTime - minutes * 60) * 100) / 100;
            var blockCount = this.speed.blockedCount;
            var maxStreakCount = this.speed.maxStreakCount;
            this.txtGameOverMessage.text = this.speed.winnerMsg;// + "\n" + minutes + ":" + seconds;
            this.txtGameOverTime.text = minutes + ":" + seconds;
            this.gameOverLayer.visible = true;
            this.gameOverLayer.alpha = 0;
            this.add.tween(this.gameOverLayer).to({ alpha: 1 }, 2000, Phaser.Easing.Cubic.Out, true, false, false);

            /////html end screen/////
            var divEndScreen = document.getElementById('divEndScreen');
            divEndScreen.style.display = "block";
            //hide game
            var gameDiv = document.getElementById('gameDiv');
            gameDiv.style.display = "none";
            //show values
            document.getElementById('txtGameOverMessage').innerHTML = this.speed.winnerMsg;
            document.getElementById('txtGameOverTime').innerHTML = minutes + ":" + seconds;
            document.getElementById('txtBlocks').innerHTML = blockCount;
            document.getElementById('txtStreaks').innerHTML = maxStreakCount;

            //show Achievements
            var storage = new Statistics();
            var achievementManager = new Achievement();
            var listElement = document.getElementById('listAchievements');
            listElement.innerHTML = '';
            for (i in this.speed.newAchievements) {

                var achievementKey = this.speed.newAchievements[i];
                var achievement = achievementManager.getAchievement(achievementKey);
                var listItem = document.createElement("li");
                // add the item text
                listItem.innerHTML = "<img  src='images/Achievements/" + achievement.Image + "' /><div class='title'>" + achievement.Title + "</div><div  class='description'>" + achievement.Description + "</div>";
                // add listItem to the listElement
                listElement.appendChild(listItem);
            }
        }


        // if (this.state === "Playing") $('#gameWrapper').removeClass("gameOver");
        // if (msg === "message") $('#message').text(value);
    }


};
