/// <reference path="js/SpeedCore.js" />
function PlayerComputer(game, level, position) {
    //public
    this.game = game;
    this.name = level;
    this.avatar ;
    this.playerPosition = position;
    this.computerTimer;
    this.computerDelay;
    this.isLocal = false;

    //private
    var _this = this;
    var _pullWaitCounter = 0;

    this.gameEvent = function (message, value, location, player) {

        if (message == "start") _this.startComputer();
        if (message == "pause") _this.pause();
        if (message == "resume") _this.resume();
        if (message == "dispose") _this.dispose();
        if (message == "destroy") _this.destroy();
        if (message == "gameover") _this.gameover();
        if (message == "pull") {
            _pullWaitCounter = 2; //wait 2 cycles
        }
    };

    this.start = function () {
        _this.startComputer();
    }

    this.pause = function () {
        _this.stopComputer();
    }
    this.resume = function () {
        _this.startComputer();
    }
    this.destroy = function () {
        _this.stopComputer();
    }

    this.gameover = function () {
        _this.stopComputer();
    }
    this.stopComputer = function () {
        clearTimeout(_this.computerTimer);
    }
    this.startComputer = function (computerName) {
        if (!computerName) computerName = _this.name;

        _this.computerDelay = 500;
        var dualComputer = false;
        if (_this.name === "None") return;
        if (_this.name === "Easy") {
            _this.computerDelay = 900;
            _this.avatar = 'images/Avatars/Easy.png';
            _this.rank = "";
        }
        if (_this.name === "Medium") {
            _this.computerDelay = 600;
            _this.avatar = 'images/Avatars/Medium.png';
            _this.rank = "";
        }
        if (_this.name === "Hard") {
            _this.computerDelay = 450;
            _this.avatar = 'images/Avatars/Hard.png';
            _this.rank = "";
        }
        if (_this.name === "CrazyNinja") {
            _this.computerDelay = 350;
            _this.avatar = 'images/Avatars/CrazyNinja.png';
            _this.rank = "";
        }
        if (_this.name === "InsaneMonkey") {
            _this.computerDelay = 290;
            _this.avatar = 'images/Avatars/InsaneMonkey.png';
            _this.rank = "";
        }
        if (_this.name === "Test") {
            _this.computerDelay = 450;
            _this.avatar = 'images/Avatars/default-avatar.png';
        }
        if (_this.name === "Online") {
            //todo:add network
            return;
        }

        //set top if not set 
        if (!_this.playerPosition) _this.playerPosition = "Top";

        _this.computerTimer = setInterval(function () {
            _this.onComputerPlay(_this.playerPosition);
        }, _this.computerDelay);
    }

    this.onComputerPlay = function (playerPosition) {


        if (game.state === "GameOver") return;

        playerPosition = playerPosition || "Top";

        var cardsHand = game.getPile("hand2");
        var cardsDraw = game.getPile("draw2");

        if (playerPosition == "Bottom") {
            cardsHand = game.getPile("hand1");
            cardsDraw = game.getPile("draw1");
        }

        //one action per loop
        var computerSelectedCard;

        //sleep after pull card, as to not look like cheating
        //if last even was pull, wait 2-3 cycles
        if (_pullWaitCounter > 0) {
            _pullWaitCounter = _pullWaitCounter - 1;
            return;
        }

        //any card in hand
        if (cardsHand.length > 0) {
            //selectNextcard in hand

            //if dragging wait
            for (var i = 0; i < cardsHand.length; i++) {
                if (cardsHand[i].dragging === true) return;
            }


            //find current card
            for (var i = 0; i < cardsHand.length; i++) {
                if (cardsHand[i].selected === true) computerSelectedCard = i;
            }

            //next card
            if (computerSelectedCard === undefined) computerSelectedCard = 0;
            else computerSelectedCard++;

            //select first card
            if (computerSelectedCard >= cardsHand.length)
                computerSelectedCard = 0;


            //reset selected card
            for (var i = 0; i < cardsHand.length; i++) {
                cardsHand[i].selected = false;
            }

            //todo: this should be in the speed class
            var selectedCard = cardsHand[computerSelectedCard];
            selectedCard.selected = true;
            game.message("selectedCardChanged", selectedCard);

            var computerMoveCardSpeed = _this.computerDelay;//1000;

            //try play card (action)
            if (game.canDrop(selectedCard, "hs1")) {
                selectedCard.dragging = true;

                //todo: this should be in the speed class
                game.message("MoveCardToPile", selectedCard.id + ":hs1:" + computerMoveCardSpeed);
                setTimeout(function () {
                    game.tryPlayCard(selectedCard, "hs1");
                    selectedCard.dragging = false;
                }, computerMoveCardSpeed);
                return;
            }
            if (game.canDrop(selectedCard, "hs2")) {
                selectedCard.dragging = true;
                game.message("MoveCardToPile", selectedCard.id + ":hs2:" + computerMoveCardSpeed);
                setTimeout(function () {
                    game.tryPlayCard(selectedCard, "hs2");
                    selectedCard.dragging = false;
                }, computerMoveCardSpeed);
                return;
            }
            //   if (game.tryPlayCard(selectedCard, "hs1") === true) return;
            //  if (game.tryPlayCard(selectedCard, "hs2") === true) return;

        }



        //draw more cards (action)
        if (cardsHand.length < 5 && cardsDraw.length > 0) {
            if (playerPosition === "Top" && game.FillHand2() === true) return;
            if (playerPosition === "Bottom" && game.FillHand1() === true) return;
        }


        //get last card played
        var lastCardPlayed = null;
        for (var i in game.eventLog) {
            if (game.eventLog[i].message === 'cardMoved') lastCardPlayed = game.eventLog[i];
        }

        //try to pull
        if (lastCardPlayed != null && game.getElaspedTime() - lastCardPlayed.timestamp > 5) {
            if (game.canPull() === true) {
                game.pull();
                return;
            }
        }




    }
}