/// <reference path="js/socket.io-1.0.3.js" />
/// <reference path="js/SpeedCore.js" />

//todo: send message to speed core to display in game like "player disconnected", could be used for computer to as a taunt
function PlayerSocketIO(game, name, localPlayer) {
    //public = this.
    this.game = game;
    this.name = name;
    this.isLocal = false;
    this.localPlayer = localPlayer;
    this.readyEvent = function () { };
    this.matchFoundEvent = function () { };
    this.gameStartEvent = function () { };
    this.onGetRoomEvent = function () { };
    //private var
    var _this = this;
    var serverUrl = 'http://jimmyinteractive.com:8001'
    //var serverUrl = 'http://localhost:8001';
    var socket = io(serverUrl);
    //var socket = io();
    // var socket = io('http://localhost:8001/');
    socket.on("connect", function () {
        startTime = Date.now();
        socket.emit('ping');
        getRooms();

        if (_this.localPlayer) {
            var user = {
                id: _this.localPlayer.id || Math.floor((Math.random() * 10000) + 1),
                name: _this.localPlayer.name || "NoName",
                avatar: _this.localPlayer.avatar || "images/default-avatar.png",
                rank: _this.localPlayer.rank || "Bronze",
                rating: _this.localPlayer.rating || 1000
            }
            socket.emit('login', user);
        }
            //default for testing
        else {

            var user = {
                id: Math.floor((Math.random() * 10000) + 1),
                name: "jimmy",
                avatar: "images/default-avatar.png",
                rank: 1233,
                rating: "Gold"
            }
            socket.emit('login', user);
        }
    });
    socket.on('message', function (data) {
        logMessage('<-- message', data);
        if (data === "Ready") {
            _this.readyEvent();
        }
    });
    socket.on('matchFound', function (data) {
        logMessage('<-- matchFound', data);

        _this.name = 'Searching...';
        _this.avatar = 'images/avatars/default-avatar.png';

        //todo: who is player 1 and who is player 2?

        //todo: there should be a better way to know who's the remote player
        if (data.users[0] && _this.localPlayer.name !== data.users[0].name) {
            _this.name = data.users[0].name;
            _this.avatar = data.users[0].avatar;
            _this.rank = data.users[0].rank;
        }
        if (data.users[1] && _this.localPlayer.name !== data.users[1].name) {
            _this.name = data.users[1].name;
            _this.avatar = data.users[1].avatar;
            _this.rank = data.users[1].rank;
        }
        _this.game.message("playerChanged");
     
        _this.matchFoundEvent(data);
    });
    socket.on('gameStart', function (data) {
        logMessage('<-- gameStart', data);

       
        _this.game.message("playerChanged");
        _this.onGetRoomEvent(data);
        _this.gameStartEvent(data);
    });

    socket.on('joined', function (data) {
        logMessage('<-- joined', data);
        getRoom(data);
    });
    socket.on('roomChanged', function (data) {
        logMessage("<-- roomChanged", data);
        getRoom(data);

    });
    socket.on('getRoom', function (data) {
        logMessage("<-- getRoom", data);
        //var lblRoom = document.getElementById("lblRoom");
        //lblRoom.innerHTML = data.name;
        //var lstUsers = document.getElementById("lstUsers");
        //lstUsers.length = 0;
        //for (i = 0; i < data.users.length; i++) {
        //    var user = data.users[i];
        //    var el = document.createElement("option");
        //    el.textContent = user.id;
        //    el.value = user.id;
        //    lstUsers.appendChild(el);
        //}

        _this.name = 'Searching...';
        _this.avatar = 'images/avatars/default-avatar.png';
        //todo: there should be a better way to konw who is the remove player
        if (data.users[0] && _this.localPlayer.name !== data.users[0].name) {
            _this.name = data.users[0].name;
            _this.avatar = data.users[0].avatar;
        }
        if (data.users[1] && _this.localPlayer.name !== data.users[1].name) {
            _this.name = data.users[1].name;
            _this.avatar = data.users[1].avatar;
        }
        _this.game.message("playerChanged");
        _this.onGetRoomEvent(data);
    });
    socket.on('getRooms', function (data) {
        logMessage("<-- getRooms", data);
        //var lstRooms = document.getElementById("lstRooms");
        //lstRooms.length = 0;
        //for (i = 0; i < data.length; i++) {
        //    var room = data[i];
        //    var el = document.createElement("option");
        //    el.textContent = room;
        //    el.value = room;
        //    lstRooms.appendChild(el);
        //}
    });
    socket.on('pong', function () {
        latency = Date.now() - startTime;
        logMessage("<-- pong", latency);
    });

    var logMessage = function (event, data) {
        console.log(data);
        //var txtLog = document.getElementById("txtLog")
        //var m = new Date();
        //var dateString = m.getUTCHours() + ":" + m.getUTCMinutes() + ":" + m.getUTCSeconds();
        //txtLog.value = dateString + ": " + event + ": " + JSON.stringify(data) + " \n" + txtLog.value;
        ////var outputDiv = document.getElementById("output")
        ////outputDiv.innerHTML += "<div>" + JSON.stringify(data) + "</div>"
    }
    this.sendMessage = function (data) {
        socket.emit('message', data);
        logMessage("--> message", data);
    };
    this.sendLogin = function (data) {
        socket.emit('login', data);
        //socket.emit('login', {
        //    id: "123",
        //    name: "jimmy",
        //    avatar: "https://graph.facebook.com/560706963/picture?type=normal",
        //    rank: 1233,
        //    rating: "Gold"
        //});
        logMessage("--> login", data);
    };
    var ping = function () {
        startTime = Date.now();
        socket.emit('ping');
        logMessage("--> ping", 0);
    };
    var startTime = Date.now();

    var joinRoom = function (data) {
        //clearLogs();
        socket.emit('joinRoom', data);
        logMessage("--> joinRoom", data);
    };
    var getUsers = function (data) {
        socket.emit('getUsers', data);
        logMessage("--> getUsers", data);
    };
    var getRooms = function (data) {
        socket.emit('getRooms', data);
        logMessage("--> getRooms", data);
    };
    var getRoom = function (data) {
        socket.emit('getRoom', data);
        logMessage("--> getRoom", data);
    };
    var clearLogs = function () {
        txtLog.value = "";
    };

    socket.on('message', function (data) {

        //todo:do action in the game
        //filter messages to command here even, if close, dont need 100% dependcy
        //but could have a text based action function for th game, like CLI
        //var msgArray = data.split("|");
        //if(msgArray[0] == 'cardMoved'){
        //    speed.addToPile(speed.getCard("card" + msgArray[1]), msgArray[2], "network");
        //}
        ////if (msgArray[0] == 'trydrop') {
        ////    speed.moveCardToPile(speed.getCard("card" + msgArray[1]), msgArray[2],300, "network");
        ////}
        ////network predict animation
        //if (msgArray[0] == 'startDrag') {
        //    //todo: find pile it can play on, if any
        //    speed.moveCardToPile(speed.getCard("card" + msgArray[1]), "hs1", 300, "network");
        //}
        // var msgArray = data.split("|");
        if (data.message == 'cardMoved') {
            _this.game.addToPile(_this.game.getCard("card" + data.value), data.location, "network");
        }
        //network predict animation
        if (data.message == 'startDrag') {
            //todo: find pile it can play on, if any
            var tryDropPile = "hs1";
            var canDropHs2 = _this.game.canDrop(_this.game.getCard("card" + data.value), "hs2");
            if (canDropHs2) tryDropPile = "hs2";
            _this.game.moveCardToPile(_this.game.getCard("card" + data.value), tryDropPile, 300, "network");
        }
        if (data.message == 'setUpGame') {
            if (data.value) {
                _this.game.cards = data.value;
                _this.game.updateUI("network");
            }
        }

    });

    //todo: the model could send en event and this class listen to it, or it get called directly from the model as done below
    this.gameEvent = function (message, value, location, player) {
        //todo: filter messages
        //todo: only send msg i didnt create
        // if (player !== "network")
        //     sendMessage(message + "|" +JSON.stringify( value )+ "|" + location + "|" + player)
        if (player !== "network" && message != "stopDrag")
            this.sendMessage({ message: message, value: value, location: location, player: player });

    };

}