/// <reference path="js/PlayerLocal.js" />
function Card(a) {
    this.id = a;
    this.number = "2"
    this.suit = "s";
    this.pile = "main";
    this.pilez = 0;
    this.showfront = true;
    this.cardUI = null;
}
function Pile() { }
Pile.prototype = new Array;

function Deck() {
    this.createDeck = function () {
        var cards = [];
        for (var i = 1; i < 14; i++) {
            var card = new Card();
            card.id = i + "s";
            card.number = i;
            card.suit = "s";
            card.cardUI = "card" + i + "s";
            cards.push(card);
        }
        for (var i = 1; i < 14; i++) {
            var card = new Card();
            card.id = i + "c";
            card.number = i;
            card.suit = "c";
            card.cardUI = "card" + i + "c";
            cards.push(card);
        }
        for (var i = 1; i < 14; i++) {
            var card = new Card();
            card.id = i + "d";
            card.number = i;
            card.suit = "d";
            card.cardUI = "card" + i + "d";
            cards.push(card);
        }
        for (var i = 1; i < 14; i++) {
            var card = new Card();
            card.id = i + "h";
            card.number = i;
            card.suit = "h";
            card.cardUI = "card" + i + "h";
            cards.push(card);
        }
        cards = this.shuffle(cards);
        return cards;
    }
    this.shuffle = function (array) {
        var currentIndex = array.length, temporaryValue, randomIndex;

        // While there remain elements to shuffle...
        while (0 !== currentIndex) {

            // Pick a remaining element...
            randomIndex = Math.floor(Math.random() * currentIndex);
            currentIndex -= 1;

            // And swap it with the current element.
            temporaryValue = array[currentIndex];
            array[currentIndex] = array[randomIndex];
            array[randomIndex] = temporaryValue;
        }

        return array;
    }
}

function Speed() {
    //public
    this.state = "Playing";
    this.winner = null;
    this.loser = null;
    this.cards = [];
    this.player1 = "Jimmy";
    this.player2 = "Hard";

    //todo:fix change to event instead of 2 function callbacks
    this.onMessage = function (message, value) { };
    this.onMessage2 = function (message, value) { };
    this.onMessage3 = function (message, value) { };
    this.PlayerTop = new PlayerLocal(this, "Player2");
    this.PlayerBottom = new PlayerLocal(this, "Player1");

    this.messageTip = "";
    this.eventTimer;
    this.elaspedTime;
    this.lastCardPlayedTime = Date.now();
    this.blockedCount = 0;
    this.maxStreakCount = 0;
    this.newAchievements = [];
    this.eventLog = [];
    this.debug = false;//todo: change to false when prod

    //private var
    var _this = this;

    //simple console polyfill
    window.console = window.console || { log: function () { } };

    var deck = new Deck();
    this.cards = deck.createDeck();


    this.message = function (message, value, location, player) {

        if (console.log != undefined && this.debug == true) console.log(message + " : " + value + " : " + location + " : " + this.getElaspedTime());

        this.eventLog.push({ 'message': message, 'value': value, 'location': location, 'player': player, timestamp: this.getElaspedTime() });

        //todo:fix change to event instead of 2 function callbacks
        this.onMessage(message, value, location, player);
        this.onMessage2(message, value, location, player);
        this.onMessage3(message, value, location, player);

        if (this.PlayerTop) this.PlayerTop.gameEvent(message, value, location, player);
        if (this.PlayerBottom) this.PlayerBottom.gameEvent(message, value, location, player);


        //check for complex events
        //blocked
        if (message === 'trydrop') {

            //get last card played
            var lastCardPlayed = null;
            for (var i in this.eventLog) {
                if (this.eventLog[i].message === 'cardMoved') lastCardPlayed = this.eventLog[i];
            }

            if (lastCardPlayed != null && lastCardPlayed.location == location) {
                //todo: fix for player local not player1
                this.message('blocked', value, location, player);
            }
        }
        //block combos
        if (message === 'blocked' && player == 'Player2') {
            this.blockedCount = 0;
            for (var i in this.eventLog) {
                if (this.eventLog[i].message === 'blocked' && this.eventLog[i].player == 'Player2')
                    this.blockedCount++;
            }
            //show message for block combos
            if (this.blockedCount == 1) this.message('combo', "Block", location, player);
            if (this.blockedCount == 2) this.message('combo', "Double Block (2x)", location, player);
            if (this.blockedCount == 3) this.message('combo', "Ninja Block (3x)", location, player);
            if (this.blockedCount == 4) this.message('combo', "Crazy Ninja Block (4x)", location, player);
            if (this.blockedCount == 5) this.message('combo', "Ultra Crazy Ninja Block (5x)", location, player);
            if (this.blockedCount > 5) this.message('combo', "Ultra Crazy Ninja Block (" + this.blockedCount + "x)", location, player);
        }
        //streaks combo
        if (message === 'cardMoved' && player == 'Player1' && (location == 'hs1' || location == 'hs2')) {
            var streakCount = 0;
            for (var i = this.eventLog.length - 1; i >= 0; i--) {
                if (this.eventLog[i].message === 'cardMoved' && this.eventLog[i].player == 'Player1' && (this.eventLog[i].location == 'hs1' || this.eventLog[i].location == 'hs2'))
                    streakCount++;
                if (this.eventLog[i].message === 'cardMoved' && this.eventLog[i].player == 'Player2' && (this.eventLog[i].location == 'hs1' || this.eventLog[i].location == 'hs2'))
                    break;
            }
            //show message for Streak combos
            if (streakCount == 3) this.message('combo', "Streak (3x)", location, player);
            if (streakCount == 4) this.message('combo', "Streak (4x)", location, player);
            if (streakCount == 5) this.message('combo', "Great Streak (5x)", location, player);
            if (streakCount == 6) this.message('combo', "Super Streak (6x)", location, player);
            if (streakCount == 7) this.message('combo', "Crazy Streak (7x)", location, player);
            if (streakCount == 8) this.message('combo', "On Fire Streak (8x)", location, player);
            if (streakCount == 9) this.message('combo', "Ninja Streak (9x)", location, player);
            if (streakCount > 9) this.message('combo', "Crazy Ninja Streak (" + streakCount + "x)", location, player);

            if (streakCount > this.maxStreakCount) this.maxStreakCount = streakCount;
        }
        //todo:Straight combo
        //todo:flush combo
    };
    this.setUpGame = function () {
        this.state = "Playing";
        var deck = new Deck();
        deck.shuffle(this.cards);
        //this.cards = deck.createDeck();
        for (var i = 0; i < this.cards.length; i++) {
            card = this.cards[i];
            card.pile = "deck";
            card.pilez = i;
        }
        for (var i = 0; i < 5; i++) {
            card = this.cards[i];
            card.pile = "hand1";
            card.pilez = i;
        }
        for (var i = 5; i < 10; i++) {
            card = this.cards[i];
            card.pile = "hand2";
            card.pilez = i;
        }
        for (var i = 10; i < 20; i++) {
            card = this.cards[i];
            card.pile = "draw1";
            card.pilez = i;
        }
        for (var i = 20; i < 30; i++) {
            card = this.cards[i];
            card.pile = "draw2";
            card.pilez = i;
        }

        card = this.cards[30];
        card.pile = "hs1";
        card = this.cards[31];
        card.pile = "hs2";

        for (var i = 32; i < 42; i++) {
            card = this.cards[i];
            card.pile = "pull1";
            card.pilez = i;
        }
        for (var i = 42; i < 52; i++) {
            card = this.cards[i];
            card.pile = "pull2";
            card.pilez = i;
        }
        //serialize the cards and piles
        this.message("setUpGame", this.cards);
     


    }

    this.start = function () {

        this.state = "Playing";
        this.startTime = Date.now();
        this.message("start", null);
        this.startEventTimer();
    }
    this.startEventTimer = function () {
        var t = this;
        this.eventTimer = setInterval(function () { t.onEventTimer(); }, 4000);
    }
    this.stopEventTimer = function () {
        clearTimeout(this.eventTimer);
    }
    this.getElaspedTime = function () {
        return (Date.now() - this.startTime) / 1000;
    }
    this.updateUI = function (player) {
        this.message("updateUI", null, null, player);
    }
    this.updateLayout = function (player) {
        this.message("updateLayout", null, null, player);
    }
    this.onEventTimer = function () {
        //check for hints if no card played for 5 seconds
        if (this.getElaspedTime() - this.lastCardPlayedTime > 5000) {

            //check if can pull
            if (this.canPull()) {
                this.message("hint", "pull");
                return;
            }

            //check if player can fill hand
            if (this.canFillHand1()) {
                this.message("hint", "hand1");
                return;
            }

            //hint card to play
            var handCards = this.getPile("hand1");
            for (var i = 0; i < handCards.length; i++) {
                var card = handCards[i];
                if (this.canDrop(card, "hs1")) {
                    this.message("hint", handCards[i].id);
                    return;
                }
                if (this.canDrop(card, "hs2")) {
                    this.message("hint", handCards[i].id);
                    return;
                }
            }

        }
    }
    this.canDrop = function (card, pileName) {

        var pileCards = this.getPile(pileName);

        //could be a pile class that has the logic
        if (pileName === "hs1" || pileName === "hs2") {
            var topCard = pileCards[pileCards.length - 1];
            if (topCard === undefined) return true;
            if (topCard.number === card.number + 1) return true;
            if (topCard.number === card.number - 1) return true;
            if (topCard.number === 1 && card.number === 13) return true;
            if (topCard.number === 13 && card.number === 1) return true;

        }
        return false;
    }
    this.getPile = function (pileName) {
        var pileCards = new Array();
        for (var i = 0; i < _this.cards.length; i++) {
            card = _this.cards[i];
            if (card.pile == pileName) {
                pileCards.push(card);
            }
        }
        pileCards = this.sortByKey(pileCards, "pilez");
        return pileCards;
    }
    this.getCard = function (cardId) {
        var cards = this.cards.filter(function (obj) {
            return obj.cardUI == cardId;
        });
        var card = cards[0];
        return card;
    }
    this.addToPile = function (card, pileName, player) {

        if (card == undefined) return;

        //todo: getcard owner;
        //var player = this.getCardOwner(card);

        var pileCards = this.getPile(pileName);

        pileCards = this.sortByKey(pileCards, "pilez");
        for (var i = 0; i < pileCards.length; i++) {
            pileCards[i].pilez = i;
        }
        card.pile = pileName;
        card.pilez = pileCards.length;

        //todo: send who did the action, not owner of card or both?
        this.message("cardMoved", card.id, pileName, player);



        this.checkForGameOver();
        this.lastCardPlayedTime = Date.now();

    }
    this.sortByKey = function (array, key) {
        return array.sort(function (a, b) {
            var x = a[key];
            var y = b[key];
            return ((x < y) ? -1 : ((x > y) ? 1 : 0));
        });
    };
    this.canFillHand1 = function () {
        var drawCards = this.getPile("draw1");
        if (drawCards.length === 0) return false;

        var handCards = this.getPile("hand1");
        if (handCards.length === 5) return false;

        return true;
    }
    this.FillHand1 = function () {
        var handCards = this.getPile("hand1");
        var numberOfCardsToDraw = 5 - handCards.length;
        var drawCards = this.getPile("draw1");
        if (numberOfCardsToDraw === 0) return false;
        for (var i = 0; i < numberOfCardsToDraw; i++) {
            var card = drawCards.pop();
            this.addToPile(card, "hand1");
        }
        return true;
    }
    this.canFillHand2 = function () {
        var drawCards = this.getPile("draw2");
        if (drawCards.length === 0) return false;

        var handCards = this.getPile("hand2");
        if (handCards.length === 5) return false;

        return true;
    }
    this.FillHand2 = function () {
        var handCards = this.getPile("hand2");
        var numberOfCardsToDraw = 5 - handCards.length;
        var drawCards = this.getPile("draw2");
        if (numberOfCardsToDraw === 0) return false;
        for (var i = 0; i < numberOfCardsToDraw; i++) {
            var card = drawCards.pop();
            this.addToPile(card, "hand2");
        }
        return true;
    }

    this.canPull = function () {
        //can pull?
        var handCards1 = this.getPile("hand1");
        var drawCards1 = this.getPile("draw1");
        //hand is not full and there are cards to pull
        if (handCards1.length < 5 && drawCards1.length > 0) {
            this.message("message", "Can't pull, cause handCards1 is not full");
            return false;
        }
        //can play any cards?
        for (var i = 0; i < handCards1.length; i++) {
            if (this.canDrop(handCards1[i], "hs1") === true) {
                this.message("message", "Can't pull, cause handCards1 has a card to play on HS1");
                return false;
            }
            if (this.canDrop(handCards1[i], "hs2") === true) {
                this.message("message", "Can't pull, cause handCards1 has a card to play on HS2");
                return false;
            }
        }


        var handCards2 = this.getPile("hand2");
        var drawCards2 = this.getPile("draw2");
        //hand is not full and there are cards to pull
        if (handCards2.length < 5 && drawCards2.length > 0) {
            this.message("message", "Can't pull, cause handCards2 is not full");
            return false;
        }
        //can play any cards?
        for (var i = 0; i < handCards2.length; i++) {
            if (this.canDrop(handCards2[i], "hs1") === true) {
                this.message("message", "Can't pull, cause handCards1 has a card to play on HS1");
                return false;
            }
            if (this.canDrop(handCards2[i], "hs2") === true) {
                this.message("message", "Can't pull, cause handCards1 has a card to play on HS2");
                return false;
            }
        }
        return true;
    }
    this.pull = function () {

        if (this.canPull() === false) return false;

        //pull card
        var cardPile = this.getPile("pull1");
        var card = cardPile.pop();
        this.addToPile(card, "hs1");

        var cardPile = this.getPile("pull2");
        var card = cardPile.pop();
        this.addToPile(card, "hs2");


        this.message("pull", null);
        this.message("cardsMoved", null);
        return true;
    }
    this.checkForGameOver = function () {
        var elaspedTime = this.getElaspedTime();
        this.elaspedTime = elaspedTime;
        
       
        

        //check for winners (top)
        var cardPileHand = this.getPile("hand1");
        var cardPileDraw = this.getPile("draw1");
        if (cardPileHand.length == 0 && cardPileDraw.length == 0) {
            _this.winner = _this.PlayerBottom;
            _this.loser = _this.PlayerTop;
        }

        //check for winners (bottom)
        var cardPileHand = this.getPile("hand2");
        var cardPileDraw = this.getPile("draw2");
        if (cardPileHand.length == 0 && cardPileDraw.length == 0) {
            _this.winner = _this.PlayerTop;
            _this.loser = _this.PlayerBottom;
        }

        if (_this.winner == null) return;

        var winnerName = _this.winner.name;
        var loserName = _this.loser.name;

        this.state = "GameOver";
        this.winnerMsg = winnerName + " Wins!";
        
        //get pull count
        var pullCount = 0;
        for (var i in this.eventLog) {
            if (this.eventLog[i].message === 'pull') pullCount++;
        }
        //get last card played
        var lastCardPlayed = null;
        for (var i in this.eventLog) {
            if (this.eventLog[i].message === 'cardMoved') lastCardPlayed = this.eventLog[i];
        }


        //detect if player is local for a win
        if (_this.winner.isLocal) {
           

            var storage = new Statistics();
            storage.stats["win"]++;
            storage.sessionStats["win"]++;
            storage.increment("win_" + loserName, 1);
            storage.increment("win_streak", 1);
            storage.increment("win_streak_" + loserName, 1);
            storage.stats["lose_streak"] = 0;
            storage.stats["lose_streak" + loserName] = 0;
            storage.increment("total_blockedCount", this.blockedCount);


            if (storage.stats["fastestWinTime"] < elaspedTime || !storage.stats["fastestWinTime"]) {
                storage.stats["fastestWinTime"] = elaspedTime;
            }

            if (storage.stats["fastestWinTime_" + loserName] < elaspedTime || !storage.stats["fastestWinTime_" + loserName]) {
                storage.stats["fastestWinTime_" + loserName] = elaspedTime;
                storage.sessionStats["lastGame_newFastestTime"] = elaspedTime;
            } else {
                storage.sessionStats["lastGame_newFastestTime"] = null;
            }

            if (lastCardPlayed != null)
                storage.sessionStats["lastGame_LastCardPlayed"] = lastCardPlayed.value;
            storage.sessionStats["lastGame_PullCount"] = pullCount;
            storage.sessionStats["lastGame_Winner"] = winnerName;
            storage.sessionStats["lastGame_Level"] = loserName;
            storage.sessionStats["lastGame_blockedCount"] = this.blockedCount;
            storage.sessionStats["lastGame_maxStreakCount"] = this.maxStreakCount;

            storage.save(); //save stats


            //todo: may not need to use session if stats saves to both.


            var achievement = new Achievement();
            this.newAchievements = achievement.checkForAchievement();
            storage.sessionStats["lastGame_newAchievements"] = this.newAchievements;


        }
        if (_this.loser.isLocal && !_this.winner.isLocal) {
           

            //save stats
            var storage = new Statistics();
            storage.stats["lose"]++;
            storage.sessionStats["lose"]++;
            storage.increment("lose_" + winnerName, 1);
            storage.stats["win_streak"] = 0;
            storage.stats["win_streak_" + winnerName] = 0;
            storage.increment("lose_streak", 1);
            storage.increment("lose_streak" + winnerName, 1);
            storage.increment("total_blockedCount", this.blockedCount);

            if (lastCardPlayed != null)
                storage.sessionStats["lastGame_LastCardPlayed"] = lastCardPlayed.value;
            storage.sessionStats["lastGame_PullCount"] = pullCount;
            storage.sessionStats["lastGame_Winner"] = winnerName;
            storage.sessionStats["lastGame_Level"] = winnerName;
            storage.sessionStats["lastGame_blockedCount"] = this.blockedCount;
            storage.sessionStats["lastGame_maxStreakCount"] = this.maxStreakCount;

            storage.save();

            var achievement = new Achievement();
            this.newAchievements = achievement.checkForAchievement();
            storage.sessionStats["lastGame_newAchievements"] = this.newAchievements;

        }

        this.message("gameover", _this.winner.name);




        //todo:check for tie
        if (this.checkForTie()) {
            var storage = new Statistics();
            storage.stats["tie"]++;
            storage.sessionStats["tie"]++;
            storage.stats["tie_" + this.player2]++;
            storage.save();
        }
    }
    this.checkForPlayer1Win = function () {
        var cardPile = this.getPile("hand1");
        if (cardPile.length > 0) return false;

        var cardPile = this.getPile("draw1");
        if (cardPile.length > 0) return false;

        return true;
    }
    this.checkForPlayer2Win = function () {
        var cardPile = this.getPile("hand2");
        if (cardPile.length > 0) return false;

        var cardPile = this.getPile("draw2");
        if (cardPile.length > 0) return false;

        return true;
    }
    this.checkForTie = function () {
        return false;
    }

    this.pause = function () {
        this.message("pause");
        this.stopEventTimer();
    }
    this.resume = function () {

        this.message("resume");
        this.startEventTimer();
    }
    this.destroy = function () {
        this.message("destroy");

        this.state = "GameOver";
        this.onMessage = function () { };
        this.onMessage2 = function () { };

        this.stopEventTimer();
    }

    this.moveCardToPile = function (card, pileName, speed, player, callback) {
        this.message("MoveCardToPile", card.id + ":" + pileName + ":" + speed, pileName, player);

        //todo: run call back after time
        //todo: have computer use this and not own timer

        //selectedCard.dragging = true;
        //this.message("MoveCardToPile", selectedCard.id + ":hs2:" + computerMoveCardSpeed);
        //setTimeout(function () {
        //    t.tryPlayCard(selectedCard, "hs2");
        //    selectedCard.dragging = false;
        //}, computerMoveCardSpeed);
    }
    this.tryPlayCard = function (card, pileName, player) {
        //var player = this.getCardOwner(card);//todo: might be part of the card properties later
        if (!player) player = this.getCardOwner(card);//todo: might be part of the card properties later
        if (this.canDrop(card, pileName)) {
            this.message("Drop", card.id, pileName, player);
            this.addToPile(card, pileName, player);
            return true;
        }

        this.message("trydrop", card.id, pileName, player);
        return false;
    }
    this.getCardOwner = function (card) {
        if (card == undefined) return;

        if (card.pile == 'draw1') return "Player1";
        if (card.pile == 'hand1') return "Player1";
        if (card.pile == 'draw2') return "Player2";
        if (card.pile == 'hand2') return "Player2";
        return null;
    }


}
