function Statistics() {
    this.stats = {
        'game_open': 0,
        'win': 0,
        'lose': 0,
        'tie': 0,
        'win_Easy': 0,
        'win_Medium': 0,
        'win_CrazyNinja': 0,
        'lose_Easy': 0,
        'lose_Medium': 0,
        'lose_Hard': 0,
        'lose_Crazy Ninja': 0
    };
    this.sessionStats = {
        'win': 0,
        'lose': 0
    };
    //update session and perm stats
    this.add = function (key, value) {
        this.stats[key] = value;
        this.sessionStats[key] = value;
       
        this.save();//could od a save when done manually or save when app is closing
    }
    //update session and perm, and add/subtract from the current stat
    this.increment = function (key, value) {
        if (this.stats[key] === undefined) this.stats[key] = 0;
        if (this.sessionStats[key] === undefined) this.sessionStats[key] = 0;
        this.stats[key] += value;
        this.sessionStats[key] += value;
        this.save();//could od a save when done manually or save when app is closing
    }
    this.clear = function () {
        delete localStorage; //has an ie11 bug so use delete- localStorage.clear(); // https://github.com/pouchdb/pouchdb/issues/1905 
        delete sessionStorage;  //has an ie11 bug so use delete - sessionStorage.clear();
    }
    this.save = function () {
        // Put the object into storage
        localStorage.stats= JSON.stringify(this.stats);
        sessionStorage.sessionStats= JSON.stringify(this.sessionStats);
    }
    this.load = function () {

        //could be one object, or two one for session and one for storage, or all three
        //get stats
        var data = localStorage.getItem('stats');
        if (data !== null) this.stats = JSON.parse(data);

        //load defaults
        if (this.stats["win_Easy"] === undefined)this.stats["win_Easy"] = 0;
        if (this.stats["win_Medium"] === undefined) this.stats["win_Medium"] = 0;
        if (this.stats["win_Hard"] === undefined) this.stats["win_Hard"] = 0;
        if (this.stats["win_CrazyNinja"] === undefined) this.stats["win_CrazyNinja"] = 0;
        if (this.stats["lose_Easy"] === undefined) this.stats["lose_Easy"] = 0;
        if (this.stats["lose_Medium"] === undefined) this.stats["lose_Medium"] = 0;
        if (this.stats["lose_Hard"] === undefined) this.stats["lose_Hard"] = 0;
        if (this.stats["lose_CrazyNinja"] === undefined) this.stats["lose_CrazyNinja"] = 0;




        //get session data
        var dataSession = sessionStorage.getItem('sessionStats');
        if (dataSession !== null) this.sessionStats = JSON.parse(dataSession);

    }
    this.load();
}