/// <reference path="cordova.js" />
/// <reference path="js/Settings.js" />
/// <reference path="js/Statistics.js" />
/// <reference path="js/Achievement.js" />
/// <reference path="js/platform.js" />
/// <reference path="js/Analytics.js" />
/// <reference path="js/openfb.js" />
/// <reference path="js/MarketPlace.js" />
/// <reference path="js/AnalyticsGA.js" />

//(function (d, s, id) {
//    var js, fjs = d.getElementsByTagName(s)[0];
//    if (d.getElementById(id)) return;
//    js = d.createElement(s); js.id = id;
//    js.src = "https://connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.3&appId=158327870889130";
//    fjs.parentNode.insertBefore(js, fjs);
//}(document, 'script', 'facebook-jssdk'));

var rateGame = function () {

    var achievement = new Achievement();
    achievement.addAchievement("Rate Game");
    MarketPlace.rateGame();
    new Achievement().addAchievement("Rate Game");

}
function loadPage() {

    document.addEventListener('deviceready', onDeviceReady, false);

    var os = platform.os.family;
    var manufacturer = platform.manufacturer;
    if (manufacturer === "Amazon") os = "Amazon";
    if (os === "Windows Phone OS") os = "WindowsPhone";
    if (os === "Windows") os = "Web";

    Analytics.TrackStart("Speed" + os, "2.0.1.1");
    Analytics.Track("PageView", "MainMenu");


    AnalyticsGA.TrackStart("Speed" + os, "2.0.1.1");
    AnalyticsGA.TrackPage("MainMenu");

    var stats = new Statistics();
    if (stats.sessionStats["game_open"] === undefined) stats.increment("game_open", 1);
    if (stats.stats["first_open_date"] === undefined) stats.add("first_open_date", Date.now());
    stats.save();

    var achievement = new Achievement();
    achievement.checkForAchievement();

    var progbar = document.getElementById("progressAchievements");
    progbar.value = achievement.achievements.length;
    progbar.max = achievement.allAchievements.length;

    ////hide rate bar
    //var os = platform.os.family;
    //var manufacturer = platform.manufacturer;
    //if (os === "Android" && manufacturer === "Amazon") {
    //    document.getElementById("rateButton").style.display = "none";
    //}


    var settings = new Settings();
    //populate user profile tag

    document.getElementById("player1Name").innerHTML = settings.settings.name;
    document.getElementById("player1Rank").innerHTML = settings.settings.rank || "Bronze";
    document.getElementById("player1Rating").innerHTML = settings.settings.rating || 1000;
    document.getElementById("player1Img").src = settings.settings.avatar || "images/Avatars/default-avatar.png";

    //get level
    //todo: put in class somewhere
    //exp= POWER(lvl*1.3,2)
    var totalWins =(stats.stats["win_Easy"]||0)+( stats.stats["win_Medium"]||0)+(stats.stats["win_Hard"]||0)+ (stats.stats["win_CrazyNinja"]||0)+(stats.stats["win_Online"]||0);
    var level = Math.floor(Math.pow(totalWins, 1 / 2) / 1.3) + 1;

    document.getElementById("player1Rank").innerHTML = "Level";
    document.getElementById("player1Rating").innerHTML = level;
    settings.settings.rank = "Level " + level;
    settings.settings.level = level;
    settings.save();


    //forward to login if never logged in
    if (!settings.settings["id"] && !settings.settings["facebooktoken"] && !settings.settings["email"]) {
        window.location.href = "Login.html";
    }


    getFacebookData();


}
function getFacebookData() {
    //if logged into facebook, do an action to test still logged ina nd to show active
    var settings = new Settings();
    if (typeof openFB != 'undefined' && settings.settings["facebooktoken"]) {
        console.log("Pinging facebook ...");
        openFB.init({ appId: '158327870889130', tokenStore: window.localStorage });
        openFB.api({
            path: '/me',
            success: function (data) {
                console.log("Facebook pinged:");
                console.log(JSON.stringify(data));
            },
            error: function errorHandler(error) { console.log("Facebookping failed: " + error.message); }
        });
    } else {
        console.log("Error: openFB script failed. openFB is not included");
    }
}
function onDeviceReady() {
    navigator.splashscreen.hide();
    StatusBar.hide();


}

window.onload = loadPage();
