speedread.drawerMenu = function($section) {
	var $header = $section.querySelectorAll("header")[0];
	var $article = $section.querySelectorAll("article")[0];
	var $ul = $article.querySelectorAll("ul")[0];
	
	function prepareText(text) {
		text = (text || "").trim().replace(/[ \t\r]*\n/g, "\xA0\n");
		localStorage.text = text;
		var words = text.split(/\s+/g);
		var countByLength = [];
		for (var i = 0; i < words.length; i++) {
			var length = Math.min(32, words[i].length);
			countByLength[length] = (countByLength[length] || 0) + 1;
		}
		for (var length = 1; length <= 32; length++) {
			localStorage.setItem("word-count-" + length, countByLength[length] || 0);
		}
	}
	
	function loadText(file) {
		if (file) {
			var r = new FileReader();
			r.onloadend = function(e) {
				if (r.error) {
					alert(r.error.name);
					return;
				}
				localStorage.file = file.name;
				prepareText(e.target.result);
				speedread.trigger("file");
				speedread.closeMenu();
			}
			r.readAsText(file, localStorage.encoding || "UTF-8");
		} else { 
			alert("Failed to load file");
		}
	}
	
	function getEncoding(html) {
		var res = /<meta[^>]*charset="?([^"]*)"/i.exec(html);
		if (res) return res[1].toUpperCase();
		res = /<?xml[^>]*encoding="([^"]*)"/i.exec(html);
		if (res) return res[1].toUpperCase();
		return "";
	}

	function loadHtml(file) {
		if (file) {
			var r = new FileReader();
			var assumedEncoding = localStorage.encoding || "UTF-8";
			r.onloadend = function(e) {
				if (r.error) {
					alert(r.error.name);
					return;
				}
				localStorage.file = file.name;
				var encoding = getEncoding(e.target.result);
				if (encoding && encoding.replace(/-/g, "") !== assumedEncoding.replace(/-/g, "")) {
					assumedEncoding = encoding;
					r.readAsText(file, assumedEncoding);
				} else {
					var text = speedread.html2text(e.target.result);
					prepareText(text);
					speedread.trigger("file");
					speedread.closeMenu();
				}
			}
			r.readAsText(file, assumedEncoding);
		} else { 
			alert("Failed to load file");
		}
	}

	function loadEpub(file) {
		document.body.classList.add("waiting");
		speedread.readEpub(file, function(pages, error) {
			if (error) {
				document.body.classList.remove("waiting");
				alert(error);
				return;
			}
			localStorage.file = file.name;
			var text = "";
			for (var i = 0; i < pages.length; i++) {
				text += speedread.html2text(pages[i]) + "\n\n\n\n";
			}
			prepareText(text);
			speedread.trigger("file");
			speedread.closeMenu();
			document.body.classList.remove("waiting");
		});
	}
	
	function loadMobi(file) {
		document.body.classList.add("waiting");
		speedread.readMobi(file, function(page, error) {
			if (error) {
				document.body.classList.remove("waiting");
				alert(error);
				return;
			}
			localStorage.file = file.name;
			var text = speedread.html2text(page);
			prepareText(text);
			speedread.trigger("file");
			speedread.closeMenu();
			document.body.classList.remove("waiting");
		});
	}
	
	function loadFile(file) {
		if (file) {
			var extension = (/\.([^.]*)$/.exec(file.name) || [null,""])[1].toLowerCase();
			switch (extension) {
				case "epub":
					loadEpub(file);
					break;
				case "mobi":
					loadMobi(file);
					break;
				case "htm":
				case "html":
				case "xhtml":
					loadHtml(file);
					break;
				default:
					loadText(file);
					break;
			}
		}
	}
	
	function openFile(filename) {
		if (filename) {
			try {
				var sdcard = sdcards[filename.split("/")[1]];
				var request = sdcard.get(filename);
				request.onsuccess = function () {
					pushRecentFile(filename);
					loadFile(this.result);
				}
				request.onerror = function (e) {
					alert("Cannot get file: " + this.error + "\n" + e);
				}
			} catch (e) {
				alert("Error open file: " + (e.message | e));
			}
		}
	}
		
	var openFileDialog = document.querySelector(".dialog.open-file");
	
	function appendSdcard(sdcard) {
		var li = document.createElement("li");
		li.className = "sdcard";
		li.textContent = sdcard.storageName;
		var context = {
			sdcard: sdcard,
			openFile: openFile
		};
		li.addEventListener("click", function() {
			speedread.openDialog(openFileDialog, [context]);
		}, false);
		$ul.appendChild(li);
	}
	
	var sdcards = {};
	var li;	
	if (navigator.getDeviceStorages) {
		try {
			var _sdcards = navigator.getDeviceStorages("sdcard");
			li = document.createElement("li");
			li.className = "subtitle";
			li.textContent = "Device Storages";
			$ul.appendChild(li);
			for (var i = 0; i < _sdcards.length; i++) {
				var sdcard = _sdcards[i];
				sdcards[sdcard.storageName] = sdcard;
				appendSdcard(sdcard);
			}
		} catch (e) {
			alert(e.message || e);
		}
		li = document.createElement("li");
		li.className = "subtitle";
		li.textContent = "Recent Files";
		$ul.appendChild(li);
	} else {
		var $fileInput = document.createElement("input");
		$fileInput.type = "file";
		var liOpen = document.createElement("li");
		liOpen.className = "open";
		liOpen.textContent = "Open ...";
		$ul.appendChild(liOpen);
		liOpen.addEventListener("click", function(e) {
			if (e.target == liOpen) {
				$fileInput.click();
				e.preventDefault();
				e.stopPropagation();
			}
		}, false);
		$fileInput.addEventListener("change", function(e) {
			var file = e.target.files[0];
			if (file) {
				loadFile(file);
			}
		}, false);
		li = document.createElement("li");
		li.className = "enter";
		li.textContent = "Enter Text ...";
		$ul.appendChild(li);
		li.addEventListener("click", function(e) {
			var text = prompt("Enter text", "");
			localStorage.file = "";
			prepareText(text);
			speedread.trigger("file");
			speedread.closeMenu();
			e.stopPropagation();
		}, false);
	}

	function pushRecentFile(file) {
		for (var i = 0; i < 10; i++) {
			if (localStorage.getItem("recent-file-" + i) === file) {
				if (i === 0) return;
				break;
			}
		}
		for (; i > 0; i--) {
			localStorage.setItem("recent-file-" + i, localStorage.getItem("recent-file-" + (i - 1)) || "");
		}
		localStorage.setItem("recent-file-0", file);
		speedread.trigger("recent-files");
	}
	
	function appendFile(file) {
		var parts = file.split("/");
		var name = parts[parts.length - 1];
		var li = document.createElement("li");
		li.className = "file";
		li.textContent = name;
		li.dataset.file = file;
		$ul.appendChild(li);
		li.addEventListener("click", function(e) {
			openFile(file);			
		}, false);
	}
	
	function updateRecentFileList() {
		for (var li = $ul.lastChild; li.classList.contains("file"); li = $ul.lastChild) {
			li.remove();
		}
		for (var i = 0; i < 5; i++) {
			var file = localStorage.getItem("recent-file-" + i);
			if (!file) break;
			appendFile(file);
		}
	}
	
	speedread.on("recent-files", updateRecentFileList);
	updateRecentFileList();
};
