(function() {

	function lz77(data) {
		var text = "";
		var offset = 0;
		var outOffset = 0;
		var out = new Uint8Array(4096);
		while (outOffset < 4096) {
			var d = data[offset++];
			if (d === 0) {
				break;
			} else if (d < 0x09) {
				while (d--) {
					out[outOffset++] = data[offset++];
				}
			} else if (d < 0x80) {
				out[outOffset++] = d;
			} else if (d < 0xc0) {
				var distance = (d & 0x3F) << 5;
				d = data[offset++];
				distance += (d & 0xF8) >> 3;
				var length = (d & 0x07) + 3;
				while (length--) {
					out[outOffset] = out[outOffset - distance];
					outOffset++;
				}
			} else {
				out[outOffset++] = 32;
				out[outOffset++] = d ^ 0x80;
			}
		}
		return out.subarray(0, outOffset);
	}

	speedread.readMobi = function(file, callback) {
		var start = new Date().getTime();
		try {
			var r = new FileReader();
			r.onloadend = function(e) {
				if (r.error) {
					callback(null, r.error.name);
					return;
				}
				try {
					var data = new DataView(r.result);
					function getString(offset, length) {
						return speedread.decodeIsoArray(new Uint8Array(r.result, offset, length));
					}
					if (getString(60, 8) !== "BOOKMOBI") throw "No Mobi-Book";
					var offset;
					function getUint32() {
						var val = data.getUint32(offset);
						offset += 4;
						return val;
					}
					function getUint16() {
						var val = data.getUint16(offset);
						offset += 2;
						return val;
					}
					var offsets = [];
					offset = 76;
					var recnum = getUint16();
					for (var i = 0; i < recnum; i++) {
						offsets.push(getUint32());
						offset += 4;
					}
					offset = offsets[0];
					var compression = getUint16();
					if (compression !== 1 && compression !== 2) throw "Unsupported compression type: " + compression;
					offset += 10;
					var encryption = getUint16();
					if (encryption) throw "Encryption not supported";
					offset += 2;
					if (getString(offset, 4) !== "MOBI") throw "No mobi header";
					offset += 8;
					var mobiType = getUint32();
					if (mobiType !== 2) throw "No mobi type";
					var encoding = getUint32();
					offset += 48;
					var lastRecord = getUint32() - 1;
					offset += 112;
					var firstRecord = getUint32();
					if (encoding === 65001) {
						var parts = [];
						for (var i = firstRecord; i <= lastRecord; i++) {
							var out;
							switch (compression) {
								case 1:
									out = new Uint8Array(r.result, offsets[i], Math.min(offsets[i + 1] - offsets[i], 4096));
									for (var j = 0; j < out.length; j++) {
										if (out[j] === 0) break;
									}
									out = out.subarray(0, j);
									break;
								case 2:
									out = lz77(new Uint8Array(r.result, offsets[i], offsets[i + 1] - offsets[i]));
									break;
							}
							parts.push(out);
						}
						var fileReader = new FileReader();
						fileReader.onloadend = function() {
							var end = new Date().getTime();
							console.log("duration: " + (end - start));
							callback(this.result, this.error && this.error.name);
						};
						fileReader.readAsText(new Blob(parts));
					} else if (encoding === 1252) {
						var html = "";
						for (var i = firstRecord; i <= lastRecord; i++) {
							switch (compression) {
								case 1:
									out = new Uint8Array(r.result, offsets[i], Math.min(offsets[i + 1] - offsets[i], 4096));
									for (var j = 0; j < out.length; j++) {
										if (out[j] === 0) break;
									}
									out = out.subarray(0, j);
									break;
								case 2:
									out = lz77(new Uint8Array(r.result, offsets[i], offsets[i + 1] - offsets[i]));
									break;
							}
							html += speedread.decodeCp1252Array(out);
						}
						var end = new Date().getTime();
						console.log("duration: " + (end - start));
						callback(html);
					} else {
						throw "Unsupported encoding: " + encoding;
					}
				} catch (e) {
					callback(null, e.message || e);
				}
			}
			r.readAsArrayBuffer(file);
		} catch (e) {
			callback(null, e.message || e);
		}
	};
	
})();

