speedread.dialogOpenFile = function($section) {
	var $header = $section.querySelectorAll("header")[0];
	var $article = $section.querySelectorAll("article")[0];
	var $title = $header.querySelectorAll(".title")[0];
	var $refresh = $header.querySelectorAll(".refresh")[0];
	var $ul = $article.querySelectorAll("ul")[0];
	var $search = $article.querySelectorAll(".search > input")[0];
	var $clear = $article.querySelectorAll(".search > .clear")[0];
	
	var context;
	
	$header.querySelectorAll("button.close")[0].addEventListener("click", function() {
		context.open = false;
		speedread.closeDialog($section);
	}, false);

	var isEdit;
	var blurSearchTimer = null;
	var changeSearchTimer = null;
	var search = "";
	$clear.addEventListener("click", function() {
		if (isEdit) {
			$search.value = "";
			clearTimeout(changeSearchTimer);
			changeSearchTimer = setTimeout(changeSearch, 500);
		} else {
			$search.focus();
		}
	}, false);
	
	$search.addEventListener("focus", function() {
		$clear.textContent = "\ue64e";
		isEdit = true;
	}, false);

	$search.addEventListener("blur", function() {
		$clear.textContent = "\ue69e";
		blurSearchTimer = setTimeout(function() {
			isEdit = false;
			blurSearchTimer = null;
		}, 100);
	}, false);
	
	function changeSearch() {
		search = $search.value.trim().toLowerCase();
		var lis = $ul.querySelectorAll("li");
		for (var i = 0; i < lis.length; i++) {
			lis[i].style.display = !search || lis[i].dataset.nameLower.indexOf(search) >= 0 || lis[i].dataset.pathLower.indexOf(search) >= 0 ? "" : "none";
		}
	}
	
	$search.addEventListener("keydown", function() {
		clearTimeout(changeSearchTimer);
		changeSearchTimer = setTimeout(changeSearch, 500);
	}, false);

	function appendFile(file) {
		var parts = file.split("/");
		parts.shift();
		parts.shift();
		var name = parts.pop();
		var path = "/" + parts.join("/");
		var li = document.createElement("li");
		li.className = "file";
		li.dataset.nameLower = name.toLowerCase();
		li.dataset.pathLower = path.toLowerCase();
		li.dataset.file = file;
		li.style.display = !search || li.dataset.nameLower.indexOf(search) >= 0 || li.dataset.pathLower.indexOf(search) >= 0 ? "" : "none";
		var div = document.createElement("div");
		div.className = "name";
		div.textContent = name;
		li.appendChild(div);
		div = document.createElement("div");
		div.className = "path";
		div.textContent = path;
		li.appendChild(div);
		$ul.appendChild(li);
	}
	
	function load() {
		$section.classList.add("loading");
		$refresh.disabled = true;
		while ($ul.lastChild) {
			$ul.lastChild.remove();
		}
		context.files = [];
		context.loading = true;
		var ctx = context;
		function stop() {
			$section.classList.remove("loading");
			$refresh.disabled = false;
			ctx.loading = false;
		}
		try {
			var cursor = context.sdcard.enumerate();
			cursor.onsuccess = function () {
				var file = this.result;
				if (file) {
					var name = file.name;
					if (/\.(txt|text|epub|mobi|html|htm|xhtml)$/i.test(name)) {
						ctx.open && appendFile(name);
						ctx.files.push(name);
					}
					this.continue();
				} else {
					stop();
				}
			}
			cursor.onerror = function () {
				stop();
				alert("Error enumerate sdcard: " + this.error);
			}
		} catch (e) {
			stop();
			alert("Error enumerate sdcard: " + (e.message | e));
		}
	}
	
	$refresh.addEventListener("click", load, false);

	$section.dataset.open = speedread.data.length;
	speedread.data.push(function(ctx) {
		context = ctx;
		ctx.open = true;
		$search.value = "";
		search = "";
		$ul.scrollTop = 0;
		if (!ctx.files) {
			load();
		} else {
			$section.classList.toggle("loading", ctx.loading);
			$refresh.disabled = ctx.loading;
			while ($ul.lastChild) {
				$ul.lastChild.remove();
			}
			for (var i = 0; i < ctx.files.length; i++) {
				appendFile(ctx.files[i]);
			}
		}
		$title.textContent = ctx.sdcard.storageName;
	});
	
	$ul.addEventListener("click", function(e) {
		var li = e.target;
		if (li.tagName !== "LI") {
			li = li.parentNode;
		}
		if (li.tagName === "LI") {
			context.openFile(li.dataset.file);
			context.open = false;
			speedread.closeDialog($section);
		}
	}, false);
};
