speedread.sectionOptions = function($section) {
	var $header = $section.querySelectorAll("header")[0];
	var $article = $section.querySelectorAll("article")[0];
	var $recentFiles = $article.querySelectorAll("li.recent-files button")[0];
	var $theme = $article.querySelectorAll("li.theme input")[0];
	var $minChars = $article.querySelectorAll("li.min-chars input")[0];
	var $maxChars = $article.querySelectorAll("li.max-chars input")[0];
	var $speed = $article.querySelectorAll("li.speed input")[0];
	var $contrast = $article.querySelectorAll("li.contrast input")[0];
	var $contrastTest = $article.querySelectorAll("li.contrast .test")[0];
	var $reset = $article.querySelectorAll("li.reset button")[0];
	var $wordSizeText = $article.querySelectorAll("li.word-size .text")[0];
	var $wordSize = $article.querySelectorAll("li.word-size select")[0];
	var $textSizeText = $article.querySelectorAll("li.text-size .text")[0];
	var $textSize = $article.querySelectorAll("li.text-size select")[0];
	var $encoding = $article.querySelectorAll("li.encoding input")[0];
	
	var wordSizeValues = [];
	var textSizeValues = [];
	for (var i = 0; i < $wordSize.options.length; i++) {
		wordSizeValues.push($wordSize.options[i].textContent);
	}
	for (var i = 0; i < $textSize.options.length; i++) {
		textSizeValues.push($textSize.options[i].textContent);
	}
	
	function update() {
		$theme.checked = localStorage.theme === "default";
		$speed.value = localStorage.speed;
		$encoding.value = localStorage.encoding || "UTF-8";
		updateContrast();
		$minChars.value = localStorage.minChars;
		$maxChars.value = localStorage.maxChars;
		var index = wordSizeValues.indexOf(localStorage.wordSize);
		if (index >= 0 && index !== $wordSize.selectedIndex) {
			$wordSize.options[$wordSize.selectedIndex].selected = false;
			$wordSize.options[index].selected = true;
		}
		$wordSizeText.textContent = localStorage.wordSize;
		index = textSizeValues.indexOf(localStorage.textSize);
		if (index >= 0 && index !== $textSize.selectedIndex) {
			$textSize.options[$textSize.selectedIndex].selected = false;
			$textSize.options[index].selected = true;
		}
		$textSizeText.textContent = localStorage.textSize;
	}
	
	function updateRecentFiles() {
		$recentFiles.disabled = !localStorage.getItem("recent-file-0");
	}
	
	function updateContrast() {
		$contrast.value = localStorage.getItem(localStorage.theme + "Contrast");
		$contrastTest.style[localStorage.theme === "default" ? "background" : "color"] = "rgb(" + $contrast.value + "," + $contrast.value + "," + $contrast.value + ")";
		$contrastTest.style[localStorage.theme === "default" ? "color" : "background"] = "black";
	}

	$recentFiles.addEventListener("click", function() {
		localStorage.removeItem("recent-file-0");
		speedread.trigger("recent-files");
	}, false);
	
	$reset.addEventListener("click", function() {
		localStorage.clear();
		speedread.reset();
		speedread.trigger("file");
		speedread.trigger("settings");
		speedread.trigger("recent-files");
		speedread.trigger("theme");
	}, false);
	
	$theme.addEventListener("change", function() {
		localStorage.theme = $theme.checked ? "default" : "dark";
		setTimeout(function() {
			speedread.trigger("theme");
		}, 200);
	}, false);

	$contrast.addEventListener("change", function() {
		localStorage.setItem(localStorage.theme + "Contrast", $contrast.value);
	}, false);

	$contrast.addEventListener("input", function() {
		$contrastTest.style[localStorage.theme === "default" ? "background" : "color"] = "rgb(" + $contrast.value + "," + $contrast.value + "," + $contrast.value + ")";
	}, false);

	$wordSize.addEventListener("change", function() {
		$wordSizeText.textContent = wordSizeValues[$wordSize.selectedIndex];
	}, false);

	$textSize.addEventListener("change", function() {
		$textSizeText.textContent = textSizeValues[$textSize.selectedIndex];
	}, false);

	function numericVal(node, defaultValue, min, max) {
		var value = node.value;
		value = (value && isFinite(value)) ? Number(value) : defaultValue;
		return Math.max(min, Math.min(max, value));
	};
	
	$header.querySelectorAll("button.back")[0].addEventListener("click", function() {
		localStorage.minChars = numericVal($minChars, localStorage.minChars, 0, 8);
		localStorage.maxChars = numericVal($maxChars, localStorage.maxChars, 8, 32);
		localStorage.speed = numericVal($speed, localStorage.speed, 10, 5000);
		localStorage.encoding = $encoding.value || "UTF-8";
		localStorage.wordSize = wordSizeValues[$wordSize.selectedIndex];
		localStorage.textSize = textSizeValues[$textSize.selectedIndex];
		speedread.trigger("settings");
	}, false);

	speedread.on("settings", update);
	speedread.on("recent-files", updateRecentFiles);
	speedread.on("theme", updateContrast);
	update();
	updateRecentFiles();
};

