var speedread = {
	data: [],
	decodeIsoArray: function(array) {
		var s = "";
		for (var i = 0; i < array.length; i += 0x10000) {
			s += String.fromCharCode.apply(null, array.subarray(i, Math.min(array.length, i + 0x10000)));
		}
		return s;
	},
	decodeUtf8Array: function(array) {
		var arr16 = new Uint16Array(array.length);
		var i16 = 0;
		for (var i = 0; i < array.length; i++) {
			var b = array[i];
			if (b < 0x80) {
				arr16[i16++] = b;
			} else if ((b & 0xE0) === 0xC0) {
				var val = (b & 0x1F) << 6;
				b = array[++i];
				if ((b & 0xC0) !== 0x80) {
					b = array[i -= 1];
					console.log("invalid utf-8 encoding f1: " + b.toString(16) + " '" + String.fromCharCode(b) + "'");
					arr16[i16++] = b;
					continue;
				}
				arr16[i16++] = val + (b & 0x3F);
			} else if ((b & 0xF0) === 0xE0) {
				var val = (b & 0xF) << 12;
				b = array[++i];
				if ((b & 0xC0) !== 0x80) {
					b = array[i -= 1];
					console.log("invalid utf-8 encoding f2: " + b.toString(16) + " '" + String.fromCharCode(b) + "'");
					arr16[i16++] = b;
					continue;
				}
				val += (b & 0x3F) << 6;
				b = array[++i];
				if ((b & 0xC0) !== 0x80) {
					b = array[i -= 2];
					console.log("invalid utf-8 encoding f3: " + b.toString(16) + " '" + String.fromCharCode(b) + "'");
					arr16[i16++] = b;
					continue;
				}
				arr16[i16++] = val + (b & 0x3F);
			} else {
				console.log("invalid utf-8 encoding s: " + b.toString(16) + " '" + String.fromCharCode(b) + "'");
				arr16[i16++] = b;
			}
		}
		return speedread.decodeIsoArray(arr16.subarray(0, i16));
	},
	decodeCp1252Array: function(array) {
		var arr16 = new Uint16Array(array.length);
		for (var i = 0; i < array.length; i++) {
			var b = array[i];
			switch (b) {
				case 0x80:
					arr16[i] = 0x20ac;
					break;
				case 0x8A:
					arr16[i] = 0x160;
					break;
				case 0x9A:
					arr16[i] = 0x161;
					break;
				case 0x8E:
					arr16[i] = 0x17D;
					break;
				case 0x9E:
					arr16[i] = 0x17E;
					break;
				case 0x8C:
					arr16[i] = 0x152;
					break;
				case 0x9C:
					arr16[i] = 0x153;
					break;
				case 0x9F:
					arr16[i] = 0x178;
					break;
				default:
					arr16[i] = b;
					break;
			}
		}
		return speedread.decodeIsoArray(arr16);
	},
	html2text: function(s) {
		s = s || "";
		var res = /<body[^>]*>(.*?)<\/body>/i.exec(s.replace(/\s+/g, " "));
		if (res) {
			s = res[1].replace(/<!--.*?-->/g, "");
			s = s.replace(/s+/, " ");
			s = s.replace(/<script.*?<\/script>/gi, "");
			s = s.replace(/<\/?(div|p|ul|ol|li)[^>]*>/gi, "\n");
			s = s.replace(/\n+/g, "\n");
			s = s.replace(/<\/?h\d[^>]*>/gi, "\n\n");
			s = s.replace(/<\/?(br|hr)[^>]*>/gi, "\n");
			s = s.replace(/<[^>]*>/g, " ");
			s = s.replace(/ +/g, " ");
			var div = document.createElement('div');
			s = s.replace(/&[a-z]+;/gi, function(match) {
				div.innerHTML = match;
				return div.firstChild.nodeValue;
			});
		}
		return s;
	}
};

window.onload = function() {

	var eventhandlers = {};

	speedread.on = function(event, handler) {
		var h = eventhandlers[event];
		if (h) {
			h.push(handler);
		} else {
			eventhandlers[event] = [handler];
		}
	};

	speedread.off = function(event, handler) {
		var h = eventhandlers[event];
		if (h) {
			var i = h.indexOf(handler);
			if (i >= 0) {
				h.splice(i, 1);
			}
		}
	};

	speedread.trigger = function(event) {
		var h = eventhandlers[event];
		if (h) {
			for (var i = 0; i < h.length; i++) {
				try {
					h[i]();
				} catch (e) {
					console.error("Event handler #" + event + ": " + (e.message || e));
				}
			}
		}
	};
	
	speedread.reset = function() {
		localStorage.theme = "default";
		localStorage.encoding = "UTF-8";
		localStorage.defaultContrast = 255;
		localStorage.darkContrast = 255;
		localStorage.minChars = 6;
		localStorage.maxChars = 32;
		localStorage.speed = 300;
		localStorage.wordSize = "23";
		localStorage.textSize = "14";
	};

	if (!localStorage.speed) {
		speedread.reset();
	}
	
	function updateTheme() {
		var cl = document.body.classList;
		cl.remove("default-theme", "dark-theme");
		cl.add(localStorage.theme + "-theme");
	}

	var $carriage = document.querySelector(".carriage");
	var pageCount = $carriage.querySelectorAll("section").length;

	speedread.slideTo = function(node) {
		var index = Array.prototype.indexOf.call($carriage.childNodes, node);
		$carriage.style.transform = "translateX(-" + 100 * index / pageCount + "%)";
	};
	
	speedread.openDialog = function(node, args) {
		node.classList.add("open");
		var fn = node.dataset.open;
		return fn && speedread.data[fn].apply(node, args);
	};

	speedread.closeDialog = function(node) {
		node.classList.remove("open");
	};


	var $menu = document.querySelector("section.menu");
	speedread.drawerMenu($menu);
	var $main = document.querySelector("section.main");
	speedread.sectionMain($main);
	var $options = document.querySelector("section.options");
	speedread.sectionOptions($options);
	speedread.dialogOpenFile(document.querySelector(".dialog.open-file"));
	
	var menuShown;
	speedread.closeMenu = function() {
		menuShown = false;
		$carriage.style.transform = "translateX(0)";
	};

	$main.querySelectorAll("header button.menu")[0].addEventListener("click", function() {
		if (menuShown) {
			speedread.slideTo($main);
		} else {
			$carriage.style.transform = "translateX(40%)";
		}
		menuShown = !menuShown;
	}, false);
	
	$main.querySelectorAll("header button.options")[0].addEventListener("click", function() {
		speedread.slideTo($options);
	}, false);

	$options.querySelectorAll("header button.back")[0].addEventListener("click", function() {
		speedread.slideTo($main);
	}, false);
	
	speedread.on("theme", updateTheme);
	updateTheme();
};
