/*
 * Spirit Level
 *
 * Copyright (C) 2013  Fabien LOISON <http://flogisoft.com/>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


var Bubble = function(canvas) {
	this._EXTREM_ANGLE = .3;

	this.canvas = canvas;
	this.horiz = 0;
	this.vert = 0;

	this._radius = this.canvas.height / 2 - 5;
	this._bubbleRadius = this.canvas.height / 15;
}

Bubble.prototype.setAngles = function(horiz, vert) {
	var horiz = horiz * (2 - this._EXTREM_ANGLE);
	if (horiz < -1) horiz = -1;
	else if (horiz > 1) horiz = 1;
	this.horiz = horiz;

	var vert = vert * (2 - this._EXTREM_ANGLE);
	if (vert < -1) vert = -1;
	else if (vert > 1) vert = 1;
	this.vert = vert;
}

Bubble.prototype.draw = function() {
	var ctx = this.canvas.getContext("2d");
	ctx.save();
	ctx.clearRect(0, 0, this.canvas.width, this.canvas.height);

	// Set (0, 0) in the middle of the canvas
	ctx.translate(Math.floor(this.canvas.width/2),
			Math.floor(this.canvas.height/2));

	// Lines
	ctx.beginPath();
	ctx.moveTo(0.5, -this._radius);
	ctx.lineTo(0.5, this._radius);
	ctx.moveTo(-this._radius, 0.5);
	ctx.lineTo(this._radius, 0.5);
	ctx.strokeStyle = "#ccc";
	ctx.lineWidth = 1;
	ctx.stroke();

	// External circle
	ctx.beginPath();
	ctx.arc(0, 0, this._radius, 0, 2 * Math.PI, false);
	ctx.strokeStyle = "#ccc";
	ctx.lineWidth = 4;
	ctx.stroke();

	// Internal circle
	ctx.beginPath();
	ctx.arc(0.5, 0.5, this._bubbleRadius + 5, 0, 2 * Math.PI, false);
	ctx.strokeStyle = "#ccc";
	ctx.lineWidth = 1;
	ctx.stroke();

	// Bubble
	var dx = this.horiz * this._radius;
	var dy = -this.vert * this._radius;
	var dh = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));
	var angle = Math.acos(dx/dh);

	if (dy < 0) angle = -angle;
	if (dh > this._radius - this._bubbleRadius - 3) dh = this._radius - this._bubbleRadius - 3;

	ctx.rotate(angle);
	ctx.beginPath();
	ctx.arc(dh+.5, 0+.5, this._bubbleRadius, 0, 2 * Math.PI, false);
	ctx.strokeStyle = "#e66000";
	ctx.lineWidth = 3;
	ctx.stroke();

	ctx.restore();
}
