/*
 * Spirit Level
 *
 * Copyright (C) 2013  Fabien LOISON <http://flogisoft.com/>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


var sensor = null
var bubble = null;
var settings = null;
var eValueX = null;
var eValueY = null;
var _lastAngle = {x: 0, y: 0};


function setText(domElement, text) {
	while (domElement.firstChild) {
		domElement.removeChild(domElement.firstChild);
	}
	domElement.appendChild(document.createTextNode(text));
}


function castBool(value) {
	if (typeof(value) == "boolean") return value;
	
	if (value == "true") return true;
	else return false;
}


function main() {
	document.getElementById("bubble").width = screen.width-50;
	document.getElementById("bubble").height = screen.width-50;
	bubble = new Bubble(document.getElementById("bubble"));
	settings = new Settings();
	sensor = new Sensor();
	eValueX = document.getElementById("value_x");
	eValueY = document.getElementById("value_y");
	update(true);
}


function update(force) {
	//sensor.update();
	var angle = sensor.getAngle();
	
	if (force || angle.x != _lastAngle.x || angle.y != _lastAngle.y) {
		bubble.setAngles(angle.x, angle.y);
		bubble.draw();
		setText(eValueX, sensor.getAngleDegree().x + "°");
		setText(eValueY, sensor.getAngleDegree().y + "°");
	}

	_lastAngle.x = angle.x;
	_lastAngle.y = angle.y;

	window.mozRequestAnimationFrame(update);
}


window.onload = main;
