/*
 * Spirit Level
 *
 * Copyright (C) 2013  Fabien LOISON <http://flogisoft.com/>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// NOTE: All angles are in radian

var Sensor = function() {
	this._AVG_COUNT = 6;

	this.instantAngle = {x: 0, y: 0};
	this.angle = {x: 0, y: 0};

	this._average = [{x: 0, y: 0}];

	window.addEventListener("devicemotion", this.onMotionEvent.bind(this), true);
}

Sensor.prototype.getAngle = function() {
	return {
		x: this.angle.x.toFixed(4),
		y: this.angle.y.toFixed(4)
	};
}

Sensor.prototype.getAngleDegree = function() {
	return {
		x: (this.angle.x*180/Math.PI).toFixed(1),
		y: (this.angle.y*180/Math.PI).toFixed(1),
	};
}

Sensor.prototype.update = function() {
	this._average.push({x: this.instantAngle.x, y: this.instantAngle.y});
	if (this._average.length > this._AVG_COUNT) {
		this._average.splice(0, 1);
	}

	var ax = 0;
	var ay = 0;

	for (var i=0 ; i<this._average.length ; i++) {
		ax += this._average[i].x;
		ay += this._average[i].y;
	}

	this.angle.x = ax / this._average.length;
	this.angle.y = ay / this._average.length;
}

Sensor.prototype.onMotionEvent = function(event) {
	// We can try yo compensate moves with event.acceleration, but
	// the angle will be less accurate.
	var ax = 0;
	var ay = 0;
	if (settings.compensateAccel && event.acceleration) {
		ax = event.acceleration.x;
		ay = event.acceleration.y;
	}

	var gx = (event.accelerationIncludingGravity.x - ax) / 9.81;
	var gy = (event.accelerationIncludingGravity.y - ay) / 9.81;

	if (gx < -1) gx = -1;
	else if (gx > 1) gx = 1;

	if (gy < -1) gy = -1;
	else if (gy > 1) gy = 1;

	this.instantAngle.x = Math.asin(gx);
	this.instantAngle.y = Math.asin(gy);

	this.update();
}
