/*
 * Spirit Level
 *
 * Copyright (C) 2013  Fabien LOISON <http://flogisoft.com/>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


var Settings = function() {
	// Attr
	this.unit = "deg";  // deg, rad
	this.compensateAccel = true;

	// DOM
	this._domElement = document.getElementById("settings");
	this._eCompensateAccel = document.getElementById("compensate_accel");

	// Bind events
	this._eCompensateAccel.onclick = this.onCompensateAccelClicked.bind(this);

	// Init
	this.load();

	// Events
	document.getElementById("settings_show").onclick = function(event) {
		this.show();
		return false;
	}.bind(this);

	document.getElementById("settings_hide").onclick = function(event) {
		this.hide();
		return false;
	}.bind(this);
}

Settings.prototype.load = function() {
	if (localStorage.compensateAccel != undefined) {
		this.compensateAccel = castBool(localStorage.compensateAccel);
	}
	this.refreshUI();
}

Settings.prototype.save = function() {
	localStorage.compensateAccel = this.compensateAccel;
}

Settings.prototype.refreshUI = function() {
	this._eCompensateAccel.checked = castBool(this.compensateAccel);
}

Settings.prototype.show = function() {
	this._domElement.style.top = 0;
}

Settings.prototype.hide = function() {
	this._domElement.style.top = "100%";
}

Settings.prototype.onCompensateAccelClicked = function(event) {
	this.compensateAccel = castBool(this._eCompensateAccel.checked);
	this.save();
}
