/**
 * Created by isaacriquelme on 30/11/13.
 */
var mTeamsList;

var mMatchesList;

var idTeamsForUser = new Array();

var userId;

var mSelectedTeam;

$(function() {

    Parse.$ = jQuery;

    // Initialize Parse with your Parse application javascript keys
    Parse.initialize("YI8hz7FRQAm1ihfVkmT5nxf46qlvMgUck2hy4qXX", "jWPQRBjLwYVhBlOKFkohnG7Iw7pZiAXI8UKUvSNW");


    //Object Models
    var mUser = new Parse.User();

    var Team = Parse.Object.extend("Team");

    var TeamsList =  Parse.Collection.extend({
        model: Team
    });

    mTeamsList = new TeamsList();

    mSelectedTeam = new TeamsList();



    var Match = Parse.Object.extend("Match", {
        // Default attributes for the match
        defaults: {
            name: "parido..."

        },

        // Ensure that each mach has content
        initialize: function() {
            if (!this.get("name")) {
                this.set({"name": this.defaults.name});
            }
        }
    });

    var MatchesList = Parse.Collection.extend({
        model: Match
    });

    mMatchesList = new MatchesList();

    var LogInView = Parse.View.extend({
        events: {
            "submit form.login-form": "logIn",
            "click .sign-up": "signUpTemplate"

        },

        el: ".content",

        initialize: function() {
            _.bindAll(this, "logIn");
            this.render();
        },

        logIn: function(e) {
            var self = this;
            var username = this.$("#login-username").val();
            var password = this.$("#login-password").val();

            Parse.User.logIn(username, password, {
                success: function(user) {
                    new MyMatchsView();
                    self.undelegateEvents();
                    delete self;
                },

                error: function(user, error) {
                    self.$(".login-form .error").html("Invalid username or password. Please try again.").show();
                    this.$(".login-form button").removeAttr("disabled");
                }
            });

            this.$(".login-form button").attr("disabled", "disabled");

            return false;

        },

        signUpTemplate: function(e) {

            new SignUpView();
            this.undelegateEvents();
            delete this;
        },

        render: function() {
            this.$el.html(_.template($("#login-template").html()));
            this.delegateEvents();
        }
    });

    var SignUpView = Parse.View.extend({
        events: {

            "submit form.signup-form": "signUp",
            "click .log-in": "logInTemplate"
        },

        el: ".content",

        initialize: function() {
            _.bindAll(this, "signUp");
            this.render();
        },

        signUp: function(e) {
            var self = this;
            var username = this.$("#signup-username").val();
            var password = this.$("#signup-password").val();
            var repassword = this.$("#signup-re-password").val();
            var email = this.$("#signup-email").val();
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if(password !== repassword)
            {
                alert("The passwords don't match. Try again please.");

            }else if (!filter.test(email))
            {
                alert("Please provide a valid email address");
                email.focus;
            }
            else
            {
                var user = new Parse.User();
                user.set("username", username);
                user.set("password", password);
                user.set("email", email);

                user.signUp(null, {
                    success: function(user) {
                        var user = Parse.User.current();
                        user.setEmail(email);
                        new MyMatchsView();
                        self.undelegateEvents();
                        delete self;
                    },


                    error: function(user, error) {
                        self.$(".signup-form .error").html(error.message).show();
                        this.$(".signup-form button").removeAttr("disabled");
                    }
                });

                this.$(".signup-form button").attr("disabled", "disabled");

                return false;
            }
        },

        logInTemplate: function(e) {

            new LogInView();
            this.undelegateEvents();
            delete this;
        },

        render: function() {
            this.$el.html(_.template($("#signup-template").html()));
            this.delegateEvents();
        }
    });

    //Add match view
    var AddMatchView = Parse.View.extend({
        events: {

            "submit form.create-match-form": "doCreateMatch",
            "click #cancel-create-match": "cancelCreateMatch",
            "click #reset-create-match": "resetCreateMatch",
            "click #create-match-date-start": "pickDateStart",
            "click #create-match-date-end": "pickDateEnd",
            "click #create-match-time-start": "pickTimeStart",
            "click #create-match-time-end": "pickTimeEnd",
            "click #create-match-price": "setPrice",
            "click #create-match-number-players": "setPlayers"
        },

        el: ".content",

        initialize: function() {
            _.bindAll(this, "doCreateMatch", "cancelCreateMatch", "resetCreateMatch", "pickDateStart", "pickDateEnd", "setPrice", "setPlayers");

            this.render();


            this.addTeams();
        },

        doCreateMatch: function(e) {
            var self = this;
            var matchName = this.$("#create-match-name").val();
            var numPlayers = this.$("#create-match-number-players").val();
            var dateStart = this.$("#create-match-date-start").val();
            var timeStart = this.$("#create-match-time-start").val();
            var dateEnd = this.$("#create-match-date-end").val();
            var timeEnd = this.$("#create-match-time-end").val();
            var price = this.$("#create-match-price").val();
            var kit = this.$("#create-match-kit").val();
            var location = this.$("#create-match-location").val();
            var comments = this.$("#create-match-comments").val();
            var teamId = this.$("#create-match-team").val();

            if(numPlayers<1 || dateStart.length<1 || timeStart.length<1 ||dateEnd.length<1 ||timeEnd.length<1 ||location.length<1 )
            {
                alert("You have to fill all the mandatory fields. Try again please.");

            }
            else
            {
                var match = Parse.Object.extend("Match");
                var newMatch = new match();
                //newMatch.set('name', matchName);
                var partsDateStart =  dateStart.split("/");
                //Date start
                var partsTimeStart =  timeStart.split(":");
                if(timeStart.contains("pm"))
                {
                    partsTimeStart[0]= parseInt(partsTimeStart[0])+12;
                }
                partsTimeStart[1]= partsTimeStart[1].substring(0, partsTimeStart[1].length-2);
                var fullDateStart = new Date(parseInt(partsDateStart[2]), parseInt(partsDateStart[0])-1, parseInt(partsDateStart[1]), partsTimeStart[0], parseInt(partsTimeStart[1]), 0, 0);

                //Date end
                var partsDateEnd =  dateEnd.split("/");

                var partsTimeEnd =  timeEnd.split(":");
                if(timeEnd.contains("pm"))
                {
                    partsTimeEnd[0]= parseInt(partsTimeEnd[0])+12;
                }
                partsTimeEnd[1]= partsTimeEnd[1].substring(0, partsTimeEnd[1].length-2);
                var fullDateEnd = new Date(parseInt(partsDateEnd[2]), parseInt(partsDateEnd[0])-1, parseInt(partsDateEnd[1]), partsTimeEnd[0], parseInt(partsTimeEnd[1]), 0, 0);

                newMatch.save({
                    name: matchName,
                    dateStart: fullDateStart,
                    dateEnd: fullDateEnd,
                    numMaxPlayers: parseInt(numPlayers),
                    kit: parseInt(kit),
                    price:parseInt(price)   ,
                    location:location,
                    comments:comments,
                    id_team: teamId

                }, {
                    success: function(newMatch) {


                        //Send the user back to the match list
                        new MyMatchsView();
                        this.undelegateEvents();
                        delete this;


                    },
                    error: function(newMatch, error) {
                        // The save failed.
                        // error is a Parse.Error with an error code and description.
                        alert('Failed to create new object, with error code: ' + error.description);
                    }
                });

            }
        },

        cancelCreateMatch: function(e) {

            new MyMatchsView();
            this.undelegateEvents();
            delete this;
        },

        resetCreateMatch: function(e) {


            this.$("#create-match-name").val("");
            this.$("#create-match-number-players").val("");
            this.$("#create-match-date-start").val("");
            this.$("#create-match-time-start").val("");
            this.$("#create-match-date-end").val("");
            this.$("#create-match-time-end").val("");
            this.$("#create-match-price").val("");
            this.$("#create-match-kit").val("");
            this.$("#create-match-comments").val("");
            this.undelegateEvents();
            delete this;
        },

        pickDateStart: function(e) {


            $('#create-match-date-start').datepicker();

        },

        pickDateEnd: function(e) {

            $('#create-match-date-end').datepicker();
        },

        pickTimeStart: function(e) {

            $('#create-match-time-start').timepicker({ 'step': 15 });
        },

        pickTimeEnd: function(e) {

            $('#create-match-time-end').timepicker({ 'step': 15 });
        },

        setPrice: function(e) {

            $('#create-match-price').spinner();
        },

        setPlayers: function(e) {

            $('#create-match-number-players').spinner();
        },

        addTeams: function(e) {


            var i = mTeamsList.length;

            for(var i=0;i<mTeamsList.length;i++)
            {
                var teamName = mTeamsList.at(i).get('name');
                var teamId =  mTeamsList.at(i).id;
                $("select#create-match-team").append( $("<option>").val(teamId).html(teamName));

            }

            $('#create-match-price').spinner();


        },

        render: function() {

            this.$el.html(_.template($("#add-match-template").html()));
            this.delegateEvents();
        }
    });


    // Match Item View
    // --------------

    // The DOM element for a match item...
    var mMatchView = Parse.View.extend({


        //... is a list tag.
        tagName:  "li",

        // Cache the template function for a single item.
        template: _.template($('#match-item-template').html()),

        // The DOM events specific to an item.
        events: {
            "click .toggle"              : "toggleDone",
            "dblclick label.match-content" : "edit",
            "click .match-destroy"   : "clear"
        },

        // The MatchView listens for changes to its model, re-rendering. Since there's
        // a one-to-one correspondence between a Match and a MatchView in this
        // app, we set a direct reference on the model for convenience.
        initialize: function() {
            _.bindAll(this, 'render', 'close', 'remove');
            this.model.bind('change', this.render);
            this.model.bind('destroy', this.remove);
        },

        // Re-render the contents of the item
        render: function() {
            $(this.el).html(this.template(this.model.toJSON()));
            //(this.model.attributes.dateStart).toString();
            return this;
        },

        // Toggle the `"done"` state of the model.
        toggleDone: function() {
            this.model.toggle();
        },

        // Switch this view into `"editing"` mode, displaying the input field.
        edit: function() {
            $(this.el).addClass("editing");
            this.input.focus();
        },

        // Close the `"editing"` mode, saving changes to the match.
        close: function() {
            this.model.save({content: this.input.val()});
            $(this.el).removeClass("editing");
        },

        // If you hit `enter`, we're through editing the item.
        updateOnEnter: function(e) {
            if (e.keyCode == 13) this.close();
        },

        // Remove the item, destroy the model.
        clear: function() {
            this.model.destroy();
        }

    });

    var MyMatchsView = Parse.View.extend({

        // Our template for the line of statistics at the bottom of the app.
        matchsTemplate: _.template($('#actions-template').html()),

        // Delegated events for creating new items, and clearing completed ones.
        events: {
            "click .log-out": "logOut",
            "click .add-match": "addMatch",
            "click .go-to-teams": "goToTeams"
        },

        el: ".content",

        initialize: function() {
            var self = this;
            // Load the template of the list
            this.$el.html(_.template($("#manage-matches-template").html()));
            this.getMatches();
            mMatchesList.each(self.addOne);

        },
        // Logs out the user and shows the login view
        logOut: function(e) {
            Parse.User.logOut();
            new LogInView();
            this.undelegateEvents();
            delete this;
        },

        addMatch: function(e) {

            new AddMatchView();
            this.undelegateEvents();
            delete this;
        },

        // Add a single item
        addOne: function(match) {
            var view = new mMatchView({model: match});
            this.$("#match-list").append(view.render().el);
        },

        // Add all items in the Todos collection at once.
        addAll: function(collection, filter) {
            this.$("#match-list").html("");
            mMatchesList.each(this.addOne);
        },

        goToTeams: function(match) {
            new MyTeamsView();
            this.undelegateEvents();
            delete this;
        },

        getMatches: function() {
            var TeamListID = Parse.Object.extend("Team_User");
            userId =  Parse.User.current().id;
            var queryTeamID = new Parse.Query(TeamListID);
            queryTeamID.equalTo("id_user",userId);
            queryTeamID.find({
                success: function(results) {


                    for (var i = 0; i < results.length; i++) {

                        idTeamsForUser.push(results[i].get('id_team'));


                    }
                    var team = new Team();
                    var queryTeam = new Parse.Query(Team);
                    var allTeams = new TeamsList();
                    allTeams.fetch({
                        success: function(collection, response) {
                            for(var e=0;e<collection.length;e++)
                            {
                                team = collection.at(e);

                                for(var n=0; n<idTeamsForUser.length;n++)
                                {
                                    var teamId = team.id;

                                    if(teamId==idTeamsForUser[n])
                                    {
                                        mTeamsList.add(team);
                                    }
                                }
                            }
                        }
                    });



                    var queryMatch = new Parse.Query(Match);
                    for(var a=0;a<idTeamsForUser.length;a++)
                    {
                        queryMatch.equalTo("id_team", idTeamsForUser[a]);
                        queryMatch.find({

                            success: function(teamMatchs) {
                                mMatchesList.add(teamMatchs);



                            },
                            error: function(error) {
                                alert("Error: " + error.code + " " + error.message);
                            }
                        });
                    }

                    mMatchesList.comparator = function(object) {
                        return object.get("dateStart");
                    }




                },
                error: function(error) {
                    alert("Error: " + error.code + " " + error.message);
                }

            });

        }





    });

    var MyTeamsView = Parse.View.extend({

        // Our template for the line of statistics at the bottom of the app.
        matchsTemplate: _.template($('#actions-template').html()),

        // Delegated events for creating new items, and clearing completed ones.
        events: {
            "click .log-out": "logOut",
            "click .go-to-matchs": "goToMatches",
            "click .search-team": "searchTeam",
            "click .add-team": "addTeam"

        },

        el: ".content",

        initialize: function() {
            var self = this;
            // Load the template of the list
            this.$el.html(_.template($("#manage-teams-template").html()));
            if(mTeamsList.length>0)
            {

            }
            else
            {
                var TeamListID = Parse.Object.extend("Team_User");
                var userId =  Parse.User.current().id;
                var queryTeamID = new Parse.Query(TeamListID);
                var idTeamsForUser = new Array();
                queryTeamID.equalTo("id_user",userId);
                queryTeamID.find({
                    success: function(results) {


                        for (var i = 0; i < results.length; i++) {

                            idTeamsForUser.push(results[i].get('id_team'));


                        }
                        var team = new Team();
                        var queryTeam = new Parse.Query(Team);
                        var allTeams = new TeamsList();
                        allTeams.fetch({
                            success: function(collection, response) {
                                for(var n=0;e<collection.length;e++)
                                {
                                    team = collection.at(n);

                                    for(var n=0; n<idTeamsForUser.length;n++)
                                    {
                                        var teamId = team.id;

                                        if(teamId==idTeamsForUser[n])
                                        {
                                            mTeamsList.add(team);
                                        }
                                    }
                                }
                            }
                        });

                    },
                    error: function(error) {
                        alert("Error: " + error.code + " " + error.message);
                    }

                });
            }

            mTeamsList.each(self.addOne);




        },
        // Logs out the user and shows the login view
        logOut: function(e) {
            Parse.User.logOut();
            new LogInView();
            this.undelegateEvents();
            delete this;
        },

        searchTeam: function(e) {

            new SearchTeamView();
            this.undelegateEvents();
            delete this;
        },

        addTeam: function(e) {

            new AddTeamView();
            this.undelegateEvents();
            delete this;
        },

        // Add a single item
        addOne: function(team) {
            var view = new mTeamView({model: team});
            this.$("#team-list").append(view.render().el);
        },

        // Add all items in the matches collection at once.
        addAll: function(collection, filter) {
            this.$("#team-list").html("");
            mMatchesList.each(this.addOne);
        },

        goToMatches: function(match) {
            new MyMatchsView();
            this.undelegateEvents();
            delete this;
        }



    });


    var SearchTeamView = Parse.View.extend({

        // Our template for the line of statistics at the bottom of the app.
        matchsTemplate: _.template($('#actions-template').html()),

        // Delegated events for creating new items, and clearing completed ones.
        events: {
            "submit form.search-team-form": "searchTeam",
            "click #cancel-search-team": "cancelSearchTeam",
            "click #reset-create-team": "resetSearchTeam"

        },

        el: ".content",

        initialize: function() {
            var self = this;
            _.bindAll(this, "searchTeam", "cancelSearchTeam", "resetSearchTeam", "addOne");
            // Load the template of the list
            this.$el.html(_.template($("#search-teams-template").html()));
        },
        searchTeam: function(){

            var teamName = this.$("#search-team-name").val();
            if(teamName.length<1)
            {
                alert("You have to fill the team name");
            }
            else
            {
                var Team = Parse.Object.extend("Team");
                var queryTeamName = new Parse.Query(Team);
                queryTeamName.equalTo("name",teamName);
                queryTeamName.find({
                    success: function(results) {

                        var team = new Team();

                        team = results[0];
                        var view = new mJoinTeamView({model: team});
                        this.$("#search-team-list").append(view.render().el);
                    },
                    error: function(error) {
                        alert("Error: " + error.code + " " + error.message);
                    }

                });
            }


        },


        cancelSearchTeam: function() {

            new MyTeamsView();
            this.undelegateEvents();
            delete this;
        },

        resetSearchTeam: function() {

            this.$("#search-team-name").val("");
        },

        // Add a single item
        addOne: function(team) {
            var view = new mJoinTeamView({model: team});
            this.$("#search-team-list").append(view.render().el);
        },


        // Add all items in the Todos collection at once.
        addAll: function(collection, filter) {
            this.$("#search-team-list").html("");
            mMatchesList.each(this.addOne);
        }





    });


    var AddTeamView = Parse.View.extend({
        events: {

            "submit form.create-team-form": "doCreateTeam",
            "click #cancel-create-team": "cancelCreateTeam",
            "click #reset-create-team": "resetCreateTeam",
            "click #create-team-number-players": "setPlayers"
        },

        el: ".content",

        initialize: function() {
            _.bindAll(this, "doCreateTeam", "cancelCreateTeam", "resetCreateTeam", "setPlayers");

            this.render();

        },

        doCreateTeam: function(e) {
            var self = this;
            var teamName = this.$("#create-team-name").val();
            var numPlayers = parseInt(this.$("#create-team-number-players").val());
            var primaryKitColor = this.$("#create-team-principal-kit-color").val();
            var secondaryKitColor = this.$("#create-team-secondary-kit-color").val();
            var location = this.$("#create-team-location").val();


            if(numPlayers<1 ||teamName.length<1 ||primaryKitColor.length<1 ||secondaryKitColor.length<1   ||location.length<1 )
            {
                alert("You have to fill all the mandatory fields. Try again please.");

            }
            else
            {
                var team = Parse.Object.extend("Team");
                var newTeam = new team();

                newTeam.save({
                    name: teamName,
                    numMaxPlayers: numPlayers,
                    firstKitColor: primaryKitColor,
                    secondKitColor:secondaryKitColor   ,
                    city:location

                }, {
                    success: function(newTeam) {
                        // The object was saved successfully.
                        // alert('New object created with objectId: ' + newMatch.id);
                        //TODO set location to the location table
                       //Join the creator to the team
                        var teamUser = Parse.Object.extend("Team_User");
                        var newTeamUser = new teamUser();
                        newTeamUser.save({
                            id_team: newTeam.id,
                            id_user: Parse.User.current().id

                        }, {
                            success: function(newTeam) {
                             alert("You have successfully created a new team");
                        //Send the user back to the match list
                             new MyMatchsView();
                             this.undelegateEvents();
                              delete this;

                            },
                            error: function(newTeam, error) {
                                // The save failed.
                                // error is a Parse.Error with an error code and description.
                                alert('Failed to create new team, with error code: ' + error.description);
                            }
                        });


                    },
                    error: function(newMatch, error) {
                        // The save failed.
                        // error is a Parse.Error with an error code and description.
                        alert('Failed to create new object, with error code: ' + error.description);
                    }
                });

            }
        },

        cancelCreateTeam: function(e) {

            new MyTeamsView();
            this.undelegateEvents();
            delete this;
        },

        resetCreateTeam: function(e) {


            this.$("#create-team-name").val("");
            this.$("#create-team-number-players").val("");
            this.$("#create-team-principal-kit-color").val("");
            this.$("#create-team-secondary-kit-color").val("");
            this.$("#create-team-location").val("");
            this.undelegateEvents();
            delete this;
        },



        setPlayers: function(e) {

            $('#create-team-number-players').spinner();
        },


        render: function() {
            this.$el.html(_.template($("#add-team-template").html()));
            this.delegateEvents();
        }
    });

    // Team Item View
    // --------------

    // The DOM element for a match item...
    var mTeamView = Parse.View.extend({


        //... is a list tag.
        tagName:  "li",

        // Cache the template function for a single item.
        template: _.template($('#team-item-template').html()),

        // The DOM events specific to an item.
        events: {

            "click .team-leave": "leaveTeam"
        },

        // The MatchView listens for changes to its model, re-rendering. Since there's
        // a one-to-one correspondence between a Match and a MatchView in this
        // app, we set a direct reference on the model for convenience.
        initialize: function() {
            _.bindAll(this, 'render', 'close');
            this.model.bind('change', this.render);

        },

        // Re-render the contents of the item
        render: function() {
            $(this.el).html(this.template(this.model.toJSON()));
            //(this.model.attributes.dateStart).toString();
            return this;
        },

        // Toggle the `"done"` state of the model.
        toggleDone: function() {
            this.model.toggle();
        },

        // Switch this view into `"editing"` mode, displaying the input field.
        edit: function() {
            $(this.el).addClass("editing");
            this.input.focus();
        },

        // Close the `"editing"` mode, saving changes to the match.
        close: function() {
            this.model.save({content: this.input.val()});
            $(this.el).removeClass("editing");
        },


        // Remove the item, destroy the model.
        leaveTeam: function() {
            if (confirm('Are you sure you want to leave this team')) {
              var TeamId = this.model.id;
              var UserId = Parse.User.current().id;
              var TeamListID = Parse.Object.extend("Team_User");
              var queryTeamID = new Parse.Query(TeamListID);
              queryTeamID.equalTo("id_user",UserId);
                queryTeamID.find({
                    success: function(results) {


                        for (var i = 0; i < results.length; i++) {

                            var team_id = results[i].get('id_team');
                            if(team_id==TeamId)
                            {
                                var Match = Parse.Object.extend("Match");
                                var mMatch = new Match();
                                mMatch = results[i];
                                mMatch.destroy({
                                    success: function(myObject) {
                                        alert("You have successfully leaved the team");
                                    },
                                    error: function(myObject, error) {
                                        // The delete failed.
                                        alert("There was a problem");
                                    }
                                });
                            }


                        }




                    },
                    error: function(error) {
                        alert("Error: " + error.code + " " + error.message);
                    }

                });
            } else {
                // Do nothing!
            }

        }

    });

    var mJoinTeamView = Parse.View.extend({


        //... is a list tag.
        tagName:  "li",

        // Cache the template function for a single item.
        template: _.template($('#join-team-item-template').html()),

        // The DOM events specific to an item.
        events: {

            "click .team-join": "joinTeam"
        },

        // The MatchView listens for changes to its model, re-rendering. Since there's
        // a one-to-one correspondence between a Match and a MatchView in this
        // app, we set a direct reference on the model for convenience.
        initialize: function() {
            _.bindAll(this, 'render', 'close');
            this.model.bind('change', this.render);

        },

        // Re-render the contents of the item
        render: function() {
            $(this.el).html(this.template(this.model.toJSON()));
            //(this.model.attributes.dateStart).toString();
            return this;
        },

        // Toggle the `"done"` state of the model.
        toggleDone: function() {
            this.model.toggle();
        },

        // Switch this view into `"editing"` mode, displaying the input field.
        edit: function() {
            $(this.el).addClass("editing");
            this.input.focus();
        },

        // Close the `"editing"` mode, saving changes to the match.
        close: function() {
            this.model.save({content: this.input.val()});
            $(this.el).removeClass("editing");
        },



        joinTeam: function() {
            if (confirm('Are you sure you want to join this team')) {
                var TeamId = this.model.id;
                var UserId = Parse.User.current().id;
                var TeamListID = Parse.Object.extend("Team_User");

                var mNewUserTeam = new TeamListID();


                mNewUserTeam.save({
                    id_user: UserId,
                    id_team: TeamId

                }, {
                    success: function(newMatch) {


                        //Send the user back to the match list
                        new MyTeamsView();
                        this.undelegateEvents();
                        delete this;


                    },
                    error: function(newMatch, error) {
                        // The save failed.
                        // error is a Parse.Error with an error code and description.
                        alert('Failed to create new object, with error code: ' + error.description);
                    }
                });

            } else {
                // Do nothing!
            }

        }

    });

    // The main view for the app
    var AppView = Parse.View.extend({
        // Instead of generating a new element, bind to the existing skeleton of
        // the App already present in the HTML.
        el: $("#sportapp"),

        initialize: function() {
            this.render();
        },

        render: function() {
            if (Parse.User.current()) {
                //If a user is logged in to the Match List
                new MyMatchsView();

            } else {
                //If no user is logged send the user to the login screen
                new LogInView();
            }
        }
    });

    //Create a new AppView
    new AppView;
    //Start the history of Parse??
    //Parse.history.start();

});
