T.ns('Sport.Controller').Article = (function  () {
	var
		Base = T.ns('Sport.Controller').Base,
		self = new Base(),
		View = T.ns('Sport.View.Article');

	var checkUrl = function (url) {
		if (!url)
			return;

		var
			re = /1,([0-9]+),([0-9]+)(?:,[a-z0-9\_]+)?\.html/i,
			sxx = null;

		sxx = url && url.match(re);

		if (sxx) {
			tryGetArticle(sxx[1], sxx[2], url);
		} else {
			self.openWebPage(url);
		}
	};

	var tryGetArticle = function (sid, xx, url) {
		self.getData(_appConfig.addr.data + _appConfig.urls.Article.replace('%SID%.%XX%', sid + '.' + xx), function (d) {
			if (d && d[0] && !d[0].err) {
				T.ns('Sport.Controller.BackButton').addToStack('article', sid + '.' + xx);
				View.render(d);
				setTimeout(function () {
					var elements = View._$container.querySelectorAll('a');

					for ( var i = 0, length = elements.length; i < length; i++ ) {
						elements[i].addEventListener('click', function (e) {
							e.preventDefault();
							checkUrl(this.getAttribute('href'));
						});
					}
				}, 100);
			} else {
				T.ns('Sport.Controller.Relation').tryGetRelation(sid, xx, url);
			}
		}, function () {
     		 T.ns('Sport.Controller.Relation').tryGetRelation(sid, xx, url);
    	});
	};

	self.getArticle = function (xx, back) {
  		View.show();
		self.getData(_appConfig.addr.data + _appConfig.urls.Article.replace('%SID%.%XX%', xx), function (d) {
			if (!back) {
				T.ns('Sport.Controller.BackButton').addToStack('article', xx);
			}
			View.render(d);
			setTimeout(function () {
				var elements = View._$container.querySelectorAll('a');

				for ( var i = 0, length = elements.length; i < length; i++ ) {
					elements[i].addEventListener('click', function (e) {
						e.preventDefault();
						checkUrl(this.getAttribute('href'));
					});
				}
			}, 100);
		}, function () {
			if (window.confirm("Pobranie danych nie powiodło się.\nSpróbować ponownie?")) {
  				self.getArticle(xx, back);
			} else {
				T.ns('Sport.Controller.BackButton').showBackButton();
			}
		});

	};

  	self.hideArticle = function () {
  		View.hide();
  	};

	return self;

})();
