T.ns('Sport.Controller').BackButton = (function  () {
	var
		Base = T.ns('Sport.Controller').Base,
		self = new Base(),
		_backButton = document.querySelector('#backButton');
		_share = document.querySelector('#share');
		_category = document.querySelector('#changeCategory');
		stack = [];

	self.goBack = function () {
		var old = self.removeFromStack(),
			next = stack.length && stack[stack.length - 1] || null;

		if (!old) {
			T.ns('Sport.Controller.Article').hideArticle();
			T.ns('Sport.Controller.Relation').hideRelation();
		} else if (stack.length === 0) {
			self.hideBackButton();
			if (old.type === 'article') {
				T.ns('Sport.Controller.Article').hideArticle();
			} else if (old.type === 'relation') {
				T.ns('Sport.Controller.Relation').hideRelation();
			} else {
				T.ns('Sport.Controller.Article').hideArticle();
				T.ns('Sport.Controller.Relation').hideRelation();
			}
		} else if (old.type !== next.type) {
			if (old.type === 'relation') {
				T.ns('Sport.Controller.Article').getArticle(next.xx, true);
				T.ns('Sport.Controller.Relation').hideRelation();
			} else {
				T.ns('Sport.Controller.Relation').getRelation(next.xx, false, true);
				T.ns('Sport.Controller.Article').hideArticle();
			}
		} else if (next.type === 'relation') {
			T.ns('Sport.Controller.Relation').getRelation(next.xx, true, true)
		} else if (next.type === 'article') {
			T.ns('Sport.Controller.Article').getArticle(next.xx, true);
		} else {
			T.ns('Sport.Controller.Article').hideArticle();
			T.ns('Sport.Controller.Relation').hideRelation();
		}
	};

	self.addToStack = function (type, xx) {
		stack.push({type:type, xx:xx});
		if (stack.length === 1) {
			self.showBackButton();
		}
	};

	self.removeFromStack = function () {
		return stack.pop();
	};
	self.showBackButton = function () {
		_backButton.style.visibility = 'visible';
		_category.style.display = 'none';
		_share.style.display = 'block';
	};
	self.hideBackButton = function () {
		_backButton.style.visibility = 'hidden';
		_category.style.display = 'block';
		_share.style.display = 'none';
	};

	return self;

})();
