T.ns('Sport.Controller').Calendar = (function  () {

	var
		Base = T.ns('Sport.Controller').Base,
		self = new Base(),
		View = T.ns('Sport.View.Calendar'),
		reminders = -1,
		KEY = 'Sport_pl_reminders',
		calendar = null;

	document.querySelector('#panel3 > a').addEventListener('click', function () {
		self.onCalendarPick();
	});

	self.onCalendarPick = function () {
		if (calendar && calendar.length) {
			if (View._nearestEvent && View._nearestEvent < Date.now()) {
				View._nearestEvent = null;
				View.render(d);
			}
		} else {
			calendar = [];
			self.show();
		}
	};

	self.filtrCalendar = function () {
		if (calendar && calendar.length) {
			View.render(calendar);
		}
	};

	self.show = function () {

		self.getData(_appConfig.addr.data + _appConfig.urls.Calendar.replace('%XX%', 'all'), function (d) {
			if (d && d.length) {
				calendar = calendar.concat(d);
			}
			View.render(d);
		}, function () {
			if (window.confirm("Pobranie danych nie powiodło się.\nSpróbować ponownie?")) {
  				self.show();
			}
		});

	};

	var saveAllReminders = function () {
		lscache.set(KEY, getAllReminders());
	};

	var loadAllReminders = function () {
		return lscache.get(KEY);
	};

	var saveReminder = function (hxx, id) {
		var
			data = getAllReminders();

		data["hxx:" + hxx] = id;
		saveAllReminders();
	};
	var deleteReminder = function (hxx) {
		delete getAllReminders()['hxx:' + hxx];
		saveAllReminders();
	};

	var getAllReminders = function () {

		if (reminders === -1)
			reminders = loadAllReminders() || {};

		return reminders;

	};

	self.getReminderId = function (hxx) {
		return getAllReminders()['hxx:' + hxx] || null;
	};

	self.setReminder = function (ts, name, hxx) {
		if (!navigator.mozAlarms)
			return;

		var
			alarmId = null,
			request = null,
			// date = new Date(Date.now()),
			date = new Date(ts*1),
			y = date.getFullYear(),
			m = date.getMonth(),
			d = date.getDate(),
			h = date.getHours(),
			min = date.getMinutes();

		request = navigator.mozAlarms.add(new Date(y, m, d, h, min), "ignoreTimezone", {
			hxx: hxx,
		  	name: name
		});

		request.onsuccess = function (el) {
			var
				elements = document.querySelectorAll('.add[data-xx="' + hxx + '"]'),
				i = 0;

			for ( ; i < elements.length; i++ ) {
				elements[i].className += ' added';
			}
			saveReminder(hxx, this.result && this.result.id || this.result);
			// ga('send', {
			//   'hitType': 'event',
			//   'eventCategory': 'reminder',
			//   'eventAction': 'set',
			//   'eventLabel': hxx
			// });
		};

		request.onerror = function () {
			alert("Przepraszamy, nie udało się dodać tego powiadomienia");
		};
	};

	self.removeReminder = function (hxx) {
		if (!navigator.mozAlarms)
			return;

		var
			alarmId = self.getReminderId(hxx);

		if (alarmId) {
			navigator.mozAlarms.remove(alarmId);

			var
				elements = document.querySelectorAll('.add[data-xx="' + hxx + '"]'),
				i = 0;

			for ( ; i < elements.length; i++ ) {
				elements[i].className = elements[i].className.replace(/ added/gi, '');
			}
			deleteReminder(hxx);
		}
	};

	return self;

})();
