T.ns('Sport.Controller').Categories = (function  () {

	var
		Base = T.ns('Sport.Controller').Base,
		self = new Base(),
		View = T.ns('Sport.View.Categories'),
    Index = T.ns('Sport.Controller').Index,
    Calendar = T.ns('Sport.Controller').Calendar,
    Events = T.ns('Sport.Controller').Events,
    _filter = null;

  self.checkFilter = function (eventCategory) {
    if (!_filter)
      return true;

    var detected = false;

    if (_filter === eventCategory) {
      return true;
    } else if (_filter === 'Inne') {
      _categories.forEach(function (cat) {
        if (cat.name === eventCategory || cat.id === eventCategory) {
          detected = true;
        } else if (cat.sub && cat.sub.length) {
          cat.sub.forEach(function (sub) {
            if (sub === eventCategory) {
              detected = true;
            }
          });
        }
      });
      if (!detected) {
        return true;
      }
    } else {
      _categories.forEach(function (cat) {
       if (cat.name === _filter) {
           if (cat.id === eventCategory) {
              detected = true;
           } else if (cat.sub && cat.sub.length) {
            cat.sub.forEach(function (sub) {
              if (sub === eventCategory) {
                detected = true;
              }
            });
          }
        }
      });
      if (detected) {
        return true;
      }
    }

    return false;

  };

	self.renderCategories = function () {

			View.render(_categories);
      setTimeout(function () {
          var elements = View._$container.querySelectorAll('.category'),
            i = 0,
            length = elements.length;

          for ( i = 0, length = elements.length; i < length; i++ ) {
            elements[i].addEventListener('click', function () {
              if (this.className.indexOf('active') === -1) {
                  View._$container.querySelector('.active').className = 'category';
                  this.className += ' active';
                  Index.changeCategory(this.getAttribute('data-id'), 1);
                  _filter = this.innerHTML;

                  // ga('send', {
                  //   'hitType': 'event',
                  //   'eventCategory': 'category',
                  //   'eventAction': 'change',
                  //   'eventLabel': _filter
                  // });

                  if (_filter === 'Wszystkie') {
                    _filter = null;
                  }
                  Calendar.filtrCalendar();
                  Events.filtrEvents();
                  self.hideCategories();
              } else {
                  self.hideCategories();
              }
            });
          }
      }, 100);

	};

  self.hideCategories = function () {
    View.hide();
  };

	return self;

})();
