T.ns('Sport.Controller').Events = (function  () {

	var
		Base = T.ns('Sport.Controller').Base,
		self = new Base(),
		View = T.ns('Sport.View.Events'),
		events = [];

	var getHeaderXx = function (url) {
		if (!url)
			return null;

		var m = url.match(/2,[0-9]+,,[a-z0-9_\-]*,,([0-9]+),[0-9]+\.html/i);

		return m && m[1] && m[1]*1 || null;

	};

	var getEventFromRelation = function (d, sid) {
		return {
					"x": d.x,
					"s": d.s || sid,
					"t": d.t,
					"c": "Sport",
					"r": d.a,
					"d": d.d,
					"p": d.p,
					"h": d.h,
					"hXx": d.s === 0 ? d.x : (d.h === null ? null : getHeaderXx(d.h.u))
				};
	};

	self.filtrEvents = function () {
		self.render();
	};

	self.getEvents = function () {

		self.getData(_appConfig.addr.data + _appConfig.urls.Events.replace('%XX%', 'all'), self.show);

	};

	self.show = function (d) {
		if (d && d.length) {
			events = events.concat(d);
		}
		View.render(d);
	};

	self.render = function () {
		View.render(events, true);
	};

	self.remove = function (data, callback) {
		var idx = -1,
			tmpCat = [];

		data.forEach(function (el) {
			idx = T.inJSONArrayByKey(events, 'x', el.x);
			if (idx !== -1) {
				events[idx].r = false;
				tmpCat.push(events[idx].c);
			}
		});
		if (typeof callback === 'function') {
			if (tmpCat.length) {
				callback(tmpCat);
			} else {
				callback();
			}
		}

	};

	self.update = function (data) {

		var idx = -1,
			hXx = null;

		data.forEach(function (d) {
			idx = T.inJSONArrayByKey(events, 'x', d.x);
			if (idx !== -1) {
				events[idx] = typeof d.a !== 'undefined' ? getEventFromRelation(d, events[idx].s) : d;
			} else if (d.h) {
				hXx = getHeaderXx(d.h.u);
				if (hXx) {
					idx = T.inJSONArrayByKey(events, 'hXx', hXx);
					if (idx !== -1) {
						events[idx] = typeof d.a !== 'undefined' ? getEventFromRelation(d, events[idx].s) : d;
					} else {
						events.push(typeof d.a !== 'undefined' ? getEventFromRelation(d) : d);
					}

				} else {
					events.push(typeof d.a !== 'undefined' ? getEventFromRelation(d) : d);
				}
			} else {
				events.push(typeof d.a !== 'undefined' ? getEventFromRelation(d) : d);
			}
		});

	};

	return self;

})();
