T.ns('Sport.Controller').Index = (function  () {

	var
		Base = T.ns('Sport.Controller').Base,
		self = new Base(),
		ViewTop20 = T.ns('Sport.View.Top20'),
		ViewLiveStream = T.ns('Sport.View.LiveStream'),
		ViewSocket = T.ns('Sport.View.Socket'),
		$badge = document.querySelector("#panel1 .sport-badge"),
		$scrollContainer = document.querySelector("#panel1 > div"),
		loadingMore = false,
    	currentPage = 1,
    	currentCategory = 'all',
    	offScreenList = [],
    	mainCategory = [];

    var getFromOffScreenList = function () {
    	ViewSocket.render(JSON.parse(JSON.stringify(offScreenList)));
		offScreenList.length = 0;
		$badge.style.visibility = 'hidden';
    };

    var getBadgeValue = function () {
    	if (offScreenList.length >= 20) {
    		return '!';
    	} else {
    		var important = false;
    		offScreenList.forEach(function (el) {
    			if (el.s >= 10 && el.s <= 14) {
    				important = true;
    			}
    		});
    		if (important) {
    			return '!';
    		} else {
    			return offScreenList.length;
    		}
    	}
    };

    var setGlobalEvents = function () {
		$scrollContainer.addEventListener('scroll',function (e) {
			if (!loadingMore && this.clientHeight + this.scrollTop + 1200 > this.scrollHeight) {
				T.ns('Sport.Controller.Index').getMore()
			} else if (offScreenList.length && this.scrollTop === 0) {
				getFromOffScreenList();
			}
		});
		document.querySelector('#panel1 > a').addEventListener('click', function () {
			if (offScreenList.length) {
				getFromOffScreenList();
				$scrollContainer.scrollTop = 0;
			}
		});
		document.querySelector('#backButton').addEventListener('click', function (e) {
			e.preventDefault();
			T.ns('Sport.Controller.BackButton').goBack();
		});
		document.querySelector("#share").onclick = function () {
	        if (typeof MozActivity !== 'undefined') {
	            var sharing = new MozActivity({
	                name: "share",
	                data: {
	                    number: 1,
	                    url: self.getShareUrl()
	                }
	            });
	        }
	    };
		document.querySelector('#changeCategory').addEventListener('click', function (e) {
			e.preventDefault();
			if (document.querySelector('#categories').className.match(/show/gi)) {
				document.querySelector('#categories').className = document.querySelector('#categories').className.replace(/ show/gi,'');
			} else {
				document.querySelector('#categories').className += ' show';
			}
		});
		new Swipe(document.querySelector('ul[role="tablist"]'), function () {
			if (window.location.href.indexOf("#panel1") !== -1) {
				window.location.href = window.location.href.split("#")[0] + '#panel2';
			} else if (window.location.href.indexOf("#panel2") !== -1) {
				window.location.href = window.location.href.split("#")[0] + '#panel3';
				T.ns('Sport.Controller.Calendar').onCalendarPick();
			}
		}, function (){
			if (window.location.href.indexOf("#panel2") !== -1) {
				window.location.href = window.location.href.split("#")[0] + '#panel1';
			} else if (window.location.href.indexOf("#panel3") !== -1) {
				window.location.href = window.location.href.split("#")[0] + '#panel2';
			}
		});

    };

    self.changeCategory = function (id, page) {
    	currentPage = page;
    	currentCategory = id;
    	offScreenList.length = 0;
    	$badge.style.visibility = 'hidden';
		ViewSocket._$container.innerHTML = '';
		ViewLiveStream._$container.innerHTML = '<progress></progress>';
    	ViewTop20._$container.innerHTML = '';
    	if (id !== 'all') {
			self.getData(_appConfig.addr.data + _appConfig.urls.LiveStreamPaged.replace('%FILTER%', id).replace('%PAGE%', page), function (d) {
				ViewLiveStream.render(d, true);
			}, function () {
				if (window.confirm("Pobranie danych nie powiodło się.\nSpróbować ponownie?")) {
  					self.changeCategory(id, page);
  				}
			});
		} else {
			ViewLiveStream.render(mainCategory, true);
		}

	};

	self.addToMainCategory = function (elements) {
		mainCategory = elements.concat(mainCategory);
	};

	self.addToOffScreenList = function (elements) {
		offScreenList = elements.concat(offScreenList);
		$badge.innerHTML = getBadgeValue();
    	$badge.style.visibility = 'visible';
	};

	self.start = function () {
		setGlobalEvents();
		self.getAll();
	};

	self.getAll = function () {
		self.getData(_appConfig.addr.data + _appConfig.urls.start.replace('%FILTER%', 'all'), function (d) {
			mainCategory = d.top20.concat(d.index);
			ViewLiveStream.render(d.index);
			ViewTop20.render(d.top20);
			T.ns('Sport.Controller.Events').show(d.events);
		}, function () {
			if (window.confirm("Pobranie danych nie powiodło się.\nSpróbować ponownie?")) {
  				self.getAll();
			}
		});
	};

	self.getCurrentCategory = function () {
		return currentCategory;
	};

  	self.getMore = function () {
	    loadingMore = true;
	    self.getData(_appConfig.addr.data + _appConfig.urls.LiveStream.replace('%XX%', currentCategory + '/' + (++currentPage)), function (d) {
	      ViewLiveStream.render(d);
	      loadingMore = false;
	    }, function() {
	      --currentPage;
	      loadingMore = false;
	    });

	};

	return self;

})();
