T.ns('Sport.Controller').Relation = (function  () {

	var
		Base = T.ns('Sport.Controller').Base,
		self = new Base(),
		View = T.ns('Sport.View.Relation'),
		showed = false,
		relation = null;

	var unique = function (data) {

		var
			tmp = [],
			xxs = [],
			i = 0,
			j = data.length;

		for ( ; i < j; i++ ) {

			if ( xxs.indexOf(data[i].xx) === -1 ) {

				tmp.push(data[i]);
				xxs.push(data[i].xx);

			}

		}
		return tmp;

	};

	var getFromCache = function (xx) {
		if (relation && relation.x === xx) {
			return relation;
		} else {
			return null;
		}
	};

	var setInCache = function (xx, data) {
		relation = data;
	};

	var mergeWithCached = function (cached, d) {
		cached.s = d.s;
		cached.t = d.t;
		cached.a = d.a;
		cached.p = d.p;
		cached.u = d.u;
		cached.h = d.h;
		if (d.e && d.e.length) {
			if (cached.e && cached.e.length) {
				cached.e = T.sortByKey(unique(cached.e.concat(d.e)), "n", d.a ? 'desc' : 'asc');
			} else {
				cached.e = d.e;
			}
		}
	};

	self.tryGetRelation = function (sid, xx, url) {
		var
			cached = getFromCache(xx*1);

		self.show();

		if (!cached) {
			self.getData(_appConfig.addr.data + _appConfig.urls.Event.replace('%SID%/%XX%/%LIMIT%', sid + '/' + xx + "/0"), function (d) {
				setInCache(d.x, d);
				showed = d.x;
				T.ns('Sport.Controller.BackButton').addToStack('relation', sid + '.' + xx);
				View.render(d);
			}, function() {
				self.openWebPage(url);
			});
		} else {
			T.ns('Sport.Controller.BackButton').addToStack('relation', sid + '.' + xx);
			View.render(cached);
		}
	};

	self.getRelation = function (xx, showed, back) {

		var
			sxx = xx.split('.'),
			cached = getFromCache(sxx[1]*1);

		if (!showed) {
			self.show();
		}

		if (!cached) {
			self.getData(_appConfig.addr.data + _appConfig.urls.Event.replace('%SID%/%XX%/%LIMIT%', sxx[0] + '/' + sxx[1] + "/0"), function (d) {
				setInCache(d.x, d);
				showed = d.x;
				if (!back) {
					T.ns('Sport.Controller.BackButton').addToStack('relation', sxx[0] + '.' + sxx[1]);
				}
				View.render(d);
			}, function () {
				if (window.confirm("Pobranie danych nie powiodło się.\nSpróbować ponownie?")) {
	  				self.getRelation(xx, showed, back);
				} else {
					T.ns('Sport.Controller.BackButton').showBackButton();
				}
			});
		} else {
			if (!back) {
				T.ns('Sport.Controller.BackButton').addToStack('relation', sxx[0] + '.' + sxx[1]);
			}
			View.render(cached);
		}

	};

	self.update = function (data) {

		var cached = null;

		data.forEach(function (d) {
			cached = getFromCache(d.x);
			if (cached) {
				mergeWithCached(cached, d);
				if (showed === d.x) {
					View.render(cached);
				}
			}
		});
	};

	self.show = function () {
		View.show();
	};

	self.getRelationByHxx = function (hxx) {
		self.show();
		self.getData(_appConfig.addr.data + _appConfig.urls.EventByHeader.replace('%XX%', hxx), function (d) {
			if (d && Object.keys(d).length) {
				setInCache(d.x, d);
				showed = d.x;
				T.ns('Sport.Controller.BackButton').addToStack('relation', '0.' + hxx);
				View.render(d);
			} else {
				self.getRelation('0.' + hxx, true);
			}
		}, function () {
			self.getRelation('0.' + hxx, true);
		});
	};

	self.hideRelation = function (xx) {
		View.hide();
		showed = false;
	};

	return self;

})();
