T.ns('Sport.Controller').Socket = (function  () {
	var
		self = function () {},
		ctrlEvents = T.ns('Sport.Controller.Events'),
		ctrlRelation = T.ns('Sport.Controller.Relation'),
		ctrlIndex = T.ns('Sport.Controller.Index'),
		View = T.ns('Sport.View.Socket'),
		$indexContainer = document.querySelector("#panel1 > div");

	self.prototype.listen = function () {

		var
			socket = io.connect(_appConfig.addr.ws),
			ref = this;

		socket.on('notice', function (data) {
			if (data && data.message) {
				ref.analyze(data.message);
			}
		});
	};

	self.prototype.analyze = function (data) {

		var
			i = '',
			refreshEvents = false,
			toLive = [],
			toMain = [];

		for ( i in data ) {

			if ( data[i] && data[i].length ) {

				switch (i) {
					case 'events':
						ctrlEvents.update(data[i]);
						if (!refreshEvents) {
							data[i].forEach(function (ev) {
								if (T.ns('Sport.Controller.Categories').checkFilter(ev.c)) {
									refreshEvents = true;
								}
							});
						}
						break;
					case 'endedEvents':
						ctrlEvents.remove(data[i], function (categories) {
							if (!refreshEvents && categories) {
								categories.forEach(function (cat) {
									if (T.ns('Sport.Controller.Categories').checkFilter(cat)) {
										refreshEvents = true;
									}
								});
							}
						});
						break;
					case 'relations':
						ctrlEvents.update(data[i]);
						ctrlRelation.update(data[i]);
						if (!refreshEvents) {
							data[i].forEach(function (rel) {
								if (rel.p && rel.p[0]) {
									if (T.ns('Sport.Controller.Categories').checkFilter(rel.p[0])) {
										refreshEvents = true;
									}
								} else {
									refreshEvents = true;
								}
							});
						}
						break;
					case 'toLiveStream':
						toMain = toMain.concat(data[i]);
						toLive = toLive.concat(data[i]);
						break;
					default:
						toMain = toMain.concat(data[i]);
						if (ctrlIndex.getCurrentCategory() === 'all' || ctrlIndex.getCurrentCategory() === i) {
							toLive = toLive.concat(data[i]);
						}
				}

			}

		}

		if (refreshEvents) {
			ctrlEvents.render();
		}

		if ( toLive.length ) {
			if (window.location.href.indexOf("#panel1") !== -1 && $indexContainer.scrollTop === 0) {
				View.render(T.sortByKey(toLive, 'd', 'desc'));
			} else {
				ctrlIndex.addToOffScreenList(T.sortByKey(toLive, 'd', 'desc'))
			}
		}

		if ( toMain.length ) {
			ctrlIndex.addToMainCategory(T.sortByKey(toMain, 'd', 'desc'));
		}
	};

	return new self();

})();
